/*    */ package org.jnp.interfaces;
/*    */ 
/*    */ import java.util.Hashtable;
/*    */ import javax.naming.Context;
/*    */ import javax.naming.Name;
/*    */ import javax.naming.NamingException;
/*    */ import javax.naming.RefAddr;
/*    */ import javax.naming.Reference;
/*    */ import javax.naming.spi.InitialContextFactory;
/*    */ import javax.naming.spi.ObjectFactory;
/*    */ 
/*    */ public class LocalOnlyContextFactory
/*    */   implements InitialContextFactory, ObjectFactory
/*    */ {
/*    */   public Context getInitialContext(Hashtable env)
/*    */     throws NamingException
/*    */   {
/* 45 */     if (NamingContext.localServer == null) throw new NamingException("Local server is not initialized");
/* 46 */     return new NamingContext(env, null, NamingContext.localServer);
/*    */   }
/*    */ 
/*    */   public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment)
/*    */     throws Exception
/*    */   {
/* 56 */     Context ctx = getInitialContext(environment);
/* 57 */     Reference ref = (Reference)obj;
/* 58 */     return ctx.lookup((String)ref.get("URL").getContent());
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jnp.interfaces.LocalOnlyContextFactory
 * JD-Core Version:    0.6.0
 */