/*     */ package org.jboss.xb.spi;
/*     */ 
/*     */ import org.jboss.beans.info.spi.BeanInfo;
/*     */ import org.jboss.beans.info.spi.PropertyInfo;
/*     */ import org.jboss.reflect.spi.MethodInfo;
/*     */ 
/*     */ public class AbstractBeanAdapter extends BeanAdapter
/*     */ {
/*     */   private BeanInfo beanInfo;
/*     */   private MethodInfo factory;
/*  44 */   private boolean constructed = false;
/*     */   private Object value;
/*     */ 
/*     */   public AbstractBeanAdapter(BeanAdapterFactory beanAdapterFactory, BeanInfo beanInfo, MethodInfo factory)
/*     */   {
/*  59 */     super(beanAdapterFactory);
/*  60 */     if (beanInfo == null)
/*  61 */       throw new IllegalArgumentException("Null bean info");
/*  62 */     this.beanInfo = beanInfo;
/*  63 */     this.factory = factory;
/*     */   }
/*     */ 
/*     */   public BeanInfo getBeanInfo()
/*     */   {
/*  73 */     return this.beanInfo;
/*     */   }
/*     */ 
/*     */   public MethodInfo getFactory()
/*     */   {
/*  83 */     return this.factory;
/*     */   }
/*     */ 
/*     */   public Object get(PropertyInfo propertyInfo) throws Throwable
/*     */   {
/*  88 */     ensureConstructed();
/*  89 */     return propertyInfo.get(this.value);
/*     */   }
/*     */ 
/*     */   public void set(PropertyInfo propertyInfo, Object child) throws Throwable
/*     */   {
/*  94 */     ensureConstructed();
/*  95 */     propertyInfo.set(this.value, child);
/*     */   }
/*     */ 
/*     */   public Object getValue()
/*     */   {
/* 100 */     ensureConstructed();
/* 101 */     return this.value;
/*     */   }
/*     */ 
/*     */   protected Object construct()
/*     */   {
/*     */     try
/*     */     {
/* 113 */       if (this.factory != null)
/* 114 */         return this.factory.invoke(null, null);
/* 115 */       return this.beanInfo.newInstance();
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 119 */     throw new RuntimeException("Error instantiating bean for " + this.beanInfo.getName(), t);
/*     */   }
/*     */ 
/*     */   protected void ensureConstructed()
/*     */   {
/* 128 */     if (!this.constructed)
/* 129 */       this.value = construct();
/* 130 */     this.constructed = true;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.spi.AbstractBeanAdapter
 * JD-Core Version:    0.6.0
 */