/*     */ package org.jboss.xb.builder.runtime;
/*     */ 
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.beans.info.spi.BeanInfo;
/*     */ import org.jboss.beans.info.spi.PropertyInfo;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.reflect.spi.ClassInfo;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ import org.jboss.reflect.spi.TypeInfoFactory;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.CharactersHandler;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
/*     */ import org.jboss.xb.spi.BeanAdapter;
/*     */ 
/*     */ public class ValueHandler extends CharactersHandler
/*     */ {
/*  44 */   private final Logger log = Logger.getLogger(getClass());
/*     */ 
/*  47 */   private boolean trace = this.log.isTraceEnabled();
/*     */   private PropertyInfo propertyInfo;
/*     */   private BeanInfo beanInfo;
/*     */   private String property;
/*     */ 
/*     */   public ValueHandler(PropertyInfo propertyInfo)
/*     */   {
/*  66 */     if (propertyInfo == null)
/*  67 */       throw new IllegalArgumentException("Null propertyInfo");
/*  68 */     this.propertyInfo = propertyInfo;
/*     */   }
/*     */ 
/*     */   public ValueHandler(PropertyInfo propertyInfo, BeanInfo beanInfo, String property)
/*     */   {
/*  81 */     if (propertyInfo == null)
/*  82 */       throw new IllegalArgumentException("Null propertyInfo");
/*  83 */     if (beanInfo == null)
/*  84 */       throw new IllegalArgumentException("Null beanInfo");
/*  85 */     if (property == null)
/*  86 */       throw new IllegalArgumentException("Null property");
/*  87 */     this.propertyInfo = propertyInfo;
/*  88 */     this.beanInfo = beanInfo;
/*  89 */     this.property = property;
/*     */   }
/*     */ 
/*     */   public PropertyInfo getPropertyInfo()
/*     */   {
/*  99 */     return this.propertyInfo;
/*     */   }
/*     */ 
/*     */   public void setValue(QName qName, ElementBinding element, Object owner, Object value)
/*     */   {
/* 105 */     if (this.trace)
/* 106 */       this.log.trace("QName " + qName + " handle " + BuilderUtil.toDebugString(value) + " to " + BuilderUtil.toDebugString(owner));
/*     */     try
/*     */     {
/* 109 */       TypeInfo typeInfo = this.propertyInfo.getType();
/* 110 */       value = typeInfo.convertValue(value, false);
/* 111 */       if (this.beanInfo != null)
/*     */       {
/* 113 */         ClassInfo classInfo = this.beanInfo.getClassInfo();
/* 114 */         TypeInfo valueType = classInfo.getTypeInfoFactory().getTypeInfo(value.getClass());
/* 115 */         if (!classInfo.isAssignableFrom(valueType))
/*     */         {
/* 117 */           Object wrapper = this.beanInfo.newInstance();
/* 118 */           this.beanInfo.setProperty(wrapper, this.property, value);
/* 119 */           value = wrapper;
/*     */         }
/*     */       }
/* 122 */       BeanAdapter beanAdapter = (BeanAdapter)owner;
/* 123 */       beanAdapter.set(this.propertyInfo, value);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 127 */       throw new RuntimeException("QName " + qName + " error setting characters " + this.propertyInfo.getName() + " with value " + BuilderUtil.toDebugString(value) + " to " + BuilderUtil.toDebugString(owner) + " property=" + this.propertyInfo.getName(), t);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.builder.runtime.ValueHandler
 * JD-Core Version:    0.6.0
 */