/*    */ package org.jboss.xb.builder.runtime;
/*    */ 
/*    */ import javax.xml.namespace.QName;
/*    */ import org.jboss.beans.info.spi.PropertyInfo;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.reflect.spi.TypeInfo;
/*    */ import org.jboss.xb.binding.sunday.unmarshalling.DefaultElementInterceptor;
/*    */ import org.jboss.xb.spi.BeanAdapter;
/*    */ 
/*    */ public class PropertyInterceptor extends DefaultElementInterceptor
/*    */ {
/* 41 */   private static final Logger log = Logger.getLogger(PropertyInterceptor.class);
/*    */ 
/* 44 */   private boolean trace = log.isTraceEnabled();
/*    */   private PropertyInfo propertyInfo;
/*    */   private TypeInfo propertyType;
/*    */ 
/*    */   public PropertyInterceptor(PropertyInfo propertyInfo, TypeInfo propertyType)
/*    */   {
/* 61 */     if (propertyInfo == null)
/* 62 */       throw new IllegalArgumentException("Null property info");
/* 63 */     if (propertyType == null)
/* 64 */       throw new IllegalArgumentException("Null property type");
/* 65 */     this.propertyInfo = propertyInfo;
/* 66 */     this.propertyType = propertyType;
/*    */   }
/*    */ 
/*    */   public void add(Object parent, Object child, QName qName)
/*    */   {
/* 73 */     if (this.trace)
/* 74 */       log.trace("setParent " + qName + " parent=" + BuilderUtil.toDebugString(parent) + " child=" + BuilderUtil.toDebugString(child) + " property=" + this.propertyInfo.getName());
/*    */     try
/*    */     {
/* 77 */       if (this.propertyType.isArray())
/*    */       {
/* 79 */         ArrayWrapper wrapper = (ArrayWrapper)child;
/* 80 */         child = wrapper.getArray(this.propertyType);
/*    */       }
/* 82 */       BeanAdapter beanAdapter = (BeanAdapter)parent;
/* 83 */       beanAdapter.set(this.propertyInfo, child);
/*    */     }
/*    */     catch (Throwable t)
/*    */     {
/* 87 */       throw new RuntimeException("QName " + qName + " error setting property " + this.propertyInfo.getName() + " with value " + BuilderUtil.toDebugString(child) + " to " + BuilderUtil.toDebugString(parent), t);
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.builder.runtime.PropertyInterceptor
 * JD-Core Version:    0.6.0
 */