/*     */ package org.jboss.xb.builder.runtime;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import javax.xml.bind.annotation.XmlEnumValue;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.reflect.spi.EnumConstantInfo;
/*     */ import org.jboss.reflect.spi.EnumInfo;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.ValueAdapter;
/*     */ 
/*     */ public class EnumValueAdapter
/*     */   implements ValueAdapter
/*     */ {
/*     */   private QName qName;
/*     */   private Map<Object, Object> valid;
/*     */ 
/*     */   public EnumValueAdapter(QName qName, EnumInfo enumInfo, TypeInfo enumType)
/*     */   {
/*  59 */     if (enumInfo == null)
/*  60 */       throw new IllegalArgumentException("Null enumInfo");
/*  61 */     if (enumType == null) {
/*  62 */       throw new IllegalArgumentException("Null enumType");
/*     */     }
/*  64 */     this.qName = qName;
/*     */ 
/*  67 */     EnumConstantInfo[] constants = enumInfo.getEnumConstants();
/*  68 */     this.valid = new HashMap(constants.length);
/*  69 */     for (EnumConstantInfo constant : constants)
/*     */     {
/*  71 */       String enumValue = constant.getName();
/*  72 */       XmlEnumValue xmlEnumValue = (XmlEnumValue)constant.getUnderlyingAnnotation(XmlEnumValue.class);
/*  73 */       if (xmlEnumValue != null) {
/*  74 */         enumValue = xmlEnumValue.value();
/*     */       }
/*  76 */       Object key = enumValue;
/*     */       try
/*     */       {
/*  79 */         key = enumType.convertValue(enumValue, false);
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/*  83 */         throw new RuntimeException("Error for enum " + enumInfo.getName() + " unable to convert " + enumValue + " to " + enumType.getName());
/*     */       }
/*  85 */       Object value = constant.getValue();
/*  86 */       this.valid.put(key, value);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Map<Object, Object> getMapping()
/*     */   {
/*  97 */     return this.valid;
/*     */   }
/*     */ 
/*     */   public Object cast(Object o, Class c)
/*     */   {
/* 103 */     if (o == null) {
/* 104 */       return null;
/*     */     }
/* 106 */     Object result = this.valid.get(o);
/* 107 */     if (result == null)
/*     */     {
/* 109 */       if (this.qName == null)
/* 110 */         throw new RuntimeException("Invalid value " + BuilderUtil.toDebugString(o) + " valid are " + this.valid.keySet());
/* 111 */       throw new RuntimeException("Invalid value " + BuilderUtil.toDebugString(o) + " for " + this.qName + " valid are " + this.valid.keySet());
/*     */     }
/* 113 */     return result;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.builder.runtime.EnumValueAdapter
 * JD-Core Version:    0.6.0
 */