/*     */ package org.jboss.xb.builder.runtime;
/*     */ 
/*     */ import javax.xml.namespace.NamespaceContext;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.parsers.DocumentBuilder;
/*     */ import javax.xml.parsers.DocumentBuilderFactory;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.xb.binding.metadata.ValueMetaData;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.CharactersHandler;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.ParticleHandler;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;
/*     */ import org.w3c.dom.DOMImplementation;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.Text;
/*     */ import org.xml.sax.Attributes;
/*     */ 
/*     */ public class DOMHandler extends CharactersHandler
/*     */   implements ParticleHandler
/*     */ {
/*  45 */   private static final Logger log = Logger.getLogger(DOMHandler.class);
/*     */ 
/*  48 */   public static final DOMHandler INSTANCE = new DOMHandler();
/*     */ 
/*  51 */   private boolean trace = log.isTraceEnabled();
/*     */ 
/*     */   public Object startParticle(Object parent, QName elementName, ParticleBinding particle, Attributes attrs, NamespaceContext nsCtx)
/*     */   {
/*  55 */     if (this.trace)
/*  56 */       log.trace("startParticle " + elementName + " parent=" + BuilderUtil.toDebugString(parent));
/*  57 */     Element element = null;
/*  58 */     if ((parent == null) || (!(parent instanceof Element)))
/*  59 */       element = createTopElement(elementName.getNamespaceURI(), elementName.getLocalPart());
/*     */     else
/*  61 */       element = appendChildElement((Element)parent, elementName.getNamespaceURI(), elementName.getLocalPart());
/*  62 */     addAttributes(element, attrs);
/*  63 */     return element;
/*     */   }
/*     */ 
/*     */   public Object endParticle(Object o, QName elementName, ParticleBinding particle)
/*     */   {
/*  68 */     if (this.trace)
/*  69 */       log.trace("endParticle " + elementName + " result=" + BuilderUtil.toDebugString(o));
/*  70 */     return o;
/*     */   }
/*     */ 
/*     */   public void setParent(Object parent, Object o, QName elementName, ParticleBinding particle, ParticleBinding parentParticle)
/*     */   {
/*  75 */     if (this.trace)
/*  76 */       log.trace("setParent " + elementName + " parent=" + BuilderUtil.toDebugString(parent) + " o=" + BuilderUtil.toDebugString(o));
/*     */   }
/*     */ 
/*     */   public void setValue(QName qName, ElementBinding element, Object owner, Object value)
/*     */   {
/*  82 */     setText(owner, value, qName);
/*     */   }
/*     */ 
/*     */   public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData, String value)
/*     */   {
/*  88 */     return value;
/*     */   }
/*     */ 
/*     */   public Object unmarshalEmpty(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData)
/*     */   {
/*  94 */     return null;
/*     */   }
/*     */ 
/*     */   public Element createTopElement(String namespace, String name)
/*     */   {
/*     */     try
/*     */     {
/* 101 */       DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
/* 102 */       factory.setNamespaceAware(true);
/* 103 */       DocumentBuilder builder = factory.newDocumentBuilder();
/* 104 */       DOMImplementation impl = builder.getDOMImplementation();
/* 105 */       Document document = impl.createDocument(null, null, null);
/*     */ 
/* 107 */       Element element = document.createElementNS(namespace, name);
/* 108 */       document.appendChild(element);
/* 109 */       if (this.trace)
/* 110 */         log.trace("createTopElement " + namespace + ":" + name + " result=" + BuilderUtil.toDebugString(element));
/* 111 */       return element;
/*     */     }
/*     */     catch (RuntimeException e)
/*     */     {
/* 115 */       throw e;
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 119 */     throw new RuntimeException("Error creating dom", e);
/*     */   }
/*     */ 
/*     */   public Element appendChildElement(Element parentElement, String namespace, String name)
/*     */   {
/* 125 */     Document document = parentElement.getOwnerDocument();
/* 126 */     Element element = document.createElementNS(namespace, name);
/* 127 */     parentElement.appendChild(element);
/* 128 */     if (this.trace)
/* 129 */       log.trace("appendChild parent=" + BuilderUtil.toDebugString(parentElement) + " child=" + BuilderUtil.toDebugString(element));
/* 130 */     return element;
/*     */   }
/*     */ 
/*     */   public void addAttributes(Element element, Attributes attrs)
/*     */   {
/* 135 */     for (int i = 0; i < attrs.getLength(); i++)
/*     */     {
/* 137 */       String local = attrs.getLocalName(i);
/* 138 */       String nsURI = attrs.getURI(i);
/* 139 */       String value = attrs.getValue(i);
/* 140 */       if (this.trace)
/* 141 */         log.trace("setAttribute " + nsURI + " " + local + " element=" + BuilderUtil.toDebugString(element) + " value=" + value);
/* 142 */       element.setAttributeNS(nsURI, local, value);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setText(Object owner, Object value, QName qName)
/*     */   {
/* 148 */     if (value == null)
/* 149 */       return;
/* 150 */     if ((owner == null) || (!(owner instanceof Element)))
/* 151 */       throw new IllegalStateException("Unexpected owner: " + owner + " for " + qName);
/* 152 */     if (!(value instanceof String))
/* 153 */       throw new IllegalStateException("Unexpected value " + value + " for " + qName);
/* 154 */     Element element = (Element)owner;
/* 155 */     Text text = element.getOwnerDocument().createTextNode((String)value);
/* 156 */     if (this.trace)
/* 157 */       log.trace("setText " + qName + " parent=" + BuilderUtil.toDebugString(owner) + " child=" + BuilderUtil.toDebugString(value));
/* 158 */     element.appendChild(text);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.builder.runtime.DOMHandler
 * JD-Core Version:    0.6.0
 */