/*     */ package org.jboss.xb.builder.runtime;
/*     */ 
/*     */ import java.lang.reflect.Modifier;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.HashSet;
/*     */ import java.util.Set;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.beans.info.spi.PropertyInfo;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.reflect.spi.ClassInfo;
/*     */ import org.jboss.reflect.spi.ConstructorInfo;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ import org.jboss.reflect.spi.TypeInfoFactory;
/*     */ import org.jboss.xb.annotations.JBossXmlCollection;
/*     */ import org.jboss.xb.spi.BeanAdapter;
/*     */ 
/*     */ public class CollectionPropertyHandler extends AbstractPropertyHandler
/*     */ {
/*     */   private final CollectionFactory colFactory;
/*     */ 
/*     */   public CollectionPropertyHandler(PropertyInfo propertyInfo, TypeInfo propertyType)
/*     */   {
/*  58 */     super(propertyInfo, propertyType);
/*     */ 
/*  60 */     ClassInfo collectionType = null;
/*  61 */     JBossXmlCollection xmlCol = (JBossXmlCollection)propertyInfo.getUnderlyingAnnotation(JBossXmlCollection.class);
/*  62 */     if (xmlCol != null)
/*     */     {
/*  64 */       collectionType = (ClassInfo)propertyType.getTypeInfoFactory().getTypeInfo(xmlCol.type());
/*     */     }
/*  66 */     else if (!Modifier.isAbstract(((ClassInfo)propertyType).getModifiers()))
/*     */     {
/*  68 */       collectionType = (ClassInfo)propertyType;
/*     */     }
/*     */ 
/*  71 */     if (collectionType == null)
/*     */     {
/*  73 */       TypeInfo set = propertyType.getTypeInfoFactory().getTypeInfo(Set.class);
/*  74 */       if (set.isAssignableFrom(propertyType))
/*     */       {
/*  76 */         this.colFactory = new HashSetFactory(null);
/*     */       }
/*     */       else
/*     */       {
/*  80 */         this.colFactory = new ArrayListFactory(null);
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/*  85 */       ConstructorInfo constructor = collectionType.getDeclaredConstructor(null);
/*  86 */       if (constructor == null)
/*     */       {
/*  88 */         for (ConstructorInfo ctor : collectionType.getDeclaredConstructors())
/*     */         {
/*  90 */           if (ctor.getParameterTypes().length != 0)
/*     */             continue;
/*  92 */           this.log.warn("ClassInfo.getDeclaredConstructor(null) didn't work for " + collectionType.getName() + ", found the default ctor in ClassInfo.getDeclaredConstructors()");
/*     */ 
/*  94 */           constructor = ctor;
/*  95 */           break;
/*     */         }
/*     */ 
/*  99 */         if (constructor == null)
/*     */         {
/* 101 */           throw new RuntimeException("Default constructor not found for " + collectionType.getName());
/*     */         }
/*     */       }
/* 104 */       this.colFactory = new CtorCollectionFactory(constructor);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void handle(PropertyInfo propertyInfo, TypeInfo propertyType, Object parent, Object child, QName qName)
/*     */   {
/* 112 */     BeanAdapter beanAdapter = (BeanAdapter)parent;
/*     */ 
/* 114 */     Collection c = null;
/*     */     try
/*     */     {
/* 117 */       if (propertyInfo.getGetter() != null)
/* 118 */         c = (Collection)beanAdapter.get(propertyInfo);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 122 */       throw new RuntimeException("QName " + qName + " error getting collection property " + propertyInfo.getName() + " for " + BuilderUtil.toDebugString(parent), t);
/*     */     }
/*     */ 
/* 126 */     if (c == null)
/*     */     {
/*     */       try
/*     */       {
/* 130 */         c = this.colFactory.createCollection();
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 134 */         throw new RuntimeException("QName " + qName + " error creating collection: " + propertyType.getName(), t);
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 139 */         beanAdapter.set(propertyInfo, c);
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 143 */         throw new RuntimeException("QName " + qName + " error setting collection property " + propertyInfo.getName() + " for " + BuilderUtil.toDebugString(parent) + " with value " + BuilderUtil.toDebugString(c), t);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 150 */       c.add(child);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 154 */       throw new RuntimeException("QName " + qName + " error adding " + BuilderUtil.toDebugString(child) + " to collection " + BuilderUtil.toDebugString(c), e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class CtorCollectionFactory
/*     */     implements CollectionPropertyHandler.CollectionFactory
/*     */   {
/*     */     private final ConstructorInfo ctor;
/*     */ 
/*     */     CtorCollectionFactory(ConstructorInfo ctor)
/*     */     {
/* 187 */       this.ctor = ctor;
/*     */     }
/*     */ 
/*     */     public Collection<Object> createCollection()
/*     */       throws Throwable
/*     */     {
/* 193 */       return (Collection)this.ctor.newInstance(null);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class HashSetFactory
/*     */     implements CollectionPropertyHandler.CollectionFactory
/*     */   {
/*     */     public Collection<Object> createCollection()
/*     */     {
/* 177 */       return new HashSet();
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class ArrayListFactory
/*     */     implements CollectionPropertyHandler.CollectionFactory
/*     */   {
/*     */     public Collection<Object> createCollection()
/*     */     {
/* 168 */       return new ArrayList();
/*     */     }
/*     */   }
/*     */ 
/*     */   private static abstract interface CollectionFactory
/*     */   {
/*     */     public abstract Collection<Object> createCollection()
/*     */       throws Throwable;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.builder.runtime.CollectionPropertyHandler
 * JD-Core Version:    0.6.0
 */