/*     */ package org.jboss.xb.builder.runtime;
/*     */ 
/*     */ import java.util.Collection;
/*     */ import javax.xml.namespace.NamespaceContext;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.beans.info.spi.BeanInfo;
/*     */ import org.jboss.reflect.spi.ClassInfo;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ import org.jboss.reflect.spi.TypeInfoFactory;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.ParticleHandler;
/*     */ import org.jboss.xb.spi.BeanAdapter;
/*     */ import org.xml.sax.Attributes;
/*     */ 
/*     */ public class ChildCollectionWildcardHandler
/*     */   implements ParticleHandler
/*     */ {
/*  46 */   public static ChildCollectionWildcardHandler SINGLETON = new ChildCollectionWildcardHandler();
/*     */   private BeanInfo beanInfo;
/*     */   private String property;
/*     */ 
/*     */   public ChildCollectionWildcardHandler()
/*     */   {
/*     */   }
/*     */ 
/*     */   public ChildCollectionWildcardHandler(BeanInfo beanInfo, String property)
/*     */   {
/*  70 */     if (beanInfo == null)
/*  71 */       throw new IllegalArgumentException("Null beanInfo");
/*  72 */     if (property == null)
/*  73 */       throw new IllegalArgumentException("Null property");
/*  74 */     this.beanInfo = beanInfo;
/*  75 */     this.property = property;
/*     */   }
/*     */ 
/*     */   public Object startParticle(Object parent, QName elementName, ParticleBinding particle, Attributes attrs, NamespaceContext nsCtx)
/*     */   {
/*  80 */     return parent;
/*     */   }
/*     */ 
/*     */   public void setParent(Object parent, Object o, QName elementName, ParticleBinding particle, ParticleBinding parentParticle)
/*     */   {
/*  86 */     BeanAdapter beanAdapter = (BeanAdapter)parent;
/*  87 */     Collection collection = (Collection)beanAdapter.getValue();
/*     */ 
/*  89 */     if (this.beanInfo != null)
/*     */     {
/*     */       try
/*     */       {
/*  93 */         ClassInfo classInfo = this.beanInfo.getClassInfo();
/*  94 */         TypeInfo valueType = classInfo.getTypeInfoFactory().getTypeInfo(o.getClass());
/*  95 */         if (!classInfo.isAssignableFrom(valueType))
/*     */         {
/*  97 */           Object wrapper = this.beanInfo.newInstance();
/*  98 */           this.beanInfo.setProperty(wrapper, this.property, o);
/*  99 */           o = wrapper;
/*     */         }
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 104 */         throw new RuntimeException("Error wrapping object in " + this.beanInfo.getName());
/*     */       }
/*     */     }
/* 107 */     collection.add(o);
/*     */   }
/*     */ 
/*     */   public Object endParticle(Object o, QName elementName, ParticleBinding particle)
/*     */   {
/* 112 */     return o;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.builder.runtime.ChildCollectionWildcardHandler
 * JD-Core Version:    0.6.0
 */