/*     */ package org.jboss.xb.builder.runtime;
/*     */ 
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.beans.info.spi.PropertyInfo;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.AttributeBinding;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.AttributeHandler;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.ValueAdapter;
/*     */ import org.jboss.xb.spi.BeanAdapter;
/*     */ 
/*     */ public abstract class AbstractPropertyHandler extends AttributeHandler
/*     */ {
/*  43 */   protected final Logger log = Logger.getLogger(getClass());
/*     */ 
/*  46 */   protected boolean trace = this.log.isTraceEnabled();
/*     */   private PropertyInfo propertyInfo;
/*     */   private TypeInfo propertyType;
/*     */ 
/*     */   public AbstractPropertyHandler(PropertyInfo propertyInfo, TypeInfo propertyType)
/*     */   {
/*  63 */     if (propertyInfo == null)
/*  64 */       throw new IllegalArgumentException("Null propertyInfo");
/*  65 */     if (propertyType == null)
/*  66 */       throw new IllegalArgumentException("Null propertyType");
/*  67 */     this.propertyInfo = propertyInfo;
/*  68 */     this.propertyType = propertyType;
/*     */   }
/*     */ 
/*     */   public PropertyInfo getPropertyInfo()
/*     */   {
/*  78 */     return this.propertyInfo;
/*     */   }
/*     */ 
/*     */   public TypeInfo getPropertyType()
/*     */   {
/*  88 */     return this.propertyType;
/*     */   }
/*     */ 
/*     */   public void doHandle(Object parent, Object child, QName qName)
/*     */   {
/*  93 */     if (this.trace) {
/*  94 */       this.log.trace("QName " + qName + " handle " + BuilderUtil.toDebugString(child) + " to " + BuilderUtil.toDebugString(parent) + " property=" + this.propertyInfo.getName());
/*     */     }
/*     */     try
/*     */     {
/*  98 */       handle(this.propertyInfo, this.propertyType, parent, child, qName);
/*     */     }
/*     */     catch (RuntimeException e)
/*     */     {
/* 102 */       throw e;
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 106 */       throw new RuntimeException("QName " + qName + "error setting property " + this.propertyInfo.getName() + " with value " + BuilderUtil.toDebugString(child) + " to " + BuilderUtil.toDebugString(parent));
/*     */     }
/*     */   }
/*     */ 
/*     */   public void attribute(QName elemName, QName attrName, AttributeBinding binding, Object owner, Object value)
/*     */   {
/* 113 */     ValueAdapter valueAdapter = binding.getValueAdapter();
/* 114 */     if (valueAdapter != null) {
/* 115 */       value = valueAdapter.cast(value, null);
/*     */     }
/* 117 */     BeanAdapter parent = (BeanAdapter)owner;
/* 118 */     doHandle(parent, value, attrName);
/*     */   }
/*     */ 
/*     */   public abstract void handle(PropertyInfo paramPropertyInfo, TypeInfo paramTypeInfo, Object paramObject1, Object paramObject2, QName paramQName);
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.builder.runtime.AbstractPropertyHandler
 * JD-Core Version:    0.6.0
 */