/*      */ package org.jboss.xb.builder;
/*      */ 
/*      */ import java.lang.reflect.Method;
/*      */ import java.lang.reflect.ParameterizedType;
/*      */ import java.lang.reflect.Type;
/*      */ import java.lang.reflect.TypeVariable;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Arrays;
/*      */ import java.util.Collection;
/*      */ import java.util.Collections;
/*      */ import java.util.HashMap;
/*      */ import java.util.HashSet;
/*      */ import java.util.Iterator;
/*      */ import java.util.List;
/*      */ import java.util.Map;
/*      */ import java.util.Set;
/*      */ import java.util.Stack;
/*      */ import javax.xml.bind.annotation.XmlAccessOrder;
/*      */ import javax.xml.bind.annotation.XmlAccessorOrder;
/*      */ import javax.xml.bind.annotation.XmlAnyElement;
/*      */ import javax.xml.bind.annotation.XmlAttribute;
/*      */ import javax.xml.bind.annotation.XmlElement;
/*      */ import javax.xml.bind.annotation.XmlElement.DEFAULT;
/*      */ import javax.xml.bind.annotation.XmlElementWrapper;
/*      */ import javax.xml.bind.annotation.XmlElements;
/*      */ import javax.xml.bind.annotation.XmlEnum;
/*      */ import javax.xml.bind.annotation.XmlNsForm;
/*      */ import javax.xml.bind.annotation.XmlRootElement;
/*      */ import javax.xml.bind.annotation.XmlSchema;
/*      */ import javax.xml.bind.annotation.XmlTransient;
/*      */ import javax.xml.bind.annotation.XmlType;
/*      */ import javax.xml.bind.annotation.XmlType.DEFAULT;
/*      */ import javax.xml.bind.annotation.XmlValue;
/*      */ import javax.xml.bind.annotation.adapters.XmlAdapter;
/*      */ import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
/*      */ import javax.xml.namespace.QName;
/*      */ import org.jboss.beans.info.spi.BeanInfo;
/*      */ import org.jboss.beans.info.spi.PropertyInfo;
/*      */ import org.jboss.config.spi.Configuration;
/*      */ import org.jboss.joinpoint.plugins.Config;
/*      */ import org.jboss.logging.Logger;
/*      */ import org.jboss.reflect.plugins.introspection.ParameterizedClassInfo;
/*      */ import org.jboss.reflect.spi.ArrayInfo;
/*      */ import org.jboss.reflect.spi.ClassInfo;
/*      */ import org.jboss.reflect.spi.EnumInfo;
/*      */ import org.jboss.reflect.spi.MethodInfo;
/*      */ import org.jboss.reflect.spi.PackageInfo;
/*      */ import org.jboss.reflect.spi.TypeInfo;
/*      */ import org.jboss.reflect.spi.TypeInfoFactory;
/*      */ import org.jboss.xb.annotations.JBossXmlAdaptedType;
/*      */ import org.jboss.xb.annotations.JBossXmlAdaptedTypes;
/*      */ import org.jboss.xb.annotations.JBossXmlAttribute;
/*      */ import org.jboss.xb.annotations.JBossXmlChild;
/*      */ import org.jboss.xb.annotations.JBossXmlChildWildcard;
/*      */ import org.jboss.xb.annotations.JBossXmlChildren;
/*      */ import org.jboss.xb.annotations.JBossXmlCollection;
/*      */ import org.jboss.xb.annotations.JBossXmlGroup;
/*      */ import org.jboss.xb.annotations.JBossXmlGroupText;
/*      */ import org.jboss.xb.annotations.JBossXmlGroupWildcard;
/*      */ import org.jboss.xb.annotations.JBossXmlModelGroup;
/*      */ import org.jboss.xb.annotations.JBossXmlModelGroup.Particle;
/*      */ import org.jboss.xb.annotations.JBossXmlNoElements;
/*      */ import org.jboss.xb.annotations.JBossXmlNsPrefix;
/*      */ import org.jboss.xb.annotations.JBossXmlSchema;
/*      */ import org.jboss.xb.annotations.JBossXmlType;
/*      */ import org.jboss.xb.binding.SimpleTypeBindings;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.AllBinding;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.AttributeBinding;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.AttributeHandler;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.CharactersHandler;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.ChoiceBinding;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.DefaultElementHandler;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.DefaultElementInterceptor;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.ModelGroupBinding;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.ParticleHandler;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.SequenceBinding;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.ValueAdapter;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.WildcardBinding;
/*      */ import org.jboss.xb.builder.runtime.AbstractPropertyHandler;
/*      */ import org.jboss.xb.builder.runtime.ArraySequenceBinding;
/*      */ import org.jboss.xb.builder.runtime.BeanHandler;
/*      */ import org.jboss.xb.builder.runtime.BuilderParticleHandler;
/*      */ import org.jboss.xb.builder.runtime.BuilderSimpleParticleHandler;
/*      */ import org.jboss.xb.builder.runtime.ChildCollectionInterceptor;
/*      */ import org.jboss.xb.builder.runtime.ChildCollectionWildcardHandler;
/*      */ import org.jboss.xb.builder.runtime.ChildWildcardHandler;
/*      */ import org.jboss.xb.builder.runtime.CollectionPropertyHandler;
/*      */ import org.jboss.xb.builder.runtime.CollectionPropertyWildcardHandler;
/*      */ import org.jboss.xb.builder.runtime.DOMHandler;
/*      */ import org.jboss.xb.builder.runtime.EnumValueAdapter;
/*      */ import org.jboss.xb.builder.runtime.NoopPropertyHandler;
/*      */ import org.jboss.xb.builder.runtime.PropertyHandler;
/*      */ import org.jboss.xb.builder.runtime.PropertyInterceptor;
/*      */ import org.jboss.xb.builder.runtime.PropertyWildcardHandler;
/*      */ import org.jboss.xb.builder.runtime.ValueHandler;
/*      */ import org.jboss.xb.spi.BeanAdapterBuilder;
/*      */ import org.jboss.xb.spi.BeanAdapterFactory;
/*      */ import org.jboss.xb.spi.DefaultBeanAdapterBuilder;
/*      */ import org.w3c.dom.Element;
/*      */ 
/*      */ public class JBossXBNoSchemaBuilder
/*      */ {
/*  133 */   private static final Logger log = Logger.getLogger(JBossXBBuilder.class);
/*      */ 
/*  136 */   private boolean trace = log.isTraceEnabled();
/*      */   private SchemaBinding schemaBinding;
/*      */   private ClassInfo root;
/*      */   private String defaultNamespace;
/*  148 */   private XmlNsForm attributeForm = XmlNsForm.UNSET;
/*      */ 
/*  151 */   private XmlNsForm elementForm = XmlNsForm.UNSET;
/*      */ 
/*  154 */   private Map<TypeInfo, TypeBinding> typeCache = new HashMap();
/*      */ 
/*  157 */   private Map<TypeInfo, ElementBinding> rootCache = new HashMap();
/*      */ 
/*  160 */   private Stack<Location> locations = new Stack();
/*      */ 
/*      */   public JBossXBNoSchemaBuilder(ClassInfo root)
/*      */   {
/*  170 */     if (root == null) {
/*  171 */       throw new IllegalArgumentException("Null root");
/*      */     }
/*  173 */     this.root = root;
/*      */   }
/*      */ 
/*      */   public SchemaBinding build()
/*      */   {
/*  183 */     initSchema();
/*  184 */     createRootElements();
/*  185 */     return this.schemaBinding;
/*      */   }
/*      */ 
/*      */   protected void initSchema()
/*      */   {
/*  194 */     this.schemaBinding = new SchemaBinding();
/*  195 */     JBossXBBuilder.initSchema(this.schemaBinding, this.root);
/*  196 */     if (this.trace) {
/*  197 */       log.trace("Building schema for " + this.root.getName() + " schemaBinding=" + this.schemaBinding);
/*      */     }
/*      */ 
/*  200 */     if (this.defaultNamespace == null)
/*      */     {
/*  202 */       this.defaultNamespace = ((String)this.schemaBinding.getNamespaces().iterator().next());
/*      */     }
/*      */ 
/*  205 */     JBossXmlSchema jbossXmlSchema = (JBossXmlSchema)this.root.getUnderlyingAnnotation(JBossXmlSchema.class);
/*  206 */     if (jbossXmlSchema != null)
/*      */     {
/*  208 */       this.attributeForm = jbossXmlSchema.attributeFormDefault();
/*  209 */       this.elementForm = jbossXmlSchema.elementFormDefault();
/*      */     }
/*      */ 
/*  213 */     PackageInfo packageInfo = this.root.getPackage();
/*  214 */     if (packageInfo != null)
/*      */     {
/*  216 */       jbossXmlSchema = (JBossXmlSchema)this.root.getUnderlyingAnnotation(JBossXmlSchema.class);
/*  217 */       if (jbossXmlSchema != null)
/*      */       {
/*  219 */         if (this.attributeForm == XmlNsForm.UNSET)
/*  220 */           this.attributeForm = jbossXmlSchema.attributeFormDefault();
/*  221 */         if (this.elementForm == XmlNsForm.UNSET) {
/*  222 */           this.elementForm = jbossXmlSchema.elementFormDefault();
/*      */         }
/*      */       }
/*  225 */       XmlSchema xmlSchema = (XmlSchema)packageInfo.getUnderlyingAnnotation(XmlSchema.class);
/*  226 */       if (xmlSchema != null)
/*      */       {
/*  228 */         String namespace = xmlSchema.namespace();
/*  229 */         if ((!"##default".equals(xmlSchema)) && ("".equals(this.defaultNamespace)))
/*      */         {
/*  231 */           this.defaultNamespace = namespace;
/*  232 */           addNamespace(this.defaultNamespace, true);
/*      */         }
/*      */ 
/*  235 */         if (this.attributeForm == XmlNsForm.UNSET)
/*  236 */           this.attributeForm = xmlSchema.attributeFormDefault();
/*  237 */         if (this.elementForm == XmlNsForm.UNSET) {
/*  238 */           this.elementForm = xmlSchema.elementFormDefault();
/*      */         }
/*      */       }
/*      */ 
/*  242 */       JBossXmlAdaptedTypes adaptedTypes = (JBossXmlAdaptedTypes)packageInfo.getUnderlyingAnnotation(JBossXmlAdaptedTypes.class);
/*  243 */       if (adaptedTypes != null)
/*      */       {
/*  245 */         for (JBossXmlAdaptedType adaptedType : adaptedTypes.value())
/*  246 */           generateAdaptedType(adaptedType);
/*      */       }
/*  248 */       JBossXmlAdaptedType adaptedType = (JBossXmlAdaptedType)packageInfo.getUnderlyingAnnotation(JBossXmlAdaptedType.class);
/*  249 */       if (adaptedType != null)
/*  250 */         generateAdaptedType(adaptedType);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void createRootElements()
/*      */   {
/*  260 */     createRootElementBinding(this.root);
/*      */   }
/*      */ 
/*      */   protected void createRootElementBinding(TypeInfo typeInfo)
/*      */   {
/*  271 */     if (this.rootCache.containsKey(typeInfo)) {
/*  272 */       return;
/*      */     }
/*  274 */     this.rootCache.put(typeInfo, null);
/*      */ 
/*  277 */     push(typeInfo);
/*      */     try
/*      */     {
/*  280 */       createElementBinding(typeInfo, typeInfo.getSimpleName(), true);
/*  281 */       pop();
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  285 */       throw rethrowWithLocation(e);
/*      */     }
/*      */   }
/*      */ 
/*      */   private ElementBinding createElementBinding(TypeInfo typeInfo, String name, boolean root)
/*      */   {
/*  300 */     TypeBinding typeBinding = resolveTypeBinding(typeInfo);
/*      */ 
/*  303 */     return createElementBinding(typeInfo, typeBinding, name, root);
/*      */   }
/*      */ 
/*      */   private ElementBinding createElementBinding(TypeInfo typeInfo, TypeBinding typeBinding, String name, boolean root)
/*      */   {
/*  318 */     String overrideNamespace = null;
/*  319 */     String overrideName = null;
/*  320 */     if ((typeInfo instanceof ClassInfo))
/*      */     {
/*  322 */       ClassInfo classInfo = (ClassInfo)typeInfo;
/*  323 */       XmlRootElement xmlRootElement = (XmlRootElement)classInfo.getUnderlyingAnnotation(XmlRootElement.class);
/*  324 */       if (xmlRootElement != null)
/*      */       {
/*  326 */         overrideNamespace = xmlRootElement.namespace();
/*  327 */         overrideName = xmlRootElement.name();
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  332 */     XmlNsForm form = this.elementForm;
/*  333 */     if (root)
/*  334 */       form = XmlNsForm.QUALIFIED;
/*  335 */     QName qName = generateXmlName(name, form, overrideNamespace, overrideName);
/*  336 */     return createElementBinding(typeInfo, typeBinding, qName, root);
/*      */   }
/*      */ 
/*      */   private ElementBinding createElementBinding(TypeInfo typeInfo, TypeBinding typeBinding, QName qName, boolean root)
/*      */   {
/*  350 */     if (this.trace) {
/*  351 */       log.trace("creating element " + qName + " with type " + typeInfo.getName());
/*      */     }
/*  353 */     if ((typeInfo instanceof ClassInfo))
/*      */     {
/*  355 */       ClassInfo classInfo = (ClassInfo)typeInfo;
/*  356 */       XmlRootElement xmlRootElement = (XmlRootElement)classInfo.getUnderlyingAnnotation(XmlRootElement.class);
/*  357 */       if (xmlRootElement != null) {
/*  358 */         root = true;
/*      */       }
/*      */     }
/*  361 */     ElementBinding elementBinding = new ElementBinding(this.schemaBinding, qName, typeBinding);
/*  362 */     if (this.trace) {
/*  363 */       log.trace("created  element " + qName + " element=" + elementBinding + " rootElement=" + root);
/*      */     }
/*      */ 
/*  366 */     if (root)
/*      */     {
/*  368 */       this.schemaBinding.addElement(elementBinding);
/*  369 */       ParticleBinding particleBinding = this.schemaBinding.getElementParticle(qName);
/*  370 */       particleBinding.setMinOccurs(1);
/*  371 */       particleBinding.setMaxOccurs(1);
/*  372 */       this.rootCache.put(typeInfo, elementBinding);
/*      */     }
/*      */ 
/*  375 */     return elementBinding;
/*      */   }
/*      */ 
/*      */   protected void process(TypeInfo typeInfo)
/*      */   {
/*  385 */     if ((!typeInfo.isPrimitive()) && (typeInfo.isEnum()) && (typeInfo.isAnnotation()) && (!Object.class.getName().equals(typeInfo.getName())))
/*      */     {
/*  387 */       ClassInfo classInfo = (ClassInfo)typeInfo;
/*      */ 
/*  390 */       resolveTypeBinding(typeInfo);
/*      */ 
/*  393 */       if (!this.rootCache.containsKey(typeInfo))
/*      */       {
/*  395 */         XmlRootElement xmlRootElement = (XmlRootElement)classInfo.getUnderlyingAnnotation(XmlRootElement.class);
/*  396 */         if (xmlRootElement != null)
/*  397 */           createRootElementBinding(typeInfo);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected TypeBinding resolveTypeBinding(TypeInfo typeInfo)
/*      */   {
/*  411 */     if (this.trace) {
/*  412 */       log.trace("resolving type " + typeInfo.getName());
/*      */     }
/*      */ 
/*  415 */     TypeBinding result = (TypeBinding)this.typeCache.get(typeInfo);
/*      */ 
/*  418 */     if (result == null)
/*      */     {
/*  421 */       result = generateTypeBinding(typeInfo);
/*      */ 
/*  424 */       this.typeCache.put(typeInfo, result);
/*      */     }
/*  426 */     if (this.trace) {
/*  427 */       log.trace("resolved  type " + typeInfo.getName() + " binding=" + result);
/*      */     }
/*      */ 
/*  430 */     return result;
/*      */   }
/*      */ 
/*      */   protected TypeBinding generateTypeBinding(TypeInfo typeInfo)
/*      */   {
/*      */     try
/*      */     {
/*      */       TypeBinding localTypeBinding1;
/*  443 */       if (typeInfo.isEnum()) {
/*  444 */         localTypeBinding1 = generateEnum((EnumInfo)typeInfo);
/*      */         ClassInfo classInfo;
/*      */         TypeInfo[] typeArgs;
/*      */         int i;
/*      */         ClassInfo superClass;
/*      */         return localTypeBinding1;
/*      */       }
/*  446 */       if (typeInfo.isAnnotation()) {
/*  447 */         localTypeBinding1 = generateAnnotation((ClassInfo)typeInfo);
/*      */         ClassInfo classInfo;
/*      */         TypeInfo[] typeArgs;
/*      */         int i;
/*      */         ClassInfo superClass;
/*      */         return localTypeBinding1;
/*      */       }
/*  449 */       if (typeInfo.isArray()) {
/*  450 */         localTypeBinding1 = generateArray((ArrayInfo)typeInfo);
/*      */         ClassInfo classInfo;
/*      */         TypeInfo[] typeArgs;
/*      */         int i;
/*      */         ClassInfo superClass;
/*      */         return localTypeBinding1;
/*      */       }
/*  452 */       if (typeInfo.isCollection()) {
/*  453 */         localTypeBinding1 = generateCollection((ClassInfo)typeInfo);
/*      */         ClassInfo classInfo;
/*      */         TypeInfo[] typeArgs;
/*      */         int i;
/*      */         ClassInfo superClass;
/*      */         return localTypeBinding1;
/*      */       }
/*  455 */       if (typeInfo.isMap()) {
/*  456 */         localTypeBinding1 = generateMap((ClassInfo)typeInfo);
/*      */         TypeInfo[] typeArgs;
/*      */         int i;
/*      */         ClassInfo superClass;
/*      */         return localTypeBinding1;
/*      */       }
/*  458 */       TypeBinding typeBinding = isSimpleType(typeInfo);
/*  459 */       if (typeBinding != null) {
/*  460 */         classInfo = typeBinding;
/*      */         ClassInfo classInfo;
/*      */         TypeInfo[] typeArgs;
/*      */         int i;
/*      */         ClassInfo superClass;
/*      */         return classInfo;
/*      */       }
/*  462 */       ClassInfo classInfo = generateBean((ClassInfo)typeInfo);
/*      */       ClassInfo classInfo;
/*      */       TypeInfo[] typeArgs;
/*      */       int i;
/*      */       ClassInfo superClass;
/*      */       return classInfo;
/*      */     }
/*      */     finally
/*      */     {
/*  467 */       if (!typeInfo.isPrimitive())
/*      */       {
/*  469 */         ClassInfo classInfo = (ClassInfo)typeInfo;
/*      */ 
/*  472 */         TypeInfo[] typeArgs = classInfo.getActualTypeArguments();
/*  473 */         if (typeArgs != null)
/*      */         {
/*  475 */           for (int i = 0; i < typeArgs.length; i++) {
/*  476 */             process(typeArgs[i]);
/*      */           }
/*      */         }
/*      */ 
/*  480 */         ClassInfo superClass = classInfo.getGenericSuperclass();
/*  481 */         if (superClass != null)
/*  482 */           process(superClass); 
/*      */       }
/*      */     }
/*  483 */     throw localObject;
/*      */   }
/*      */ 
/*      */   public TypeBinding generateEnum(EnumInfo typeInfo)
/*      */   {
/*  496 */     String overrideNamespace = null;
/*  497 */     String overrideName = null;
/*  498 */     boolean root = false;
/*  499 */     XmlType xmlType = (XmlType)typeInfo.getUnderlyingAnnotation(XmlType.class);
/*  500 */     if (xmlType != null)
/*      */     {
/*  502 */       root = true;
/*  503 */       overrideNamespace = xmlType.namespace();
/*  504 */       overrideName = xmlType.name();
/*      */     }
/*      */ 
/*  508 */     Class xmlEnumValue = String.class;
/*  509 */     XmlEnum xmlEnum = (XmlEnum)typeInfo.getUnderlyingAnnotation(XmlEnum.class);
/*  510 */     if (xmlEnum != null)
/*  511 */       xmlEnumValue = xmlEnum.value();
/*  512 */     TypeInfo enumType = typeInfo.getTypeInfoFactory().getTypeInfo(xmlEnumValue);
/*      */ 
/*  515 */     TypeBinding parent = getSimpleType(enumType);
/*      */ 
/*  518 */     QName qName = null;
/*  519 */     TypeBinding typeBinding = null;
/*  520 */     if (root)
/*      */     {
/*  522 */       qName = generateXmlName(typeInfo, XmlNsForm.QUALIFIED, overrideNamespace, overrideName);
/*  523 */       typeBinding = new TypeBinding(qName, parent);
/*      */     }
/*      */     else
/*      */     {
/*  527 */       typeBinding = new TypeBinding(null, parent);
/*      */     }
/*      */ 
/*  530 */     typeBinding.setValueAdapter(new EnumValueAdapter(qName, typeInfo, enumType));
/*      */ 
/*  532 */     if (this.trace) {
/*  533 */       log.trace("Created enum=" + typeInfo.getName() + " type=" + typeBinding + " rootType=" + root);
/*      */     }
/*      */ 
/*  536 */     if (root)
/*  537 */       this.schemaBinding.addType(typeBinding);
/*      */     else {
/*  539 */       typeBinding.setSchemaBinding(this.schemaBinding);
/*      */     }
/*  541 */     return typeBinding;
/*      */   }
/*      */ 
/*      */   public TypeBinding generateAdaptedType(JBossXmlAdaptedType adaptedType)
/*      */   {
/*  553 */     String overrideNamespace = adaptedType.namespace();
/*  554 */     String overrideName = adaptedType.name();
/*  555 */     Class type = adaptedType.type();
/*  556 */     Class adapter = adaptedType.valueAdapter();
/*      */     try
/*      */     {
/*  560 */       TypeInfo typeInfo = JBossXBBuilder.configuration.getTypeInfo(type);
/*  561 */       BeanInfo adapterInfo = JBossXBBuilder.configuration.getBeanInfo(adapter);
/*      */ 
/*  563 */       ValueAdapter valueAdapter = (ValueAdapter)adapterInfo.newInstance();
/*      */ 
/*  565 */       QName qName = generateXmlName(typeInfo, XmlNsForm.QUALIFIED, overrideNamespace, overrideName);
/*      */ 
/*  567 */       TypeInfo parentType = typeInfo.getTypeInfoFactory().getTypeInfo(String.class);
/*  568 */       TypeBinding parent = getSimpleType(parentType);
/*      */ 
/*  570 */       TypeBinding typeBinding = new TypeBinding(qName, parent);
/*  571 */       typeBinding.setValueAdapter(valueAdapter);
/*  572 */       if (this.trace) {
/*  573 */         log.trace("Created adapted type=" + typeInfo.getName() + " typeBinding=" + typeBinding + " adapter=" + adapter.getName());
/*      */       }
/*  575 */       this.typeCache.put(typeInfo, typeBinding);
/*  576 */       this.schemaBinding.addType(typeBinding);
/*      */ 
/*  578 */       return typeBinding;
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  582 */     throw new RuntimeException("Unable to adapt type " + type.getName() + " with " + adapter.getName(), t);
/*      */   }
/*      */ 
/*      */   public TypeBinding generateAnnotation(ClassInfo typeInfo)
/*      */   {
/*  595 */     throw new UnsupportedOperationException("generateAnnotation");
/*      */   }
/*      */ 
/*      */   public TypeBinding generateArray(ArrayInfo typeInfo)
/*      */   {
/*  606 */     return resolveTypeBinding(typeInfo.getComponentType());
/*      */   }
/*      */ 
/*      */   public TypeBinding generateCollection(ClassInfo typeInfo)
/*      */   {
/*  617 */     if ((typeInfo instanceof ParameterizedClassInfo))
/*      */     {
/*  619 */       ParameterizedClassInfo parameterizedClassInfo = (ParameterizedClassInfo)typeInfo;
/*  620 */       TypeInfo[] actualTypes = parameterizedClassInfo.getActualTypeArguments();
/*  621 */       TypeInfo elementType = actualTypes[0];
/*  622 */       return resolveTypeBinding(elementType);
/*      */     }
/*      */ 
/*  626 */     return generateBean(typeInfo);
/*      */   }
/*      */ 
/*      */   public TypeBinding generateMap(ClassInfo typeInfo)
/*      */   {
/*  639 */     return generateBean(typeInfo);
/*      */   }
/*      */ 
/*      */   public TypeBinding isSimpleType(TypeInfo typeInfo)
/*      */   {
/*  650 */     QName qName = SimpleTypeBindings.typeQName(typeInfo.getType());
/*  651 */     if (qName == null)
/*  652 */       return null;
/*  653 */     TypeBinding result = this.schemaBinding.getType(qName);
/*  654 */     if (result == null)
/*  655 */       throw new IllegalStateException("SimpleType is not bound in the schema: " + qName + " for " + typeInfo.getName());
/*  656 */     result.setHandler(BuilderSimpleParticleHandler.SIMPLE_INSTANCE);
/*  657 */     return result;
/*      */   }
/*      */ 
/*      */   public TypeBinding getSimpleType(TypeInfo typeInfo)
/*      */   {
/*  669 */     TypeBinding result = isSimpleType(typeInfo);
/*  670 */     if (result == null)
/*  671 */       throw new IllegalStateException(typeInfo.getName() + " does not map to a simple type.");
/*  672 */     return result;
/*      */   }
/*      */ 
/*      */   public TypeBinding generateBean(ClassInfo typeInfo)
/*      */   {
/*  683 */     return generateBean(typeInfo, false);
/*      */   }
/*      */ 
/*      */   public TypeBinding generateBean(ClassInfo typeInfo, boolean root)
/*      */   {
/*  695 */     return generateType(typeInfo, root);
/*      */   }
/*      */ 
/*      */   public TypeBinding generateType(ClassInfo typeInfo, boolean root)
/*      */   {
/*  708 */     String overrideNamespace = null;
/*  709 */     String overrideName = null;
/*  710 */     ClassInfo factoryClassInfo = typeInfo;
/*  711 */     String factoryMethod = null;
/*  712 */     String[] propertyOrder = { "" };
/*  713 */     XmlAccessOrder accessOrder = XmlAccessOrder.UNDEFINED;
/*  714 */     Class beanAdapterBuilderClass = DefaultBeanAdapterBuilder.class;
/*  715 */     XmlType xmlType = (XmlType)typeInfo.getUnderlyingAnnotation(XmlType.class);
/*  716 */     if (xmlType != null)
/*      */     {
/*  718 */       root = true;
/*  719 */       overrideNamespace = xmlType.namespace();
/*  720 */       overrideName = xmlType.name();
/*  721 */       if (overrideName.length() == 0) {
/*  722 */         root = false;
/*      */       }
/*  724 */       Class factoryClass = xmlType.factoryClass();
/*  725 */       if (factoryClass != XmlType.DEFAULT.class)
/*  726 */         factoryClassInfo = (ClassInfo)typeInfo.getTypeInfoFactory().getTypeInfo(factoryClass);
/*  727 */       factoryMethod = xmlType.factoryMethod();
/*  728 */       propertyOrder = xmlType.propOrder();
/*      */     }
/*  730 */     JBossXmlType jbossXmlType = (JBossXmlType)typeInfo.getUnderlyingAnnotation(JBossXmlType.class);
/*  731 */     if (jbossXmlType != null)
/*      */     {
/*  733 */       beanAdapterBuilderClass = jbossXmlType.beanAdapterBuilder();
/*      */     }
/*      */ 
/*  736 */     XmlAccessorOrder accessorOrder = (XmlAccessorOrder)typeInfo.getUnderlyingAnnotation(XmlAccessorOrder.class);
/*  737 */     if (accessorOrder == null)
/*      */     {
/*  739 */       PackageInfo pkg = typeInfo.getPackage();
/*  740 */       if (pkg != null)
/*  741 */         accessorOrder = (XmlAccessorOrder)pkg.getUnderlyingAnnotation(XmlAccessorOrder.class);
/*      */     }
/*  743 */     if (accessorOrder != null) {
/*  744 */       accessOrder = accessorOrder.value();
/*      */     }
/*      */ 
/*  747 */     TypeBinding typeBinding = null;
/*  748 */     if (root)
/*      */     {
/*  750 */       QName qName = generateXmlName(typeInfo, XmlNsForm.QUALIFIED, overrideNamespace, overrideName);
/*  751 */       typeBinding = new TypeBinding(qName);
/*      */     }
/*      */     else
/*      */     {
/*  755 */       typeBinding = new TypeBinding();
/*      */     }
/*      */ 
/*  759 */     this.typeCache.put(typeInfo, typeBinding);
/*      */ 
/*  762 */     MethodInfo factory = null;
/*  763 */     if ((factoryMethod != null) && (factoryMethod.length() > 0)) {
/*  764 */       factory = Config.findMethodInfo(factoryClassInfo, factoryMethod, null, true, true);
/*      */     }
/*      */ 
/*  767 */     BeanInfo beanInfo = JBossXBBuilder.configuration.getBeanInfo(typeInfo);
/*  768 */     BeanAdapterFactory beanAdapterFactory = null;
/*      */     try
/*      */     {
/*  771 */       BeanInfo beanAdapterBuilderInfo = JBossXBBuilder.configuration.getBeanInfo(beanAdapterBuilderClass);
/*  772 */       BeanAdapterBuilder beanAdapterBuilder = (BeanAdapterBuilder)beanAdapterBuilderInfo.newInstance();
/*  773 */       beanAdapterFactory = beanAdapterBuilder.newFactory(beanInfo, factory);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  777 */       throw new RuntimeException("Error creating BeanAdapterFactory for " + beanAdapterBuilderClass.getName(), t);
/*      */     }
/*  779 */     BeanHandler handler = new BeanHandler(beanInfo.getName(), beanAdapterFactory);
/*  780 */     typeBinding.setHandler(handler);
/*  781 */     if (this.trace) {
/*  782 */       log.trace("Created BeanHandler for type=" + beanInfo.getName() + " factory=" + factory);
/*      */     }
/*      */ 
/*  785 */     JBossXmlNoElements jbossXmlNoElements = (JBossXmlNoElements)typeInfo.getUnderlyingAnnotation(JBossXmlNoElements.class);
/*  786 */     boolean noElements = jbossXmlNoElements != null;
/*  787 */     PropertyInfo valueProperty = null;
/*  788 */     PropertyInfo wildcardProperty = null;
/*  789 */     boolean allBinding = propertyOrder.length == 0;
/*  790 */     boolean determinePropertyOrder = (allBinding) || ((propertyOrder.length == 1) && (propertyOrder[0].length() == 0));
/*  791 */     ArrayList propertyNames = new ArrayList();
/*  792 */     Set properties = beanInfo.getProperties();
/*  793 */     if ((properties != null) && (!properties.isEmpty()))
/*      */     {
/*  795 */       boolean seenXmlAnyElement = false;
/*  796 */       for (PropertyInfo property : properties)
/*      */       {
/*  798 */         push(typeInfo, property.getName());
/*      */ 
/*  800 */         if (this.trace) {
/*  801 */           log.trace("Checking property " + property.getName() + " for " + beanInfo.getName() + " type=" + property.getType().getName());
/*      */         }
/*      */ 
/*  804 */         XmlValue xmlValue = (XmlValue)property.getUnderlyingAnnotation(XmlValue.class);
/*  805 */         if (xmlValue != null)
/*      */         {
/*  807 */           if (this.trace)
/*  808 */             log.trace("Seen @XmlValue for type=" + beanInfo.getName() + " property=" + property.getName());
/*  809 */           if (valueProperty != null)
/*  810 */             throw new RuntimeException("@XmlValue seen on two properties: " + property.getName() + " and " + valueProperty.getName());
/*  811 */           valueProperty = property;
/*      */         }
/*      */ 
/*  815 */         XmlAnyElement xmlAnyElement = (XmlAnyElement)property.getUnderlyingAnnotation(XmlAnyElement.class);
/*  816 */         if (xmlAnyElement != null)
/*      */         {
/*  818 */           if (this.trace)
/*  819 */             log.trace("Seen @XmlAnyElement for type=" + beanInfo.getName() + " property=" + property.getName());
/*  820 */           if ((wildcardProperty != null) && (seenXmlAnyElement))
/*  821 */             throw new RuntimeException("@XmlAnyElement seen on two properties: " + property.getName() + " and " + wildcardProperty.getName());
/*  822 */           wildcardProperty = property;
/*  823 */           seenXmlAnyElement = true;
/*      */         }
/*  825 */         else if ((!seenXmlAnyElement) && (wildcardProperty == null) && (property.getType().getName().equals(Element.class.getName())))
/*      */         {
/*  827 */           if (this.trace)
/*  828 */             log.trace("Using type=" + beanInfo.getName() + " property=" + property.getName() + " as the base wildcard");
/*  829 */           if (wildcardProperty != null)
/*  830 */             throw new RuntimeException("@XmlAnyElement seen on two properties: " + property.getName() + " and " + wildcardProperty.getName());
/*  831 */           wildcardProperty = property;
/*      */         }
/*      */ 
/*  835 */         XmlAttribute xmlAttribute = (XmlAttribute)property.getUnderlyingAnnotation(XmlAttribute.class);
/*  836 */         if (xmlAttribute != null)
/*      */         {
/*  838 */           JBossXmlAttribute jbossXmlAttribute = (JBossXmlAttribute)property.getUnderlyingAnnotation(JBossXmlAttribute.class);
/*      */ 
/*  840 */           QName qName = generateXmlName(property.getName(), this.attributeForm, xmlAttribute.namespace(), xmlAttribute.name());
/*      */ 
/*  842 */           TypeInfo attributeTypeInfo = property.getType();
/*  843 */           if ((jbossXmlAttribute != null) && (jbossXmlAttribute.type() != Object.class))
/*  844 */             attributeTypeInfo = attributeTypeInfo.getTypeInfoFactory().getTypeInfo(jbossXmlAttribute.type());
/*  845 */           TypeBinding attributeType = resolveTypeBinding(attributeTypeInfo);
/*      */ 
/*  847 */           AttributeHandler attributeHandler = new PropertyHandler(property, attributeTypeInfo);
/*      */ 
/*  849 */           AttributeBinding attribute = new AttributeBinding(this.schemaBinding, qName, attributeType, attributeHandler);
/*  850 */           attribute.setRequired(xmlAttribute.required());
/*  851 */           typeBinding.addAttribute(attribute);
/*  852 */           if (this.trace) {
/*  853 */             log.trace("Bound attribute " + qName + " type=" + beanInfo.getName() + " property=" + property.getName() + " propertyType=" + attributeTypeInfo);
/*      */           }
/*      */         }
/*      */ 
/*  857 */         if (determinePropertyOrder)
/*      */         {
/*  860 */           if (xmlValue != null)
/*      */           {
/*  862 */             if (this.trace)
/*  863 */               log.trace("Ignore not element @XmlValue for type=" + beanInfo.getName() + " property=" + property.getName());
/*  864 */             pop();
/*  865 */             continue;
/*      */           }
/*      */ 
/*  868 */           if (xmlAnyElement != null)
/*      */           {
/*  870 */             if (this.trace)
/*  871 */               log.trace("Ignore not element @XmlAnyElement for type=" + beanInfo.getName() + " property=" + property.getName());
/*  872 */             pop();
/*  873 */             continue;
/*      */           }
/*      */ 
/*  876 */           if (xmlAttribute != null)
/*      */           {
/*  878 */             if (this.trace)
/*  879 */               log.trace("Ignore not element @XmlAttribute for type=" + beanInfo.getName() + " property=" + property.getName());
/*  880 */             pop();
/*  881 */             continue;
/*      */           }
/*      */ 
/*  884 */           XmlTransient xmlTransient = (XmlTransient)property.getUnderlyingAnnotation(XmlTransient.class);
/*  885 */           if (xmlTransient != null)
/*      */           {
/*  887 */             if (this.trace)
/*  888 */               log.trace("Ignore not element @XmlTransient for type=" + beanInfo.getName() + " property=" + property.getName());
/*  889 */             pop();
/*  890 */             continue;
/*      */           }
/*      */ 
/*  893 */           String name = property.getName();
/*  894 */           if ("class".equals(name))
/*      */           {
/*  896 */             pop();
/*  897 */             continue;
/*      */           }
/*      */ 
/*  900 */           if (noElements)
/*      */           {
/*  902 */             pop();
/*  903 */             continue;
/*      */           }
/*      */ 
/*  906 */           if (this.trace)
/*  907 */             log.trace("Element for type=" + beanInfo.getName() + " property=" + property.getName());
/*  908 */           propertyNames.add(property.getName());
/*      */         }
/*      */ 
/*  911 */         pop();
/*      */       }
/*      */ 
/*  914 */       if (determinePropertyOrder)
/*      */       {
/*  916 */         if (accessOrder == XmlAccessOrder.ALPHABETICAL)
/*  917 */           Collections.sort(propertyNames);
/*  918 */         propertyOrder = (String[])propertyNames.toArray(new String[propertyNames.size()]);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  936 */     if (valueProperty != null)
/*      */     {
/*  938 */       CharactersHandler charactersHandler = new ValueHandler(valueProperty);
/*  939 */       typeBinding.setSimpleType(charactersHandler);
/*      */     }
/*  941 */     else if (this.trace) {
/*  942 */       log.trace("No value for type=" + beanInfo.getName());
/*      */     }
/*  944 */     if (this.trace) {
/*  945 */       log.trace("PropertyOrder " + Arrays.asList(propertyOrder) + " for type=" + beanInfo.getName());
/*      */     }
/*      */ 
/*  949 */     typeBinding.setSimple(false);
/*  950 */     ModelGroupBinding model = null;
/*  951 */     if (allBinding)
/*      */     {
/*  953 */       if (this.trace)
/*  954 */         log.trace("AllBinding for type=" + beanInfo.getName());
/*  955 */       model = new AllBinding(this.schemaBinding);
/*      */     }
/*      */     else
/*      */     {
/*  959 */       if (this.trace)
/*  960 */         log.trace("SequenceBinding for type=" + beanInfo.getName());
/*  961 */       model = new SequenceBinding(this.schemaBinding);
/*      */     }
/*  963 */     model.setHandler(BuilderParticleHandler.INSTANCE);
/*  964 */     ParticleBinding typeParticle = new ParticleBinding(model);
/*  965 */     typeParticle.setMinOccurs(1);
/*  966 */     typeParticle.setMaxOccurs(1);
/*  967 */     typeBinding.setParticle(typeParticle);
/*      */ 
/*  969 */     if (typeInfo.isCollection())
/*      */     {
/*  971 */       TypeInfo memberBaseType = findComponentType(typeInfo);
/*  972 */       JBossXmlModelGroup xmlModelGroup = (JBossXmlModelGroup)((ClassInfo)memberBaseType).getUnderlyingAnnotation(JBossXmlModelGroup.class);
/*      */ 
/*  974 */       if ((xmlModelGroup != null) && (xmlModelGroup.particles().length > 0))
/*      */       {
/*  976 */         if (this.trace) {
/*  977 */           log.trace("Item base type for " + typeInfo.getName() + " is " + memberBaseType.getName() + " and bound to repeatable choice");
/*      */         }
/*      */ 
/*  982 */         ModelGroupBinding choiceGroup = null;
/*  983 */         QName choiceName = null;
/*  984 */         if (!"##default".equals(xmlModelGroup.name()))
/*      */         {
/*  986 */           choiceName = new QName(this.defaultNamespace, xmlModelGroup.name());
/*  987 */           choiceGroup = this.schemaBinding.getGroup(choiceName);
/*      */         }
/*      */ 
/*  990 */         if (choiceGroup == null)
/*      */         {
/*  992 */           choiceGroup = new ChoiceBinding(this.schemaBinding);
/*  993 */           choiceGroup.setHandler(BuilderParticleHandler.INSTANCE);
/*  994 */           if (choiceName != null)
/*      */           {
/*  996 */             choiceGroup.setQName(choiceName);
/*  997 */             this.schemaBinding.addGroup(choiceGroup.getQName(), choiceGroup);
/*      */           }
/*      */ 
/* 1000 */           ParticleBinding choiceParticle = new ParticleBinding(choiceGroup, 0, 1, true);
/* 1001 */           model.addParticle(choiceParticle);
/*      */ 
/* 1003 */           for (JBossXmlModelGroup.Particle member : xmlModelGroup.particles())
/*      */           {
/* 1005 */             XmlElement element = member.element();
/* 1006 */             QName memberQName = generateXmlName(element.name(), XmlNsForm.QUALIFIED, element.namespace(), null);
/* 1007 */             TypeInfo memberTypeInfo = typeInfo.getTypeInfoFactory().getTypeInfo(member.type());
/*      */ 
/* 1009 */             boolean isCol = false;
/* 1010 */             if (memberTypeInfo.isCollection())
/*      */             {
/* 1012 */               memberTypeInfo = findComponentType((ClassInfo)memberTypeInfo);
/* 1013 */               isCol = true;
/*      */             }
/*      */ 
/* 1016 */             TypeBinding memberTypeBinding = resolveTypeBinding(memberTypeInfo);
/* 1017 */             ElementBinding memberElement = createElementBinding(memberTypeInfo, memberTypeBinding, memberQName, false);
/* 1018 */             memberElement.setNillable(true);
/* 1019 */             ParticleBinding memberParticle = new ParticleBinding(memberElement, 0, 1, isCol);
/* 1020 */             choiceGroup.addParticle(memberParticle);
/*      */ 
/* 1022 */             typeBinding.pushInterceptor(memberQName, ChildCollectionInterceptor.SINGLETON);
/*      */           }
/*      */         }
/*      */         else
/*      */         {
/* 1027 */           ParticleBinding choiceParticle = new ParticleBinding(choiceGroup, 0, 1, true);
/* 1028 */           model.addParticle(choiceParticle);
/*      */         }
/*      */ 
/* 1031 */         if (this.trace) {
/* 1032 */           log.trace("choices for " + typeBinding.getQName() + ": " + choiceGroup.getParticles());
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/* 1037 */     AbstractPropertyHandler wildcardHandler = null;
/* 1038 */     if (wildcardProperty != null)
/*      */     {
/* 1040 */       TypeInfo wildcardType = wildcardProperty.getType();
/* 1041 */       if (wildcardType.isCollection())
/* 1042 */         wildcardHandler = new CollectionPropertyWildcardHandler(wildcardProperty, wildcardType);
/*      */       else {
/* 1044 */         wildcardHandler = new PropertyWildcardHandler(wildcardProperty, wildcardType);
/*      */       }
/*      */     }
/*      */ 
/* 1048 */     for (String name : propertyOrder)
/*      */     {
/* 1051 */       push(typeInfo, name);
/*      */ 
/* 1053 */       PropertyInfo property = beanInfo.getProperty(name);
/* 1054 */       bindProperty(property, typeBinding, model, beanAdapterFactory, propertyOrder);
/* 1055 */       pop();
/*      */     }
/*      */ 
/* 1059 */     JBossXmlChild[] children = null;
/* 1060 */     JBossXmlChildren jbossXmlChildren = (JBossXmlChildren)typeInfo.getUnderlyingAnnotation(JBossXmlChildren.class);
/* 1061 */     if (jbossXmlChildren != null) {
/* 1062 */       children = jbossXmlChildren.value();
/*      */     }
/*      */     else {
/* 1065 */       JBossXmlChild jbossXmlChild = (JBossXmlChild)typeInfo.getUnderlyingAnnotation(JBossXmlChild.class);
/* 1066 */       if (jbossXmlChild != null) {
/* 1067 */         children = new JBossXmlChild[] { jbossXmlChild };
/*      */       }
/*      */     }
/* 1070 */     if ((children != null) && (children.length > 0))
/*      */     {
/* 1072 */       for (JBossXmlChild child : children)
/*      */       {
/* 1074 */         QName qName = generateXmlName(child.name(), this.elementForm, child.namespace(), child.name());
/* 1075 */         TypeInfo childType = JBossXBBuilder.configuration.getTypeInfo(child.type());
/*      */ 
/* 1077 */         TypeBinding elementTypeBinding = resolveTypeBinding(childType);
/* 1078 */         ElementBinding elementBinding = createElementBinding(childType, elementTypeBinding, qName, false);
/*      */ 
/* 1081 */         ParticleBinding particle = new ParticleBinding(elementBinding, child.minOccurs(), child.maxOccurs(), child.unbounded());
/* 1082 */         model.addParticle(particle);
/*      */ 
/* 1084 */         DefaultElementInterceptor interceptor = null;
/* 1085 */         if (typeInfo.isCollection()) {
/* 1086 */           interceptor = ChildCollectionInterceptor.SINGLETON;
/*      */         }
/*      */         else
/*      */         {
/* 1090 */           PropertyInfo property = beanInfo.getProperty("value");
/* 1091 */           if (property == null)
/* 1092 */             throw new UnsupportedOperationException("Expected a value property for non-collection type with JBossXmlChildren");
/* 1093 */           TypeInfo propertyType = property.getType();
/* 1094 */           interceptor = new PropertyInterceptor(property, propertyType);
/*      */         }
/* 1096 */         typeBinding.pushInterceptor(qName, interceptor);
/* 1097 */         if (this.trace) {
/* 1098 */           log.trace("Added interceptor " + qName + " for type=" + childType + " interceptor=" + interceptor);
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/* 1103 */     if (wildcardProperty != null)
/*      */     {
/* 1105 */       if (this.trace)
/* 1106 */         log.trace("Processing WildcardProperty for type=" + beanInfo.getName() + " property=" + wildcardProperty.getName());
/* 1107 */       ModelGroupBinding localModel = model;
/* 1108 */       TypeInfo wildcardType = wildcardProperty.getType();
/* 1109 */       TypeInfo type = wildcardType;
/*      */ 
/* 1112 */       if (wildcardType.isArray())
/*      */       {
/* 1114 */         localModel = createArray(localModel);
/* 1115 */         type = ((ArrayInfo)wildcardType).getComponentType();
/* 1116 */         if (this.trace)
/* 1117 */           log.trace("Wildcard " + wildcardProperty.getName() + " is an array of type " + type.getName());
/*      */       }
/* 1119 */       else if (wildcardType.isCollection())
/*      */       {
/* 1121 */         localModel = createCollection(localModel);
/* 1122 */         type = findComponentType(wildcardProperty);
/* 1123 */         if (this.trace) {
/* 1124 */           log.trace("Wildcard " + wildcardProperty.getName() + " is a collection of type " + type.getName());
/*      */         }
/*      */       }
/* 1127 */       XmlAnyElement xmlAnyElement = (XmlAnyElement)wildcardProperty.getUnderlyingAnnotation(XmlAnyElement.class);
/* 1128 */       boolean isLax = xmlAnyElement == null ? true : xmlAnyElement.lax();
/* 1129 */       WildcardBinding wildcard = new WildcardBinding(this.schemaBinding);
/* 1130 */       if (isLax)
/* 1131 */         wildcard.setProcessContents(3);
/*      */       else {
/* 1133 */         wildcard.setProcessContents(1);
/*      */       }
/*      */ 
/* 1136 */       if (Element.class.getName().equals(type.getName()))
/*      */       {
/* 1138 */         wildcard.setUnresolvedElementHandler(DOMHandler.INSTANCE);
/* 1139 */         wildcard.setUnresolvedCharactersHandler(DOMHandler.INSTANCE);
/*      */       }
/*      */ 
/* 1143 */       ParticleBinding particleBinding = new ParticleBinding(wildcard);
/* 1144 */       particleBinding.setMinOccurs(0);
/* 1145 */       particleBinding.setMaxOccurs(1);
/* 1146 */       localModel.addParticle(particleBinding);
/* 1147 */       typeBinding.getWildcard().setWildcardHandler((ParticleHandler)wildcardHandler);
/* 1148 */       beanAdapterFactory.setWildcardHandler(wildcardHandler);
/*      */     }
/*      */ 
/* 1151 */     JBossXmlChildWildcard childWildcard = (JBossXmlChildWildcard)typeInfo.getUnderlyingAnnotation(JBossXmlChildWildcard.class);
/* 1152 */     if (childWildcard != null)
/*      */     {
/* 1154 */       if (beanAdapterFactory.getWildcardHandler() != null) {
/* 1155 */         throw new RuntimeException("Cannot have both @JBossXmlChildWildcard and @XmlAnyElement");
/*      */       }
/* 1157 */       ParticleHandler childWildcardHandler = null;
/* 1158 */       if (typeInfo.isCollection())
/*      */       {
/* 1160 */         if (childWildcard.wrapper() != Object.class)
/*      */         {
/* 1162 */           BeanInfo wrapperInfo = JBossXBBuilder.configuration.getBeanInfo(childWildcard.wrapper());
/* 1163 */           childWildcardHandler = new ChildCollectionWildcardHandler(wrapperInfo, childWildcard.property());
/*      */         }
/*      */         else {
/* 1166 */           childWildcardHandler = ChildCollectionWildcardHandler.SINGLETON;
/*      */         }
/*      */       }
/* 1169 */       else throw new UnsupportedOperationException("TODO");
/*      */ 
/* 1171 */       WildcardBinding wildcard = new WildcardBinding(this.schemaBinding);
/* 1172 */       if (childWildcard.lax())
/* 1173 */         wildcard.setProcessContents(3);
/*      */       else {
/* 1175 */         wildcard.setProcessContents(1);
/*      */       }
/* 1177 */       ParticleBinding particleBinding = new ParticleBinding(wildcard);
/* 1178 */       particleBinding.setMinOccurs(0);
/* 1179 */       particleBinding.setMaxOccurs(1);
/* 1180 */       model.addParticle(particleBinding);
/*      */ 
/* 1182 */       typeBinding.getWildcard().setWildcardHandler(childWildcardHandler);
/*      */     }
/*      */ 
/* 1185 */     if (this.trace) {
/* 1186 */       log.trace("Created type=" + typeInfo.getName() + " typeBinding=" + typeBinding + " rootType=" + root);
/*      */     }
/*      */ 
/* 1189 */     if (root)
/* 1190 */       this.schemaBinding.addType(typeBinding);
/*      */     else {
/* 1192 */       typeBinding.setSchemaBinding(this.schemaBinding);
/*      */     }
/* 1194 */     return typeBinding;
/*      */   }
/*      */ 
/*      */   private void bindProperty(PropertyInfo property, TypeBinding typeBinding, ModelGroupBinding model, BeanAdapterFactory beanAdapterFactory, String[] propertyOrder)
/*      */   {
/* 1200 */     TypeInfo propertyType = property.getType();
/* 1201 */     if (this.trace) {
/* 1202 */       log.trace("Processing type=" + property.getBeanInfo().getName() + " property=" + property.getName());
/*      */     }
/*      */ 
/* 1205 */     XmlTransient xmlTransient = (XmlTransient)property.getUnderlyingAnnotation(XmlTransient.class);
/* 1206 */     if ((xmlTransient != null) && (propertyOrder != null)) {
/* 1207 */       throw new RuntimeException("Property " + property.getName() + " in property order " + Arrays.asList(propertyOrder) + " is marked @XmlTransient");
/*      */     }
/*      */ 
/* 1211 */     ModelGroupBinding localModel = model;
/*      */ 
/* 1214 */     if (propertyType.isArray())
/*      */     {
/* 1216 */       if (this.trace)
/* 1217 */         log.trace("Property " + property.getName() + " is an array");
/* 1218 */       localModel = createArray(localModel);
/*      */     }
/* 1220 */     else if (propertyType.isCollection())
/*      */     {
/* 1222 */       if (this.trace)
/* 1223 */         log.trace("Property " + property.getName() + " is a collection");
/* 1224 */       localModel = createCollection(localModel);
/*      */ 
/* 1226 */       JBossXmlCollection xmlCol = (JBossXmlCollection)property.getUnderlyingAnnotation(JBossXmlCollection.class);
/* 1227 */       if (xmlCol != null)
/*      */       {
/* 1230 */         propertyType = propertyType.getTypeInfoFactory().getTypeInfo(xmlCol.type());
/*      */       }
/*      */ 
/*      */     }
/* 1234 */     else if (!property.getType().isPrimitive())
/*      */     {
/* 1236 */       ClassInfo propClassInfo = (ClassInfo)property.getType();
/*      */ 
/* 1239 */       XmlElement propXmlElement = (XmlElement)property.getUnderlyingAnnotation(XmlElement.class);
/* 1240 */       if (propXmlElement != null)
/*      */       {
/* 1242 */         propClassInfo = (ClassInfo)propClassInfo.getTypeInfoFactory().getTypeInfo(propXmlElement.type());
/*      */       }
/*      */ 
/* 1245 */       JBossXmlModelGroup xmlModelGroup = (JBossXmlModelGroup)propClassInfo.getUnderlyingAnnotation(JBossXmlModelGroup.class);
/* 1246 */       if ((xmlModelGroup != null) && (xmlModelGroup.particles().length == 0))
/*      */       {
/* 1248 */         if (this.trace) {
/* 1249 */           log.trace("Property " + property.getName() + " is bound to " + xmlModelGroup.kind());
/*      */         }
/* 1251 */         ModelGroupBinding propertyGroup = null;
/* 1252 */         QName groupName = null;
/* 1253 */         if (!"##default".equals(xmlModelGroup.name())) {
/* 1254 */           groupName = new QName(xmlModelGroup.name());
/*      */         }
/* 1256 */         if (groupName != null) {
/* 1257 */           propertyGroup = this.schemaBinding.getGroup(groupName);
/*      */         }
/* 1259 */         if (propertyGroup == null)
/*      */         {
/* 1261 */           if (xmlModelGroup.kind().equals("sequence"))
/*      */           {
/* 1263 */             propertyGroup = new SequenceBinding(this.schemaBinding);
/*      */           }
/* 1265 */           else if (xmlModelGroup.kind().equals("choice"))
/*      */           {
/* 1267 */             propertyGroup = new ChoiceBinding(this.schemaBinding);
/*      */           }
/* 1269 */           else if (xmlModelGroup.kind().equals("all"))
/*      */           {
/* 1271 */             propertyGroup = new AllBinding(this.schemaBinding);
/*      */           }
/*      */           else
/*      */           {
/* 1275 */             throw new IllegalStateException("Unexpected JBossXmlModelGroup.kind=" + xmlModelGroup.kind());
/*      */           }
/*      */ 
/* 1278 */           if (groupName != null)
/*      */           {
/* 1281 */             propertyGroup.setQName(groupName);
/* 1282 */             this.schemaBinding.addGroup(propertyGroup.getQName(), propertyGroup);
/*      */           }
/*      */ 
/* 1285 */           propertyGroup.setSkip(Boolean.FALSE);
/*      */ 
/* 1288 */           BeanInfo propBeanInfo = JBossXBBuilder.configuration.getBeanInfo(propClassInfo);
/* 1289 */           BeanAdapterFactory propBeanAdapterFactory = null;
/*      */           try
/*      */           {
/* 1293 */             BeanInfo propBeanAdapterBuilderInfo = JBossXBBuilder.configuration.getBeanInfo(DefaultBeanAdapterBuilder.class);
/*      */ 
/* 1295 */             BeanAdapterBuilder propBeanAdapterBuilder = (BeanAdapterBuilder)propBeanAdapterBuilderInfo.newInstance();
/*      */ 
/* 1297 */             propBeanAdapterFactory = propBeanAdapterBuilder.newFactory(propBeanInfo, null);
/*      */           }
/*      */           catch (Throwable t)
/*      */           {
/* 1301 */             throw new RuntimeException("Error creating BeanAdapterFactory for " + DefaultBeanAdapterBuilder.class.getName(), t);
/*      */           }
/*      */ 
/* 1304 */           BeanHandler propHandler = new BeanHandler(propBeanInfo.getName(), propBeanAdapterFactory);
/* 1305 */           propertyGroup.setHandler(propHandler);
/*      */ 
/* 1307 */           String[] memberOrder = xmlModelGroup.propOrder();
/* 1308 */           if ((memberOrder.length == 0) || (memberOrder[0].length() == 0))
/*      */           {
/* 1310 */             List propNames = new ArrayList();
/* 1311 */             for (PropertyInfo prop : propBeanInfo.getProperties())
/*      */             {
/* 1313 */               propNames.add(prop.getName());
/*      */             }
/* 1315 */             memberOrder = (String[])propNames.toArray(new String[propNames.size()]);
/*      */           }
/*      */ 
/* 1318 */           if (this.trace) {
/* 1319 */             log.trace("Property order for " + xmlModelGroup.kind() + " property " + property.getName() + ": " + Arrays.asList(memberOrder));
/*      */           }
/*      */ 
/* 1323 */           for (String memberPropName : memberOrder)
/*      */           {
/* 1325 */             if ("class".equals(memberPropName))
/*      */             {
/*      */               continue;
/*      */             }
/*      */ 
/* 1330 */             PropertyInfo memberProp = propBeanInfo.getProperty(memberPropName);
/* 1331 */             TypeInfo memberTypeInfo = memberProp.getType();
/* 1332 */             String memberNamespace = null;
/*      */ 
/* 1334 */             JBossXmlNsPrefix nsPrefix = (JBossXmlNsPrefix)memberProp.getUnderlyingAnnotation(JBossXmlNsPrefix.class);
/* 1335 */             if (nsPrefix != null)
/*      */             {
/* 1337 */               memberNamespace = this.schemaBinding.getNamespace(nsPrefix.prefix());
/* 1338 */               if ((memberNamespace == null) && (nsPrefix.schemaTargetIfNotMapped()))
/*      */               {
/* 1340 */                 throw new IllegalStateException("Prefix '" + nsPrefix.prefix() + "' is not mapped to any namespace!");
/*      */               }
/*      */ 
/*      */             }
/*      */ 
/* 1345 */             String memberName = null;
/* 1346 */             XmlElement memberXmlElement = (XmlElement)memberProp.getUnderlyingAnnotation(XmlElement.class);
/* 1347 */             if (memberXmlElement != null)
/*      */             {
/* 1349 */               if (!XmlElement.DEFAULT.class.equals(memberXmlElement.type()))
/*      */               {
/* 1351 */                 memberTypeInfo = memberTypeInfo.getTypeInfoFactory().getTypeInfo(memberXmlElement.type());
/*      */               }
/*      */ 
/* 1354 */               if (memberNamespace == null)
/* 1355 */                 memberNamespace = memberXmlElement.namespace();
/* 1356 */               memberName = memberXmlElement.name();
/*      */             }
/*      */ 
/* 1359 */             if (memberNamespace == null)
/*      */             {
/* 1361 */               memberNamespace = this.defaultNamespace;
/*      */             }
/*      */ 
/* 1364 */             boolean isCol = false;
/* 1365 */             AbstractPropertyHandler memberPropertyHandler = null;
/* 1366 */             if (memberProp.getType().isCollection())
/*      */             {
/* 1368 */               memberPropertyHandler = new CollectionPropertyHandler(memberProp, memberProp.getType());
/* 1369 */               isCol = true;
/*      */ 
/* 1371 */               if ((memberXmlElement == null) || (XmlElement.DEFAULT.class.equals(memberXmlElement.type())))
/*      */               {
/* 1373 */                 JBossXmlCollection jbossXmlCollection = (JBossXmlCollection)memberProp.getUnderlyingAnnotation(JBossXmlCollection.class);
/*      */ 
/* 1375 */                 if (jbossXmlCollection != null)
/*      */                 {
/* 1377 */                   memberTypeInfo = memberTypeInfo.getTypeInfoFactory().getTypeInfo(jbossXmlCollection.type());
/*      */                 }
/* 1379 */                 memberTypeInfo = findComponentType((ClassInfo)memberTypeInfo);
/*      */               }
/*      */ 
/*      */             }
/* 1383 */             else if (memberTypeInfo.isCollection())
/*      */             {
/* 1385 */               memberPropertyHandler = new CollectionPropertyHandler(memberProp, memberTypeInfo);
/* 1386 */               isCol = true;
/* 1387 */               memberTypeInfo = findComponentType((ClassInfo)memberTypeInfo);
/*      */             }
/*      */             else
/*      */             {
/* 1391 */               memberPropertyHandler = new PropertyHandler(memberProp, memberTypeInfo);
/*      */             }
/*      */ 
/* 1394 */             QName memberQName = generateXmlName(memberProp.getName(), this.elementForm, memberNamespace, memberName);
/* 1395 */             propBeanAdapterFactory.addProperty(memberQName, memberPropertyHandler);
/*      */ 
/* 1397 */             XBValueAdapter valueAdapter = null;
/* 1398 */             XmlJavaTypeAdapter xmlTypeAdapter = (XmlJavaTypeAdapter)memberProp.getUnderlyingAnnotation(XmlJavaTypeAdapter.class);
/* 1399 */             if (xmlTypeAdapter != null)
/*      */             {
/* 1401 */               valueAdapter = new XBValueAdapter(xmlTypeAdapter.value(), memberTypeInfo.getTypeInfoFactory());
/* 1402 */               memberTypeInfo = valueAdapter.getAdaptedTypeInfo();
/*      */             }
/*      */ 
/* 1405 */             TypeBinding memberTypeBinding = resolveTypeBinding(memberTypeInfo);
/* 1406 */             ElementBinding memberElement = createElementBinding(memberTypeInfo, memberTypeBinding, memberQName, false);
/*      */ 
/* 1408 */             memberElement.setNillable(true);
/* 1409 */             memberElement.setValueAdapter(valueAdapter);
/* 1410 */             ParticleBinding memberParticle = new ParticleBinding(memberElement, 0, 1, isCol);
/* 1411 */             propertyGroup.addParticle(memberParticle);
/*      */ 
/* 1413 */             if (this.trace) {
/* 1414 */               log.trace("added " + memberParticle + " to " + xmlModelGroup.kind() + ", property " + property.getName());
/*      */             }
/*      */           }
/*      */         }
/*      */ 
/* 1419 */         model.addParticle(new ParticleBinding(propertyGroup));
/*      */ 
/* 1423 */         AbstractPropertyHandler propertyHandler = null;
/* 1424 */         if (propertyType.isCollection()) {
/* 1425 */           propertyHandler = new CollectionPropertyHandler(property, propClassInfo);
/*      */         }
/*      */         else {
/* 1428 */           propertyHandler = new PropertyHandler(property, propClassInfo);
/*      */         }
/* 1430 */         beanAdapterFactory.addProperty(propertyGroup.getQName(), propertyHandler);
/* 1431 */         return;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1436 */     XmlElement[] elements = null;
/* 1437 */     XmlElement xmlElement = (XmlElement)property.getUnderlyingAnnotation(XmlElement.class);
/* 1438 */     if (xmlElement != null)
/*      */     {
/* 1441 */       elements = new XmlElement[] { xmlElement };
/*      */     }
/*      */     else
/*      */     {
/* 1447 */       XmlElements xmlElements = (XmlElements)property.getUnderlyingAnnotation(XmlElements.class);
/* 1448 */       if (xmlElements != null) {
/* 1449 */         elements = xmlElements.value();
/*      */       }
/*      */     }
/*      */ 
/* 1453 */     if ((elements == null) || (elements.length == 0)) {
/* 1454 */       elements = new XmlElement[1];
/*      */     }
/*      */ 
/* 1457 */     JBossXmlNsPrefix xmlNsPrefix = (JBossXmlNsPrefix)property.getUnderlyingAnnotation(JBossXmlNsPrefix.class);
/*      */ 
/* 1461 */     XmlElementWrapper xmlWrapper = (XmlElementWrapper)property.getUnderlyingAnnotation(XmlElementWrapper.class);
/* 1462 */     if (xmlWrapper != null)
/*      */     {
/* 1464 */       String wrapperNamespace = xmlWrapper.namespace();
/* 1465 */       String wrapperName = xmlWrapper.name();
/* 1466 */       boolean wrapperNillable = xmlWrapper.nillable();
/*      */ 
/* 1468 */       QName wrapperQName = generateXmlName(property.getName(), this.elementForm, wrapperNamespace, wrapperName);
/*      */ 
/* 1470 */       TypeBinding wrapperType = new TypeBinding();
/* 1471 */       SequenceBinding seq = new SequenceBinding(this.schemaBinding);
/* 1472 */       seq.setHandler(BuilderParticleHandler.INSTANCE);
/* 1473 */       ParticleBinding particle = new ParticleBinding(seq);
/* 1474 */       wrapperType.setParticle(particle);
/* 1475 */       wrapperType.setHandler(new DefaultElementHandler());
/*      */ 
/* 1477 */       ElementBinding wrapperElement = createElementBinding(propertyType, wrapperType, wrapperQName, false);
/* 1478 */       wrapperElement.setNillable(wrapperNillable);
/* 1479 */       wrapperElement.setSkip(Boolean.TRUE);
/* 1480 */       particle = new ParticleBinding(wrapperElement, 1, 1, false);
/* 1481 */       localModel.addParticle(particle);
/*      */ 
/* 1483 */       localModel = seq;
/*      */ 
/* 1485 */       if (this.trace) {
/* 1486 */         log.trace("Added property " + wrapperQName + " for type=" + property.getBeanInfo().getName() + " property=" + property.getName() + " as a wrapper element");
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1491 */     if (elements.length > 1)
/*      */     {
/* 1493 */       ChoiceBinding choice = new ChoiceBinding(this.schemaBinding);
/* 1494 */       choice.setHandler(BuilderParticleHandler.INSTANCE);
/* 1495 */       ParticleBinding particleBinding = new ParticleBinding(choice);
/* 1496 */       particleBinding.setMinOccurs(0);
/* 1497 */       particleBinding.setMaxOccurs(1);
/* 1498 */       localModel.addParticle(particleBinding);
/* 1499 */       localModel = choice;
/* 1500 */       if (this.trace) {
/* 1501 */         log.trace("XmlElements seen adding choice for type=" + property.getBeanInfo().getName() + " property=" + property.getName());
/*      */       }
/*      */     }
/*      */ 
/* 1505 */     for (int i = 0; i < elements.length; i++)
/*      */     {
/* 1507 */       XmlElement element = elements[i];
/* 1508 */       if (this.trace) {
/* 1509 */         log.trace("Processing " + element + " for type=" + property.getBeanInfo().getName() + " property=" + property.getName());
/*      */       }
/*      */ 
/* 1513 */       String overrideNamespace = null;
/* 1514 */       String overrideName = null;
/* 1515 */       boolean nillable = false;
/* 1516 */       boolean required = false;
/*      */ 
/* 1518 */       TypeInfo localPropertyType = propertyType;
/*      */ 
/* 1520 */       if (element != null)
/*      */       {
/* 1522 */         overrideNamespace = element.namespace();
/* 1523 */         overrideName = element.name();
/* 1524 */         nillable = element.nillable();
/* 1525 */         required = element.required();
/* 1526 */         Class elementType = element.type();
/* 1527 */         if (elementType != XmlElement.DEFAULT.class) {
/* 1528 */           localPropertyType = propertyType.getTypeInfoFactory().getTypeInfo(elementType);
/*      */         }
/*      */       }
/* 1531 */       if (xmlNsPrefix != null)
/*      */       {
/* 1533 */         overrideNamespace = this.schemaBinding.getNamespace(xmlNsPrefix.prefix());
/* 1534 */         if (overrideNamespace == null)
/*      */         {
/* 1536 */           if (xmlNsPrefix.schemaTargetIfNotMapped())
/*      */           {
/* 1538 */             overrideNamespace = this.defaultNamespace;
/*      */           }
/*      */           else
/*      */           {
/* 1542 */             throw new IllegalStateException("Prefix '" + xmlNsPrefix.prefix() + "' is not mapped to any namespace!");
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 1549 */       QName qName = generateXmlName(property.getName(), this.elementForm, overrideNamespace, overrideName);
/*      */ 
/* 1552 */       JBossXmlGroup jbossXmlGroup = null;
/* 1553 */       if (!propertyType.isPrimitive())
/* 1554 */         jbossXmlGroup = (JBossXmlGroup)((ClassInfo)propertyType).getUnderlyingAnnotation(JBossXmlGroup.class);
/* 1555 */       if ((element == null) && (jbossXmlGroup != null))
/*      */       {
/* 1557 */         if (this.trace) {
/* 1558 */           log.trace("Processing group for property " + property.getName() + " in " + property.getBeanInfo().getName() + " " + jbossXmlGroup);
/*      */         }
/* 1560 */         JBossXmlChild[] children = jbossXmlGroup.value();
/* 1561 */         if ((children != null) && (children.length > 0))
/*      */         {
/* 1563 */           TypeBinding elementTypeBinding = new TypeBinding();
/* 1564 */           elementTypeBinding.setSchemaBinding(this.schemaBinding);
/* 1565 */           elementTypeBinding.setHandler(BuilderParticleHandler.INSTANCE);
/* 1566 */           ElementBinding elementBinding = createElementBinding(localPropertyType, elementTypeBinding, qName, false);
/*      */ 
/* 1569 */           ParticleBinding particle = new ParticleBinding(elementBinding, 1, 1, false);
/* 1570 */           if (!required)
/* 1571 */             particle.setMinOccurs(0);
/* 1572 */           localModel.addParticle(particle);
/*      */ 
/* 1575 */           JBossXmlGroupText groupText = (JBossXmlGroupText)((ClassInfo)propertyType).getUnderlyingAnnotation(JBossXmlGroupText.class);
/*      */ 
/* 1577 */           if (groupText != null)
/*      */           {
/*      */             CharactersHandler textHandler;
/*      */             CharactersHandler textHandler;
/* 1580 */             if (groupText.wrapper() != Object.class)
/*      */             {
/* 1582 */               BeanInfo wrapperInfo = JBossXBBuilder.configuration.getBeanInfo(groupText.wrapper());
/* 1583 */               textHandler = new ValueHandler(property, wrapperInfo, groupText.property());
/*      */             }
/*      */             else {
/* 1586 */               textHandler = new ValueHandler(property);
/* 1587 */             }elementTypeBinding.setSimpleType(textHandler);
/*      */           }
/*      */ 
/* 1591 */           ChoiceBinding childModel = new ChoiceBinding(this.schemaBinding);
/* 1592 */           childModel.setHandler(BuilderParticleHandler.INSTANCE);
/* 1593 */           ParticleBinding particleBinding = new ParticleBinding(childModel);
/* 1594 */           particleBinding.setMinOccurs(0);
/* 1595 */           particleBinding.setMaxOccurs(1);
/* 1596 */           elementTypeBinding.setParticle(particleBinding);
/*      */ 
/* 1598 */           for (JBossXmlChild child : children)
/*      */           {
/* 1600 */             QName childName = generateXmlName(child.name(), this.elementForm, child.namespace(), child.name());
/* 1601 */             TypeInfo childType = JBossXBBuilder.configuration.getTypeInfo(child.type());
/*      */ 
/* 1603 */             TypeBinding childTypeBinding = resolveTypeBinding(childType);
/* 1604 */             ElementBinding childBinding = createElementBinding(childType, childTypeBinding, childName, false);
/* 1605 */             childBinding.setNillable(nillable);
/*      */ 
/* 1608 */             particle = new ParticleBinding(childBinding, child.minOccurs(), child.maxOccurs(), child.unbounded());
/* 1609 */             particle.setMinOccurs(0);
/* 1610 */             childModel.addParticle(particle);
/*      */ 
/* 1612 */             DefaultElementInterceptor interceptor = new PropertyInterceptor(property, propertyType);
/* 1613 */             elementTypeBinding.pushInterceptor(childName, interceptor);
/* 1614 */             if (this.trace) {
/* 1615 */               log.trace("Added interceptor " + childName + " for type=" + property.getBeanInfo().getName() + " property=" + property.getName() + " interceptor=" + interceptor);
/*      */             }
/*      */ 
/* 1618 */             beanAdapterFactory.addProperty(qName, new NoopPropertyHandler(property, propertyType));
/*      */ 
/* 1620 */             JBossXmlGroupWildcard groupWildcard = (JBossXmlGroupWildcard)((ClassInfo)propertyType).getUnderlyingAnnotation(JBossXmlGroupWildcard.class);
/*      */ 
/* 1623 */             if (groupWildcard == null)
/*      */               continue;
/*      */             ChildWildcardHandler groupWildcardHandler;
/*      */             ChildWildcardHandler groupWildcardHandler;
/* 1626 */             if (groupWildcard.wrapper() != Object.class)
/*      */             {
/* 1628 */               BeanInfo wrapperInfo = JBossXBBuilder.configuration.getBeanInfo(groupWildcard.wrapper());
/* 1629 */               groupWildcardHandler = new ChildWildcardHandler(property, wrapperInfo, groupWildcard.property());
/*      */             }
/*      */             else {
/* 1632 */               groupWildcardHandler = new ChildWildcardHandler(property);
/*      */             }
/* 1634 */             WildcardBinding wildcard = new WildcardBinding(this.schemaBinding);
/* 1635 */             if (groupWildcard.lax())
/* 1636 */               wildcard.setProcessContents(3);
/*      */             else {
/* 1638 */               wildcard.setProcessContents(1);
/*      */             }
/* 1640 */             particleBinding = new ParticleBinding(wildcard);
/* 1641 */             particleBinding.setMinOccurs(0);
/* 1642 */             particleBinding.setMaxOccurs(1);
/* 1643 */             childModel.addParticle(particleBinding);
/*      */ 
/* 1645 */             elementTypeBinding.getWildcard().setWildcardHandler(groupWildcardHandler);
/*      */           }
/*      */         }
/*      */ 
/*      */       }
/*      */       else
/*      */       {
/* 1652 */         XBValueAdapter valueAdapter = null;
/* 1653 */         XmlJavaTypeAdapter xmlTypeAdapter = (XmlJavaTypeAdapter)property.getUnderlyingAnnotation(XmlJavaTypeAdapter.class);
/* 1654 */         if (xmlTypeAdapter != null)
/*      */         {
/* 1656 */           valueAdapter = new XBValueAdapter(xmlTypeAdapter.value(), propertyType.getTypeInfoFactory());
/* 1657 */           localPropertyType = valueAdapter.getAdaptedTypeInfo();
/*      */         }
/*      */ 
/* 1660 */         ModelGroupBinding targetGroup = localModel;
/* 1661 */         boolean isCol = false;
/* 1662 */         AbstractPropertyHandler propertyHandler = null;
/*      */ 
/* 1666 */         if ((propertyType.isCollection()) && (((ClassInfo)propertyType).getUnderlyingAnnotation(XmlType.class) == null))
/*      */         {
/* 1669 */           isCol = true;
/* 1670 */           propertyHandler = new CollectionPropertyHandler(property, propertyType);
/* 1671 */           ClassInfo typeArg = (ClassInfo)findComponentType(property);
/*      */ 
/* 1674 */           if ((typeArg != null) && (typeArg.getUnderlyingAnnotation(JBossXmlModelGroup.class) == null))
/*      */           {
/* 1678 */             JBossXmlChild xmlChild = (JBossXmlChild)((ClassInfo)propertyType).getUnderlyingAnnotation(JBossXmlChild.class);
/* 1679 */             if ((xmlChild == null) && (localPropertyType.equals(propertyType)))
/*      */             {
/* 1681 */               localPropertyType = typeArg;
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/*      */         }
/* 1687 */         else if ((localPropertyType.isCollection()) && (((ClassInfo)localPropertyType).getUnderlyingAnnotation(XmlType.class) == null))
/*      */         {
/*      */           Type parameterizedType;
/*      */           Type parameterizedType;
/* 1691 */           if (valueAdapter != null)
/*      */           {
/* 1693 */             propertyHandler = new PropertyHandler(property, localPropertyType);
/* 1694 */             parameterizedType = valueAdapter.getAdaptedType();
/*      */           }
/*      */           else
/*      */           {
/* 1698 */             propertyHandler = new CollectionPropertyHandler(property, localPropertyType);
/* 1699 */             parameterizedType = localPropertyType.getType();
/*      */           }
/* 1701 */           isCol = true;
/* 1702 */           localPropertyType = findActualType((ClassInfo)localPropertyType, parameterizedType, Collection.class, 0);
/*      */         }
/*      */         else
/*      */         {
/* 1707 */           propertyHandler = new PropertyHandler(property, localPropertyType);
/*      */         }
/*      */ 
/* 1713 */         if (!Element.class.getName().equals(propertyType.getName()))
/*      */         {
/* 1715 */           TypeBinding elementTypeBinding = resolveTypeBinding(localPropertyType);
/* 1716 */           ElementBinding elementBinding = createElementBinding(localPropertyType, elementTypeBinding, qName, false);
/* 1717 */           elementBinding.setNillable(nillable);
/* 1718 */           elementBinding.setValueAdapter(valueAdapter);
/*      */ 
/* 1721 */           ParticleBinding particle = new ParticleBinding(elementBinding, 1, 1, isCol);
/* 1722 */           if (!required) {
/* 1723 */             particle.setMinOccurs(0);
/*      */           }
/* 1725 */           targetGroup.addParticle(particle);
/*      */         }
/*      */ 
/* 1728 */         beanAdapterFactory.addProperty(qName, propertyHandler);
/* 1729 */         if (this.trace)
/* 1730 */           log.trace("Added property " + qName + " for type=" + property.getBeanInfo().getName() + " property=" + property.getName() + " handler=" + propertyHandler);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private ModelGroupBinding createArray(ModelGroupBinding localModel)
/*      */   {
/* 1744 */     SequenceBinding sequenceBinding = new SequenceBinding(this.schemaBinding);
/* 1745 */     sequenceBinding.setHandler(BuilderParticleHandler.INSTANCE);
/* 1746 */     ArraySequenceBinding arraySequenceBinding = new ArraySequenceBinding(this.schemaBinding);
/* 1747 */     arraySequenceBinding.setHandler(BuilderParticleHandler.INSTANCE);
/* 1748 */     ParticleBinding particle = new ParticleBinding(sequenceBinding);
/* 1749 */     particle.setMinOccurs(0);
/* 1750 */     particle.setMaxOccursUnbounded(true);
/* 1751 */     arraySequenceBinding.addParticle(particle);
/* 1752 */     particle = new ParticleBinding(arraySequenceBinding);
/* 1753 */     localModel.addParticle(particle);
/* 1754 */     return sequenceBinding;
/*      */   }
/*      */ 
/*      */   private ModelGroupBinding createCollection(ModelGroupBinding localModel)
/*      */   {
/* 1765 */     SequenceBinding sequenceBinding = new SequenceBinding(this.schemaBinding);
/* 1766 */     sequenceBinding.setHandler(BuilderParticleHandler.INSTANCE);
/* 1767 */     ParticleBinding particle = new ParticleBinding(sequenceBinding);
/* 1768 */     particle.setMinOccurs(0);
/* 1769 */     particle.setMaxOccursUnbounded(true);
/* 1770 */     localModel.addParticle(particle);
/* 1771 */     return sequenceBinding;
/*      */   }
/*      */ 
/*      */   private void addNamespace(String namespace, boolean erase)
/*      */   {
/* 1783 */     Set namespaces = this.schemaBinding.getNamespaces();
/* 1784 */     if ((erase) && (namespaces.size() <= 1))
/* 1785 */       namespaces = new HashSet(Collections.singleton(namespace));
/* 1786 */     namespaces.add(namespace);
/* 1787 */     this.schemaBinding.setNamespaces(namespaces);
/*      */   }
/*      */ 
/*      */   protected QName generateXmlName(TypeInfo typeInfo, XmlNsForm form, String namespace, String name)
/*      */   {
/* 1801 */     return generateXmlName(typeInfo.getSimpleName(), form, namespace, name);
/*      */   }
/*      */ 
/*      */   protected QName generateXmlName(String localName, XmlNsForm form, String namespace, String name)
/*      */   {
/* 1815 */     String nsUri = "";
/* 1816 */     if (form == XmlNsForm.QUALIFIED)
/* 1817 */       nsUri = this.defaultNamespace;
/* 1818 */     if ((namespace != null) && (!"##default".equals(namespace)))
/* 1819 */       nsUri = namespace;
/* 1820 */     if ((name != null) && (!"##default".equals(name)))
/* 1821 */       localName = name;
/*      */     else
/* 1823 */       localName = JBossXBBuilder.generateXMLNameFromJavaName(localName, true, this.schemaBinding.isIgnoreLowLine());
/* 1824 */     return new QName(nsUri, localName);
/*      */   }
/*      */ 
/*      */   private void push(TypeInfo typeInfo)
/*      */   {
/* 1829 */     push(typeInfo, null);
/*      */   }
/*      */ 
/*      */   private void push(TypeInfo typeInfo, String joinpoint)
/*      */   {
/* 1834 */     this.locations.push(new Location(typeInfo, joinpoint));
/*      */   }
/*      */ 
/*      */   private void pop()
/*      */   {
/* 1839 */     this.locations.pop();
/*      */   }
/*      */ 
/*      */   private RuntimeException rethrowWithLocation(Throwable t)
/*      */   {
/* 1844 */     StringBuilder message = new StringBuilder();
/* 1845 */     message.append(t.getMessage());
/* 1846 */     message.append("\n");
/* 1847 */     while (!this.locations.isEmpty())
/*      */     {
/* 1849 */       Location location = (Location)this.locations.pop();
/* 1850 */       location.append(message);
/* 1851 */       if (!this.locations.isEmpty())
/* 1852 */         message.append('\n');
/*      */     }
/* 1854 */     throw new RuntimeException(message.toString(), t);
/*      */   }
/*      */ 
/*      */   private TypeInfo findComponentType(PropertyInfo prop)
/*      */   {
/* 1885 */     return findActualType(prop, Collection.class, 0);
/*      */   }
/*      */ 
/*      */   protected TypeInfo findComponentType(ClassInfo classInfo)
/*      */   {
/* 1890 */     return findActualType(classInfo, classInfo.getType(), Collection.class, 0);
/*      */   }
/*      */ 
/*      */   private TypeInfo findActualType(PropertyInfo property, Class reference, int parameter)
/*      */   {
/* 1895 */     MethodInfo getter = property.getGetter();
/* 1896 */     if (getter == null)
/*      */     {
/* 1898 */       throw new IllegalStateException("Expected a getter for " + property.getName() + " in " + property.getBeanInfo().getName());
/*      */     }
/*      */     Method m;
/*      */     try
/*      */     {
/* 1904 */       m = property.getBeanInfo().getClassInfo().getType().getMethod(getter.getName(), null);
/*      */     }
/*      */     catch (NoSuchMethodException e)
/*      */     {
/* 1908 */       throw new IllegalStateException("Expected a getter for " + property.getName() + " in " + property.getBeanInfo().getName());
/*      */     }
/*      */ 
/* 1911 */     return findActualType((ClassInfo)property.getType(), m.getGenericReturnType(), reference, parameter);
/*      */   }
/*      */ 
/*      */   protected TypeInfo findActualType(ClassInfo classInfo, Type genericType, Class reference, int parameter)
/*      */   {
/* 1916 */     Type result = locateActualType(reference, parameter, classInfo.getType(), genericType);
/* 1917 */     if ((result instanceof TypeVariable))
/*      */     {
/* 1919 */       TypeVariable typeVariable = (TypeVariable)result;
/* 1920 */       result = typeVariable.getBounds()[0];
/*      */     }
/*      */ 
/* 1923 */     return classInfo.getTypeInfoFactory().getTypeInfo(result);
/*      */   }
/*      */ 
/*      */   protected static Type locateActualType(Class reference, int parameter, Class clazz, Type type)
/*      */   {
/* 1928 */     if (reference.equals(clazz))
/*      */     {
/* 1930 */       if ((type instanceof Class))
/*      */       {
/* 1932 */         Class typeClass = (Class)type;
/* 1933 */         return typeClass.getTypeParameters()[parameter];
/*      */       }
/*      */ 
/* 1937 */       ParameterizedType parameterized = (ParameterizedType)type;
/* 1938 */       return parameterized.getActualTypeArguments()[parameter];
/*      */     }
/*      */ 
/* 1942 */     Type[] interfaces = clazz.getGenericInterfaces();
/* 1943 */     for (Type intf : interfaces)
/*      */     {
/*      */       Class interfaceClass;
/* 1946 */       if ((intf instanceof Class))
/*      */       {
/* 1948 */         interfaceClass = (Class)intf;
/*      */       }
/*      */       else
/*      */       {
/*      */         Class interfaceClass;
/* 1950 */         if ((intf instanceof ParameterizedType))
/*      */         {
/* 1952 */           ParameterizedType interfaceType = (ParameterizedType)intf;
/* 1953 */           interfaceClass = (Class)interfaceType.getRawType();
/*      */         }
/*      */         else {
/* 1956 */           throw new IllegalStateException("Unexpected type " + intf.getClass());
/*      */         }
/*      */       }
/*      */       Class interfaceClass;
/* 1958 */       Type result = null;
/* 1959 */       if (reference.isAssignableFrom(interfaceClass))
/*      */       {
/* 1961 */         result = locateActualType(reference, parameter, interfaceClass, intf);
/* 1962 */         if ((result instanceof TypeVariable)) {
/* 1963 */           result = getParameter(clazz, type, (TypeVariable)result);
/*      */         }
/*      */       }
/* 1966 */       if (result != null) {
/* 1967 */         return result;
/*      */       }
/*      */     }
/* 1970 */     Class superClass = clazz.getSuperclass();
/* 1971 */     Type genericSuperClass = clazz.getGenericSuperclass();
/* 1972 */     Type result = locateActualType(reference, parameter, superClass, genericSuperClass);
/* 1973 */     if ((result instanceof TypeVariable))
/* 1974 */       result = getParameter(clazz, type, (TypeVariable)result);
/* 1975 */     return result;
/*      */   }
/*      */ 
/*      */   private static Type getParameter(Class clazz, Type type, TypeVariable variable)
/*      */   {
/* 1980 */     TypeVariable[] variables = clazz.getTypeParameters();
/* 1981 */     for (int i = 0; i < variables.length; i++)
/*      */     {
/* 1983 */       if (!variables[i].getName().equals(variable.getName()))
/*      */         continue;
/* 1985 */       if ((type instanceof ParameterizedType))
/*      */       {
/* 1987 */         ParameterizedType parameterized = (ParameterizedType)type;
/* 1988 */         return parameterized.getActualTypeArguments()[i];
/*      */       }
/* 1990 */       return variable;
/*      */     }
/*      */ 
/* 1994 */     return Object.class;
/*      */   }
/*      */ 
/*      */   private static class XBValueAdapter implements ValueAdapter
/*      */   {
/*      */     private final XmlAdapter xmlAdapter;
/*      */     private final TypeInfo adaptedTypeInfo;
/*      */     private final Type adaptedType;
/*      */ 
/*      */     public XBValueAdapter(Class<? extends XmlAdapter> adapterImplClass, TypeInfoFactory factory) {
/*      */       try {
/* 2008 */         this.xmlAdapter = ((XmlAdapter)adapterImplClass.newInstance());
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/* 2012 */         throw new IllegalStateException("Failed to create an instance of " + adapterImplClass.getName(), e);
/*      */       }
/*      */ 
/* 2019 */       this.adaptedType = ((ParameterizedType)adapterImplClass.getGenericSuperclass()).getActualTypeArguments()[0];
/* 2020 */       this.adaptedTypeInfo = factory.getTypeInfo(this.adaptedType);
/*      */     }
/*      */ 
/*      */     public TypeInfo getAdaptedTypeInfo()
/*      */     {
/* 2025 */       return this.adaptedTypeInfo;
/*      */     }
/*      */ 
/*      */     public Type getAdaptedType()
/*      */     {
/* 2030 */       return this.adaptedType;
/*      */     }
/*      */ 
/*      */     public Object cast(Object o, Class c)
/*      */     {
/*      */       try
/*      */       {
/* 2037 */         return this.xmlAdapter.unmarshal(o);
/*      */       }
/*      */       catch (Exception e) {
/*      */       }
/* 2041 */       throw new IllegalStateException("Failed to adapt value " + o + " to type " + c, e);
/*      */     }
/*      */   }
/*      */ 
/*      */   private class Location
/*      */   {
/*      */     TypeInfo typeInfo;
/*      */     String joinpoint;
/*      */ 
/*      */     Location(TypeInfo typeInfo, String joinpoint)
/*      */     {
/* 1868 */       this.typeInfo = typeInfo;
/* 1869 */       this.joinpoint = joinpoint;
/*      */     }
/*      */ 
/*      */     public void append(StringBuilder builder)
/*      */     {
/* 1874 */       builder.append("at ");
/* 1875 */       builder.append(this.typeInfo.getName());
/* 1876 */       if (this.joinpoint != null)
/* 1877 */         builder.append('.').append(this.joinpoint);
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.builder.JBossXBNoSchemaBuilder
 * JD-Core Version:    0.6.0
 */