/*     */ package org.jboss.xb.builder;
/*     */ 
/*     */ import java.util.Collections;
/*     */ import java.util.HashSet;
/*     */ import java.util.Set;
/*     */ import javax.xml.bind.annotation.XmlNs;
/*     */ import org.jboss.config.plugins.property.PropertyConfiguration;
/*     */ import org.jboss.config.spi.Configuration;
/*     */ import org.jboss.reflect.spi.ClassInfo;
/*     */ import org.jboss.reflect.spi.PackageInfo;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ import org.jboss.xb.annotations.JBossXmlSchema;
/*     */ import org.jboss.xb.binding.metadata.PackageMetaData;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingInitializer;
/*     */ 
/*     */ public class JBossXBBuilder
/*     */ {
/*  49 */   static Configuration configuration = new PropertyConfiguration();
/*     */ 
/*  52 */   static final ClassInfo STRING = configuration.getClassInfo(String.class);
/*     */ 
/*  55 */   static final ClassInfo OBJECT = configuration.getClassInfo(Object.class);
/*     */ 
/*     */   public static <T> SchemaBindingInitializer newInitializer(Class<T> root)
/*     */   {
/*  67 */     return new BuilderSchemaBindingInitializer(root);
/*     */   }
/*     */ 
/*     */   public static void build(SchemaBinding schemaBinding, Class<?> root)
/*     */   {
/*  79 */     if (schemaBinding == null)
/*  80 */       throw new IllegalArgumentException("Null schemaBinding");
/*  81 */     if (root == null)
/*  82 */       throw new IllegalArgumentException("Null root");
/*     */   }
/*     */ 
/*     */   public static SchemaBinding build(Class<?> root)
/*     */   {
/*  96 */     ClassInfo classInfo = configuration.getClassInfo(root);
/*     */ 
/*  98 */     SchemaBinding binding = (SchemaBinding)classInfo.getAttachment(SchemaBinding.class);
/*  99 */     if (binding == null)
/*     */     {
/* 101 */       JBossXBNoSchemaBuilder builder = new JBossXBNoSchemaBuilder(classInfo);
/* 102 */       binding = builder.build();
/* 103 */       classInfo.setAttachment(SchemaBinding.class.getName(), binding);
/*     */     }
/* 105 */     return binding;
/*     */   }
/*     */ 
/*     */   protected static void initSchema(SchemaBinding schemaBinding, ClassInfo classInfo)
/*     */   {
/* 117 */     JBossXmlSchema schema = (JBossXmlSchema)classInfo.getUnderlyingAnnotation(JBossXmlSchema.class);
/* 118 */     PackageInfo packageInfo = classInfo.getPackage();
/* 119 */     if ((schema == null) && (packageInfo != null))
/*     */     {
/* 121 */       schema = (JBossXmlSchema)packageInfo.getUnderlyingAnnotation(JBossXmlSchema.class);
/*     */     }
/*     */ 
/* 125 */     String packageName = null;
/* 126 */     if (packageInfo != null) {
/* 127 */       packageName = packageInfo.getName();
/*     */     }
/* 129 */     if (schema != null)
/*     */     {
/* 131 */       String schemaPackageName = schema.packageName();
/* 132 */       if (!"##default".equals(schemaPackageName)) {
/* 133 */         packageName = schemaPackageName;
/*     */       }
/* 135 */       if (schema.xmlns().length > 0)
/*     */       {
/* 137 */         for (int i = 0; i < schema.xmlns().length; i++)
/*     */         {
/* 139 */           schemaBinding.addPrefixMapping(schema.xmlns()[i].prefix(), schema.xmlns()[i].namespaceURI());
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 145 */     if (schemaBinding.getNamespaces().isEmpty())
/*     */     {
/* 147 */       String namespace = "";
/* 148 */       if (schema != null)
/*     */       {
/* 150 */         String schemaNamespace = schema.namespace();
/* 151 */         if (!"##default".equals(schemaNamespace))
/* 152 */           namespace = schemaNamespace;
/*     */       }
/* 154 */       schemaBinding.setNamespaces(new HashSet(Collections.singleton(namespace)));
/*     */     }
/*     */ 
/* 158 */     if (packageName != null)
/*     */     {
/* 160 */       PackageMetaData packageMetaData = new PackageMetaData();
/* 161 */       packageMetaData.setName(packageName);
/* 162 */       schemaBinding.setPackageMetaData(packageMetaData);
/*     */     }
/*     */ 
/* 166 */     if (schema == null) {
/* 167 */       return;
/*     */     }
/*     */ 
/* 170 */     schemaBinding.setIgnoreUnresolvedFieldOrClass(schema.ignoreUnresolvedFieldOrClass());
/* 171 */     schemaBinding.setIgnoreLowLine(schema.ignoreLowLine());
/* 172 */     schemaBinding.setReplacePropertyRefs(schema.replacePropertyRefs());
/* 173 */     schemaBinding.setStrictSchema(schema.strict());
/*     */   }
/*     */ 
/*     */   public static String generateXMLNameFromClassName(TypeInfo typeInfo, boolean ignoreLowerLine)
/*     */   {
/* 185 */     return generateXMLNameFromJavaName(typeInfo.getSimpleName(), true, ignoreLowerLine);
/*     */   }
/*     */ 
/*     */   public static String generateXMLNameFromJavaName(String string, boolean dash, boolean ignoreLowerLine)
/*     */   {
/* 199 */     boolean seenLower = false;
/*     */ 
/* 202 */     boolean first = true;
/*     */ 
/* 204 */     StringBuilder result = new StringBuilder(string.length());
/* 205 */     for (int i = 0; i < string.length(); i++)
/*     */     {
/* 207 */       char c = string.charAt(i);
/*     */ 
/* 209 */       if ((first) || ((!seenLower) && (Character.isUpperCase(c))))
/*     */       {
/* 211 */         result.append(Character.toLowerCase(c));
/* 212 */         first = false;
/*     */       }
/* 216 */       else if ((seenLower) && (Character.isUpperCase(c)) && (dash))
/*     */       {
/* 218 */         result.append('-');
/* 219 */         result.append(Character.toLowerCase(c));
/* 220 */         seenLower = false;
/*     */       }
/*     */       else
/*     */       {
/* 225 */         result.append(c);
/* 226 */         seenLower = true;
/*     */       }
/*     */     }
/* 229 */     return result.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.builder.JBossXBBuilder
 * JD-Core Version:    0.6.0
 */