/*     */ package org.jboss.xb.binding.sunday.xop;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.ObjectInputStream;
/*     */ import javax.xml.namespace.NamespaceContext;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.xb.binding.Constants;
/*     */ import org.jboss.xb.binding.JBossXBRuntimeException;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.ParticleHandler;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;
/*     */ import org.xml.sax.Attributes;
/*     */ 
/*     */ public class XOPIncludeHandler
/*     */   implements ParticleHandler
/*     */ {
/*     */   private final TypeBinding type;
/*     */   private XOPUnmarshaller xopUnmarshaller;
/*     */ 
/*     */   public XOPIncludeHandler(TypeBinding type)
/*     */   {
/*  52 */     this.type = type;
/*     */   }
/*     */ 
/*     */   public XOPIncludeHandler(TypeBinding type, XOPUnmarshaller xopUnmarshaller)
/*     */   {
/*  57 */     this.type = type;
/*  58 */     this.xopUnmarshaller = xopUnmarshaller;
/*     */   }
/*     */ 
/*     */   public Object startParticle(Object parent, QName elementName, ParticleBinding particle, Attributes attrs, NamespaceContext nsCtx)
/*     */   {
/*  67 */     ElementBinding xopInclude = (ElementBinding)particle.getTerm();
/*  68 */     if (!Constants.QNAME_XOP_INCLUDE.equals(xopInclude.getQName()))
/*     */     {
/*  70 */       throw new JBossXBRuntimeException("Expected " + Constants.QNAME_XOP_INCLUDE + " but got " + xopInclude.getQName());
/*     */     }
/*     */ 
/*  75 */     XOPUnmarshaller xopUnmarshaller = this.xopUnmarshaller == null ? this.type.getXopUnmarshaller() : this.xopUnmarshaller;
/*  76 */     if (xopUnmarshaller == null)
/*     */     {
/*  78 */       throw new JBossXBRuntimeException("Failed to process " + Constants.QNAME_XOP_INCLUDE + ": XOPUnmarshaller is not provided.");
/*     */     }
/*     */ 
/*  83 */     String cid = attrs.getValue("href");
/*  84 */     if (cid == null)
/*     */     {
/*  86 */       throw new JBossXBRuntimeException(Constants.QNAME_XOP_INCLUDE + " doesn't contain required href attribute");
/*     */     }
/*     */ 
/*  89 */     XOPObject xopObject = xopUnmarshaller.getAttachmentAsDataHandler(cid);
/*  90 */     Object content = xopObject.getContent();
/*  91 */     if (content == null)
/*     */     {
/*  93 */       throw new JBossXBRuntimeException("Content is not available for cid '" + cid + "'");
/*     */     }
/*     */ 
/*  96 */     if ((content instanceof InputStream))
/*     */     {
/*     */       try
/*     */       {
/* 100 */         ObjectInputStream ois = new ObjectInputStream((InputStream)content);
/* 101 */         content = ois.readObject();
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 105 */         throw new JBossXBRuntimeException("Failed to deserialize object: " + e.getMessage());
/*     */       }
/*     */       catch (ClassNotFoundException e)
/*     */       {
/* 109 */         throw new JBossXBRuntimeException("Failed to load the class to deserialize object: " + e.getMessage());
/*     */       }
/*     */     }
/* 112 */     return content;
/*     */   }
/*     */ 
/*     */   public Object endParticle(Object o, QName elementName, ParticleBinding particle)
/*     */   {
/* 117 */     return o;
/*     */   }
/*     */ 
/*     */   public void setParent(Object parent, Object o, QName elementName, ParticleBinding particle, ParticleBinding parentParticle)
/*     */   {
/* 126 */     if ((parent instanceof XOPElementHandler.XOPElement))
/*     */     {
/* 128 */       ((XOPElementHandler.XOPElement)parent).value = o;
/*     */     }
/*     */     else
/*     */     {
/* 132 */       throw new JBossXBRuntimeException("Expected XOPElement as a parent but got " + parent + " for element " + elementName);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.sunday.xop.XOPIncludeHandler
 * JD-Core Version:    0.6.0
 */