/*     */ package org.jboss.xb.binding.sunday.unmarshalling.impl.runtime;
/*     */ 
/*     */ import java.lang.reflect.Array;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import javax.xml.namespace.NamespaceContext;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.util.Classes;
/*     */ import org.jboss.xb.binding.JBossXBRuntimeException;
/*     */ import org.jboss.xb.binding.Util;
/*     */ import org.jboss.xb.binding.introspection.FieldInfo;
/*     */ import org.jboss.xb.binding.metadata.ValueMetaData;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.ValueAdapter;
/*     */ 
/*     */ public class RtUtil
/*     */ {
/*     */   public static void add(Object o, Object value, String prop, String colType, boolean ignoreNotFoundField, ValueAdapter valueAdapter)
/*     */   {
/*  55 */     FieldInfo fieldInfo = FieldInfo.getFieldInfo(o.getClass(), prop, !ignoreNotFoundField);
/*  56 */     if (fieldInfo == null)
/*     */     {
/*  58 */       return;
/*     */     }
/*     */ 
/*  61 */     Class fieldType = fieldInfo.getType();
/*     */     boolean arrType;
/*  63 */     if (fieldType.isArray())
/*     */     {
/*  65 */       arrType = true;
/*     */     }
/*     */     else
/*     */     {
/*     */       boolean arrType;
/*  67 */       if (Collection.class.isAssignableFrom(fieldType))
/*     */       {
/*  69 */         arrType = false;
/*     */       }
/*     */       else
/*     */       {
/*  73 */         throw new JBossXBRuntimeException("Expected type for " + prop + " in " + o.getClass() + " is an array or java.util.Collection but was " + fieldType);
/*     */       }
/*     */     }
/*     */     boolean arrType;
/*  79 */     if (valueAdapter != null)
/*     */     {
/*  81 */       value = valueAdapter.cast(value, fieldType);
/*     */     }
/*     */ 
/*  84 */     if ((!arrType) || (colType != null))
/*     */     {
/*  86 */       Collection col = (Collection)fieldInfo.getValue(o);
/*  87 */       if (col == null)
/*     */       {
/*  89 */         if (colType == null)
/*     */         {
/*  91 */           col = new ArrayList();
/*     */         }
/*     */         else
/*     */         {
/*     */           Class colCls;
/*     */           try {
/*  98 */             colCls = Thread.currentThread().getContextClassLoader().loadClass(colType);
/*     */           }
/*     */           catch (ClassNotFoundException e)
/*     */           {
/* 102 */             throw new JBossXBRuntimeException("Failed to load collection type: " + colType);
/*     */           }
/*     */ 
/*     */           try
/*     */           {
/* 107 */             col = (Collection)colCls.newInstance();
/*     */           }
/*     */           catch (Exception e)
/*     */           {
/* 111 */             throw new JBossXBRuntimeException("Failed to create an instance of " + colCls);
/*     */           }
/*     */         }
/*     */ 
/* 115 */         fieldInfo.setValue(o, col);
/*     */       }
/*     */ 
/* 118 */       col.add(value);
/*     */     }
/*     */     else
/*     */     {
/* 122 */       Object arr = fieldInfo.getValue(o);
/* 123 */       int length = 0;
/* 124 */       if (arr == null)
/*     */       {
/* 126 */         arr = Array.newInstance(fieldType.getComponentType(), 1);
/*     */       }
/*     */       else
/*     */       {
/* 130 */         Object tmp = arr;
/* 131 */         length = Array.getLength(arr);
/* 132 */         arr = Array.newInstance(fieldType.getComponentType(), length + 1);
/* 133 */         System.arraycopy(tmp, 0, arr, 0, length);
/*     */       }
/*     */ 
/* 136 */       Array.set(arr, length, value);
/* 137 */       fieldInfo.setValue(o, arr);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void set(Object o, Object value, String prop, String colType, boolean ignoreNotFoundField, ValueAdapter valueAdapter)
/*     */   {
/* 148 */     FieldInfo fieldInfo = FieldInfo.getFieldInfo(o.getClass(), prop, !ignoreNotFoundField);
/* 149 */     if (fieldInfo == null)
/*     */     {
/* 151 */       return;
/*     */     }
/*     */ 
/* 154 */     Class fieldType = fieldInfo.getType();
/*     */ 
/* 156 */     if (valueAdapter != null)
/*     */     {
/* 158 */       value = valueAdapter.cast(value, fieldType);
/*     */     }
/*     */ 
/* 161 */     if ((Collection.class.isAssignableFrom(fieldType)) && (!Collection.class.isAssignableFrom(value.getClass())))
/*     */     {
/* 164 */       Collection col = (Collection)fieldInfo.getValue(o);
/* 165 */       if (col == null)
/*     */       {
/* 167 */         if (colType == null)
/*     */         {
/* 169 */           col = new ArrayList();
/*     */         }
/*     */         else
/*     */         {
/*     */           Class colCls;
/*     */           try {
/* 176 */             colCls = Thread.currentThread().getContextClassLoader().loadClass(colType);
/*     */           }
/*     */           catch (ClassNotFoundException e)
/*     */           {
/* 180 */             throw new JBossXBRuntimeException("Failed to load collection type: " + colType);
/*     */           }
/*     */ 
/*     */           try
/*     */           {
/* 185 */             col = (Collection)colCls.newInstance();
/*     */           }
/*     */           catch (Exception e)
/*     */           {
/* 189 */             throw new JBossXBRuntimeException("Failed to create an instance of " + colCls);
/*     */           }
/*     */         }
/*     */ 
/* 193 */         fieldInfo.setValue(o, col);
/*     */       }
/*     */ 
/* 197 */       col.add(value);
/*     */     }
/*     */     else
/*     */     {
/* 228 */       Class valueClass = value == null ? null : value.getClass();
/* 229 */       if ((valueClass != null) && (fieldType.isArray()) && (Collection.class.isAssignableFrom(valueClass)))
/*     */       {
/* 231 */         Collection col = (Collection)value;
/* 232 */         Class compType = fieldType.getComponentType();
/* 233 */         value = Array.newInstance(compType, col.size());
/*     */         int i;
/*     */         Iterator iter;
/* 234 */         if (compType.isPrimitive())
/*     */         {
/* 236 */           i = 0;
/* 237 */           for (iter = col.iterator(); iter.hasNext(); )
/*     */           {
/* 239 */             Array.set(value, i++, iter.next());
/*     */           }
/*     */         }
/*     */         else
/*     */         {
/* 244 */           value = col.toArray((Object[])(Object[])value);
/*     */         }
/*     */       }
/*     */ 
/* 248 */       fieldInfo.setValue(o, value);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void set(Object o, QName elementName, Object value, boolean ignoreLowLine)
/*     */   {
/* 254 */     if ((o instanceof Collection))
/*     */     {
/* 256 */       ((Collection)o).add(value);
/*     */     }
/*     */     else
/*     */     {
/* 260 */       String fieldName = Util.xmlNameToFieldName(elementName.getLocalPart(), ignoreLowLine);
/* 261 */       FieldInfo fieldInfo = FieldInfo.getFieldInfo(o.getClass(), fieldName, true);
/* 262 */       fieldInfo.setValue(o, value);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static Class loadClass(String clsName, boolean failIfNotFound)
/*     */   {
/* 268 */     Class cls = null;
/*     */     try
/*     */     {
/* 271 */       cls = Classes.loadClass(clsName);
/*     */     }
/*     */     catch (ClassNotFoundException e)
/*     */     {
/* 275 */       if (failIfNotFound)
/*     */       {
/* 277 */         throw new JBossXBRuntimeException("Failed to load class " + clsName);
/*     */       }
/*     */     }
/* 280 */     return cls;
/*     */   }
/*     */ 
/*     */   public static Method getUnmarshalMethod(QName qName, ValueMetaData valueMetaData)
/*     */   {
/* 285 */     String unmarshalMethod = valueMetaData.getUnmarshalMethod();
/* 286 */     if (unmarshalMethod == null)
/*     */     {
/* 288 */       throw new JBossXBRuntimeException("javaType annotation is specified for " + qName + " but does not contain parseMethod attribute");
/*     */     }
/*     */ 
/* 293 */     int lastDot = unmarshalMethod.lastIndexOf('.');
/* 294 */     String clsName = unmarshalMethod.substring(0, lastDot);
/* 295 */     String methodName = unmarshalMethod.substring(lastDot + 1);
/*     */ 
/* 297 */     Class cls = loadClass(clsName, true);
/*     */     try
/*     */     {
/* 301 */       return cls.getMethod(methodName, new Class[] { String.class });
/*     */     }
/*     */     catch (NoSuchMethodException e)
/*     */     {
/*     */       try
/*     */       {
/* 307 */         return cls.getMethod(methodName, new Class[] { String.class, NamespaceContext.class });
/*     */       } catch (NoSuchMethodException e1) {
/*     */       }
/*     */     }
/* 311 */     throw new JBossXBRuntimeException("Neither " + methodName + "(" + String.class.getName() + " p) nor " + methodName + "(" + String.class.getName() + " p1, " + NamespaceContext.class.getName() + " p2) were found in " + cls);
/*     */   }
/*     */ 
/*     */   public static Object invokeUnmarshalMethod(Class cls, String methodName, Object value, Class valueType, NamespaceContext nsCtx, QName qName)
/*     */   {
/*     */     Method method;
/*     */     Object[] args;
/*     */     try
/*     */     {
/* 338 */       method = cls.getMethod(methodName, new Class[] { valueType });
/* 339 */       args = new Object[] { value };
/*     */     }
/*     */     catch (NoSuchMethodException e)
/*     */     {
/*     */       try
/*     */       {
/* 345 */         method = cls.getMethod(methodName, new Class[] { valueType, NamespaceContext.class });
/* 346 */         args = new Object[] { value, nsCtx };
/*     */       }
/*     */       catch (NoSuchMethodException e1)
/*     */       {
/* 350 */         throw new JBossXBRuntimeException("Neither " + methodName + "(" + valueType.getName() + " p) nor " + methodName + "(" + valueType.getName() + " p1, " + NamespaceContext.class.getName() + " p2) were found in " + cls);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 365 */     return invokeUnmarshalMethod(method, args, qName);
/*     */   }
/*     */ 
/*     */   public static Object invokeUnmarshalMethod(Method method, Object[] args, QName qName)
/*     */   {
/*     */     Object unmarshalled;
/*     */     try {
/* 373 */       unmarshalled = method.invoke(null, args);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 377 */       throw new JBossXBRuntimeException("Failed to invoke unmarshalMethod " + method.getDeclaringClass().getName() + "." + method.getName() + " for element " + qName + " and value " + args[0] + ": " + e.getMessage(), e);
/*     */     }
/*     */ 
/* 390 */     return unmarshalled;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.sunday.unmarshalling.impl.runtime.RtUtil
 * JD-Core Version:    0.6.0
 */