/*      */ package org.jboss.xb.binding.sunday.unmarshalling.impl.runtime;
/*      */ 
/*      */ import java.lang.reflect.Array;
/*      */ import java.lang.reflect.Constructor;
/*      */ import java.lang.reflect.Method;
/*      */ import java.lang.reflect.Modifier;
/*      */ import java.util.Collection;
/*      */ import java.util.List;
/*      */ import java.util.Map;
/*      */ import javax.xml.namespace.NamespaceContext;
/*      */ import javax.xml.namespace.QName;
/*      */ import org.jboss.logging.Logger;
/*      */ import org.jboss.util.Classes;
/*      */ import org.jboss.xb.binding.Constants;
/*      */ import org.jboss.xb.binding.GenericValueContainer;
/*      */ import org.jboss.xb.binding.GenericValueContainer.FACTORY;
/*      */ import org.jboss.xb.binding.JBossXBRuntimeException;
/*      */ import org.jboss.xb.binding.SimpleTypeBindings;
/*      */ import org.jboss.xb.binding.Util;
/*      */ import org.jboss.xb.binding.group.ValueList;
/*      */ import org.jboss.xb.binding.group.ValueListHandler;
/*      */ import org.jboss.xb.binding.group.ValueListHandler.FACTORY;
/*      */ import org.jboss.xb.binding.group.ValueListInitializer;
/*      */ import org.jboss.xb.binding.introspection.FieldInfo;
/*      */ import org.jboss.xb.binding.metadata.AddMethodMetaData;
/*      */ import org.jboss.xb.binding.metadata.ClassMetaData;
/*      */ import org.jboss.xb.binding.metadata.MapEntryMetaData;
/*      */ import org.jboss.xb.binding.metadata.PackageMetaData;
/*      */ import org.jboss.xb.binding.metadata.PropertyMetaData;
/*      */ import org.jboss.xb.binding.metadata.PutMethodMetaData;
/*      */ import org.jboss.xb.binding.metadata.ValueMetaData;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.AttributeBinding;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.AttributeHandler;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.CharactersHandler;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.ModelGroupBinding;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.ParticleHandler;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.TermBinding;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.WildcardBinding;
/*      */ import org.xml.sax.Attributes;
/*      */ 
/*      */ public class RtElementHandler
/*      */   implements ParticleHandler
/*      */ {
/*   70 */   private static final Logger log = Logger.getLogger(RtElementHandler.class);
/*      */ 
/*   72 */   public static final RtElementHandler INSTANCE = new RtElementHandler();
/*      */ 
/*      */   public Object startParticle(Object parent, QName elementName, ParticleBinding particle, Attributes attrs, NamespaceContext nsCtx)
/*      */   {
/*   88 */     TermBinding term = particle.getTerm();
/*   89 */     Object o = startElement(parent, elementName, particle);
/*   90 */     if (!term.isModelGroup())
/*      */     {
/*   92 */       ElementBinding element = (ElementBinding)term;
/*   93 */       if (o != null)
/*      */       {
/*   95 */         attrs = element.getType().expandWithDefaultAttributes(attrs);
/*   96 */         attributes(o, elementName, element, attrs, nsCtx);
/*      */       }
/*      */     }
/*   99 */     return o;
/*      */   }
/*      */ 
/*      */   public void setParent(Object parent, Object o, QName qName, ParticleBinding particle, ParticleBinding parentParticle)
/*      */   {
/*  108 */     TermBinding term = particle.getTerm();
/*  109 */     if (term.isSkip())
/*      */     {
/*  111 */       return;
/*      */     }
/*      */ 
/*  114 */     boolean trace = log.isTraceEnabled();
/*  115 */     if (trace)
/*      */     {
/*  117 */       log.trace("setParent " + qName + " parent=" + parent + " object=" + o + " term=" + term);
/*      */     }
/*      */ 
/*  120 */     TermBinding parentTerm = parentParticle.getTerm();
/*      */ 
/*  122 */     if (term.isMapEntryKey())
/*      */     {
/*  124 */       if (trace)
/*      */       {
/*  126 */         log.trace("setParent " + qName + " mapKey");
/*      */       }
/*      */ 
/*  129 */       if ((parent instanceof MapEntry))
/*      */       {
/*  131 */         MapEntry mapEntry = (MapEntry)parent;
/*  132 */         mapEntry.setKey(o);
/*      */       }
/*  134 */       else if (parentTerm != null)
/*      */       {
/*  136 */         MapEntryMetaData mapEntryMetaData = getMapEntryMetaData(parentTerm, qName);
/*      */ 
/*  138 */         String getKeyMethodName = mapEntryMetaData.getGetKeyMethod();
/*  139 */         if (getKeyMethodName == null)
/*      */         {
/*  141 */           getKeyMethodName = "getKey";
/*      */         }
/*      */ 
/*  144 */         String setKeyMethodName = mapEntryMetaData.getSetKeyMethod();
/*  145 */         if (setKeyMethodName == null)
/*      */         {
/*  147 */           setKeyMethodName = "setKey";
/*      */         }
/*      */ 
/*  150 */         Class parentCls = parent.getClass();
/*  151 */         Method setKeyMethod = getSetMethod(parentCls, getKeyMethodName, setKeyMethodName);
/*  152 */         invokeSetter(setKeyMethod, parent, o, setKeyMethodName);
/*      */       }
/*      */       else
/*      */       {
/*  156 */         throw new JBossXBRuntimeException("Element " + qName + " bound as map entry key but parent element is not recognized as map entry and its metadata is not available.");
/*      */       }
/*      */ 
/*      */     }
/*  163 */     else if (term.isMapEntryValue())
/*      */     {
/*  165 */       if (trace)
/*      */       {
/*  167 */         log.trace("setParent " + qName + " mapValue");
/*      */       }
/*      */ 
/*  170 */       if ((parent instanceof MapEntry))
/*      */       {
/*  172 */         MapEntry mapEntry = (MapEntry)parent;
/*  173 */         mapEntry.setValue(o);
/*      */       }
/*  175 */       else if (parentTerm != null)
/*      */       {
/*  177 */         MapEntryMetaData mapEntryMetaData = getMapEntryMetaData(parentTerm, qName);
/*  178 */         setMapEntryValue(mapEntryMetaData, parent, o);
/*      */       }
/*      */       else
/*      */       {
/*  182 */         throw new JBossXBRuntimeException("Element " + qName + " bound as map entry key but parent element is not recognized as map entry and its metadata is not available.");
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/*  191 */       Object owner = parent;
/*  192 */       if ((parent instanceof MapEntry))
/*      */       {
/*  194 */         if (trace)
/*      */         {
/*  196 */           log.trace("setParent " + qName + " mapEntry");
/*      */         }
/*      */ 
/*  199 */         MapEntry mapEntry = (MapEntry)parent;
/*  200 */         owner = mapEntry.getValue();
/*  201 */         if (owner == null)
/*      */         {
/*  203 */           if (parentTerm == null)
/*      */           {
/*  205 */             throw new JBossXBRuntimeException("Binding metadata needed for lazy map entry value instantiation is not available for parent element of element " + qName);
/*      */           }
/*      */ 
/*  211 */           MapEntryMetaData mapEntryMetaData = getMapEntryMetaData(parentTerm, qName);
/*  212 */           String valueType = mapEntryMetaData.getValueType();
/*  213 */           if (valueType == null)
/*      */           {
/*  215 */             throw new JBossXBRuntimeException("Element " + qName + " is supposed to be bound as map entry value with lazy value instantiation " + "but value type is not specified in its map entry metadata.");
/*      */           }
/*      */ 
/*      */           Class valueCls;
/*      */           try
/*      */           {
/*  225 */             valueCls = Thread.currentThread().getContextClassLoader().loadClass(valueType);
/*      */           }
/*      */           catch (ClassNotFoundException e)
/*      */           {
/*  229 */             throw new JBossXBRuntimeException("Failed to load value type specified in the map entry metadata: " + valueType);
/*      */           }
/*      */ 
/*      */           try
/*      */           {
/*  236 */             owner = valueCls.newInstance();
/*      */           }
/*      */           catch (Exception e)
/*      */           {
/*  240 */             throw new JBossXBRuntimeException("Failed to create an instance of value type " + valueType + ": " + e.getMessage());
/*      */           }
/*      */ 
/*  245 */           setMapEntryValue(mapEntryMetaData, parent, owner);
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  250 */       WildcardBinding wildcard = null;
/*  251 */       if ((parentTerm != null) && (!parentTerm.isModelGroup()))
/*      */       {
/*  253 */         ElementBinding parentElement = (ElementBinding)parentTerm;
/*  254 */         TypeBinding parentType = parentElement.getType();
/*  255 */         wildcard = parentType.getWildcard();
/*      */ 
/*  257 */         if ((wildcard != null) && (parentType.getElement(qName) != null))
/*      */         {
/*  259 */           wildcard = null;
/*      */         }
/*      */       }
/*      */ 
/*  263 */       if (!tryPut(owner, o, qName, term, trace))
/*      */       {
/*  266 */         if (!tryAdd(owner, o, qName, term, wildcard, trace))
/*      */         {
/*  269 */           if ((owner instanceof GenericValueContainer))
/*      */           {
/*  271 */             if (trace)
/*      */             {
/*  273 */               log.trace("setParent " + qName + " addChild");
/*      */             }
/*  275 */             ((GenericValueContainer)owner).addChild(qName, o);
/*      */           }
/*  277 */           else if ((owner instanceof Collection))
/*      */           {
/*  279 */             if (trace)
/*      */             {
/*  281 */               log.trace("setParent " + qName + " collection.add()");
/*      */             }
/*  283 */             ((Collection)owner).add(o);
/*      */           }
/*      */           else
/*      */           {
/*  287 */             PropertyMetaData propertyMetaData = wildcard == null ? null : wildcard.getPropertyMetaData();
/*  288 */             if (propertyMetaData == null)
/*      */             {
/*  290 */               propertyMetaData = term.getPropertyMetaData();
/*      */             }
/*      */ 
/*  293 */             String propName = null;
/*  294 */             String colType = null;
/*  295 */             if (propertyMetaData != null)
/*      */             {
/*  297 */               propName = propertyMetaData.getName();
/*  298 */               colType = propertyMetaData.getCollectionType();
/*      */             }
/*      */ 
/*  301 */             if (propName == null)
/*      */             {
/*  303 */               propName = Util.xmlNameToFieldName(qName.getLocalPart(), term.getSchema().isIgnoreLowLine());
/*      */             }
/*      */ 
/*  306 */             if (trace)
/*      */             {
/*  308 */               log.trace("setParent " + qName + " metadata set " + propName);
/*      */             }
/*      */ 
/*  320 */             RtUtil.set(owner, o, propName, colType, term.getSchema().isIgnoreUnresolvedFieldOrClass(), term.getValueAdapter());
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public Object endParticle(Object o, QName elementName, ParticleBinding particle)
/*      */   {
/*  330 */     TermBinding term = particle.getTerm();
/*  331 */     if (term.isSkip())
/*      */     {
/*  333 */       return o;
/*      */     }
/*      */ 
/*  336 */     boolean trace = log.isTraceEnabled();
/*  337 */     if (trace)
/*      */     {
/*  339 */       log.trace("endParticle " + elementName + " object=" + o + " term=" + term);
/*      */     }
/*      */ 
/*  342 */     if ((o instanceof GenericValueContainer))
/*      */     {
/*      */       try
/*      */       {
/*  346 */         if (trace)
/*      */         {
/*  348 */           log.trace("endParticle " + elementName + " instantiate()");
/*      */         }
/*  350 */         o = ((GenericValueContainer)o).instantiate();
/*      */       }
/*      */       catch (JBossXBRuntimeException e)
/*      */       {
/*  354 */         throw e;
/*      */       }
/*      */       catch (RuntimeException e)
/*      */       {
/*  358 */         throw new JBossXBRuntimeException("Container failed to create an instance for " + elementName + ": " + e.getMessage(), e);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  365 */     return o;
/*      */   }
/*      */ 
/*      */   private Object startElement(Object parent, QName elementName, ParticleBinding particle)
/*      */   {
/*  372 */     TermBinding term = particle.getTerm();
/*  373 */     if (term.isSkip())
/*      */     {
/*  375 */       return parent;
/*      */     }
/*      */ 
/*  378 */     boolean trace = log.isTraceEnabled();
/*  379 */     if (trace)
/*      */     {
/*  381 */       log.trace("startElement " + elementName + " parent=" + parent + " term=" + term);
/*      */     }
/*      */ 
/*  384 */     ClassMetaData classMetaData = term.getClassMetaData();
/*  385 */     MapEntryMetaData mapEntryMetaData = term.getMapEntryMetaData();
/*      */ 
/*  387 */     if (!term.isModelGroup())
/*      */     {
/*  389 */       TypeBinding type = ((ElementBinding)term).getType();
/*  390 */       if ((type.isSimple()) || ((classMetaData == null) && (mapEntryMetaData == null) && ((!type.isStartElementCreatesObject()) || (Constants.QNAME_ANYTYPE.equals(type.getQName())))))
/*      */       {
/*  395 */         if (trace)
/*      */         {
/*  397 */           log.trace("startElement " + elementName + " does not create an object");
/*      */         }
/*  399 */         return null;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  405 */     ElementBinding arrayItem = null;
/*  406 */     if (!term.isModelGroup())
/*      */     {
/*  408 */       TypeBinding type = ((ElementBinding)term).getType();
/*  409 */       if (type.getAttributes().isEmpty())
/*      */       {
/*  411 */         ParticleBinding typeParticle = type.getParticle();
/*  412 */         ModelGroupBinding modelGroup = (ModelGroupBinding)(typeParticle == null ? null : typeParticle.getTerm());
/*  413 */         arrayItem = modelGroup == null ? null : modelGroup.getArrayItem();
/*      */ 
/*  416 */         if ((arrayItem != null) && ((arrayItem.isSkip()) || (arrayItem.getMapEntryMetaData() != null) || (arrayItem.getPutMethodMetaData() != null) || (arrayItem.getAddMethodMetaData() != null)))
/*      */         {
/*  423 */           arrayItem = null;
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  428 */     if (arrayItem != null)
/*      */     {
/*  430 */       Class wrapperType = null;
/*  431 */       if (classMetaData != null)
/*      */       {
/*  433 */         wrapperType = loadClassForTerm(classMetaData.getImpl(), term.getSchema().isIgnoreUnresolvedFieldOrClass(), elementName);
/*      */ 
/*  438 */         if ((GenericValueContainer.class.isAssignableFrom(wrapperType)) || (Collection.class.isAssignableFrom(wrapperType)) || (Map.class.isAssignableFrom(wrapperType)))
/*      */         {
/*  442 */           return newInstance(wrapperType, elementName, term.getSchema().isUseNoArgCtorIfFound());
/*      */         }
/*      */       }
/*      */ 
/*  446 */       if ((wrapperType == null) && (parent == null))
/*      */       {
/*  448 */         Class itemType = classForElement(arrayItem, null);
/*  449 */         if (itemType != null)
/*      */         {
/*  451 */           if (trace)
/*      */           {
/*  453 */             log.trace("startElement " + elementName + " new array " + itemType.getName());
/*      */           }
/*  455 */           return GenericValueContainer.FACTORY.array(itemType);
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/*  460 */         PropertyMetaData propertyMetaData = wrapperType == null ? term.getPropertyMetaData() : arrayItem.getPropertyMetaData();
/*      */         String propName;
/*      */         String propName;
/*  464 */         if (propertyMetaData == null)
/*      */         {
/*  466 */           propName = Util.xmlNameToFieldName(wrapperType == null ? elementName.getLocalPart() : arrayItem.getQName().getLocalPart(), term.getSchema().isIgnoreLowLine());
/*      */         }
/*      */         else
/*      */         {
/*  473 */           propName = propertyMetaData.getName();
/*      */         }
/*      */ 
/*  476 */         if (trace)
/*      */         {
/*  478 */           log.trace("startElement " + elementName + " property=" + propName + " wrapper=" + wrapperType);
/*      */         }
/*      */ 
/*  481 */         Class parentClass = wrapperType;
/*  482 */         if (wrapperType == null)
/*      */         {
/*  484 */           if ((parent instanceof GenericValueContainer))
/*      */           {
/*  486 */             parentClass = ((GenericValueContainer)parent).getTargetClass();
/*      */           }
/*  488 */           else if ((parent instanceof ValueList))
/*      */           {
/*  490 */             parentClass = ((ValueList)parent).getTargetClass();
/*      */           }
/*      */           else
/*      */           {
/*  494 */             parentClass = parent.getClass();
/*      */           }
/*      */         }
/*      */ 
/*  498 */         Class fieldType = null;
/*  499 */         if (parentClass.isArray())
/*      */         {
/*  501 */           fieldType = parentClass.getComponentType();
/*      */         }
/*      */         else
/*      */         {
/*  509 */           FieldInfo fieldInfo = FieldInfo.getFieldInfo(parentClass, propName, false);
/*  510 */           if (fieldInfo != null)
/*      */           {
/*  512 */             fieldType = fieldInfo.getType();
/*  513 */             if ((particle.isRepeatable()) && (fieldType.isArray()))
/*      */             {
/*  515 */               fieldType = fieldType.getComponentType();
/*      */             }
/*      */           }
/*  518 */           else if ((((ElementBinding)term).getType().getInterceptors(arrayItem.getQName()).isEmpty()) && (arrayItem.getInterceptors().isEmpty()))
/*      */           {
/*  521 */             QName typeName = ((ElementBinding)term).getType().getQName();
/*  522 */             throw new JBossXBRuntimeException("Couldn't apply 'array wrapper' pattern for element " + elementName + " of type " + (typeName == null ? "anonymous" : typeName.toString()) + ": failed to resolve property " + propName + " and no interceptors applied to override handler.setParent(...)");
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*  531 */         if (fieldType != null)
/*      */         {
/*  534 */           if (fieldType.isArray())
/*      */           {
/*  536 */             return GenericValueContainer.FACTORY.array(wrapperType, propName, fieldType.getComponentType());
/*      */           }
/*  538 */           if (Collection.class.isAssignableFrom(fieldType))
/*      */           {
/*  540 */             if (wrapperType == null)
/*      */             {
/*  542 */               return new ValueListInitializer().newValueList(ValueListHandler.FACTORY.child(), Collection.class);
/*      */             }
/*      */ 
/*      */           }
/*      */           else
/*      */           {
/*  548 */             return GenericValueContainer.FACTORY.array(wrapperType, propName, fieldType);
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  554 */     Object o = null;
/*  555 */     if (mapEntryMetaData != null)
/*      */     {
/*  557 */       if (mapEntryMetaData.getImpl() != null)
/*      */       {
/*  559 */         Class cls = loadClassForTerm(mapEntryMetaData.getImpl(), term.getSchema().isIgnoreUnresolvedFieldOrClass(), elementName);
/*      */ 
/*  561 */         if (trace)
/*      */         {
/*  563 */           log.trace("startElement " + elementName + " new map entry " + cls.getName());
/*      */         }
/*      */ 
/*  566 */         o = newInstance(cls, elementName, term.getSchema().isUseNoArgCtorIfFound());
/*      */       }
/*      */       else
/*      */       {
/*  570 */         o = new MapEntry();
/*  571 */         if (trace)
/*      */         {
/*  573 */           log.trace("startElement " + elementName + " new map entry");
/*      */         }
/*      */       }
/*      */ 
/*  577 */       if ((mapEntryMetaData.isNonNullValue()) && (mapEntryMetaData.getValueType() != null))
/*      */       {
/*      */         Class mapValueType;
/*      */         try {
/*  582 */           mapValueType = Thread.currentThread().getContextClassLoader().loadClass(mapEntryMetaData.getValueType());
/*      */         }
/*      */         catch (ClassNotFoundException e)
/*      */         {
/*  586 */           throw new JBossXBRuntimeException("startElement failed for " + elementName + ": failed to load class " + mapEntryMetaData.getValueType() + " for map entry value.");
/*      */         }
/*      */ 
/*      */         Object value;
/*      */         try
/*      */         {
/*  593 */           if (trace)
/*      */           {
/*  595 */             log.trace("startElement " + elementName + " map value type " + mapEntryMetaData.getValueType());
/*      */           }
/*  597 */           value = mapValueType.newInstance();
/*      */         }
/*      */         catch (Exception e)
/*      */         {
/*  601 */           throw new JBossXBRuntimeException("startElement failed for " + elementName + ": failed to create an instance of " + mapValueType + " for map entry value.");
/*      */         }
/*      */ 
/*  605 */         if ((o instanceof MapEntry))
/*      */         {
/*  607 */           ((MapEntry)o).setValue(value);
/*      */         }
/*      */         else
/*      */         {
/*  611 */           String getValueMethodName = mapEntryMetaData.getGetValueMethod();
/*  612 */           if (getValueMethodName == null)
/*      */           {
/*  614 */             getValueMethodName = "getValue";
/*      */           }
/*      */ 
/*  617 */           String setValueMethodName = mapEntryMetaData.getSetValueMethod();
/*  618 */           if (setValueMethodName == null)
/*      */           {
/*  620 */             setValueMethodName = "setValue";
/*      */           }
/*      */           Method getValueMethod;
/*      */           try
/*      */           {
/*  626 */             getValueMethod = o.getClass().getMethod(getValueMethodName, null);
/*      */           }
/*      */           catch (NoSuchMethodException e)
/*      */           {
/*  630 */             throw new JBossXBRuntimeException("getValueMethod=" + getValueMethodName + " is not found in map entry " + o.getClass());
/*      */           }
/*      */ 
/*      */           Method setValueMethod;
/*      */           try
/*      */           {
/*  637 */             setValueMethod = o.getClass().getMethod(setValueMethodName, new Class[] { getValueMethod.getReturnType() });
/*      */           }
/*      */           catch (NoSuchMethodException e)
/*      */           {
/*  641 */             throw new JBossXBRuntimeException("setValueMethod=" + setValueMethodName + "(" + getValueMethod.getReturnType().getName() + " value) is not found in map entry " + o.getClass());
/*      */           }
/*      */ 
/*      */           try
/*      */           {
/*  648 */             setValueMethod.invoke(o, new Object[] { value });
/*      */           }
/*      */           catch (Exception e)
/*      */           {
/*  653 */             throw new JBossXBRuntimeException("setValueMethod=" + setValueMethodName + " failed: owner=" + o + ", value=" + value + ", msg=" + e.getMessage(), e);
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/*  663 */       Class parentClass = null;
/*  664 */       if (parent != null)
/*      */       {
/*  666 */         if ((parent instanceof GenericValueContainer))
/*      */         {
/*  668 */           parentClass = ((GenericValueContainer)parent).getTargetClass();
/*      */         }
/*  670 */         else if ((parent instanceof ValueList))
/*      */         {
/*  672 */           parentClass = ((ValueList)parent).getTargetClass();
/*      */         }
/*      */         else
/*      */         {
/*  676 */           parentClass = parent.getClass();
/*      */         }
/*      */       }
/*      */       Class cls;
/*      */       Class cls;
/*  681 */       if (term.isModelGroup())
/*      */       {
/*  683 */         if (classMetaData == null)
/*      */         {
/*  685 */           throw new JBossXBRuntimeException("Model groups should be annotated with 'class' annotation to be bound.");
/*      */         }
/*      */ 
/*  688 */         cls = loadClassForTerm(classMetaData.getImpl(), term.getSchema().isIgnoreUnresolvedFieldOrClass(), elementName);
/*      */       }
/*      */       else
/*      */       {
/*  692 */         ElementBinding element = (ElementBinding)term;
/*  693 */         cls = classForNonArrayItem(element, parentClass);
/*  694 */         if (cls != null)
/*      */         {
/*  697 */           TypeBinding simpleType = element.getType().getSimpleType();
/*  698 */           if (simpleType != null)
/*      */           {
/*  700 */             Class simpleCls = classForSimpleType(simpleType, element.isNillable());
/*  701 */             if ((cls.equals(simpleCls)) || ((cls.isPrimitive()) && (Classes.getPrimitiveWrapper(cls) == simpleCls)) || ((simpleCls.isPrimitive()) && (Classes.getPrimitiveWrapper(simpleCls) == cls)))
/*      */             {
/*  704 */               cls = null;
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */ 
/*  710 */       if (cls != null)
/*      */       {
/*      */         boolean noArgCtor;
/*      */         boolean noArgCtor;
/*  713 */         if (classMetaData == null)
/*      */         {
/*  715 */           noArgCtor = term.getSchema().isUseNoArgCtorIfFound();
/*      */         }
/*      */         else
/*      */         {
/*  719 */           Boolean termUsesNoArgCtor = classMetaData.isUseNoArgCtor();
/*  720 */           noArgCtor = termUsesNoArgCtor == null ? term.getSchema().isUseNoArgCtorIfFound() : termUsesNoArgCtor.booleanValue();
/*      */         }
/*      */ 
/*  724 */         if (trace)
/*      */         {
/*  726 */           log.trace("startElement " + elementName + " new " + cls.getName() + ", noArgCtor=" + noArgCtor);
/*      */         }
/*  728 */         o = newInstance(cls, elementName, noArgCtor);
/*      */       }
/*      */     }
/*      */ 
/*  732 */     return o;
/*      */   }
/*      */ 
/*      */   private void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx)
/*      */   {
/*  741 */     TypeBinding type = element.getType();
/*  742 */     for (int i = 0; i < attrs.getLength(); i++)
/*      */     {
/*  744 */       QName attrName = new QName(attrs.getURI(i), attrs.getLocalName(i));
/*  745 */       AttributeBinding binding = type.getAttribute(attrName);
/*  746 */       if (binding != null)
/*      */       {
/*  748 */         AttributeHandler handler = binding.getHandler();
/*  749 */         if (handler != null)
/*      */         {
/*  751 */           Object value = handler.unmarshal(elementName, attrName, binding, nsCtx, attrs.getValue(i));
/*  752 */           handler.attribute(elementName, attrName, binding, o, value);
/*      */         }
/*      */         else
/*      */         {
/*  756 */           throw new JBossXBRuntimeException("Attribute binding present but has no handler: element=" + elementName + ", attrinute=" + attrName);
/*      */         }
/*      */ 
/*      */       }
/*      */       else
/*      */       {
/*  763 */         if ("http://www.w3.org/2001/XMLSchema-instance".equals(attrs.getURI(i)))
/*      */           continue;
/*  765 */         CharactersHandler simpleType = type.getCharactersHandler();
/*      */ 
/*  767 */         if (simpleType != null)
/*      */           continue;
/*  769 */         Object value = attrs.getValue(i);
/*  770 */         RtUtil.set(o, attrName, value, element.getSchema().isIgnoreLowLine());
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private boolean tryAdd(Object owner, Object o, QName qName, TermBinding term, WildcardBinding wildcard, boolean trace)
/*      */   {
/*  784 */     AddMethodMetaData addMetaData = wildcard == null ? null : wildcard.getAddMethodMetaData();
/*  785 */     if (addMetaData == null)
/*      */     {
/*  787 */       addMetaData = term.getAddMethodMetaData();
/*      */     }
/*      */ 
/*  790 */     if (addMetaData == null)
/*      */     {
/*  792 */       return false;
/*      */     }
/*      */ 
/*  795 */     if (trace)
/*      */     {
/*  797 */       log.trace("setParent " + qName + " add");
/*      */     }
/*  799 */     invokeAdd(qName, addMetaData, owner, o);
/*  800 */     return true;
/*      */   }
/*      */ 
/*      */   private boolean tryPut(Object owner, Object o, QName qName, TermBinding term, boolean trace)
/*      */   {
/*  805 */     if ((term.getPutMethodMetaData() != null) || ((term.getMapEntryMetaData() != null) && ((owner instanceof Map))))
/*      */     {
/*  808 */       if (trace)
/*      */       {
/*  810 */         log.trace("setParent " + qName + " mapPut");
/*      */       }
/*  812 */       invokePut(qName, term, owner, o);
/*  813 */       return true;
/*      */     }
/*  815 */     return false;
/*      */   }
/*      */ 
/*      */   private Class classForElement(ElementBinding element, Class parentClass)
/*      */   {
/*  821 */     TypeBinding type = element.getType();
/*  822 */     QName typeQName = type.getQName();
/*      */     Class cls;
/*      */     Class cls;
/*  823 */     if ((typeQName != null) && ("http://www.w3.org/2001/XMLSchema".equals(typeQName.getNamespaceURI())))
/*      */     {
/*  825 */       cls = SimpleTypeBindings.classForType(type.getQName().getLocalPart(), element.isNillable());
/*      */     }
/*      */     else
/*      */     {
/*  829 */       ElementBinding arrayItem = null;
/*  830 */       if ((!type.isSimple()) && (type.getAttributes().isEmpty()))
/*      */       {
/*  832 */         ParticleBinding typeParticle = type.getParticle();
/*  833 */         ModelGroupBinding modelGroup = (ModelGroupBinding)(typeParticle == null ? null : typeParticle.getTerm());
/*  834 */         arrayItem = modelGroup == null ? null : modelGroup.getArrayItem();
/*      */       }
/*      */ 
/*  837 */       if (arrayItem != null)
/*      */       {
/*  839 */         Class cls = classForElement(arrayItem, parentClass);
/*      */ 
/*  841 */         cls = Array.newInstance(cls, 0).getClass();
/*      */       }
/*      */       else
/*      */       {
/*  845 */         cls = classForNonArrayItem(element, parentClass);
/*      */       }
/*      */     }
/*  848 */     return cls;
/*      */   }
/*      */ 
/*      */   private static void setMapEntryValue(MapEntryMetaData mapEntryMetaData, Object parent, Object o)
/*      */   {
/*  853 */     String getValueMethodName = mapEntryMetaData.getGetValueMethod();
/*  854 */     if (getValueMethodName == null)
/*      */     {
/*  856 */       getValueMethodName = "getValue";
/*      */     }
/*      */ 
/*  859 */     String setValueMethodName = mapEntryMetaData.getSetValueMethod();
/*  860 */     if (setValueMethodName == null)
/*      */     {
/*  862 */       setValueMethodName = "setValue";
/*      */     }
/*      */ 
/*  865 */     Class parentCls = parent.getClass();
/*  866 */     Method setValueMethod = getSetMethod(parentCls, getValueMethodName, setValueMethodName);
/*  867 */     invokeSetter(setValueMethod, parent, o, setValueMethodName);
/*      */   }
/*      */ 
/*      */   private static void invokeSetter(Method setValueMethod, Object parent, Object o, String setValueMethodName)
/*      */   {
/*      */     try
/*      */     {
/*  874 */       setValueMethod.invoke(parent, new Object[] { o });
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  878 */       throw new JBossXBRuntimeException("Failed to invoke " + setValueMethodName + " on " + parent + " with parameter " + o + ": " + e.getMessage());
/*      */     }
/*      */   }
/*      */ 
/*      */   private static Method getSetMethod(Class cls, String getMethodName, String setMethodName)
/*      */   {
/*      */     Method getKeyMethod;
/*      */     try
/*      */     {
/*  895 */       getKeyMethod = cls.getMethod(getMethodName, null);
/*      */     }
/*      */     catch (NoSuchMethodException e)
/*      */     {
/*  899 */       throw new JBossXBRuntimeException("Method " + getMethodName + " not found in " + cls);
/*      */     }
/*      */     Method setKeyMethod;
/*      */     try
/*      */     {
/*  905 */       setKeyMethod = cls.getMethod(setMethodName, new Class[] { getKeyMethod.getReturnType() });
/*      */     }
/*      */     catch (NoSuchMethodException e)
/*      */     {
/*  909 */       throw new JBossXBRuntimeException("Method " + setMethodName + "(" + getKeyMethod.getReturnType().getName() + " p) not found in " + cls);
/*      */     }
/*      */ 
/*  917 */     return setKeyMethod;
/*      */   }
/*      */ 
/*      */   private static MapEntryMetaData getMapEntryMetaData(TermBinding term, QName qName)
/*      */   {
/*  922 */     MapEntryMetaData mapEntryMetaData = term.getMapEntryMetaData();
/*  923 */     if (mapEntryMetaData == null)
/*      */     {
/*      */       String msg;
/*      */       String msg;
/*  926 */       if (term.isModelGroup())
/*      */       {
/*  928 */         msg = "Term " + qName + " bound as map entry key or value but map entry metadata is not available for its parent term.";
/*      */       }
/*      */       else
/*      */       {
/*  934 */         ElementBinding element = (ElementBinding)term;
/*  935 */         msg = "Element " + qName + " bound as map entry key or value but map entry metadata is not available for its parent element nor its " + (element.getType().getQName() == null ? "annonymous" : element.getType().getQName().toString()) + " type.";
/*      */       }
/*      */ 
/*  944 */       throw new JBossXBRuntimeException(msg);
/*      */     }
/*  946 */     return mapEntryMetaData;
/*      */   }
/*      */ 
/*      */   private static Object newInstance(Class cls, QName elementName, boolean useNoArgCtorIfFound)
/*      */   {
/*      */     Object o;
/*      */     Object o;
/*  952 */     if (cls.isArray())
/*      */     {
/*  954 */       o = GenericValueContainer.FACTORY.array(cls.getComponentType());
/*      */     }
/*      */     else
/*      */     {
/*  958 */       Constructor[] ctors = cls.getConstructors();
/*  959 */       if (ctors.length == 0)
/*      */       {
/*  961 */         throw new JBossXBRuntimeException("Class " + cls.getName() + " has no public constructors or the class reflects a primitive type or void");
/*      */       }
/*      */       Object o;
/*  966 */       if (useNoArgCtorIfFound)
/*      */       {
/*      */         try
/*      */         {
/*  970 */           Constructor ctor = cls.getConstructor(null);
/*  971 */           o = ctor.newInstance(null);
/*      */         }
/*      */         catch (NoSuchMethodException e)
/*      */         {
/*  975 */           o = new ValueListInitializer().newValueList(ValueListHandler.NON_DEFAULT_CTOR, cls);
/*      */         }
/*      */         catch (Exception e)
/*      */         {
/*  979 */           throw new JBossXBRuntimeException("Failed to create an instance of " + cls + " using default constructor for element " + elementName + ": " + e.getMessage(), e);
/*      */         }
/*      */ 
/*      */       }
/*  986 */       else if ((ctors.length > 1) || (ctors[0].getParameterTypes().length > 0))
/*      */       {
/*  988 */         o = new ValueListInitializer().newValueList(ValueListHandler.NON_DEFAULT_CTOR, cls);
/*      */       }
/*      */       else
/*      */       {
/*      */         try
/*      */         {
/*  994 */           o = ctors[0].newInstance(null);
/*      */         }
/*      */         catch (Exception e)
/*      */         {
/*  998 */           throw new JBossXBRuntimeException("Failed to create an instance of " + cls + " using default constructor for element " + elementName + ": " + e.getMessage(), e);
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1006 */     return o;
/*      */   }
/*      */ 
/*      */   private static Class loadClassForTerm(String className, boolean ignoreCNFE, QName elementName)
/*      */   {
/* 1013 */     if (className == null)
/*      */     {
/* 1015 */       throw new JBossXBRuntimeException("No class for " + elementName);
/*      */     }
/*      */ 
/* 1018 */     Class cls = null;
/*      */     try
/*      */     {
/* 1021 */       cls = Thread.currentThread().getContextClassLoader().loadClass(className);
/*      */     }
/*      */     catch (ClassNotFoundException e)
/*      */     {
/* 1025 */       if (ignoreCNFE)
/*      */       {
/* 1027 */         if (log.isTraceEnabled())
/*      */         {
/* 1029 */           log.trace("Failed to resolve class for element " + elementName + ": " + className);
/*      */         }
/*      */ 
/*      */       }
/*      */       else
/*      */       {
/* 1038 */         throw new JBossXBRuntimeException("Failed to resolve class name for " + elementName + ": " + e.getMessage());
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1045 */     return cls;
/*      */   }
/*      */ 
/*      */   private void invokeAdd(QName qName, AddMethodMetaData addMethodMetaData, Object owner, Object o)
/*      */   {
/* 1050 */     Class valueType = Object.class;
/* 1051 */     if (addMethodMetaData.getValueType() != null)
/*      */     {
/*      */       try
/*      */       {
/* 1055 */         valueType = Thread.currentThread().getContextClassLoader().loadClass(addMethodMetaData.getValueType());
/*      */       }
/*      */       catch (ClassNotFoundException e)
/*      */       {
/* 1060 */         throw new JBossXBRuntimeException("Failed to load value type for addMethod.name=" + addMethodMetaData.getMethodName() + ", valueType=" + addMethodMetaData.getValueType() + ": " + e.getMessage(), e);
/*      */       }
/*      */ 
/*      */     }
/* 1068 */     else if (addMethodMetaData.isChildType())
/*      */     {
/* 1070 */       if (o == null)
/*      */       {
/* 1072 */         throw new JBossXBRuntimeException("addMethod=" + addMethodMetaData.getMethodName() + " for element " + qName + " is configured with valueType='child'. The valueType cannot be determined because" + " the child is null");
/*      */       }
/*      */ 
/* 1080 */       valueType = o.getClass();
/* 1083 */     }
/*      */ Class ownerClass = owner.getClass();
/*      */     Method addMethod;
/*      */     try {
/* 1087 */       addMethod = ownerClass.getMethod(addMethodMetaData.getMethodName(), new Class[] { valueType });
/*      */     }
/*      */     catch (NoSuchMethodException e)
/*      */     {
/* 1091 */       throw new JBossXBRuntimeException("Failed to find addMethod.name=" + addMethodMetaData.getMethodName() + ", addMethod.valueType=" + valueType.getName() + " in class " + ownerClass.getName() + ": " + e.getMessage(), e);
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/* 1104 */       addMethod.invoke(owner, new Object[] { o });
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/* 1108 */       throw new JBossXBRuntimeException("setParent failed for " + qName + "=" + o + ": addMethod=" + addMethodMetaData.getMethodName() + " threw an exception for owner=" + owner + ", value=" + o + ": " + e.getMessage(), e);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void invokePut(QName qName, TermBinding term, Object owner, Object o)
/*      */   {
/* 1127 */     PutMethodMetaData putMethodMetaData = term.getPutMethodMetaData();
/*      */ 
/* 1129 */     MapEntryMetaData mapEntryMetaData = term.getMapEntryMetaData();
/* 1130 */     if (mapEntryMetaData == null)
/*      */     {
/* 1132 */       throw new JBossXBRuntimeException((putMethodMetaData == null ? "Parent object is an instance of java.util.Map" : new StringBuilder().append("putMethod is specified for element ").append(qName).toString()) + " but mapEntry is specified for neither element " + qName + " nor it's type.");
/*      */     }
/*      */ 
/* 1142 */     Class oClass = o.getClass();
/* 1143 */     String getKeyMethodName = mapEntryMetaData.getGetKeyMethod();
/* 1144 */     if (getKeyMethodName == null)
/*      */     {
/* 1146 */       getKeyMethodName = "getKey";
/*      */     }
/*      */     Method keyMethod;
/*      */     try
/*      */     {
/* 1152 */       keyMethod = oClass.getMethod(getKeyMethodName, null);
/*      */     }
/*      */     catch (NoSuchMethodException e)
/*      */     {
/* 1156 */       throw new JBossXBRuntimeException("setParent failed for " + qName + "=" + o + ": getKeyMethod=" + getKeyMethodName + " not found in " + oClass);
/*      */     }
/*      */ 
/*      */     Object key;
/*      */     try
/*      */     {
/* 1169 */       key = keyMethod.invoke(o, null);
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/* 1173 */       throw new JBossXBRuntimeException("setParent failed for " + qName + "=" + o + ": getKeyMethod=" + getKeyMethodName + " threw an exception: " + e.getMessage(), e);
/*      */     }
/*      */ 
/* 1183 */     Class keyType = Object.class;
/* 1184 */     Class valueType = Object.class;
/* 1185 */     String putMethodName = "put";
/* 1186 */     Class ownerClass = owner.getClass();
/*      */ 
/* 1188 */     if (putMethodMetaData != null)
/*      */     {
/* 1190 */       if (putMethodMetaData.getKeyType() != null)
/*      */       {
/*      */         try
/*      */         {
/* 1194 */           keyType = Thread.currentThread().getContextClassLoader().loadClass(putMethodMetaData.getKeyType());
/*      */         }
/*      */         catch (ClassNotFoundException e)
/*      */         {
/* 1198 */           throw new JBossXBRuntimeException("setParent failed for " + qName + ": " + e.getMessage(), e);
/*      */         }
/*      */       }
/*      */ 
/* 1202 */       if (putMethodMetaData.getValueType() != null)
/*      */       {
/*      */         try
/*      */         {
/* 1206 */           valueType = Thread.currentThread().getContextClassLoader().loadClass(putMethodMetaData.getValueType());
/*      */         }
/*      */         catch (ClassNotFoundException e)
/*      */         {
/* 1210 */           throw new JBossXBRuntimeException("setParent failed for " + qName + ": " + e.getMessage(), e);
/*      */         }
/*      */       }
/*      */ 
/* 1214 */       String name = putMethodMetaData.getName();
/* 1215 */       if (name != null)
/*      */       {
/* 1217 */         putMethodName = name;
/*      */       }
/*      */     }
/*      */     Method putMethod;
/*      */     try
/*      */     {
/* 1224 */       putMethod = ownerClass.getMethod(putMethodName, new Class[] { keyType, valueType });
/*      */     }
/*      */     catch (NoSuchMethodException e)
/*      */     {
/* 1228 */       throw new JBossXBRuntimeException("setParent failed for " + qName + "=" + o + ": putMethod=" + putMethodName + "(" + keyType.getName() + " key, " + valueType.getName() + " value) not found in " + ownerClass);
/*      */     }
/*      */ 
/* 1238 */     Object value = o;
/* 1239 */     String valueMethodName = mapEntryMetaData.getGetValueMethod();
/* 1240 */     if (valueMethodName != null)
/*      */     {
/*      */       Method valueMethod;
/*      */       try {
/* 1245 */         valueMethod = oClass.getMethod(valueMethodName, null);
/*      */       }
/*      */       catch (NoSuchMethodException e)
/*      */       {
/* 1249 */         throw new JBossXBRuntimeException("setParent failed for " + qName + "=" + o + ": getValueMethod=" + mapEntryMetaData.getGetValueMethod() + " not found in " + oClass);
/*      */       }
/*      */ 
/*      */       try
/*      */       {
/* 1261 */         value = valueMethod.invoke(o, null);
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/* 1265 */         throw new JBossXBRuntimeException("setParent failed for " + qName + "=" + o + ": getValueMethod=" + mapEntryMetaData.getGetValueMethod() + " threw an exception: " + e.getMessage(), e);
/*      */       }
/*      */ 
/*      */     }
/* 1275 */     else if ((o instanceof MapEntry))
/*      */     {
/* 1277 */       value = ((MapEntry)o).getValue();
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/* 1282 */       putMethod.invoke(owner, new Object[] { key, value });
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/* 1286 */       throw new JBossXBRuntimeException("setParent failed for " + qName + "=" + o + ": putMethod=" + putMethodName + " threw an exception for owner=" + owner + ", key=" + key + ", value=" + value + ": " + e.getMessage(), e);
/*      */     }
/*      */   }
/*      */ 
/*      */   private Class classForNonArrayItem(ElementBinding element, Class parentClass)
/*      */   {
/* 1310 */     ClassMetaData clsMetaData = element.getClassMetaData();
/* 1311 */     String clsName = clsMetaData == null ? null : clsMetaData.getImpl();
/* 1312 */     if (clsName == null)
/*      */     {
/* 1314 */       MapEntryMetaData mapEntryMetaData = element.getMapEntryMetaData();
/* 1315 */       if (mapEntryMetaData != null)
/*      */       {
/* 1317 */         clsName = mapEntryMetaData.getImpl();
/* 1318 */         if (clsName == null)
/*      */         {
/* 1320 */           clsName = MapEntry.class.getName();
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1326 */     if (clsName == null)
/*      */     {
/* 1328 */       if (parentClass == null)
/*      */       {
/* 1330 */         clsName = classFromQName(element);
/*      */       }
/*      */       else
/*      */       {
/* 1334 */         PropertyMetaData propertyMetaData = element.getPropertyMetaData();
/* 1335 */         String propName = propertyMetaData == null ? null : propertyMetaData.getName();
/* 1336 */         if (propName == null)
/*      */         {
/* 1339 */           if ((element.getAddMethodMetaData() == null) && (element.getPutMethodMetaData() == null))
/*      */           {
/* 1341 */             propName = Util.xmlNameToFieldName(element.getQName().getLocalPart(), element.getSchema().isIgnoreLowLine());
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/* 1346 */         if (propName != null)
/*      */         {
/* 1348 */           FieldInfo fieldInfo = FieldInfo.getFieldInfo(parentClass, propName, false);
/* 1349 */           Class fieldType = fieldInfo == null ? null : fieldInfo.getType();
/*      */ 
/* 1351 */           if ((fieldType == null) || (Modifier.isAbstract(fieldType.getModifiers())) || (Modifier.isInterface(fieldType.getModifiers())) || (fieldType.isArray()) || (Collection.class.isAssignableFrom(fieldType)))
/*      */           {
/* 1357 */             clsName = classFromQName(element);
/*      */           }
/*      */           else
/*      */           {
/* 1361 */             return fieldType;
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/* 1367 */     return loadClassForTerm(clsName, element.getSchema().isIgnoreUnresolvedFieldOrClass(), element.getQName());
/*      */   }
/*      */ 
/*      */   private String classFromQName(ElementBinding element)
/*      */   {
/* 1373 */     QName typeBase = element.getType().getQName();
/* 1374 */     if (typeBase == null)
/*      */     {
/* 1376 */       typeBase = element.getQName();
/*      */     }
/*      */ 
/* 1379 */     SchemaBinding schema = element.getSchema();
/* 1380 */     PackageMetaData pkgMetaData = schema.getPackageMetaData();
/*      */     String clsName;
/*      */     String clsName;
/* 1381 */     if (pkgMetaData == null)
/*      */     {
/* 1383 */       clsName = Util.xmlNameToClassName(typeBase.getNamespaceURI(), typeBase.getLocalPart(), schema.isIgnoreLowLine());
/*      */     }
/*      */     else
/*      */     {
/* 1391 */       String pkg = pkgMetaData.getName();
/* 1392 */       clsName = pkg + "." + Util.xmlNameToClassName(typeBase.getLocalPart(), schema.isIgnoreLowLine());
/*      */     }
/*      */ 
/* 1397 */     return clsName;
/*      */   }
/*      */ 
/*      */   private static Class classForSimpleType(TypeBinding type, boolean nillable)
/*      */   {
/* 1402 */     ValueMetaData valueMetaData = type.getValueMetaData();
/* 1403 */     if ((valueMetaData != null) && (valueMetaData.getUnmarshalMethod() != null))
/*      */     {
/* 1405 */       return RtUtil.getUnmarshalMethod(type.getQName(), valueMetaData).getReturnType();
/*      */     }
/* 1407 */     if ((type.getClassMetaData() != null) && (type.getClassMetaData().getImpl() != null))
/*      */     {
/* 1409 */       return RtUtil.loadClass(type.getClassMetaData().getImpl(), true);
/*      */     }
/*      */ 
/* 1412 */     TypeBinding itemType = type.getItemType();
/* 1413 */     if (itemType != null)
/*      */     {
/* 1415 */       if (type.getSchemaBinding().isUnmarshalListsToArrays())
/*      */       {
/* 1418 */         Class itemClass = classForSimpleType(itemType, nillable);
/* 1419 */         return Array.newInstance(itemClass, 0).getClass();
/*      */       }
/*      */ 
/* 1423 */       return List.class;
/*      */     }
/*      */ 
/* 1428 */     QName qName = type.getQName();
/* 1429 */     if ((qName != null) && ("http://www.w3.org/2001/XMLSchema".equals(qName.getNamespaceURI())))
/*      */     {
/* 1431 */       return SimpleTypeBindings.classForType(qName.getLocalPart(), nillable);
/*      */     }
/*      */ 
/* 1435 */     TypeBinding baseType = type.getBaseType();
/* 1436 */     if (baseType == null)
/*      */     {
/* 1438 */       throw new JBossXBRuntimeException("Expected a base type here.");
/*      */     }
/*      */ 
/* 1441 */     return classForSimpleType(baseType, nillable);
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.sunday.unmarshalling.impl.runtime.RtElementHandler
 * JD-Core Version:    0.6.0
 */