/*     */ package org.jboss.xb.binding.sunday.unmarshalling.impl.runtime;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import javax.xml.namespace.NamespaceContext;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.util.Classes;
/*     */ import org.jboss.xb.binding.JBossXBRuntimeException;
/*     */ import org.jboss.xb.binding.Util;
/*     */ import org.jboss.xb.binding.metadata.CharactersMetaData;
/*     */ import org.jboss.xb.binding.metadata.ClassMetaData;
/*     */ import org.jboss.xb.binding.metadata.PropertyMetaData;
/*     */ import org.jboss.xb.binding.metadata.ValueMetaData;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.CharactersHandler;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;
/*     */ 
/*     */ public class RtCharactersHandler extends CharactersHandler
/*     */ {
/*  45 */   public static final RtCharactersHandler INSTANCE = new RtCharactersHandler();
/*     */ 
/*     */   public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData, String value)
/*     */   {
/*  53 */     Object unmarshalled = null;
/*  54 */     if (valueMetaData != null)
/*     */     {
/*  56 */       Method unmarshalMethod = RtUtil.getUnmarshalMethod(qName, valueMetaData);
/*  57 */       Object[] args = { value, unmarshalMethod.getParameterTypes().length == 1 ? new Object[] { value } : nsCtx };
/*     */ 
/*  60 */       unmarshalled = RtUtil.invokeUnmarshalMethod(unmarshalMethod, args, qName);
/*     */     }
/*     */     else
/*     */     {
/*  64 */       unmarshalled = super.unmarshal(qName, typeBinding, nsCtx, valueMetaData, value);
/*     */ 
/*  66 */       if (typeBinding.isSimple())
/*     */       {
/*  68 */         String clsName = null;
/*  69 */         boolean failIfNotFound = false;
/*  70 */         if (typeBinding.getClassMetaData() != null)
/*     */         {
/*  72 */           clsName = typeBinding.getClassMetaData().getImpl();
/*  73 */           failIfNotFound = true;
/*     */         }
/*     */         else
/*     */         {
/*  77 */           QName typeName = typeBinding.getQName();
/*  78 */           if ((typeName != null) && (!"http://www.w3.org/2001/XMLSchema".equals(typeName.getNamespaceURI())))
/*     */           {
/*  80 */             boolean ignoreLowLine = typeBinding.getSchemaBinding() != null ? typeBinding.getSchemaBinding().isIgnoreLowLine() : true;
/*     */ 
/*  83 */             clsName = Util.xmlNameToClassName(typeName.getNamespaceURI(), typeName.getLocalPart(), ignoreLowLine);
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/*  88 */         Class cls = clsName == null ? null : RtUtil.loadClass(clsName, failIfNotFound);
/*  89 */         if ((cls != null) && (!cls.isPrimitive()))
/*     */         {
/*  94 */           if (cls.getConstructors().length == 0)
/*     */           {
/*  96 */             Class valueType = unmarshalled.getClass();
/*     */ 
/*  98 */             if (Classes.isPrimitiveWrapper(valueType))
/*     */             {
/* 100 */               valueType = Classes.getPrimitive(valueType);
/*     */             }
/*     */ 
/* 104 */             unmarshalled = unmarshalled == null ? null : RtUtil.invokeUnmarshalMethod(cls, "fromValue", unmarshalled, valueType, nsCtx, qName);
/*     */           }
/*     */           else
/*     */           {
/* 109 */             throw new JBossXBRuntimeException("This case is not yet supported (create a feature request): simple type (" + typeBinding.getQName() + ") is bound to a class (" + cls + ") with optional property metadata with " + "default value for the property name 'value'.");
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 122 */     return unmarshalled;
/*     */   }
/*     */ 
/*     */   public void setValue(QName qName, ElementBinding element, Object owner, Object value)
/*     */   {
/* 129 */     if (owner == null)
/*     */     {
/* 131 */       return;
/*     */     }
/*     */ 
/* 134 */     if ((owner instanceof MapEntry))
/*     */     {
/* 136 */       TypeBinding type = element.getType();
/* 137 */       CharactersMetaData characters = type.getCharactersMetaData();
/* 138 */       if (characters != null)
/*     */       {
/* 140 */         if (characters.isMapEntryKey())
/*     */         {
/* 142 */           ((MapEntry)owner).setKey(value);
/*     */         }
/* 144 */         else if (characters.isMapEntryValue())
/*     */         {
/* 146 */           ((MapEntry)owner).setValue(value);
/*     */         }
/*     */         else
/*     */         {
/* 150 */           throw new JBossXBRuntimeException("Parent object is a map entry but characters of element " + qName + " of type " + type.getQName() + " were bound to niether key nor value in a map entry.");
/*     */         }
/*     */ 
/*     */       }
/*     */       else
/*     */       {
/* 156 */         throw new JBossXBRuntimeException("Parent object is a map entry but characters of element " + qName + " of type " + type.getQName() + " were bound to niether key nor value in a map entry.");
/*     */       }
/*     */ 
/*     */     }
/*     */     else
/*     */     {
/* 162 */       String propName = null;
/* 163 */       String colType = null;
/* 164 */       TypeBinding type = element.getType();
/* 165 */       if ((type != null) && (!type.isSimple()))
/*     */       {
/* 167 */         PropertyMetaData propertyMetaData = type.getPropertyMetaData();
/* 168 */         if (propertyMetaData == null)
/*     */         {
/* 170 */           CharactersMetaData charactersMetaData = type.getCharactersMetaData();
/* 171 */           propertyMetaData = charactersMetaData == null ? null : charactersMetaData.getProperty();
/*     */         }
/*     */ 
/* 174 */         if (propertyMetaData != null)
/*     */         {
/* 176 */           propName = propertyMetaData.getName();
/* 177 */           colType = propertyMetaData.getCollectionType();
/*     */         }
/*     */ 
/* 180 */         if (propName == null)
/*     */         {
/* 182 */           propName = type.getSchemaBinding().getSimpleContentProperty();
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 187 */         PropertyMetaData PropertyMetaData = element.getPropertyMetaData();
/* 188 */         if (PropertyMetaData != null)
/*     */         {
/* 190 */           propName = PropertyMetaData.getName();
/* 191 */           colType = PropertyMetaData.getCollectionType();
/*     */         }
/*     */ 
/* 194 */         if (propName == null)
/*     */         {
/* 196 */           propName = Util.xmlNameToFieldName(qName.getLocalPart(), element.getSchema().isIgnoreLowLine());
/*     */         }
/*     */       }
/*     */ 
/* 200 */       RtUtil.set(owner, value, propName, colType, element.getSchema().isIgnoreUnresolvedFieldOrClass(), element.getValueAdapter());
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.sunday.unmarshalling.impl.runtime.RtCharactersHandler
 * JD-Core Version:    0.6.0
 */