/*    */ package org.jboss.xb.binding.sunday.unmarshalling.impl.runtime;
/*    */ 
/*    */ import javax.xml.namespace.QName;
/*    */ import org.jboss.xb.binding.GenericValueContainer;
/*    */ import org.jboss.xb.binding.JBossXBRuntimeException;
/*    */ import org.jboss.xb.binding.Util;
/*    */ import org.jboss.xb.binding.group.ValueList;
/*    */ import org.jboss.xb.binding.group.ValueListInitializer;
/*    */ import org.jboss.xb.binding.metadata.PropertyMetaData;
/*    */ import org.jboss.xb.binding.sunday.unmarshalling.AttributeBinding;
/*    */ import org.jboss.xb.binding.sunday.unmarshalling.AttributeHandler;
/*    */ import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
/*    */ 
/*    */ public class RtAttributeHandler extends AttributeHandler
/*    */ {
/* 41 */   public static final RtAttributeHandler INSTANCE = new RtAttributeHandler();
/*    */ 
/*    */   public void attribute(QName elemName, QName attrName, AttributeBinding binding, Object owner, Object value)
/*    */   {
/* 45 */     if ((owner instanceof MapEntry))
/*    */     {
/* 47 */       if (binding.isMapEntryKey())
/*    */       {
/* 49 */         ((MapEntry)owner).setKey(value);
/*    */       }
/* 51 */       else if (binding.isMapEntryValue())
/*    */       {
/* 53 */         ((MapEntry)owner).setValue(value);
/*    */       }
/*    */       else
/*    */       {
/* 57 */         throw new JBossXBRuntimeException("Parent object is a map entry but attribute " + attrName + " in element " + elemName + " bound to neither key nor value in a map entry.");
/*    */       }
/*    */ 
/*    */     }
/* 66 */     else if ((owner instanceof GenericValueContainer))
/*    */     {
/* 68 */       ((GenericValueContainer)owner).addChild(attrName, value);
/*    */     }
/* 70 */     else if ((owner instanceof ValueList))
/*    */     {
/* 72 */       ValueList valueList = (ValueList)owner;
/* 73 */       valueList.getInitializer().addAttributeValue(attrName, binding, valueList, value);
/*    */     }
/*    */     else
/*    */     {
/* 77 */       String property = null;
/* 78 */       PropertyMetaData propertyMetaData = binding.getPropertyMetaData();
/* 79 */       if (propertyMetaData != null)
/*    */       {
/* 81 */         property = propertyMetaData.getName();
/*    */       }
/*    */ 
/* 84 */       if (property == null)
/*    */       {
/* 86 */         property = Util.xmlNameToFieldName(attrName.getLocalPart(), binding.getSchema().isIgnoreLowLine());
/*    */       }
/*    */ 
/* 89 */       RtUtil.set(owner, value, property, null, binding.getSchema().isIgnoreUnresolvedFieldOrClass(), binding.getValueAdapter());
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.sunday.unmarshalling.impl.runtime.RtAttributeHandler
 * JD-Core Version:    0.6.0
 */