/*      */ package org.jboss.xb.binding.sunday.unmarshalling;
/*      */ 
/*      */ import java.io.InputStream;
/*      */ import java.io.Reader;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Collection;
/*      */ import java.util.Collections;
/*      */ import java.util.HashMap;
/*      */ import java.util.LinkedHashSet;
/*      */ import java.util.List;
/*      */ import java.util.ListIterator;
/*      */ import java.util.Map;
/*      */ import java.util.Set;
/*      */ import javax.xml.namespace.QName;
/*      */ import org.apache.xerces.xs.StringList;
/*      */ import org.apache.xerces.xs.XSAnnotation;
/*      */ import org.apache.xerces.xs.XSAttributeDeclaration;
/*      */ import org.apache.xerces.xs.XSAttributeUse;
/*      */ import org.apache.xerces.xs.XSComplexTypeDefinition;
/*      */ import org.apache.xerces.xs.XSElementDeclaration;
/*      */ import org.apache.xerces.xs.XSModel;
/*      */ import org.apache.xerces.xs.XSModelGroup;
/*      */ import org.apache.xerces.xs.XSModelGroupDefinition;
/*      */ import org.apache.xerces.xs.XSNamedMap;
/*      */ import org.apache.xerces.xs.XSObjectList;
/*      */ import org.apache.xerces.xs.XSParticle;
/*      */ import org.apache.xerces.xs.XSSimpleTypeDefinition;
/*      */ import org.apache.xerces.xs.XSTerm;
/*      */ import org.apache.xerces.xs.XSTypeDefinition;
/*      */ import org.apache.xerces.xs.XSWildcard;
/*      */ import org.jboss.logging.Logger;
/*      */ import org.jboss.xb.binding.Constants;
/*      */ import org.jboss.xb.binding.JBossXBRuntimeException;
/*      */ import org.jboss.xb.binding.Util;
/*      */ import org.jboss.xb.binding.metadata.AddMethodMetaData;
/*      */ import org.jboss.xb.binding.metadata.CharactersMetaData;
/*      */ import org.jboss.xb.binding.metadata.ClassMetaData;
/*      */ import org.jboss.xb.binding.metadata.MapEntryMetaData;
/*      */ import org.jboss.xb.binding.metadata.PackageMetaData;
/*      */ import org.jboss.xb.binding.metadata.PropertyMetaData;
/*      */ import org.jboss.xb.binding.metadata.PutMethodMetaData;
/*      */ import org.jboss.xb.binding.metadata.SchemaMetaData;
/*      */ import org.jboss.xb.binding.metadata.ValueMetaData;
/*      */ import org.jboss.xb.binding.metadata.XsdAnnotation;
/*      */ import org.jboss.xb.binding.metadata.XsdAppInfo;
/*      */ import org.jboss.xb.binding.sunday.xop.XOPIncludeHandler;
/*      */ 
/*      */ public class XsdBinder
/*      */ {
/*   77 */   static final Logger log = Logger.getLogger(XsdBinder.class);
/*      */ 
/*  298 */   private boolean processAnnotations = true;
/*      */   private SchemaBindingResolver resolver;
/*  300 */   private boolean simpleContentWithIdAsSimpleType = true;
/*  301 */   private boolean unresolvedContentBoundToDOM = true;
/*      */ 
/*  305 */   private boolean trace = log.isTraceEnabled();
/*      */   private final SchemaBinding schema;
/*  307 */   private SharedElements sharedElements = new SharedElements(null);
/*  308 */   private final List typeGroupStack = new ArrayList();
/*      */ 
/*      */   public static XsdBinder newInstance()
/*      */   {
/*   87 */     return new XsdBinder();
/*      */   }
/*      */ 
/*      */   public static SchemaBinding bind(String xsdUrl)
/*      */   {
/*   98 */     DefaultSchemaResolver resolver = new DefaultSchemaResolver();
/*   99 */     resolver.setBaseURI(xsdUrl);
/*  100 */     return bind(xsdUrl, resolver);
/*      */   }
/*      */ 
/*      */   public static SchemaBinding bind(String xsdUrl, SchemaBindingResolver resolver)
/*      */   {
/*  113 */     XSModel model = Util.loadSchema(xsdUrl, resolver);
/*  114 */     return bind(model, resolver);
/*      */   }
/*      */ 
/*      */   public static SchemaBinding bind(InputStream xsdStream, String encoding)
/*      */   {
/*  119 */     return bind(xsdStream, encoding, new DefaultSchemaResolver());
/*      */   }
/*      */ 
/*      */   public static SchemaBinding bind(InputStream xsdStream, String encoding, String baseURI)
/*      */   {
/*  131 */     return bind(xsdStream, encoding, baseURI, true);
/*      */   }
/*      */ 
/*      */   public static SchemaBinding bind(InputStream xsdStream, String encoding, String baseURI, boolean processAnnotations)
/*      */   {
/*  144 */     DefaultSchemaResolver resolver = new DefaultSchemaResolver();
/*  145 */     resolver.setBaseURI(baseURI);
/*  146 */     return bind(xsdStream, encoding, resolver, processAnnotations);
/*      */   }
/*      */ 
/*      */   public static SchemaBinding bind(InputStream xsdStream, String encoding, SchemaBindingResolver resolver)
/*      */   {
/*  160 */     return bind(xsdStream, encoding, resolver, true);
/*      */   }
/*      */ 
/*      */   public static SchemaBinding bind(InputStream xsdStream, String encoding, SchemaBindingResolver resolver, boolean processAnnotations)
/*      */   {
/*  175 */     XSModel model = Util.loadSchema(xsdStream, encoding, resolver);
/*  176 */     return bind(model, resolver, processAnnotations);
/*      */   }
/*      */ 
/*      */   public static SchemaBinding bind(Reader xsdReader, String encoding)
/*      */   {
/*  181 */     return bind(xsdReader, encoding, new DefaultSchemaResolver());
/*      */   }
/*      */ 
/*      */   public static SchemaBinding bind(Reader xsdReader, String encoding, String baseURI)
/*      */   {
/*  193 */     DefaultSchemaResolver resolver = new DefaultSchemaResolver();
/*  194 */     resolver.setBaseURI(baseURI);
/*  195 */     return bind(xsdReader, encoding, resolver);
/*      */   }
/*      */ 
/*      */   public static SchemaBinding bind(Reader xsdReader, String encoding, SchemaBindingResolver resolver)
/*      */   {
/*  209 */     XSModel model = Util.loadSchema(xsdReader, encoding, resolver);
/*  210 */     return bind(model, resolver);
/*      */   }
/*      */ 
/*      */   public static SchemaBinding bind(String xsd, String encoding)
/*      */   {
/*  222 */     return bind(xsd, encoding, new DefaultSchemaResolver());
/*      */   }
/*      */ 
/*      */   public static SchemaBinding bind(String xsd, String encoding, SchemaBindingResolver resolver)
/*      */   {
/*  236 */     XSModel model = Util.loadSchema(xsd, encoding);
/*  237 */     return bind(model, resolver);
/*      */   }
/*      */ 
/*      */   public static SchemaBinding bind(XSModel model, SchemaBindingResolver resolver)
/*      */   {
/*  242 */     return bind(model, resolver, true);
/*      */   }
/*      */ 
/*      */   public static SchemaBinding bind(XSModel model, SchemaBindingResolver resolver, boolean processAnnotations)
/*      */   {
/*  247 */     XsdBinder binder = new XsdBinder();
/*  248 */     binder.setProcessAnnotations(processAnnotations);
/*  249 */     binder.setSchemaResolver(resolver);
/*  250 */     return binder.parse(model);
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public static void bindType(SchemaBinding schema, XSTypeDefinition type)
/*      */   {
/*  264 */     XsdBinder binder = new XsdBinder(schema);
/*  265 */     TypeBinding typeBinding = binder.bindType(type);
/*  266 */     schema.addType(typeBinding);
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public static void bindElement(SchemaBinding schema, XSElementDeclaration element, int minOccurs, int maxOccurs, boolean maxOccursUnbounded)
/*      */   {
/*  287 */     XsdBinder binder = new XsdBinder(schema);
/*  288 */     ParticleBinding particle = binder.bindElement(element, minOccurs, maxOccurs, maxOccursUnbounded);
/*      */ 
/*  293 */     schema.addElementParticle(particle);
/*      */   }
/*      */ 
/*      */   private XsdBinder()
/*      */   {
/*  314 */     this(new SchemaBinding());
/*      */   }
/*      */ 
/*      */   private XsdBinder(SchemaBinding schema)
/*      */   {
/*  319 */     this.schema = schema;
/*      */   }
/*      */ 
/*      */   public void setProcessAnnotations(boolean processAnnotations)
/*      */   {
/*  326 */     this.processAnnotations = processAnnotations;
/*      */   }
/*      */ 
/*      */   public boolean isProcessAnnotations()
/*      */   {
/*  331 */     return this.processAnnotations;
/*      */   }
/*      */ 
/*      */   public void setSchemaResolver(SchemaBindingResolver resolver)
/*      */   {
/*  336 */     this.resolver = resolver;
/*      */   }
/*      */ 
/*      */   public SchemaBindingResolver getSchemaResolver()
/*      */   {
/*  341 */     return this.resolver;
/*      */   }
/*      */ 
/*      */   public void setSimpleContentWithIdAsSimpleType(boolean simpleContentWithIdAsSimpleType)
/*      */   {
/*  346 */     this.simpleContentWithIdAsSimpleType = simpleContentWithIdAsSimpleType;
/*      */   }
/*      */ 
/*      */   public boolean isSimpleContentWithIdAsSimpleType()
/*      */   {
/*  351 */     return this.simpleContentWithIdAsSimpleType;
/*      */   }
/*      */ 
/*      */   public void setUnresolvedContentBoundToDOM(boolean toDOM)
/*      */   {
/*  356 */     this.unresolvedContentBoundToDOM = toDOM;
/*      */   }
/*      */ 
/*      */   public boolean isUnresolvedContentBoundToDOM()
/*      */   {
/*  361 */     return this.unresolvedContentBoundToDOM;
/*      */   }
/*      */ 
/*      */   public SchemaBinding parse(String xsdUrl)
/*      */   {
/*  366 */     if (this.resolver == null)
/*      */     {
/*  368 */       this.resolver = new DefaultSchemaResolver();
/*      */     }
/*      */ 
/*  371 */     XSModel model = Util.loadSchema(xsdUrl, this.resolver);
/*  372 */     return parse(model);
/*      */   }
/*      */ 
/*      */   public SchemaBinding parse(InputStream xsdStream, String encoding)
/*      */   {
/*  377 */     if (this.resolver == null)
/*      */     {
/*  379 */       this.resolver = new DefaultSchemaResolver();
/*      */     }
/*      */ 
/*  382 */     XSModel model = Util.loadSchema(xsdStream, encoding, this.resolver);
/*  383 */     return parse(model);
/*      */   }
/*      */ 
/*      */   public SchemaBinding parse(Reader xsdReader, String encoding)
/*      */   {
/*  388 */     if (this.resolver == null)
/*      */     {
/*  390 */       this.resolver = new DefaultSchemaResolver();
/*      */     }
/*      */ 
/*  393 */     XSModel model = Util.loadSchema(xsdReader, encoding, this.resolver);
/*  394 */     return parse(model);
/*      */   }
/*      */ 
/*      */   private SchemaBinding parse(XSModel model)
/*      */   {
/*  402 */     this.schema.setSchemaResolver(this.resolver);
/*      */ 
/*  405 */     if (this.processAnnotations)
/*      */     {
/*  407 */       XSObjectList annotations = model.getAnnotations();
/*  408 */       if (this.trace)
/*      */       {
/*  410 */         log.trace("started binding schema " + this.schema);
/*  411 */         log.trace("Schema annotations: " + annotations.getLength());
/*      */       }
/*      */ 
/*  414 */       for (int i = 0; i < annotations.getLength(); i++)
/*      */       {
/*  416 */         XSAnnotation annotation = (XSAnnotation)annotations.item(i);
/*  417 */         XsdAnnotation an = XsdAnnotation.unmarshal(annotation.getAnnotationString());
/*  418 */         XsdAppInfo appinfo = an.getAppInfo();
/*  419 */         if (appinfo == null)
/*      */           continue;
/*  421 */         SchemaMetaData schemaBindings = appinfo.getSchemaMetaData();
/*  422 */         if (schemaBindings == null) {
/*      */           continue;
/*      */         }
/*  425 */         this.schema.setIgnoreUnresolvedFieldOrClass(schemaBindings.isIgnoreUnresolvedFieldOrClass());
/*      */ 
/*  427 */         this.schema.setReplacePropertyRefs(schemaBindings.isReplacePropertyRefs());
/*      */ 
/*  429 */         PackageMetaData packageMetaData = schemaBindings.getPackage();
/*  430 */         if (packageMetaData == null)
/*      */           continue;
/*  432 */         if (this.trace)
/*  433 */           log.trace("schema default package: " + packageMetaData.getName());
/*  434 */         this.schema.setPackageMetaData(packageMetaData);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  441 */     StringList namespaceList = model.getNamespaces();
/*  442 */     Set namespaces = new LinkedHashSet(namespaceList.getLength());
/*  443 */     for (int i = 0; i < namespaceList.getLength(); i++)
/*  444 */       namespaces.add(namespaceList.item(i));
/*  445 */     this.schema.setNamespaces(namespaces);
/*      */ 
/*  447 */     XSNamedMap groups = model.getComponents(6);
/*  448 */     if (this.trace) {
/*  449 */       log.trace("Model groups: " + groups.getLength());
/*      */     }
/*  451 */     for (int i = 0; i < groups.getLength(); i++)
/*      */     {
/*  453 */       XSModelGroupDefinition groupDef = (XSModelGroupDefinition)groups.item(i);
/*  454 */       bindGlobalGroup(groupDef);
/*      */     }
/*      */ 
/*  457 */     for (int i = 0; i < groups.getLength(); i++)
/*      */     {
/*  459 */       XSModelGroupDefinition groupDef = (XSModelGroupDefinition)groups.item(i);
/*  460 */       bindGlobalGroupParticles(groupDef.getModelGroup());
/*      */     }
/*      */ 
/*  463 */     XSNamedMap types = model.getComponents(3);
/*  464 */     if (this.trace)
/*  465 */       log.trace("Model types: " + types.getLength());
/*  466 */     for (int i = 0; i < types.getLength(); i++)
/*      */     {
/*  468 */       XSTypeDefinition type = (XSTypeDefinition)types.item(i);
/*  469 */       if ("http://www.w3.org/2001/XMLSchema".equals(type.getNamespace()))
/*      */         continue;
/*  471 */       bindType(type);
/*      */     }
/*      */ 
/*  475 */     XSNamedMap elements = model.getComponents(2);
/*  476 */     if (this.trace)
/*  477 */       log.trace("Model elements: " + types.getLength());
/*  478 */     for (int i = 0; i < elements.getLength(); i++)
/*      */     {
/*  480 */       XSElementDeclaration element = (XSElementDeclaration)elements.item(i);
/*  481 */       bindElement(element, 1, 0, false);
/*      */     }
/*      */ 
/*  484 */     if (this.unresolvedContentBoundToDOM)
/*      */     {
/*  486 */       this.schema.setUnresolvedContentBoundToDOM(this.unresolvedContentBoundToDOM);
/*      */     }
/*      */ 
/*  489 */     if (this.trace)
/*      */     {
/*  491 */       log.trace("finished binding schema " + this.schema);
/*      */     }
/*      */ 
/*  494 */     return this.schema;
/*      */   }
/*      */ 
/*      */   private TypeBinding bindType(XSTypeDefinition type)
/*      */   {
/*      */     TypeBinding binding;
/*  502 */     switch (type.getTypeCategory())
/*      */     {
/*      */     case 16:
/*  505 */       binding = bindSimpleType((XSSimpleTypeDefinition)type);
/*  506 */       break;
/*      */     case 15:
/*  508 */       binding = bindComplexType((XSComplexTypeDefinition)type);
/*  509 */       break;
/*      */     default:
/*  511 */       throw new JBossXBRuntimeException("Unexpected type category: " + type.getTypeCategory());
/*      */     }
/*  513 */     return binding;
/*      */   }
/*      */ 
/*      */   private TypeBinding bindSimpleType(XSSimpleTypeDefinition type)
/*      */   {
/*  518 */     QName typeName = type.getName() == null ? null : new QName(type.getNamespace(), type.getName());
/*  519 */     TypeBinding binding = typeName == null ? null : this.schema.getType(typeName);
/*  520 */     if (binding != null)
/*      */     {
/*  522 */       return binding;
/*      */     }
/*      */ 
/*  525 */     if (this.trace)
/*      */     {
/*  527 */       log.trace("binding simple type " + typeName);
/*      */     }
/*      */ 
/*  530 */     XSTypeDefinition baseTypeDef = type.getBaseType();
/*  531 */     TypeBinding baseType = baseTypeDef == null ? null : bindType(baseTypeDef);
/*      */ 
/*  533 */     binding = baseType == null ? new TypeBinding(typeName) : new TypeBinding(typeName, baseType);
/*      */ 
/*  535 */     StringList strList = type.getLexicalPattern();
/*  536 */     if ((strList != null) && (strList.getLength() > 0))
/*      */     {
/*  538 */       for (int i = 0; i < strList.getLength(); i++)
/*      */       {
/*  540 */         binding.addLexicalPattern(strList.item(i));
/*      */       }
/*      */     }
/*      */ 
/*  544 */     strList = type.getLexicalEnumeration();
/*  545 */     if ((strList != null) && (strList.getLength() > 0))
/*      */     {
/*  547 */       for (int i = 0; i < strList.getLength(); i++)
/*      */       {
/*  549 */         binding.addEnumValue(strList.item(i));
/*      */       }
/*      */     }
/*      */ 
/*  553 */     if (type.getItemType() != null)
/*      */     {
/*  555 */       TypeBinding itemType = bindSimpleType(type.getItemType());
/*  556 */       binding.setItemType(itemType);
/*      */     }
/*      */ 
/*  559 */     if (typeName != null)
/*      */     {
/*  561 */       this.schema.addType(binding);
/*      */     }
/*      */ 
/*  564 */     if (this.trace)
/*      */     {
/*  566 */       String msg = "bound simple type " + typeName;
/*  567 */       if (baseType != null)
/*      */       {
/*  569 */         msg = msg + " inherited binding metadata from " + baseType.getQName();
/*      */       }
/*  571 */       log.trace(msg);
/*      */     }
/*      */ 
/*  575 */     if (this.processAnnotations)
/*      */     {
/*  577 */       XSObjectList annotations = type.getAnnotations();
/*  578 */       if (annotations != null)
/*      */       {
/*  580 */         if (this.trace)
/*      */         {
/*  582 */           log.trace(typeName + " annotations " + annotations.getLength());
/*      */         }
/*  584 */         for (int i = 0; i < annotations.getLength(); i++)
/*      */         {
/*  586 */           XSAnnotation an = (XSAnnotation)annotations.item(i);
/*  587 */           XsdAnnotation xsdAn = XsdAnnotation.unmarshal(an.getAnnotationString());
/*  588 */           XsdAppInfo appInfo = xsdAn.getAppInfo();
/*  589 */           if (appInfo == null)
/*      */             continue;
/*  591 */           ClassMetaData classMetaData = appInfo.getClassMetaData();
/*  592 */           if (classMetaData != null)
/*      */           {
/*  594 */             if (this.trace)
/*      */             {
/*  596 */               log.trace("simple type " + type.getName() + ": impl=" + classMetaData.getImpl());
/*      */             }
/*      */ 
/*  601 */             binding.setClassMetaData(classMetaData);
/*      */           }
/*      */ 
/*  604 */           ValueMetaData valueMetaData = appInfo.getValueMetaData();
/*  605 */           if (valueMetaData == null)
/*      */             continue;
/*  607 */           if (this.trace)
/*      */           {
/*  609 */             log.trace("simple type " + type.getName() + ": unmarshalMethod=" + valueMetaData.getUnmarshalMethod() + ", marshalMethod=" + valueMetaData.getMarshalMethod());
/*      */           }
/*      */ 
/*  616 */           binding.setValueMetaData(valueMetaData);
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  623 */     binding.setSchemaBinding(this.schema);
/*      */ 
/*  625 */     return binding;
/*      */   }
/*      */ 
/*      */   private TypeBinding bindComplexType(XSComplexTypeDefinition type)
/*      */   {
/*  630 */     QName typeName = type.getName() == null ? null : new QName(type.getNamespace(), type.getName());
/*  631 */     TypeBinding binding = typeName == null ? null : this.schema.getType(typeName);
/*  632 */     if (binding != null)
/*      */     {
/*  634 */       return binding;
/*      */     }
/*      */ 
/*  637 */     XSTypeDefinition baseTypeDef = type.getBaseType();
/*      */ 
/*  639 */     TypeBinding baseType = null;
/*  640 */     if ((baseTypeDef != null) && (!Constants.QNAME_ANYTYPE.equals(typeName)))
/*      */     {
/*  642 */       baseType = bindType(baseTypeDef);
/*      */ 
/*  645 */       if (typeName != null)
/*      */       {
/*  647 */         binding = this.schema.getType(typeName);
/*  648 */         if (binding != null)
/*      */         {
/*  650 */           return binding;
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  655 */     if (this.trace) {
/*  656 */       log.trace("binding complex " + (typeName == null ? "anonymous type" : new StringBuilder().append("type ").append(typeName).toString()));
/*      */     }
/*  658 */     binding = new TypeBinding(typeName);
/*  659 */     binding.setBaseType(baseType);
/*  660 */     binding.setSimple(false);
/*      */ 
/*  662 */     if (type.getSimpleType() != null)
/*      */     {
/*  664 */       TypeBinding simpleType = bindSimpleType(type.getSimpleType());
/*  665 */       binding.setSimpleType(simpleType);
/*      */     }
/*  667 */     else if (type.getContentType() == 3)
/*      */     {
/*  669 */       TypeBinding stringType = this.schema.getType(Constants.QNAME_STRING);
/*  670 */       if (stringType == null)
/*      */       {
/*  672 */         throw new JBossXBRuntimeException("xsd:string has not been bound yet!");
/*      */       }
/*  674 */       binding.setSimpleType(stringType);
/*      */     }
/*      */ 
/*  677 */     if (typeName != null)
/*      */     {
/*  679 */       this.schema.addType(binding);
/*      */     }
/*      */ 
/*  682 */     binding.setSchemaBinding(this.schema);
/*      */ 
/*  684 */     XSObjectList attrs = type.getAttributeUses();
/*  685 */     if (this.trace) {
/*  686 */       log.trace(typeName + " attributes " + attrs.getLength());
/*      */     }
/*  688 */     AttributeBinding attrBinding = null;
/*  689 */     boolean hasOnlyIdAttrs = true;
/*  690 */     for (int i = 0; i < attrs.getLength(); i++)
/*      */     {
/*  692 */       XSAttributeUse attr = (XSAttributeUse)attrs.item(i);
/*  693 */       attrBinding = bindAttribute(attr);
/*  694 */       binding.addAttribute(attrBinding);
/*  695 */       if ((!hasOnlyIdAttrs) || (Constants.QNAME_ID.equals(attrBinding.getType().getQName())))
/*      */         continue;
/*  697 */       hasOnlyIdAttrs = false;
/*      */     }
/*      */ 
/*  702 */     if (this.processAnnotations)
/*      */     {
/*  704 */       XSObjectList annotations = type.getAnnotations();
/*  705 */       if (annotations != null)
/*      */       {
/*  707 */         if (this.trace)
/*  708 */           log.trace(typeName + " annotations " + annotations.getLength());
/*  709 */         for (int i = 0; i < annotations.getLength(); i++)
/*      */         {
/*  711 */           XSAnnotation an = (XSAnnotation)annotations.item(i);
/*  712 */           XsdAnnotation xsdAn = XsdAnnotation.unmarshal(an.getAnnotationString());
/*  713 */           XsdAppInfo appInfo = xsdAn.getAppInfo();
/*  714 */           if (appInfo == null)
/*      */             continue;
/*  716 */           ClassMetaData classMetaData = appInfo.getClassMetaData();
/*  717 */           if (classMetaData != null)
/*      */           {
/*  719 */             if (this.trace)
/*      */             {
/*  721 */               log.trace("complex type " + type.getName() + ": impl=" + classMetaData.getImpl());
/*      */             }
/*      */ 
/*  727 */             binding.setClassMetaData(classMetaData);
/*      */           }
/*      */ 
/*  730 */           CharactersMetaData charactersMetaData = appInfo.getCharactersMetaData();
/*  731 */           if (charactersMetaData != null)
/*      */           {
/*  733 */             if (this.trace)
/*      */             {
/*  735 */               PropertyMetaData propertyMetaData = charactersMetaData.getProperty();
/*  736 */               if (propertyMetaData != null)
/*      */               {
/*  738 */                 log.trace("complex type " + type.getName() + ": characters bound to " + propertyMetaData.getName());
/*      */               }
/*      */ 
/*  744 */               ValueMetaData valueMetaData = charactersMetaData.getValue();
/*  745 */               if (valueMetaData != null)
/*      */               {
/*  747 */                 log.trace("complex type " + type.getName() + ": characters unmarshalMethod=" + valueMetaData.getUnmarshalMethod() + ", marshalMethod=" + valueMetaData.getMarshalMethod());
/*      */               }
/*      */ 
/*  755 */               boolean mapEntryKey = appInfo.isMapEntryKey();
/*  756 */               if (mapEntryKey)
/*      */               {
/*  758 */                 log.trace("complex type " + type.getName() + ": characters are bound as a key in a map entry");
/*      */               }
/*      */ 
/*  764 */               boolean mapEntryValue = appInfo.isMapEntryValue();
/*  765 */               if (mapEntryValue)
/*      */               {
/*  767 */                 log.trace("complex type " + type.getName() + ": characters are bound as a value in a map entry");
/*      */               }
/*      */ 
/*      */             }
/*      */ 
/*  773 */             binding.setCharactersMetaData(charactersMetaData);
/*      */           }
/*      */ 
/*  776 */           MapEntryMetaData mapEntryMetaData = appInfo.getMapEntryMetaData();
/*  777 */           if (mapEntryMetaData != null)
/*      */           {
/*  779 */             if (this.trace)
/*      */             {
/*  781 */               log.trace("complex type " + type.getName() + " is bound to a map entry: impl=" + mapEntryMetaData.getImpl() + ", getKeyMethod=" + mapEntryMetaData.getGetKeyMethod() + ", setKeyMethod=" + mapEntryMetaData.getSetKeyMethod() + ", getValueMethod=" + mapEntryMetaData.getGetValueMethod() + ", setValueMethod=" + mapEntryMetaData.getSetValueMethod() + ", valueType=" + mapEntryMetaData.getValueType() + ", nonNullValue=" + mapEntryMetaData.isNonNullValue());
/*      */             }
/*      */ 
/*  799 */             if (classMetaData != null)
/*      */             {
/*  801 */               throw new JBossXBRuntimeException("Illegal binding: both jbxb:class and jbxb:mapEntry are specified for complex type " + type.getName());
/*      */             }
/*      */ 
/*  805 */             binding.setMapEntryMetaData(mapEntryMetaData);
/*      */           }
/*      */ 
/*  808 */           boolean skip = appInfo.isSkip();
/*  809 */           if (skip)
/*      */           {
/*  811 */             if (this.trace)
/*      */             {
/*  813 */               log.trace("complex type " + type.getName() + ": elements of this type will be skipped; their attrs, character content " + "and elements will be set the parent.");
/*      */             }
/*      */ 
/*  819 */             binding.setSkip(skip);
/*      */           }
/*      */ 
/*  822 */           PropertyMetaData propertyMetaData = appInfo.getPropertyMetaData();
/*  823 */           if (propertyMetaData != null)
/*      */           {
/*  825 */             if (this.trace)
/*      */             {
/*  827 */               log.trace("complex type " + type.getName() + ": the content of elements of this type is bound to property " + propertyMetaData.getName());
/*      */             }
/*      */ 
/*  832 */             binding.setPropertyMetaData(propertyMetaData);
/*      */           }
/*      */ 
/*  835 */           AddMethodMetaData addMethodMetaData = appInfo.getAddMethodMetaData();
/*  836 */           if (addMethodMetaData == null)
/*      */             continue;
/*  838 */           if (this.trace)
/*      */           {
/*  840 */             log.trace("complex type " + type.getName() + ": elements of this type will be added to parent objects with addMethod=" + addMethodMetaData.getMethodName() + ", valueType=" + addMethodMetaData.getValueType());
/*      */           }
/*      */ 
/*  846 */           binding.setAddMethodMetaData(addMethodMetaData);
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  853 */     XSParticle particle = type.getParticle();
/*  854 */     if (particle != null)
/*      */     {
/*  856 */       pushType(binding);
/*  857 */       bindParticle(particle);
/*  858 */       popType();
/*      */     }
/*      */ 
/*  861 */     if ((binding.getClassMetaData() == null) && (this.simpleContentWithIdAsSimpleType) && (particle == null) && (hasOnlyIdAttrs))
/*      */     {
/*  865 */       binding.setStartElementCreatesObject(false);
/*      */     }
/*      */     else
/*      */     {
/*  869 */       binding.setStartElementCreatesObject(true);
/*      */     }
/*      */ 
/*  872 */     if (binding.hasOnlyXmlMimeAttributes())
/*      */     {
/*  874 */       addXOPInclude(binding, this.schema);
/*      */     }
/*      */ 
/*  877 */     if (this.trace)
/*      */     {
/*  879 */       log.trace("bound complex type " + typeName);
/*      */     }
/*      */ 
/*  882 */     return binding;
/*      */   }
/*      */ 
/*      */   private AttributeBinding bindAttribute(XSAttributeUse attrUse)
/*      */   {
/*  887 */     XSAttributeDeclaration attr = attrUse.getAttrDeclaration();
/*  888 */     QName attrName = new QName(attr.getNamespace(), attr.getName());
/*      */ 
/*  890 */     XSSimpleTypeDefinition attrType = attr.getTypeDefinition();
/*  891 */     TypeBinding typeBinding = bindSimpleType(attrType);
/*      */ 
/*  893 */     if (this.trace)
/*      */     {
/*  895 */       log.trace("binding attribute " + attrName + ", required=" + attrUse.getRequired());
/*      */     }
/*      */ 
/*  898 */     AttributeBinding binding = new AttributeBinding(this.schema, attrName, typeBinding, DefaultHandlers.ATTRIBUTE_HANDLER);
/*  899 */     binding.setRequired(attrUse.getRequired());
/*  900 */     if (attrUse.getConstraintType() == 1)
/*      */     {
/*  903 */       binding.setDefaultConstraint(attrUse.getConstraintValue());
/*      */     }
/*      */ 
/*  906 */     if (this.processAnnotations)
/*      */     {
/*  908 */       XSAnnotation an = attr.getAnnotation();
/*  909 */       if (an != null)
/*      */       {
/*  911 */         if (this.trace)
/*      */         {
/*  913 */           log.trace(attrName + " attribute annotation");
/*      */         }
/*      */ 
/*  916 */         XsdAnnotation xsdAn = XsdAnnotation.unmarshal(an.getAnnotationString());
/*  917 */         XsdAppInfo appInfo = xsdAn.getAppInfo();
/*  918 */         if (appInfo != null)
/*      */         {
/*  920 */           PropertyMetaData propertyMetaData = appInfo.getPropertyMetaData();
/*  921 */           if (propertyMetaData != null)
/*      */           {
/*  923 */             binding.setPropertyMetaData(propertyMetaData);
/*      */           }
/*      */ 
/*  926 */           boolean mapEntryKey = appInfo.isMapEntryKey();
/*  927 */           if (mapEntryKey)
/*      */           {
/*  929 */             binding.setMapEntryKey(mapEntryKey);
/*      */           }
/*      */ 
/*  932 */           boolean mapEntryValue = appInfo.isMapEntryValue();
/*  933 */           if (mapEntryValue)
/*      */           {
/*  935 */             binding.setMapEntryValue(mapEntryValue);
/*      */           }
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  942 */     if (this.trace)
/*      */     {
/*  944 */       String msg = "bound attribute " + attrName;
/*      */ 
/*  946 */       if (binding.getPropertyMetaData() != null)
/*      */       {
/*  948 */         msg = msg + " property=" + binding.getPropertyMetaData().getName() + ", collectionType=" + binding.getPropertyMetaData().getCollectionType();
/*      */       }
/*  952 */       else if (binding.isMapEntryKey())
/*      */       {
/*  954 */         msg = msg + "bound as a key in a map entry";
/*      */       }
/*  956 */       else if (binding.isMapEntryValue())
/*      */       {
/*  958 */         msg = msg + "bound as a value in a map entry";
/*      */       }
/*      */       else
/*      */       {
/*  962 */         msg = msg + " type=" + attrType.getName();
/*      */       }
/*      */ 
/*  965 */       if (binding.getDefaultConstraint() != null)
/*      */       {
/*  967 */         msg = msg + ", default=" + binding.getDefaultConstraint();
/*      */       }
/*      */ 
/*  970 */       log.trace(msg);
/*      */     }
/*      */ 
/*  973 */     return binding;
/*      */   }
/*      */ 
/*      */   private void bindParticle(XSParticle particle)
/*      */   {
/*  978 */     XSTerm term = particle.getTerm();
/*  979 */     switch (term.getType())
/*      */     {
/*      */     case 7:
/*  982 */       XSModelGroup modelGroup = (XSModelGroup)term;
/*      */ 
/*  984 */       if (modelGroup.getParticles().getLength() <= 0)
/*      */         break;
/*  986 */       ModelGroupBinding groupBinding = bindModelGroup(modelGroup);
/*      */ 
/*  988 */       ParticleBinding particleBinding = new ParticleBinding(groupBinding);
/*  989 */       particleBinding.setMaxOccursUnbounded(particle.getMaxOccursUnbounded());
/*  990 */       particleBinding.setMinOccurs(particle.getMinOccurs());
/*  991 */       particleBinding.setMaxOccurs(particle.getMaxOccurs());
/*      */ 
/*  993 */       Object o = peekTypeOrGroup();
/*  994 */       if ((o instanceof ModelGroupBinding))
/*      */       {
/*  996 */         ModelGroupBinding parentGroup = (ModelGroupBinding)o;
/*  997 */         parentGroup.addParticle(particleBinding);
/*  998 */         if (this.trace)
/*      */         {
/* 1000 */           log.trace("added " + groupBinding + " to " + parentGroup);
/*      */         }
/*      */       }
/* 1003 */       else if ((o instanceof TypeBinding))
/*      */       {
/* 1005 */         TypeBinding typeBinding = (TypeBinding)o;
/* 1006 */         typeBinding.setParticle(particleBinding);
/* 1007 */         if (this.trace)
/*      */         {
/* 1009 */           log.trace("added " + groupBinding + " to type " + typeBinding.getQName());
/*      */         }
/*      */       }
/*      */ 
/* 1013 */       if (groupBinding.getParticles().isEmpty())
/*      */       {
/* 1015 */         pushModelGroup(groupBinding);
/* 1016 */         bindModelGroupParticles(modelGroup);
/* 1017 */         popModelGroup();
/*      */       }
/* 1019 */       break;
/*      */     case 9:
/* 1022 */       bindWildcard(particle);
/* 1023 */       break;
/*      */     case 2:
/* 1025 */       bindElement((XSElementDeclaration)term, particle.getMinOccurs(), particle.getMaxOccurs(), particle.getMaxOccursUnbounded());
/*      */ 
/* 1031 */       break;
/*      */     default:
/* 1033 */       throw new IllegalStateException("Unexpected term type: " + term.getType());
/*      */     }
/*      */   }
/*      */ 
/*      */   private ModelGroupBinding bindModelGroup(XSModelGroup modelGroup)
/*      */   {
/* 1040 */     ModelGroupBinding groupBinding = this.sharedElements.getGlobalGroup(modelGroup);
/* 1041 */     if (groupBinding != null) {
/* 1042 */       return groupBinding;
/*      */     }
/* 1044 */     switch (modelGroup.getCompositor())
/*      */     {
/*      */     case 3:
/* 1047 */       groupBinding = new AllBinding(this.schema);
/* 1048 */       break;
/*      */     case 2:
/* 1050 */       groupBinding = new ChoiceBinding(this.schema);
/* 1051 */       break;
/*      */     case 1:
/* 1053 */       groupBinding = new SequenceBinding(this.schema);
/* 1054 */       break;
/*      */     default:
/* 1056 */       throw new JBossXBRuntimeException("Unexpected model group: " + modelGroup.getCompositor());
/*      */     }
/*      */ 
/* 1059 */     if (this.trace) {
/* 1060 */       log.trace("created model group " + groupBinding);
/*      */     }
/* 1062 */     if (this.processAnnotations)
/*      */     {
/* 1064 */       XSAnnotation annotation = modelGroup.getAnnotation();
/* 1065 */       if (annotation != null)
/* 1066 */         customizeTerm(annotation, groupBinding, this.trace);
/*      */     }
/* 1068 */     return groupBinding;
/*      */   }
/*      */ 
/*      */   private void bindWildcard(XSParticle particle)
/*      */   {
/* 1073 */     WildcardBinding binding = new WildcardBinding(this.schema);
/*      */ 
/* 1075 */     ModelGroupBinding group = (ModelGroupBinding)peekTypeOrGroup();
/* 1076 */     ParticleBinding particleBinding = new ParticleBinding(binding);
/* 1077 */     particleBinding.setMaxOccurs(particle.getMaxOccurs());
/* 1078 */     particleBinding.setMaxOccursUnbounded(particle.getMaxOccursUnbounded());
/* 1079 */     particleBinding.setMinOccurs(particle.getMinOccurs());
/* 1080 */     group.addParticle(particleBinding);
/*      */ 
/* 1082 */     XSWildcard wildcard = (XSWildcard)particle.getTerm();
/* 1083 */     if (wildcard.getName() != null)
/*      */     {
/* 1085 */       binding.setQName(new QName(wildcard.getNamespace(), wildcard.getName()));
/*      */     }
/*      */ 
/* 1088 */     binding.setProcessContents(wildcard.getProcessContents());
/*      */ 
/* 1090 */     if (this.processAnnotations)
/*      */     {
/* 1092 */       XSAnnotation annotation = wildcard.getAnnotation();
/* 1093 */       if (annotation != null)
/*      */       {
/* 1095 */         customizeTerm(annotation, binding, this.trace);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private ParticleBinding bindElement(XSElementDeclaration elementDec, int minOccurs, int maxOccurs, boolean maxOccursUnbounded)
/*      */   {
/* 1105 */     QName qName = new QName(elementDec.getNamespace(), elementDec.getName());
/*      */ 
/* 1107 */     ModelGroupBinding parentGroup = (ModelGroupBinding)peekTypeOrGroup();
/*      */ 
/* 1109 */     boolean global = elementDec.getScope() == 1;
/* 1110 */     ElementBinding element = this.schema.getElement(qName);
/*      */ 
/* 1112 */     if ((global) && (element != null))
/*      */     {
/* 1114 */       ParticleBinding particle = new ParticleBinding(element);
/* 1115 */       if (parentGroup != null)
/*      */       {
/* 1117 */         parentGroup.addParticle(particle);
/*      */       }
/*      */ 
/* 1120 */       particle.setMinOccurs(minOccurs);
/* 1121 */       if (maxOccursUnbounded)
/*      */       {
/* 1123 */         particle.setMaxOccursUnbounded(maxOccursUnbounded);
/*      */       }
/*      */       else
/*      */       {
/* 1127 */         particle.setMaxOccurs(maxOccurs);
/*      */       }
/*      */ 
/* 1130 */       return particle;
/*      */     }
/*      */ 
/* 1133 */     TypeBinding type = null;
/*      */ 
/* 1135 */     boolean shared = this.sharedElements.isShared(elementDec);
/* 1136 */     if (shared)
/*      */     {
/* 1138 */       type = this.sharedElements.getTypeBinding(elementDec);
/*      */     }
/*      */ 
/* 1141 */     if (type == null)
/*      */     {
/* 1143 */       type = bindType(elementDec.getTypeDefinition());
/* 1144 */       if (shared)
/*      */       {
/* 1146 */         this.sharedElements.setTypeBinding(elementDec, type);
/*      */       }
/*      */     }
/*      */ 
/* 1150 */     element = new ElementBinding(this.schema, qName, type);
/* 1151 */     element.setNillable(elementDec.getNillable());
/* 1152 */     ParticleBinding particle = new ParticleBinding(element);
/* 1153 */     particle.setMinOccurs(minOccurs);
/* 1154 */     particle.setMaxOccurs(maxOccurs);
/* 1155 */     particle.setMaxOccursUnbounded(maxOccursUnbounded);
/* 1156 */     if (global)
/*      */     {
/* 1158 */       this.schema.addElementParticle(particle);
/*      */     }
/*      */ 
/* 1161 */     if (parentGroup != null)
/*      */     {
/* 1163 */       parentGroup.addParticle(particle);
/* 1164 */       if (this.trace)
/*      */       {
/* 1166 */         log.trace("Element " + element.getQName() + " added to " + parentGroup);
/*      */       }
/*      */     }
/*      */ 
/* 1170 */     if (this.trace)
/*      */     {
/* 1172 */       TypeBinding parentType = peekType();
/* 1173 */       QName parentQName = null;
/* 1174 */       if (parentType != null)
/* 1175 */         parentQName = parentType.getQName();
/* 1176 */       log.trace("element: name=" + qName + ", type=" + type.getQName() + ", repeatable=" + particle.isRepeatable() + ", nillable=" + element.isNillable() + ", minOccurs=" + minOccurs + ", maxOccurs=" + (maxOccursUnbounded ? "unbounded" : new StringBuilder().append("").append(maxOccurs).toString()) + ", " + (global ? "global scope" : new StringBuilder().append(" owner type=").append(parentQName).toString()));
/*      */     }
/*      */ 
/* 1191 */     if (this.processAnnotations)
/*      */     {
/* 1193 */       XSAnnotation an = elementDec.getAnnotation();
/* 1194 */       if (an != null)
/*      */       {
/* 1196 */         customizeTerm(an, element, this.trace);
/*      */       }
/*      */     }
/* 1199 */     return particle;
/*      */   }
/*      */ 
/*      */   private void bindModelGroupParticles(XSModelGroup modelGroup)
/*      */   {
/* 1204 */     XSObjectList particles = modelGroup.getParticles();
/* 1205 */     for (int i = 0; i < particles.getLength(); i++)
/*      */     {
/* 1207 */       XSParticle particle = (XSParticle)particles.item(i);
/* 1208 */       bindParticle(particle);
/*      */     }
/*      */   }
/*      */ 
/*      */   private static void addXOPInclude(TypeBinding binding, SchemaBinding schema)
/*      */   {
/* 1216 */     binding.setHandler(DefaultHandlers.XOP_HANDLER);
/* 1217 */     if (binding.getParticle() != null)
/*      */     {
/* 1219 */       throw new JBossXBRuntimeException("XOP optimizable type has a particle which is unexpected, please, open a JIRA issue!");
/*      */     }
/*      */ 
/* 1224 */     TypeBinding anyUriType = schema.getType(Constants.QNAME_ANYURI);
/* 1225 */     if (anyUriType == null)
/*      */     {
/* 1227 */       log.warn("Type " + Constants.QNAME_ANYURI + " not bound.");
/*      */     }
/*      */ 
/* 1230 */     TypeBinding xopIncludeType = new TypeBinding(new QName("http://www.w3.org/2004/08/xop/include", "Include"));
/* 1231 */     xopIncludeType.setSchemaBinding(schema);
/* 1232 */     xopIncludeType.addAttribute(new QName("href"), anyUriType, DefaultHandlers.ATTRIBUTE_HANDLER);
/* 1233 */     xopIncludeType.setHandler(new XOPIncludeHandler(binding));
/*      */ 
/* 1235 */     ElementBinding xopInclude = new ElementBinding(schema, new QName("http://www.w3.org/2004/08/xop/include", "Include"), xopIncludeType);
/*      */ 
/* 1237 */     ParticleBinding particleBinding = new ParticleBinding(xopInclude);
/* 1238 */     particleBinding.setMinOccurs(0);
/*      */ 
/* 1240 */     binding.addParticle(particleBinding);
/*      */   }
/*      */ 
/*      */   private static void customizeTerm(XSAnnotation an, TermBinding term, boolean trace)
/*      */   {
/* 1245 */     XsdAnnotation xsdAn = XsdAnnotation.unmarshal(an.getAnnotationString());
/* 1246 */     XsdAppInfo appInfo = xsdAn.getAppInfo();
/* 1247 */     if (appInfo != null)
/*      */     {
/* 1249 */       Boolean skip = null;
/*      */ 
/* 1251 */       ClassMetaData classMetaData = appInfo.getClassMetaData();
/* 1252 */       if (classMetaData != null)
/*      */       {
/* 1254 */         if (trace)
/*      */         {
/*      */           String msg;
/* 1257 */           if (term.isModelGroup())
/*      */           {
/* 1259 */             msg = term + " bound to ";
/*      */           }
/*      */           else
/*      */           {
/*      */             String msg;
/* 1261 */             if (term.isWildcard())
/*      */             {
/* 1263 */               msg = " wildcard bound to ";
/*      */             }
/*      */             else
/*      */             {
/* 1267 */               msg = "element: name=" + ((ElementBinding)term).getQName() + ", class=";
/*      */             }
/*      */           }
/* 1270 */           String msg = msg + classMetaData.getImpl();
/* 1271 */           log.trace(msg);
/*      */         }
/* 1273 */         term.setClassMetaData(classMetaData);
/* 1274 */         skip = Boolean.FALSE;
/*      */       }
/*      */ 
/* 1277 */       PropertyMetaData propertyMetaData = appInfo.getPropertyMetaData();
/* 1278 */       if (propertyMetaData != null)
/*      */       {
/* 1280 */         if (trace)
/*      */         {
/* 1282 */           String msg = "element: name=" + ((ElementBinding)term).getQName() + ", ";
/*      */ 
/* 1284 */           msg = msg + " property=" + propertyMetaData.getName() + ", collectionType=" + propertyMetaData.getCollectionType();
/*      */ 
/* 1287 */           log.trace(msg);
/*      */         }
/* 1289 */         term.setPropertyMetaData(propertyMetaData);
/*      */       }
/*      */ 
/* 1292 */       MapEntryMetaData mapEntryMetaData = appInfo.getMapEntryMetaData();
/* 1293 */       if (mapEntryMetaData != null)
/*      */       {
/* 1295 */         if (propertyMetaData != null)
/*      */         {
/* 1297 */           String msg = "A term can be bound either as a property or as a map entry but not both: " + (term.isModelGroup() ? term.toString() : ((ElementBinding)term).getQName().toString());
/*      */ 
/* 1300 */           throw new JBossXBRuntimeException(msg);
/*      */         }
/*      */ 
/* 1303 */         if (trace)
/*      */         {
/* 1305 */           String msg = "element name=" + ((ElementBinding)term).getQName();
/*      */ 
/* 1308 */           msg = msg + " is bound to a map entry: impl=" + mapEntryMetaData.getImpl() + ", getKeyMethod=" + mapEntryMetaData.getGetKeyMethod() + ", setKeyMethod=" + mapEntryMetaData.getSetKeyMethod() + ", getValueMethod=" + mapEntryMetaData.getGetValueMethod() + ", setValueMethod=" + mapEntryMetaData.getSetValueMethod() + ", valueType=" + mapEntryMetaData.getValueType() + ", nonNullValue=" + mapEntryMetaData.isNonNullValue();
/*      */ 
/* 1321 */           log.trace(msg);
/*      */         }
/*      */ 
/* 1324 */         if (classMetaData != null)
/*      */         {
/* 1326 */           String msg = "Invalid customization: both jbxb:class and jbxb:mapEntry are specified for term " + ((term.isWildcard()) || (term.isModelGroup()) ? term.toString() : ((ElementBinding)term).getQName().toString());
/*      */ 
/* 1328 */           throw new JBossXBRuntimeException(msg);
/*      */         }
/* 1330 */         term.setMapEntryMetaData(mapEntryMetaData);
/* 1331 */         skip = Boolean.FALSE;
/*      */       }
/*      */ 
/* 1334 */       PutMethodMetaData putMethodMetaData = appInfo.getPutMethodMetaData();
/* 1335 */       if (putMethodMetaData != null)
/*      */       {
/* 1337 */         if (trace)
/*      */         {
/* 1339 */           String msg = "element: name=" + ((ElementBinding)term).getQName() + ",";
/*      */ 
/* 1342 */           msg = msg + " putMethod=" + putMethodMetaData.getName() + ", keyType=" + putMethodMetaData.getKeyType() + ", valueType=" + putMethodMetaData.getValueType();
/*      */ 
/* 1347 */           log.trace(msg);
/*      */         }
/* 1349 */         term.setPutMethodMetaData(putMethodMetaData);
/*      */       }
/*      */ 
/* 1352 */       AddMethodMetaData addMethodMetaData = appInfo.getAddMethodMetaData();
/* 1353 */       if (addMethodMetaData != null)
/*      */       {
/* 1355 */         if (trace)
/*      */         {
/* 1357 */           String msg = "element: name=" + ((ElementBinding)term).getQName() + ",";
/*      */ 
/* 1359 */           msg = msg + " addMethod=" + addMethodMetaData.getMethodName() + ", valueType=" + addMethodMetaData.getValueType() + ", isChildType=" + addMethodMetaData.isChildType();
/*      */ 
/* 1364 */           log.trace(msg);
/*      */         }
/* 1366 */         term.setAddMethodMetaData(addMethodMetaData);
/*      */       }
/*      */ 
/* 1369 */       ValueMetaData valueMetaData = appInfo.getValueMetaData();
/* 1370 */       if (valueMetaData != null)
/*      */       {
/* 1372 */         if (trace)
/*      */         {
/* 1374 */           String msg = "element " + ((ElementBinding)term).getQName();
/*      */ 
/* 1376 */           msg = msg + ": unmarshalMethod=" + valueMetaData.getUnmarshalMethod();
/* 1377 */           log.trace(msg);
/*      */         }
/* 1379 */         term.setValueMetaData(valueMetaData);
/*      */       }
/*      */ 
/* 1382 */       boolean mapEntryKey = appInfo.isMapEntryKey();
/* 1383 */       if (mapEntryKey)
/*      */       {
/* 1385 */         if (trace)
/*      */         {
/* 1387 */           String msg = "element name=" + ((ElementBinding)term).getQName();
/*      */ 
/* 1389 */           msg = msg + ": is bound to a key in a map entry";
/* 1390 */           log.trace(msg);
/*      */         }
/* 1392 */         term.setMapEntryKey(mapEntryKey);
/* 1393 */         skip = Boolean.FALSE;
/*      */       }
/*      */ 
/* 1396 */       boolean mapEntryValue = appInfo.isMapEntryValue();
/* 1397 */       if (mapEntryValue)
/*      */       {
/* 1399 */         if (trace)
/*      */         {
/* 1401 */           String msg = "element name=" + ((ElementBinding)term).getQName();
/*      */ 
/* 1403 */           msg = msg + ": is bound to a value in a map entry";
/* 1404 */           log.trace(msg);
/*      */         }
/* 1406 */         term.setMapEntryValue(mapEntryValue);
/* 1407 */         skip = Boolean.FALSE;
/*      */       }
/*      */ 
/* 1410 */       boolean skipAnnotation = appInfo.isSkip();
/* 1411 */       if (skip != null)
/*      */       {
/* 1413 */         term.setSkip(skip);
/*      */       }
/* 1415 */       else if (skipAnnotation)
/*      */       {
/* 1417 */         if (trace)
/*      */         {
/* 1419 */           String msg = "element name=" + ((ElementBinding)term).getQName();
/*      */ 
/* 1421 */           msg = msg + ": will be skipped, it's attributes, character content and children will be set on the parent";
/* 1422 */           log.trace(msg);
/*      */         }
/* 1424 */         term.setSkip(skipAnnotation ? Boolean.TRUE : Boolean.FALSE);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private void bindGlobalGroup(XSModelGroupDefinition groupDef)
/*      */   {
/* 1431 */     QName groupName = new QName(groupDef.getNamespace(), groupDef.getName());
/* 1432 */     XSModelGroup group = groupDef.getModelGroup();
/* 1433 */     ModelGroupBinding groupBinding = bindModelGroup(group);
/* 1434 */     groupBinding.setQName(groupName);
/* 1435 */     this.sharedElements.addGlobalGroup(group, groupBinding);
/* 1436 */     this.schema.addGroup(groupName, groupBinding);
/*      */   }
/*      */ 
/*      */   private void bindGlobalGroupParticles(XSModelGroup group)
/*      */   {
/* 1441 */     ModelGroupBinding groupBinding = this.sharedElements.getGlobalGroup(group);
/* 1442 */     if (groupBinding.getParticles().isEmpty())
/*      */     {
/* 1444 */       pushModelGroup(groupBinding);
/* 1445 */       bindModelGroupParticles(group);
/* 1446 */       popModelGroup();
/*      */     }
/*      */   }
/*      */ 
/*      */   private void popType()
/*      */   {
/* 1452 */     Object o = this.typeGroupStack.remove(this.typeGroupStack.size() - 1);
/* 1453 */     if (!(o instanceof TypeBinding))
/*      */     {
/* 1455 */       throw new JBossXBRuntimeException("Should have poped type binding but got " + o);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void pushType(TypeBinding binding)
/*      */   {
/* 1461 */     this.typeGroupStack.add(binding);
/*      */   }
/*      */ 
/*      */   private void popModelGroup()
/*      */   {
/* 1466 */     Object o = this.typeGroupStack.remove(this.typeGroupStack.size() - 1);
/* 1467 */     if (!(o instanceof ModelGroupBinding))
/*      */     {
/* 1469 */       throw new JBossXBRuntimeException("Should have poped model group binding but got " + o);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void pushModelGroup(ModelGroupBinding binding)
/*      */   {
/* 1475 */     this.typeGroupStack.add(binding);
/*      */   }
/*      */ 
/*      */   private Object peekTypeOrGroup()
/*      */   {
/* 1480 */     return this.typeGroupStack.isEmpty() ? null : this.typeGroupStack.get(this.typeGroupStack.size() - 1);
/*      */   }
/*      */ 
/*      */   private TypeBinding peekType()
/*      */   {
/* 1485 */     TypeBinding binding = null;
/* 1486 */     for (ListIterator i = this.typeGroupStack.listIterator(this.typeGroupStack.size()); i.hasPrevious(); )
/*      */     {
/* 1488 */       Object o = i.previous();
/* 1489 */       if ((o instanceof TypeBinding))
/*      */       {
/* 1491 */         binding = (TypeBinding)o;
/* 1492 */         break;
/*      */       }
/*      */     }
/* 1495 */     return binding;
/*      */   }
/*      */ 
/*      */   private static final class SharedElements
/*      */   {
/* 1502 */     private Map elements = Collections.EMPTY_MAP;
/*      */ 
/* 1504 */     private Map globalGroups = Collections.EMPTY_MAP;
/*      */ 
/*      */     public void add(XSElementDeclaration element)
/*      */     {
/* 1508 */       switch (this.elements.size())
/*      */       {
/*      */       case 0:
/* 1511 */         this.elements = Collections.singletonMap(element, null);
/* 1512 */         break;
/*      */       case 1:
/* 1514 */         this.elements = new HashMap(this.elements);
/*      */       default:
/* 1516 */         this.elements.put(element, null);
/*      */       }
/*      */     }
/*      */ 
/*      */     public boolean isShared(XSElementDeclaration element)
/*      */     {
/* 1522 */       return this.elements.containsKey(element);
/*      */     }
/*      */ 
/*      */     public TypeBinding getTypeBinding(XSElementDeclaration element)
/*      */     {
/* 1527 */       return (TypeBinding)this.elements.get(element);
/*      */     }
/*      */ 
/*      */     public void setTypeBinding(XSElementDeclaration element, TypeBinding type)
/*      */     {
/* 1532 */       switch (this.elements.size())
/*      */       {
/*      */       case 0:
/* 1535 */         this.elements = Collections.singletonMap(element, type);
/* 1536 */         break;
/*      */       case 1:
/* 1538 */         this.elements = new HashMap(this.elements);
/*      */       default:
/* 1540 */         this.elements.put(element, type);
/*      */       }
/*      */     }
/*      */ 
/*      */     public void addGlobalGroup(XSModelGroup group, ModelGroupBinding groupBinding)
/*      */     {
/* 1546 */       switch (this.globalGroups.size())
/*      */       {
/*      */       case 0:
/* 1549 */         this.globalGroups = Collections.singletonMap(group, groupBinding);
/* 1550 */         break;
/*      */       case 1:
/* 1552 */         this.globalGroups = new HashMap(this.globalGroups);
/*      */       default:
/* 1554 */         this.globalGroups.put(group, groupBinding);
/*      */       }
/*      */     }
/*      */ 
/*      */     public ModelGroupBinding getGlobalGroup(XSModelGroup group)
/*      */     {
/* 1560 */       return (ModelGroupBinding)this.globalGroups.get(group);
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.sunday.unmarshalling.XsdBinder
 * JD-Core Version:    0.6.0
 */