/*     */ package org.jboss.xb.binding.sunday.unmarshalling;
/*     */ 
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.xb.binding.JBossXBRuntimeException;
/*     */ import org.jboss.xb.binding.ObjectLocalMarshaller;
/*     */ import org.jboss.xb.binding.Util;
/*     */ import org.xml.sax.Attributes;
/*     */ 
/*     */ public class WildcardBinding extends TermBinding
/*     */ {
/*  38 */   private static final Logger log = Logger.getLogger(WildcardBinding.class);
/*     */   private static final short PC_LAX = 3;
/*     */   private static final short PC_SKIP = 2;
/*     */   private static final short PC_STRICT = 1;
/*     */   private QName qName;
/*     */   private SchemaBindingResolver schemaResolver;
/*     */   private short pc;
/*     */   private ParticleHandler unresolvedElementHandler;
/*     */   private CharactersHandler unresolvedCharactersHandler;
/*     */   private ObjectLocalMarshaller unresolvedMarshaller;
/*     */   private ParticleHandler wildcardHandler;
/*     */ 
/*     */   public WildcardBinding(SchemaBinding schema)
/*     */   {
/*  56 */     super(schema);
/*     */   }
/*     */ 
/*     */   public QName getQName()
/*     */   {
/*  61 */     return this.qName;
/*     */   }
/*     */ 
/*     */   public void setQName(QName qName)
/*     */   {
/*  66 */     this.qName = qName;
/*     */   }
/*     */ 
/*     */   public SchemaBindingResolver getSchemaResolver()
/*     */   {
/*  71 */     return this.schemaResolver;
/*     */   }
/*     */ 
/*     */   public void setSchemaResolver(SchemaBindingResolver schemaResolver)
/*     */   {
/*  76 */     this.schemaResolver = schemaResolver;
/*     */   }
/*     */ 
/*     */   public short getProcessContents()
/*     */   {
/*  81 */     return this.pc;
/*     */   }
/*     */ 
/*     */   public void setProcessContents(short pc)
/*     */   {
/*  86 */     this.pc = pc;
/*  87 */     if ((pc != 3) && (pc != 2) && (pc != 1))
/*     */     {
/*  89 */       throw new JBossXBRuntimeException("Unexpected value for process contents: " + pc);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean isProcessContentsLax()
/*     */   {
/*  95 */     return this.pc == 3;
/*     */   }
/*     */ 
/*     */   public boolean isProcessContentsSkip()
/*     */   {
/* 100 */     return this.pc == 2;
/*     */   }
/*     */ 
/*     */   public boolean isProcessContentsStrict()
/*     */   {
/* 105 */     return this.pc == 1;
/*     */   }
/*     */ 
/*     */   public void setWildcardHandler(ParticleHandler wildcardHandler)
/*     */   {
/* 110 */     this.wildcardHandler = wildcardHandler;
/*     */   }
/*     */ 
/*     */   public ParticleHandler getWildcardHandler()
/*     */   {
/* 115 */     return this.wildcardHandler;
/*     */   }
/*     */ 
/*     */   public ParticleHandler getUnresolvedElementHandler()
/*     */   {
/* 120 */     return this.unresolvedElementHandler;
/*     */   }
/*     */ 
/*     */   public void setUnresolvedElementHandler(ParticleHandler unresolvedElementHandler)
/*     */   {
/* 125 */     this.unresolvedElementHandler = unresolvedElementHandler;
/*     */   }
/*     */ 
/*     */   public CharactersHandler getUnresolvedCharactersHandler()
/*     */   {
/* 130 */     return this.unresolvedCharactersHandler;
/*     */   }
/*     */ 
/*     */   public void setUnresolvedCharactersHandler(CharactersHandler unresolvedCharactersHandler)
/*     */   {
/* 135 */     this.unresolvedCharactersHandler = unresolvedCharactersHandler;
/*     */   }
/*     */ 
/*     */   public ObjectLocalMarshaller getUnresolvedMarshaller()
/*     */   {
/* 140 */     return this.unresolvedMarshaller;
/*     */   }
/*     */ 
/*     */   public void setUnresolvedMarshaller(ObjectLocalMarshaller marshaller)
/*     */   {
/* 145 */     this.unresolvedMarshaller = marshaller;
/*     */   }
/*     */ 
/*     */   public ElementBinding getElement(QName qName, Attributes attrs)
/*     */   {
/* 150 */     if (this.pc == 2)
/*     */     {
/* 152 */       return getUnresolvedElement(qName, false);
/*     */     }
/*     */ 
/* 155 */     ElementBinding element = null;
/*     */ 
/* 157 */     if (this.schema != null)
/*     */     {
/* 159 */       element = this.schema.getElement(qName);
/*     */     }
/*     */ 
/* 162 */     if (element == null)
/*     */     {
/* 164 */       SchemaBindingResolver resolver = this.schemaResolver;
/* 165 */       if ((resolver == null) && (this.schema != null))
/*     */       {
/* 167 */         resolver = this.schema.getSchemaResolver();
/*     */       }
/*     */ 
/* 170 */       if (resolver != null)
/*     */       {
/* 173 */         String schemaLocation = attrs == null ? null : Util.getSchemaLocation(attrs, qName.getNamespaceURI());
/* 174 */         SchemaBinding schema = resolver.resolve(qName.getNamespaceURI(), null, schemaLocation);
/* 175 */         if (schema != null)
/*     */         {
/* 177 */           element = schema.getElement(qName);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 182 */     if ((element == null) && (this.pc == 3))
/*     */     {
/* 184 */       element = getUnresolvedElement(qName, false);
/*     */     }
/*     */ 
/* 187 */     return element;
/*     */   }
/*     */ 
/*     */   private ElementBinding getUnresolvedElement(QName qName, boolean required)
/*     */   {
/* 199 */     if (log.isTraceEnabled())
/*     */     {
/* 201 */       log.trace("getUnresolvedElement for " + qName + ", required=" + required + ", unresolvedElementHandler=" + this.unresolvedElementHandler);
/*     */     }
/*     */ 
/* 207 */     if (this.unresolvedElementHandler == null)
/*     */     {
/* 209 */       if (required)
/*     */       {
/* 211 */         throw new JBossXBRuntimeException("Schema could not be resolved for wildcard content element " + qName + " and particle handler for unresolved wildcard content elements is not initialized.");
/*     */       }
/*     */ 
/* 219 */       ParticleBinding particle = new ParticleBinding(this);
/* 220 */       SequenceBinding sequence = new SequenceBinding(this.schema);
/* 221 */       sequence.addParticle(particle);
/*     */ 
/* 223 */       TypeBinding type = new TypeBinding();
/* 224 */       type.setParticle(new ParticleBinding(sequence));
/*     */ 
/* 226 */       ElementBinding element = new ElementBinding(this.schema, qName, type);
/*     */ 
/* 228 */       element.setSkip(Boolean.TRUE);
/* 229 */       return element;
/*     */     }
/*     */ 
/* 237 */     WildcardBinding unresolvedWildcard = new WildcardBinding(this.schema);
/* 238 */     unresolvedWildcard.pc = 3;
/* 239 */     unresolvedWildcard.schemaResolver = this.schemaResolver;
/* 240 */     unresolvedWildcard.unresolvedCharactersHandler = this.unresolvedCharactersHandler;
/* 241 */     unresolvedWildcard.unresolvedElementHandler = this.unresolvedElementHandler;
/*     */ 
/* 243 */     ParticleBinding particle = new ParticleBinding(unresolvedWildcard);
/* 244 */     SequenceBinding sequence = new SequenceBinding(this.schema);
/* 245 */     sequence.addParticle(particle);
/*     */ 
/* 247 */     TypeBinding type = new TypeBinding();
/* 248 */     type.setHandler(this.unresolvedElementHandler);
/* 249 */     type.setSimpleType(this.unresolvedCharactersHandler);
/* 250 */     type.setParticle(new ParticleBinding(sequence, 1, 0, true));
/*     */ 
/* 252 */     return new ElementBinding(this.schema, qName, type);
/*     */   }
/*     */ 
/*     */   public boolean isSkip()
/*     */   {
/* 257 */     return this.skip == null ? false : this.skip.booleanValue();
/*     */   }
/*     */ 
/*     */   public boolean isModelGroup()
/*     */   {
/* 262 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean isWildcard()
/*     */   {
/* 267 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean isElement()
/*     */   {
/* 272 */     return false;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.sunday.unmarshalling.WildcardBinding
 * JD-Core Version:    0.6.0
 */