/*     */ package org.jboss.xb.binding.sunday.unmarshalling;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.xb.binding.metadata.AddMethodMetaData;
/*     */ import org.jboss.xb.binding.metadata.CharactersMetaData;
/*     */ import org.jboss.xb.binding.metadata.ClassMetaData;
/*     */ import org.jboss.xb.binding.metadata.MapEntryMetaData;
/*     */ import org.jboss.xb.binding.metadata.PropertyMetaData;
/*     */ import org.jboss.xb.binding.metadata.ValueMetaData;
/*     */ import org.jboss.xb.binding.sunday.marshalling.TermBeforeMarshallingCallback;
/*     */ import org.jboss.xb.binding.sunday.xop.XOPMarshaller;
/*     */ import org.jboss.xb.binding.sunday.xop.XOPUnmarshaller;
/*     */ import org.xml.sax.Attributes;
/*     */ import org.xml.sax.helpers.AttributesImpl;
/*     */ 
/*     */ public class TypeBinding
/*     */ {
/*     */   protected QName qName;
/*  55 */   private Map attrs = Collections.EMPTY_MAP;
/*     */   private ParticleHandler handler;
/*     */   private CharactersHandler charactersHandler;
/*     */   private ClassMetaData classMetaData;
/*     */   private ValueMetaData valueMetaData;
/*     */   private PropertyMetaData propertyMetaData;
/*     */   private MapEntryMetaData mapEntryMetaData;
/*     */   private SchemaBinding schemaBinding;
/*     */   private TypeBinding baseType;
/*     */   private boolean skip;
/*     */   private CharactersMetaData charMetaData;
/*     */   private AddMethodMetaData addMethodMetaData;
/*  67 */   private ValueAdapter valueAdapter = ValueAdapter.NOOP;
/*     */   private TermBeforeMarshallingCallback beforeMarshallingCallback;
/*     */   private TermBeforeSetParentCallback beforeSetParentCallback;
/*     */   private Boolean startElementCreatesObject;
/*     */   private Boolean simple;
/*     */   private WildcardBinding wildcard;
/*     */   private ParticleBinding particle;
/*     */   private List patternValues;
/*     */   private List enumValues;
/*     */   private TypeBinding itemType;
/*     */   private TypeBinding simpleType;
/*     */   private XOPUnmarshaller xopUnmarshaller;
/*     */   private XOPMarshaller xopMarshaller;
/*  88 */   private Map interceptors = Collections.EMPTY_MAP;
/*     */   private boolean initializedWildcard;
/*     */ 
/*     */   public TypeBinding()
/*     */   {
/*  92 */     this.qName = null;
/*     */   }
/*     */ 
/*     */   public TypeBinding(QName qName)
/*     */   {
/*  98 */     this(qName, DefaultHandlers.CHARACTERS_HANDLER);
/*     */   }
/*     */ 
/*     */   public TypeBinding(CharactersHandler charactersHandler)
/*     */   {
/* 103 */     this(null, charactersHandler);
/*     */   }
/*     */ 
/*     */   public TypeBinding(QName qName, CharactersHandler charactersHandler)
/*     */   {
/* 108 */     this.qName = qName;
/* 109 */     this.charactersHandler = charactersHandler;
/*     */   }
/*     */ 
/*     */   public TypeBinding(QName qName, TypeBinding baseType)
/*     */   {
/* 114 */     this(qName, baseType.charactersHandler);
/*     */ 
/* 116 */     if (baseType.particle != null)
/*     */     {
/* 119 */       this.particle = baseType.particle;
/*     */     }
/*     */ 
/* 122 */     this.attrs = new HashMap(baseType.attrs);
/* 123 */     this.classMetaData = baseType.classMetaData;
/* 124 */     this.valueMetaData = baseType.valueMetaData;
/* 125 */     this.propertyMetaData = baseType.propertyMetaData;
/* 126 */     this.mapEntryMetaData = baseType.mapEntryMetaData;
/* 127 */     this.schemaBinding = baseType.schemaBinding;
/* 128 */     this.baseType = baseType;
/*     */ 
/* 130 */     if (!baseType.isStartElementCreatesObject())
/*     */     {
/* 132 */       this.handler = baseType.handler;
/*     */     }
/*     */   }
/*     */ 
/*     */   public QName getQName()
/*     */   {
/* 138 */     return this.qName;
/*     */   }
/*     */ 
/*     */   public ElementBinding getElement(QName name)
/*     */   {
/* 143 */     return getElement(name, true);
/*     */   }
/*     */ 
/*     */   private ElementBinding getElement(QName name, boolean ignoreWildcards)
/*     */   {
/* 148 */     ElementBinding element = null;
/* 149 */     if (this.particle != null)
/*     */     {
/* 151 */       ModelGroupBinding modelGroup = (ModelGroupBinding)this.particle.getTerm();
/* 152 */       element = modelGroup.newCursor(this.particle).getElement(name, null, ignoreWildcards);
/*     */     }
/*     */ 
/* 155 */     if ((element == null) && (!ignoreWildcards) && (this.wildcard != null))
/*     */     {
/* 157 */       element = this.wildcard.getElement(name, null);
/*     */     }
/* 159 */     return element;
/*     */   }
/*     */ 
/*     */   public void addParticle(ParticleBinding particle)
/*     */   {
/*     */     ModelGroupBinding modelGroup;
/* 165 */     if (this.particle == null)
/*     */     {
/* 167 */       ModelGroupBinding modelGroup = new AllBinding(this.schemaBinding);
/* 168 */       this.particle = new ParticleBinding(modelGroup);
/*     */     }
/*     */     else
/*     */     {
/* 172 */       modelGroup = (ModelGroupBinding)this.particle.getTerm();
/*     */     }
/* 174 */     modelGroup.addParticle(particle);
/*     */   }
/*     */ 
/*     */   public void addElement(ElementBinding element)
/*     */   {
/* 179 */     addElement(element, 1, false);
/*     */   }
/*     */ 
/*     */   public void addElement(ElementBinding element, int minOccurs, boolean unbounded)
/*     */   {
/* 184 */     ParticleBinding particle = new ParticleBinding(element);
/* 185 */     particle.setMinOccurs(minOccurs);
/* 186 */     particle.setMaxOccursUnbounded(unbounded);
/* 187 */     addParticle(particle);
/*     */   }
/*     */ 
/*     */   public ElementBinding addElement(QName name, TypeBinding type)
/*     */   {
/* 192 */     return addElement(name, type, 1, false);
/*     */   }
/*     */ 
/*     */   public ElementBinding addElement(QName name, TypeBinding type, int minOccurs, boolean unbounded)
/*     */   {
/* 197 */     ElementBinding el = new ElementBinding(this.schemaBinding, name, type);
/* 198 */     addElement(el, minOccurs, unbounded);
/* 199 */     return el;
/*     */   }
/*     */ 
/*     */   public void addGroup(Map group)
/*     */   {
/* 204 */     for (Iterator i = group.entrySet().iterator(); i.hasNext(); )
/*     */     {
/* 206 */       Map.Entry entry = (Map.Entry)i.next();
/* 207 */       QName name = (QName)entry.getKey();
/* 208 */       TypeBinding type = (TypeBinding)entry.getValue();
/* 209 */       addElement(name, type);
/*     */     }
/*     */   }
/*     */ 
/*     */   public AttributeBinding getAttribute(QName qName)
/*     */   {
/* 215 */     return (AttributeBinding)this.attrs.get(qName);
/*     */   }
/*     */ 
/*     */   public Attributes expandWithDefaultAttributes(Attributes attrs)
/*     */   {
/* 228 */     if (this.attrs.size() == 0)
/*     */     {
/* 230 */       return attrs;
/*     */     }
/*     */ 
/* 234 */     HashMap attrsNotSeen = new HashMap(this.attrs);
/* 235 */     for (int n = 0; n < attrs.getLength(); n++)
/*     */     {
/* 237 */       QName name = new QName(attrs.getURI(n), attrs.getLocalName(n));
/* 238 */       attrsNotSeen.remove(name);
/*     */     }
/*     */ 
/* 241 */     Attributes expandedAttrs = attrs;
/* 242 */     if (attrsNotSeen.size() > 0)
/*     */     {
/* 244 */       AttributesImpl tmp = new AttributesImpl(attrs);
/* 245 */       Iterator iter = attrsNotSeen.entrySet().iterator();
/* 246 */       while (iter.hasNext())
/*     */       {
/* 248 */         Map.Entry entry = (Map.Entry)iter.next();
/* 249 */         QName name = (QName)entry.getKey();
/* 250 */         AttributeBinding binding = (AttributeBinding)entry.getValue();
/* 251 */         String constraint = binding.getDefaultConstraint();
/* 252 */         if (constraint != null)
/*     */         {
/* 258 */           tmp.addAttribute(name.getNamespaceURI(), name.getLocalPart(), name.toString(), "CDATA", constraint);
/*     */         }
/*     */       }
/*     */ 
/* 262 */       expandedAttrs = tmp;
/*     */     }
/*     */ 
/* 265 */     return expandedAttrs;
/*     */   }
/*     */ 
/*     */   public AttributeBinding addAttribute(QName name, TypeBinding type, AttributeHandler handler)
/*     */   {
/* 270 */     AttributeBinding attr = new AttributeBinding(this.schemaBinding, name, type, handler);
/* 271 */     addAttribute(attr);
/* 272 */     return attr;
/*     */   }
/*     */ 
/*     */   public void addAttribute(AttributeBinding attr)
/*     */   {
/* 277 */     switch (this.attrs.size())
/*     */     {
/*     */     case 0:
/* 280 */       this.attrs = Collections.singletonMap(attr.getQName(), attr);
/* 281 */       break;
/*     */     case 1:
/* 283 */       this.attrs = new HashMap(this.attrs);
/*     */     default:
/* 285 */       this.attrs.put(attr.getQName(), attr);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Collection getAttributes()
/*     */   {
/* 291 */     return this.attrs.values();
/*     */   }
/*     */ 
/*     */   public CharactersHandler getCharactersHandler()
/*     */   {
/* 296 */     return this.charactersHandler;
/*     */   }
/*     */ 
/*     */   public void setCharactersHandler(CharactersHandler charactersHandler)
/*     */   {
/* 301 */     this.charactersHandler = charactersHandler;
/*     */   }
/*     */ 
/*     */   public void setSimpleType(CharactersHandler charactersHandler)
/*     */   {
/* 311 */     setSimpleType(new TypeBinding(charactersHandler));
/*     */   }
/*     */ 
/*     */   public TypeBinding getSimpleType()
/*     */   {
/* 316 */     return this.simpleType;
/*     */   }
/*     */ 
/*     */   public void setSimpleType(TypeBinding simpleType)
/*     */   {
/* 321 */     this.simpleType = simpleType;
/*     */   }
/*     */ 
/*     */   public void setHandler(ParticleHandler handler)
/*     */   {
/* 326 */     this.handler = handler;
/*     */   }
/*     */ 
/*     */   public ParticleHandler getHandler()
/*     */   {
/* 331 */     return this.handler;
/*     */   }
/*     */ 
/*     */   public void pushInterceptor(QName qName, ElementInterceptor interceptor)
/*     */   {
/* 349 */     ElementBinding el = getElement(qName);
/* 350 */     if (el == null)
/*     */     {
/* 352 */       el = addElement(qName, new TypeBinding());
/*     */     }
/*     */ 
/* 356 */     List intList = (List)this.interceptors.get(qName);
/* 357 */     if (intList == null)
/*     */     {
/* 359 */       intList = Collections.singletonList(interceptor);
/* 360 */       switch (this.interceptors.size())
/*     */       {
/*     */       case 0:
/* 363 */         this.interceptors = Collections.singletonMap(qName, intList);
/* 364 */         break;
/*     */       case 1:
/* 366 */         this.interceptors = new HashMap(this.interceptors);
/*     */       default:
/* 368 */         this.interceptors.put(qName, intList); break;
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 373 */       if (intList.size() == 1)
/*     */       {
/* 375 */         intList = new ArrayList(intList);
/* 376 */         this.interceptors.put(qName, intList);
/*     */       }
/* 378 */       intList.add(interceptor);
/*     */     }
/*     */   }
/*     */ 
/*     */   public List getInterceptors(QName qName)
/*     */   {
/* 392 */     List list = (List)this.interceptors.get(qName);
/* 393 */     return list == null ? Collections.EMPTY_LIST : list;
/*     */   }
/*     */ 
/*     */   public TypeBinding getBaseType()
/*     */   {
/* 398 */     return this.baseType;
/*     */   }
/*     */ 
/*     */   public void setBaseType(TypeBinding baseType)
/*     */   {
/* 403 */     this.baseType = baseType;
/*     */   }
/*     */ 
/*     */   public boolean isSimple()
/*     */   {
/* 411 */     return this.simple == null ? false : (this.particle == null) && (this.attrs.isEmpty()) ? true : this.simple.booleanValue();
/*     */   }
/*     */ 
/*     */   public void setSimple(boolean simple)
/*     */   {
/* 416 */     this.simple = (simple ? Boolean.TRUE : Boolean.FALSE);
/*     */   }
/*     */ 
/*     */   public boolean isTextContentAllowed()
/*     */   {
/* 421 */     return (this.simpleType != null) || (isSimple());
/*     */   }
/*     */ 
/*     */   public ClassMetaData getClassMetaData()
/*     */   {
/* 426 */     return this.classMetaData;
/*     */   }
/*     */ 
/*     */   public void setClassMetaData(ClassMetaData classMetaData)
/*     */   {
/* 431 */     this.classMetaData = classMetaData;
/*     */   }
/*     */ 
/*     */   public SchemaBinding getSchemaBinding()
/*     */   {
/* 436 */     return this.schemaBinding;
/*     */   }
/*     */ 
/*     */   public void setSchemaBinding(SchemaBinding schemaBinding)
/*     */   {
/* 441 */     this.schemaBinding = schemaBinding;
/*     */   }
/*     */ 
/*     */   public void setValueMetaData(ValueMetaData valueMetaData)
/*     */   {
/* 446 */     this.valueMetaData = valueMetaData;
/*     */   }
/*     */ 
/*     */   public ValueMetaData getValueMetaData()
/*     */   {
/* 451 */     return this.valueMetaData;
/*     */   }
/*     */ 
/*     */   public PropertyMetaData getPropertyMetaData()
/*     */   {
/* 456 */     return this.propertyMetaData;
/*     */   }
/*     */ 
/*     */   public void setPropertyMetaData(PropertyMetaData propertyMetaData)
/*     */   {
/* 461 */     this.propertyMetaData = propertyMetaData;
/*     */   }
/*     */ 
/*     */   public MapEntryMetaData getMapEntryMetaData()
/*     */   {
/* 466 */     return this.mapEntryMetaData;
/*     */   }
/*     */ 
/*     */   public void setMapEntryMetaData(MapEntryMetaData mapEntryMetaData)
/*     */   {
/* 471 */     this.mapEntryMetaData = mapEntryMetaData;
/*     */   }
/*     */ 
/*     */   public void setSkip(boolean skip)
/*     */   {
/* 476 */     this.skip = skip;
/*     */   }
/*     */ 
/*     */   public boolean isSkip()
/*     */   {
/* 481 */     return this.skip;
/*     */   }
/*     */ 
/*     */   public CharactersMetaData getCharactersMetaData()
/*     */   {
/* 486 */     return this.charMetaData;
/*     */   }
/*     */ 
/*     */   public void setCharactersMetaData(CharactersMetaData charMetaData)
/*     */   {
/* 491 */     this.charMetaData = charMetaData;
/*     */   }
/*     */ 
/*     */   public void setAddMethodMetaData(AddMethodMetaData addMethodMetaData)
/*     */   {
/* 496 */     this.addMethodMetaData = addMethodMetaData;
/*     */   }
/*     */ 
/*     */   public AddMethodMetaData getAddMethodMetaData()
/*     */   {
/* 501 */     return this.addMethodMetaData;
/*     */   }
/*     */ 
/*     */   public ValueAdapter getValueAdapter()
/*     */   {
/* 506 */     return this.valueAdapter;
/*     */   }
/*     */ 
/*     */   public void setValueAdapter(ValueAdapter valueAdapter)
/*     */   {
/* 511 */     this.valueAdapter = valueAdapter;
/*     */   }
/*     */ 
/*     */   public boolean isStartElementCreatesObject()
/*     */   {
/* 525 */     return this.startElementCreatesObject == null ? false : (this.particle != null) || (!this.attrs.isEmpty()) ? true : this.startElementCreatesObject.booleanValue();
/*     */   }
/*     */ 
/*     */   public void setStartElementCreatesObject(boolean startElementCreatesObject)
/*     */   {
/* 540 */     this.startElementCreatesObject = (startElementCreatesObject ? Boolean.TRUE : Boolean.FALSE);
/*     */   }
/*     */ 
/*     */   public WildcardBinding getWildcard()
/*     */   {
/* 546 */     if (this.initializedWildcard)
/*     */     {
/* 548 */       return this.wildcard;
/*     */     }
/*     */ 
/* 551 */     if (this.particle != null)
/*     */     {
/* 553 */       this.wildcard = getWildcard(this.particle.getTerm());
/* 554 */       this.initializedWildcard = true;
/*     */     }
/*     */ 
/* 557 */     return this.wildcard;
/*     */   }
/*     */ 
/*     */   public ParticleBinding getParticle()
/*     */   {
/* 562 */     return this.particle;
/*     */   }
/*     */ 
/*     */   public void setParticle(ParticleBinding particle)
/*     */   {
/* 567 */     this.particle = particle;
/*     */   }
/*     */ 
/*     */   public List getLexicalPattern()
/*     */   {
/* 572 */     return this.patternValues;
/*     */   }
/*     */ 
/*     */   public void addLexicalPattern(String patternValue)
/*     */   {
/* 577 */     if (this.patternValues == null)
/*     */     {
/* 579 */       this.patternValues = Collections.singletonList(patternValue);
/*     */     }
/*     */     else
/*     */     {
/* 583 */       if (this.patternValues.size() == 1)
/*     */       {
/* 585 */         this.patternValues = new ArrayList(this.patternValues);
/*     */       }
/* 587 */       this.patternValues.add(patternValue);
/*     */     }
/*     */   }
/*     */ 
/*     */   public List getLexicalEnumeration()
/*     */   {
/* 593 */     return this.enumValues;
/*     */   }
/*     */ 
/*     */   public void addEnumValue(String value)
/*     */   {
/* 598 */     if (this.enumValues == null)
/*     */     {
/* 600 */       this.enumValues = Collections.singletonList(value);
/*     */     }
/*     */     else
/*     */     {
/* 604 */       if (this.enumValues.size() == 1)
/*     */       {
/* 606 */         this.enumValues = new ArrayList(this.enumValues);
/*     */       }
/* 608 */       this.enumValues.add(value);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setItemType(TypeBinding itemType)
/*     */   {
/* 614 */     this.itemType = itemType;
/*     */   }
/*     */ 
/*     */   public TypeBinding getItemType()
/*     */   {
/* 619 */     return this.itemType;
/*     */   }
/*     */ 
/*     */   public XOPUnmarshaller getXopUnmarshaller()
/*     */   {
/* 624 */     return this.xopUnmarshaller == null ? this.schemaBinding.getXopUnmarshaller() : this.schemaBinding == null ? null : this.xopUnmarshaller;
/*     */   }
/*     */ 
/*     */   public void setXopUnmarshaller(XOPUnmarshaller xopUnmarshaller)
/*     */   {
/* 630 */     this.xopUnmarshaller = xopUnmarshaller;
/*     */   }
/*     */ 
/*     */   public XOPMarshaller getXopMarshaller()
/*     */   {
/* 635 */     return this.xopMarshaller == null ? this.schemaBinding.getXopMarshaller() : this.schemaBinding == null ? null : this.xopMarshaller;
/*     */   }
/*     */ 
/*     */   public void setXopMarshaller(XOPMarshaller xopMarshaller)
/*     */   {
/* 641 */     this.xopMarshaller = xopMarshaller;
/*     */   }
/*     */ 
/*     */   public boolean hasOnlyXmlMimeAttributes()
/*     */   {
/* 646 */     if (this.attrs.isEmpty())
/*     */     {
/* 648 */       return false;
/*     */     }
/*     */ 
/* 652 */     Iterator iter = this.attrs.keySet().iterator();
/* 653 */     while (iter.hasNext())
/*     */     {
/* 655 */       QName qName = (QName)iter.next();
/* 656 */       if (!"http://www.w3.org/2005/05/xmlmime".equals(qName.getNamespaceURI()))
/*     */       {
/* 658 */         return false;
/*     */       }
/*     */     }
/*     */ 
/* 662 */     return true;
/*     */   }
/*     */ 
/*     */   public void setBeforeMarshallingCallback(TermBeforeMarshallingCallback marshallingHandler)
/*     */   {
/* 667 */     this.beforeMarshallingCallback = marshallingHandler;
/*     */   }
/*     */ 
/*     */   public TermBeforeMarshallingCallback getBeforeMarshallingCallback()
/*     */   {
/* 672 */     return this.beforeMarshallingCallback;
/*     */   }
/*     */ 
/*     */   public void setBeforeSetParentCallback(TermBeforeSetParentCallback beforeSetParent)
/*     */   {
/* 677 */     this.beforeSetParentCallback = beforeSetParent;
/*     */   }
/*     */ 
/*     */   public TermBeforeSetParentCallback getBeforeSetParentCallback()
/*     */   {
/* 682 */     return this.beforeSetParentCallback;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 687 */     return super.toString() + "[" + this.qName + "]";
/*     */   }
/*     */ 
/*     */   private static WildcardBinding getWildcard(TermBinding term)
/*     */   {
/* 692 */     if (term.isWildcard())
/*     */     {
/* 694 */       return (WildcardBinding)term;
/*     */     }
/*     */     Iterator i;
/* 697 */     if (term.isModelGroup())
/*     */     {
/* 699 */       ModelGroupBinding group = (ModelGroupBinding)term;
/* 700 */       for (i = group.getParticles().iterator(); i.hasNext(); )
/*     */       {
/* 702 */         term = ((ParticleBinding)i.next()).getTerm();
/* 703 */         if (term.isWildcard())
/*     */         {
/* 705 */           return (WildcardBinding)term;
/*     */         }
/* 707 */         if (!term.isModelGroup())
/*     */           continue;
/* 709 */         WildcardBinding wc = getWildcard(term);
/* 710 */         if (wc != null) {
/* 711 */           return wc;
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 716 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.sunday.unmarshalling.TypeBinding
 * JD-Core Version:    0.6.0
 */