/*     */ package org.jboss.xb.binding.sunday.unmarshalling;
/*     */ 
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class SingletonSchemaResolverFactory
/*     */   implements SchemaResolverFactory
/*     */ {
/*  35 */   private static final Logger log = Logger.getLogger(SingletonSchemaResolverFactory.class);
/*     */ 
/*  38 */   private static final SingletonSchemaResolverFactory singleton = new SingletonSchemaResolverFactory();
/*     */ 
/*  41 */   private final DefaultSchemaResolver resolver = new DefaultSchemaResolver();
/*     */ 
/*     */   public static SingletonSchemaResolverFactory getInstance()
/*     */   {
/*  50 */     return singleton;
/*     */   }
/*     */ 
/*     */   private SingletonSchemaResolverFactory()
/*     */   {
/*  58 */     addSchema("urn:jboss:aop-beans:1.0", "org.jboss.aop.microcontainer.beans.xml.AOPBeansSchemaInitializer", Boolean.FALSE);
/*  59 */     addSchema("urn:jboss:bean-deployer", "org.jboss.kernel.plugins.deployment.xml.BeanSchemaInitializer", Boolean.FALSE);
/*  60 */     addSchema("urn:jboss:bean-deployer:2.0", "org.jboss.kernel.plugins.deployment.xml.BeanSchemaInitializer20", Boolean.FALSE);
/*  61 */     addSchema("urn:jboss:javabean:1.0", "org.jboss.javabean.plugins.xml.JavaBeanSchemaInitializer", Boolean.FALSE);
/*  62 */     addSchema("urn:jboss:javabean:2.0", "org.jboss.javabean.plugins.xml.JavaBeanSchemaInitializer20", Boolean.FALSE);
/*  63 */     addSchema("urn:jboss:spring-beans:2.0", "org.jboss.spring.deployment.xml.SpringSchemaInitializer", Boolean.FALSE);
/*  64 */     addSchema("urn:jboss:policy:1.0", "org.jboss.kernel.plugins.deployment.xml.PolicySchemaInitializer", Boolean.FALSE);
/*  65 */     addSchema("urn:jboss:osgi-beans:1.0", "org.jboss.osgi.deployment.xml.OSGiSchemaInitializer", Boolean.FALSE);
/*  66 */     addSchema("urn:jboss:seam-components:1.0", "org.jboss.seam.ioc.microcontainer.xml.SeamSchemaInitializer", Boolean.FALSE);
/*     */   }
/*     */ 
/*     */   public SchemaBindingResolver getSchemaBindingResolver()
/*     */   {
/*  71 */     return this.resolver;
/*     */   }
/*     */ 
/*     */   protected boolean addSchema(String namespace, String initializer)
/*     */   {
/*     */     try
/*     */     {
/*  85 */       this.resolver.addSchemaInitializer(namespace, initializer);
/*  86 */       log.trace("Mapped initializer '" + namespace + "' to '" + initializer + "'");
/*  87 */       return true;
/*     */     }
/*     */     catch (Exception ignored)
/*     */     {
/*  91 */       log.trace("Ignored: ", ignored);
/*  92 */     }return false;
/*     */   }
/*     */ 
/*     */   protected boolean addSchema(String namespace, String initializer, Boolean parseAnnotations)
/*     */   {
/* 106 */     if (!addSchema(namespace, initializer))
/* 107 */       return false;
/* 108 */     setParseAnnotations(namespace, parseAnnotations);
/* 109 */     return true;
/*     */   }
/*     */ 
/*     */   protected boolean addSchema(String namespace, String initializer, String location)
/*     */   {
/* 122 */     if (!addSchema(namespace, initializer))
/* 123 */       return false;
/*     */     try
/*     */     {
/* 126 */       this.resolver.addSchemaLocation(namespace, location);
/* 127 */       log.trace("Mapped location '" + namespace + "' to '" + location + "'");
/* 128 */       return true;
/*     */     }
/*     */     catch (Exception ignored)
/*     */     {
/* 132 */       log.trace("Ignored: ", ignored);
/* 133 */     }return false;
/*     */   }
/*     */ 
/*     */   protected boolean addSchema(String namespace, String initializer, String location, Boolean parseAnnotations)
/*     */   {
/* 148 */     if (!addSchema(namespace, initializer, location))
/* 149 */       return false;
/* 150 */     setParseAnnotations(namespace, parseAnnotations);
/* 151 */     return true;
/*     */   }
/*     */ 
/*     */   protected void setParseAnnotations(String namespace, Boolean parseAnnotations)
/*     */   {
/* 162 */     this.resolver.addSchemaParseAnnotations(namespace, parseAnnotations);
/* 163 */     log.trace("Parse annotations '" + namespace + "' set to '" + parseAnnotations + "'");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.sunday.unmarshalling.SingletonSchemaResolverFactory
 * JD-Core Version:    0.6.0
 */