/*     */ package org.jboss.xb.binding.sunday.unmarshalling;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.HashSet;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.xb.binding.JBossXBRuntimeException;
/*     */ import org.xml.sax.Attributes;
/*     */ 
/*     */ public class SequenceBinding extends ModelGroupBinding
/*     */ {
/*  42 */   private List sequence = Collections.EMPTY_LIST;
/*     */   private ElementBinding arrayItem;
/*     */ 
/*     */   public SequenceBinding(SchemaBinding schema)
/*     */   {
/*  47 */     super(schema);
/*     */   }
/*     */ 
/*     */   public ElementBinding getArrayItem()
/*     */   {
/*  52 */     return this.arrayItem;
/*     */   }
/*     */ 
/*     */   public void addParticle(ParticleBinding particle)
/*     */   {
/*  57 */     switch (this.sequence.size())
/*     */     {
/*     */     case 0:
/*  60 */       this.sequence = Collections.singletonList(particle);
/*  61 */       if ((!particle.isRepeatable()) || (!particle.getTerm().isElement()))
/*     */         break;
/*  63 */       ElementBinding element = (ElementBinding)particle.getTerm();
/*  64 */       if (particle.isRepeatable())
/*     */       {
/*  66 */         this.arrayItem = element;
/*     */       }
/*  68 */       break;
/*     */     case 1:
/*  71 */       this.sequence = new ArrayList(this.sequence);
/*  72 */       this.arrayItem = null;
/*     */     default:
/*  74 */       this.sequence.add(particle);
/*     */     }
/*  76 */     super.addParticle(particle);
/*     */   }
/*     */ 
/*     */   public Collection getParticles()
/*     */   {
/*  81 */     return Collections.unmodifiableCollection(this.sequence);
/*     */   }
/*     */ 
/*     */   public ModelGroupBinding.Cursor newCursor(ParticleBinding particle)
/*     */   {
/*  86 */     return new ModelGroupBinding.Cursor(particle) { private int pos = -1;
/*     */       private ElementBinding element;
/*     */       private int occurence;
/*     */       private boolean wildcardContent;
/*     */ 
/*  95 */       public ParticleBinding getCurrentParticle() { if (this.pos < 0)
/*     */         {
/*  97 */           throw new JBossXBRuntimeException("The cursor has not been positioned yet! startElement should be called.");
/*     */         }
/*     */ 
/* 101 */         return (ParticleBinding)SequenceBinding.this.sequence.get(this.pos);
/*     */       }
/*     */ 
/*     */       public ElementBinding getElement()
/*     */       {
/* 106 */         if (this.pos < 0)
/*     */         {
/* 108 */           throw new JBossXBRuntimeException("The cursor has not been positioned yet! startElement should be called.");
/*     */         }
/*     */ 
/* 112 */         return this.element;
/*     */       }
/*     */ 
/*     */       public boolean isPositioned()
/*     */       {
/* 117 */         return this.pos != -1;
/*     */       }
/*     */ 
/*     */       public void endElement(QName qName)
/*     */       {
/* 122 */         if ((this.element == null) || (!this.element.getQName().equals(qName)))
/*     */         {
/* 124 */           throw new JBossXBRuntimeException("Failed to process endElement for " + qName + " since the current element is " + (this.element == null ? "null" : this.element.getQName().toString()));
/*     */         }
/*     */ 
/* 129 */         if (this.trace)
/*     */         {
/* 131 */           SequenceBinding.this.log.trace("endElement " + qName + " in " + getModelGroup());
/*     */         }
/*     */       }
/*     */ 
/*     */       public int getOccurence()
/*     */       {
/* 137 */         return this.occurence;
/*     */       }
/*     */ 
/*     */       public boolean isWildcardContent()
/*     */       {
/* 142 */         return this.wildcardContent;
/*     */       }
/*     */ 
/*     */       protected List startElement(QName qName, Attributes atts, Set passedGroups, List groupStack, boolean required)
/*     */       {
/* 147 */         if (this.trace)
/*     */         {
/* 149 */           StringBuffer sb = new StringBuffer();
/* 150 */           sb.append("startElement " + qName + " in " + getModelGroup() + ", " + SequenceBinding.this.sequence.size() + ": ");
/*     */ 
/* 152 */           for (int i = 0; i < SequenceBinding.this.sequence.size(); i++)
/*     */           {
/* 154 */             ParticleBinding particle = (ParticleBinding)SequenceBinding.this.sequence.get(i);
/* 155 */             Object o = particle.getTerm();
/* 156 */             if ((o instanceof ElementBinding))
/*     */             {
/* 158 */               sb.append(((ElementBinding)o).getQName());
/*     */             }
/* 160 */             else if ((o instanceof SequenceBinding))
/*     */             {
/* 162 */               sb.append("sequence");
/*     */             }
/* 164 */             else if ((o instanceof ChoiceBinding))
/*     */             {
/* 166 */               sb.append("choice");
/*     */             }
/* 168 */             else if ((o instanceof AllBinding))
/*     */             {
/* 170 */               sb.append("all");
/*     */             }
/*     */ 
/* 173 */             sb.append(" ");
/*     */           }
/* 175 */           sb.append("]");
/* 176 */           SequenceBinding.this.log.trace(sb.toString());
/*     */         }
/*     */ 
/* 179 */         this.wildcardContent = false;
/* 180 */         int i = this.pos;
/* 181 */         if (this.pos >= 0)
/*     */         {
/* 183 */           ParticleBinding particle = getCurrentParticle();
/* 184 */           if ((particle.getMaxOccursUnbounded()) || (this.occurence < particle.getMinOccurs()) || (this.occurence < particle.getMaxOccurs()))
/*     */           {
/* 188 */             i--;
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/* 194 */         while (i < SequenceBinding.this.sequence.size() - 1)
/*     */         {
/* 196 */           i++; ParticleBinding particle = (ParticleBinding)SequenceBinding.this.sequence.get(i);
/* 197 */           Object item = particle.getTerm();
/* 198 */           if ((item instanceof ElementBinding))
/*     */           {
/* 200 */             ElementBinding element = (ElementBinding)item;
/* 201 */             if (qName.equals(element.getQName()))
/*     */             {
/* 203 */               if (this.pos == i)
/*     */               {
/* 205 */                 this.occurence += 1;
/*     */               }
/*     */               else
/*     */               {
/* 209 */                 this.pos = i;
/* 210 */                 this.occurence = 1;
/*     */               }
/* 212 */               groupStack = addItem(groupStack, this);
/* 213 */               this.element = element;
/*     */ 
/* 215 */               if (!this.trace)
/*     */                 break;
/* 217 */               SequenceBinding.this.log.trace("found " + qName + " in " + getModelGroup()); break;
/*     */             }
/*     */ 
/* 222 */             if ((i != this.pos) && (particle.getMinOccurs() > 0))
/*     */             {
/* 224 */               if (!required)
/*     */                 break;
/* 226 */               throw new JBossXBRuntimeException("Requested element " + qName + " is not allowed in this position in the sequence. The next element should be " + element.getQName());
/*     */             }
/*     */ 
/*     */           }
/* 237 */           else if ((item instanceof ModelGroupBinding))
/*     */           {
/* 239 */             ModelGroupBinding modelGroup = (ModelGroupBinding)item;
/* 240 */             if (!passedGroups.contains(modelGroup))
/*     */             {
/* 242 */               switch (passedGroups.size())
/*     */               {
/*     */               case 0:
/* 245 */                 passedGroups = Collections.singleton(this);
/* 246 */                 break;
/*     */               case 1:
/* 248 */                 passedGroups = new HashSet(passedGroups);
/*     */               default:
/* 250 */                 passedGroups.add(this);
/*     */               }
/*     */ 
/* 253 */               int groupStackSize = groupStack.size();
/* 254 */               groupStack = modelGroup.newCursor(particle).startElement(qName, atts, passedGroups, groupStack, particle.isRequired(this.occurence));
/*     */ 
/* 258 */               if (groupStackSize != groupStack.size())
/*     */               {
/* 260 */                 if (this.pos != i)
/*     */                 {
/* 262 */                   this.pos = i;
/* 263 */                   this.occurence = 1;
/*     */                 }
/*     */                 else
/*     */                 {
/* 267 */                   this.occurence += 1;
/*     */                 }
/* 269 */                 groupStack = addItem(groupStack, this);
/* 270 */                 this.element = null;
/* 271 */                 break;
/*     */               }
/*     */ 
/* 274 */               if ((i != this.pos) && (particle.isRequired()))
/*     */               {
/* 276 */                 if (!required)
/*     */                   break;
/* 278 */                 throw new JBossXBRuntimeException("Requested element " + qName + " is not allowed in this position in the sequence. A model group with minOccurs=" + particle.getMinOccurs() + " that doesn't contain this element must follow.");
/*     */               }
/*     */ 
/*     */             }
/* 289 */             else if ((i != this.pos) && (particle.isRequired()))
/*     */             {
/* 291 */               if (!required)
/*     */                 break;
/* 293 */               throw new JBossXBRuntimeException("Requested element " + qName + " is not allowed in this position in the sequence. A model group with minOccurs=" + particle.getMinOccurs() + " that doesn't contain this element must follow.");
/*     */             }
/*     */ 
/*     */           }
/* 304 */           else if ((item instanceof WildcardBinding))
/*     */           {
/* 306 */             WildcardBinding wildcard = (WildcardBinding)item;
/* 307 */             this.element = wildcard.getElement(qName, atts);
/* 308 */             if (this.element != null)
/*     */             {
/* 310 */               if (this.pos != i)
/*     */               {
/* 312 */                 this.pos = i;
/* 313 */                 this.occurence = 1;
/*     */               }
/*     */               else
/*     */               {
/* 317 */                 this.occurence += 1;
/*     */               }
/* 319 */               groupStack = addItem(groupStack, this);
/* 320 */               this.wildcardContent = true;
/* 321 */               break;
/*     */             }
/*     */ 
/* 324 */             if ((i != this.pos) && (particle.getMinOccurs() > 0))
/*     */             {
/* 326 */               if (!required)
/*     */                 break;
/* 328 */               throw new JBossXBRuntimeException("Requested element " + qName + " is not allowed in this position in the sequence.");
/*     */             }
/*     */ 
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/* 340 */         if ((this.trace) && (i == SequenceBinding.this.sequence.size()))
/*     */         {
/* 342 */           SequenceBinding.this.log.trace(qName + " not found in " + getModelGroup());
/*     */         }
/*     */ 
/* 345 */         return groupStack;
/*     */       }
/*     */ 
/*     */       protected ElementBinding getElement(QName qName, Attributes atts, Set passedGroups, boolean ignoreWildcards)
/*     */       {
/* 350 */         return getElement(SequenceBinding.this.sequence, qName, atts, passedGroups, ignoreWildcards);
/*     */       } } ;
/*     */   }
/*     */ 
/*     */   protected boolean mayStartWith(QName qName, Set set)
/*     */   {
/* 357 */     boolean result = false;
/* 358 */     for (int i = 0; i < this.sequence.size(); i++)
/*     */     {
/* 360 */       ParticleBinding particle = (ParticleBinding)this.sequence.get(i);
/* 361 */       Object item = particle.getTerm();
/* 362 */       if ((item instanceof ElementBinding))
/*     */       {
/* 364 */         ElementBinding element = (ElementBinding)item;
/* 365 */         if (qName.equals(element.getQName()))
/*     */         {
/* 367 */           result = true;
/* 368 */           break;
/*     */         }
/*     */ 
/* 371 */         if (particle.getMinOccurs() > 0)
/*     */           break;
/*     */       }
/*     */       else
/*     */       {
/* 376 */         if (!(item instanceof ModelGroupBinding))
/*     */           continue;
/* 378 */         ModelGroupBinding modelGroup = (ModelGroupBinding)item;
/* 379 */         if (!set.contains(modelGroup))
/*     */         {
/* 381 */           switch (set.size())
/*     */           {
/*     */           case 0:
/* 384 */             set = Collections.singleton(this);
/* 385 */             break;
/*     */           case 1:
/* 387 */             set = new HashSet(set);
/*     */           default:
/* 389 */             set.add(this);
/*     */           }
/*     */ 
/* 392 */           result = modelGroup.mayStartWith(qName, set);
/*     */ 
/* 394 */           if (result) break; if (particle.getMinOccurs() <= 0)
/*     */             continue;
/* 396 */           break;
/*     */         }
/*     */ 
/* 399 */         if (particle.getMinOccurs() > 0)
/*     */         {
/*     */           break;
/*     */         }
/*     */       }
/*     */     }
/* 405 */     return result;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.sunday.unmarshalling.SequenceBinding
 * JD-Core Version:    0.6.0
 */