/*     */ package org.jboss.xb.binding.sunday.unmarshalling;
/*     */ 
/*     */ import java.net.URI;
/*     */ import java.net.URISyntaxException;
/*     */ import java.net.URL;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import java.util.WeakHashMap;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.xml.JBossEntityResolver;
/*     */ import org.jboss.xb.binding.JBossXBRuntimeException;
/*     */ import org.jboss.xb.builder.JBossXBBuilder;
/*     */ import org.w3c.dom.ls.LSInput;
/*     */ import org.xml.sax.InputSource;
/*     */ 
/*     */ public class DefaultSchemaResolver
/*     */   implements SchemaBindingResolver
/*     */ {
/*  48 */   private static Logger log = Logger.getLogger(DefaultSchemaResolver.class);
/*     */   private String baseURI;
/*     */   private JBossEntityResolver resolver;
/*  52 */   private boolean cacheResolvedSchemas = true;
/*     */ 
/*  54 */   private Map<String, SchemaBinding> schemasByUri = Collections.emptyMap();
/*     */ 
/*  56 */   private WeakHashMap<String, Class> uriToClass = new WeakHashMap();
/*     */ 
/*  58 */   private WeakHashMap<String, Class> schemaLocationToClass = new WeakHashMap();
/*     */ 
/*  60 */   private Map<String, SchemaBindingInitializer> schemaInitByUri = Collections.emptyMap();
/*     */ 
/*  62 */   private Map<String, Boolean> schemaParseAnnotationsByUri = Collections.emptyMap();
/*     */ 
/*     */   public DefaultSchemaResolver()
/*     */   {
/*  66 */     this(new JBossEntityResolver());
/*     */   }
/*     */ 
/*     */   public DefaultSchemaResolver(JBossEntityResolver resolver)
/*     */   {
/*  71 */     this.resolver = resolver;
/*     */   }
/*     */ 
/*     */   public boolean isCacheResolvedSchemas()
/*     */   {
/*  79 */     return this.cacheResolvedSchemas;
/*     */   }
/*     */ 
/*     */   public void setCacheResolvedSchemas(boolean cacheResolvedSchemas)
/*     */   {
/*  91 */     this.cacheResolvedSchemas = cacheResolvedSchemas;
/*  92 */     if (!cacheResolvedSchemas)
/*     */     {
/*  94 */       this.schemasByUri = Collections.emptyMap();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void addSchemaLocation(String nsUri, String location)
/*     */   {
/* 108 */     this.resolver.registerLocalEntity(nsUri, location);
/*     */   }
/*     */ 
/*     */   public void removeSchemaLocation(String nsUri)
/*     */   {
/* 120 */     this.resolver.registerLocalEntity(nsUri, null);
/*     */   }
/*     */ 
/*     */   public void addSchemaParseAnnotations(String nsUri, Boolean value)
/*     */   {
/* 131 */     if (nsUri == null)
/* 132 */       throw new IllegalArgumentException("Null namespace uri");
/* 133 */     if (value == null)
/* 134 */       throw new IllegalArgumentException("Null value");
/* 135 */     switch (this.schemaParseAnnotationsByUri.size())
/*     */     {
/*     */     case 0:
/* 138 */       this.schemaParseAnnotationsByUri = Collections.singletonMap(nsUri, value);
/* 139 */       break;
/*     */     case 1:
/* 141 */       this.schemaParseAnnotationsByUri = new HashMap(this.schemaParseAnnotationsByUri);
/*     */     default:
/* 143 */       this.schemaParseAnnotationsByUri.put(nsUri, value);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Boolean removeSchemaParseAnnotations(String nsUri)
/*     */   {
/* 155 */     if (nsUri == null)
/* 156 */       throw new IllegalArgumentException("Null namespace uri");
/* 157 */     return (Boolean)this.schemaParseAnnotationsByUri.remove(nsUri);
/*     */   }
/*     */ 
/*     */   public void addSchemaInitializer(String nsUri, String sbiClassName)
/*     */     throws Exception
/*     */   {
/* 173 */     if (sbiClassName == null)
/* 174 */       throw new IllegalArgumentException("Null class name");
/* 175 */     Class clazz = Thread.currentThread().getContextClassLoader().loadClass(sbiClassName);
/* 176 */     Object object = clazz.newInstance();
/* 177 */     if (!(object instanceof SchemaBindingInitializer))
/* 178 */       throw new IllegalArgumentException(clazz.getName() + " is not an instance of " + SchemaBindingInitializer.class.getName());
/* 179 */     SchemaBindingInitializer sbi = (SchemaBindingInitializer)object;
/* 180 */     addSchemaInitializer(nsUri, sbi);
/*     */   }
/*     */ 
/*     */   public void addSchemaInitializer(String nsUri, SchemaBindingInitializer sbi)
/*     */   {
/* 195 */     if (nsUri == null)
/* 196 */       throw new IllegalArgumentException("Null namespace uri");
/* 197 */     if (sbi == null)
/* 198 */       throw new IllegalArgumentException("Null schema binding initializer");
/* 199 */     switch (this.schemaInitByUri.size())
/*     */     {
/*     */     case 0:
/* 202 */       this.schemaInitByUri = Collections.singletonMap(nsUri, sbi);
/* 203 */       break;
/*     */     case 1:
/* 205 */       this.schemaInitByUri = new HashMap(this.schemaInitByUri);
/*     */     default:
/* 207 */       this.schemaInitByUri.put(nsUri, sbi);
/*     */     }
/*     */   }
/*     */ 
/*     */   public SchemaBindingInitializer removeSchemaInitializer(String nsUri)
/*     */   {
/* 219 */     if (nsUri == null)
/* 220 */       throw new IllegalArgumentException("Null namespace uri");
/* 221 */     return (SchemaBindingInitializer)this.schemaInitByUri.remove(nsUri);
/*     */   }
/*     */ 
/*     */   public void addClassBinding(String nsUri, Class clazz)
/*     */   {
/* 226 */     this.uriToClass.put(nsUri, clazz);
/*     */   }
/*     */ 
/*     */   public Class removeClassBinding(String nsUri) {
/* 230 */     return (Class)this.uriToClass.remove(nsUri);
/*     */   }
/*     */ 
/*     */   public void addClassBindingForLocation(String schemaLocation, Class clazz)
/*     */   {
/* 235 */     this.schemaLocationToClass.put(schemaLocation, clazz);
/*     */   }
/*     */ 
/*     */   public Class removeClassBindingForLocation(String schemaLocation) {
/* 239 */     return (Class)this.schemaLocationToClass.remove(schemaLocation);
/*     */   }
/*     */ 
/*     */   public String getBaseURI()
/*     */   {
/* 244 */     return this.baseURI;
/*     */   }
/*     */ 
/*     */   public void setBaseURI(String baseURI)
/*     */   {
/* 249 */     this.baseURI = baseURI;
/*     */   }
/*     */ 
/*     */   public SchemaBinding resolve(String nsURI, String baseURI, String schemaLocation)
/*     */   {
/* 262 */     boolean trace = log.isTraceEnabled();
/*     */ 
/* 264 */     boolean foundByNS = false;
/* 265 */     SchemaBinding schema = (SchemaBinding)this.schemasByUri.get(nsURI);
/* 266 */     if (schema != null)
/*     */     {
/* 268 */       if (trace)
/* 269 */         log.trace("resolved cached schema, nsURI=" + nsURI + ", schema: " + schema);
/* 270 */       return schema;
/*     */     }
/*     */ 
/* 274 */     Class bindingClass = resolveClassFromSchemaLocation(schemaLocation, trace);
/* 275 */     if (bindingClass == null)
/*     */     {
/* 278 */       bindingClass = (Class)this.uriToClass.get(nsURI);
/* 279 */       if (bindingClass != null)
/* 280 */         foundByNS = true;
/*     */     }
/* 282 */     if (bindingClass != null)
/*     */     {
/* 284 */       if (trace)
/*     */       {
/* 286 */         log.trace("found bindingClass, nsURI=" + nsURI + ", baseURI=" + baseURI + ", schemaLocation=" + schemaLocation + ", class=" + bindingClass);
/*     */       }
/*     */ 
/* 291 */       schema = JBossXBBuilder.build(bindingClass);
/*     */     }
/*     */     else
/*     */     {
/* 296 */       InputSource is = getInputSource(nsURI, baseURI, schemaLocation);
/* 297 */       if (trace)
/*     */       {
/* 299 */         log.trace("found schema InputSource, nsURI=" + nsURI + ", baseURI=" + baseURI + ", schemaLocation=" + schemaLocation);
/*     */       }
/*     */ 
/* 304 */       if (is != null)
/*     */       {
/* 306 */         if (baseURI == null) {
/* 307 */           baseURI = this.baseURI;
/*     */         }
/* 309 */         Boolean processAnnotationsBoolean = (Boolean)this.schemaParseAnnotationsByUri.get(nsURI);
/* 310 */         boolean processAnnotations = processAnnotationsBoolean == null ? true : processAnnotationsBoolean.booleanValue();
/*     */         try
/*     */         {
/* 313 */           schema = XsdBinder.bind(is.getByteStream(), null, baseURI, processAnnotations);
/* 314 */           foundByNS = true;
/*     */         }
/*     */         catch (RuntimeException e)
/*     */         {
/* 318 */           String msg = "Failed to parse schema for nsURI=" + nsURI + ", baseURI=" + baseURI + ", schemaLocation=" + schemaLocation;
/*     */ 
/* 321 */           throw new JBossXBRuntimeException(msg, e);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 326 */     if (schema != null)
/*     */     {
/* 328 */       schema.setSchemaResolver(this);
/* 329 */       SchemaBindingInitializer sbi = (SchemaBindingInitializer)this.schemaInitByUri.get(nsURI);
/* 330 */       if (sbi != null)
/*     */       {
/* 332 */         schema = sbi.init(schema);
/*     */       }
/*     */ 
/* 335 */       if ((schema != null) && (nsURI.length() > 0) && (this.cacheResolvedSchemas) && (foundByNS))
/*     */       {
/* 337 */         if (this.schemasByUri == Collections.EMPTY_MAP)
/*     */         {
/* 339 */           this.schemasByUri = new HashMap();
/*     */         }
/* 341 */         this.schemasByUri.put(nsURI, schema);
/*     */       }
/*     */     }
/*     */ 
/* 345 */     if (trace)
/*     */     {
/* 347 */       log.trace("resolved schema: " + schema);
/*     */     }
/*     */ 
/* 350 */     return schema;
/*     */   }
/*     */ 
/*     */   protected Class resolveClassFromSchemaLocation(String schemaLocation, boolean trace)
/*     */   {
/* 366 */     Class bindingClass = (Class)this.schemaLocationToClass.get(schemaLocation);
/* 367 */     if ((bindingClass == null) && (schemaLocation != null) && (schemaLocation.length() > 0))
/*     */     {
/*     */       try
/*     */       {
/* 372 */         URI url = new URI(schemaLocation);
/* 373 */         String path = url.getPath();
/* 374 */         if (path == null)
/* 375 */           path = url.getSchemeSpecificPart();
/* 376 */         int slash = path.lastIndexOf('/');
/*     */         String filename;
/*     */         String filename;
/* 378 */         if (slash >= 0)
/* 379 */           filename = path.substring(slash + 1);
/*     */         else {
/* 381 */           filename = path;
/*     */         }
/* 383 */         if (path.length() == 0) {
/* 384 */           return null;
/*     */         }
/* 386 */         if (trace)
/* 387 */           log.trace("Mapped schemaLocation to filename: " + filename);
/* 388 */         bindingClass = (Class)this.schemaLocationToClass.get(filename);
/*     */       }
/*     */       catch (URISyntaxException e)
/*     */       {
/* 392 */         if (trace)
/* 393 */           log.trace("schemaLocation: is not a URI, using systemId as resource", e);
/*     */       }
/*     */     }
/* 396 */     return bindingClass;
/*     */   }
/*     */ 
/*     */   public LSInput resolveAsLSInput(String nsURI, String baseURI, String schemaLocation)
/*     */   {
/* 401 */     LSInput lsInput = null;
/* 402 */     InputSource is = getInputSource(nsURI, baseURI, schemaLocation);
/* 403 */     if (is != null)
/*     */     {
/* 405 */       String publicId = is.getPublicId();
/* 406 */       String systemId = is.getSystemId();
/* 407 */       lsInput = new LSInputAdaptor(publicId, systemId, baseURI);
/* 408 */       lsInput.setCharacterStream(is.getCharacterStream());
/* 409 */       lsInput.setByteStream(is.getByteStream());
/* 410 */       lsInput.setEncoding(is.getEncoding());
/*     */     }
/* 412 */     return lsInput;
/*     */   }
/*     */ 
/*     */   private InputSource getInputSource(String nsURI, String baseURI, String schemaLocation)
/*     */   {
/* 417 */     boolean trace = log.isTraceEnabled();
/* 418 */     InputSource is = null;
/*     */ 
/* 420 */     if (trace) {
/* 421 */       log.trace("getInputSource, nsURI=" + nsURI + ", baseURI=" + baseURI + ", schemaLocation=" + schemaLocation);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 426 */       is = this.resolver.resolveEntity(nsURI, schemaLocation);
/* 427 */       if (trace)
/* 428 */         log.trace("Resolved schema using namespace as publicId and schemaLocation as systemId");
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 432 */       if (trace) {
/* 433 */         log.trace("Failed to use nsUri/schemaLocation", e);
/*     */       }
/*     */     }
/*     */ 
/* 437 */     if (baseURI == null)
/*     */     {
/* 439 */       baseURI = this.baseURI;
/*     */     }
/*     */ 
/* 442 */     if ((is == null) && (baseURI != null) && (schemaLocation != null))
/*     */     {
/*     */       try
/*     */       {
/* 446 */         URL url = new URL(baseURI);
/* 447 */         url = new URL(url, schemaLocation);
/* 448 */         String resolvedSchemaLocation = url.toString();
/*     */ 
/* 450 */         if (!schemaLocation.equals(resolvedSchemaLocation))
/*     */         {
/* 452 */           is = this.resolver.resolveEntity(null, url.toString());
/* 453 */           if ((trace) && (is != null))
/* 454 */             log.trace("Resolved schema location using baseURI");
/*     */         }
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 459 */         if (trace) {
/* 460 */           log.trace("Failed to use schema location with baseURI", e);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 465 */     if ((is == null) && (nsURI != null))
/*     */     {
/*     */       try
/*     */       {
/* 469 */         is = this.resolver.resolveEntity(null, nsURI);
/* 470 */         if ((trace) && (is != null))
/* 471 */           log.trace("Resolved namespace as system id");
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 475 */         if (trace)
/* 476 */           log.trace("Failed to use namespace as system id", e);
/*     */       }
/*     */     }
/* 479 */     if (trace)
/*     */     {
/* 481 */       log.trace("getInputSource, nsURI=" + nsURI + ", baseURI=" + baseURI + ", schemaLocation=" + schemaLocation + ", is=" + is);
/*     */     }
/*     */ 
/* 484 */     return is;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.sunday.unmarshalling.DefaultSchemaResolver
 * JD-Core Version:    0.6.0
 */