/*     */ package org.jboss.xb.binding.sunday.unmarshalling;
/*     */ 
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.xb.binding.JBossXBRuntimeException;
/*     */ import org.xml.sax.Attributes;
/*     */ 
/*     */ public class AllBinding extends ModelGroupBinding
/*     */ {
/*  43 */   private static final Logger log = Logger.getLogger(AllBinding.class);
/*     */ 
/*  45 */   private Map elements = Collections.EMPTY_MAP;
/*     */ 
/*     */   public AllBinding(SchemaBinding schema)
/*     */   {
/*  49 */     super(schema);
/*     */   }
/*     */ 
/*     */   public ElementBinding getArrayItem()
/*     */   {
/*  54 */     return null;
/*     */   }
/*     */ 
/*     */   public void addParticle(ParticleBinding particle)
/*     */   {
/*  59 */     if (!particle.getTerm().isElement())
/*     */     {
/*  61 */       throw new JBossXBRuntimeException("Model group all may contain only elements!");
/*     */     }
/*     */ 
/*  64 */     ElementBinding element = (ElementBinding)particle.getTerm();
/*  65 */     switch (this.elements.size())
/*     */     {
/*     */     case 0:
/*  68 */       this.elements = Collections.singletonMap(element.getQName(), particle);
/*  69 */       break;
/*     */     case 1:
/*  71 */       this.elements = new HashMap(this.elements);
/*     */     default:
/*  73 */       this.elements.put(element.getQName(), particle);
/*     */     }
/*  75 */     super.addParticle(particle);
/*     */   }
/*     */ 
/*     */   public Collection getParticles()
/*     */   {
/*  80 */     return Collections.unmodifiableCollection(this.elements.values());
/*     */   }
/*     */ 
/*     */   public ModelGroupBinding.Cursor newCursor(ParticleBinding particle)
/*     */   {
/*  85 */     return new ModelGroupBinding.Cursor(particle) {
/*     */       private ParticleBinding curParticle;
/*     */       private int occurence;
/*     */ 
/*     */       public ParticleBinding getCurrentParticle() {
/*  92 */         if (this.curParticle == null)
/*     */         {
/*  94 */           throw new JBossXBRuntimeException("The cursor in all group has not been positioned yet!");
/*     */         }
/*  96 */         return this.curParticle;
/*     */       }
/*     */ 
/*     */       public ElementBinding getElement()
/*     */       {
/* 101 */         return (ElementBinding)getCurrentParticle().getTerm();
/*     */       }
/*     */ 
/*     */       public boolean isPositioned()
/*     */       {
/* 106 */         return this.curParticle != null;
/*     */       }
/*     */ 
/*     */       public void endElement(QName qName)
/*     */       {
/* 111 */         if ((this.curParticle == null) || (!getElement().getQName().equals(qName)))
/*     */         {
/* 113 */           throw new JBossXBRuntimeException("Failed to process endElement for " + qName + " since the current element is " + (this.curParticle == null ? null : getElement().getQName()));
/*     */         }
/*     */       }
/*     */ 
/*     */       public int getOccurence()
/*     */       {
/* 121 */         return this.occurence;
/*     */       }
/*     */ 
/*     */       public boolean isWildcardContent()
/*     */       {
/* 126 */         return false;
/*     */       }
/*     */ 
/*     */       protected List startElement(QName qName, Attributes atts, Set passedGroups, List groupStack, boolean required)
/*     */       {
/* 131 */         ParticleBinding particle = (ParticleBinding)AllBinding.this.elements.get(qName);
/* 132 */         if (particle != null)
/*     */         {
/* 134 */           if (this.curParticle == particle)
/*     */           {
/* 136 */             this.occurence += 1;
/*     */           }
/*     */           else
/*     */           {
/* 140 */             this.curParticle = particle;
/* 141 */             this.occurence = 1;
/*     */           }
/* 143 */           groupStack = addItem(groupStack, this);
/*     */         }
/* 145 */         return groupStack;
/*     */       }
/*     */ 
/*     */       protected ElementBinding getElement(QName qName, Attributes atts, Set passedGroups, boolean ignoreWildcards)
/*     */       {
/* 150 */         ParticleBinding particle = (ParticleBinding)AllBinding.this.elements.get(qName);
/* 151 */         return particle == null ? null : (ElementBinding)particle.getTerm();
/*     */       }
/*     */     };
/*     */   }
/*     */ 
/*     */   protected boolean mayStartWith(QName qName, Set set) {
/* 158 */     return this.elements.containsKey(qName);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.sunday.unmarshalling.AllBinding
 * JD-Core Version:    0.6.0
 */