/*      */ package org.jboss.xb.binding.sunday.marshalling;
/*      */ 
/*      */ import java.io.IOException;
/*      */ import java.io.Reader;
/*      */ import java.io.StringWriter;
/*      */ import java.io.Writer;
/*      */ import java.lang.reflect.Array;
/*      */ import java.lang.reflect.Method;
/*      */ import java.math.BigDecimal;
/*      */ import java.math.BigInteger;
/*      */ import java.util.AbstractList;
/*      */ import java.util.Collection;
/*      */ import java.util.Date;
/*      */ import java.util.Iterator;
/*      */ import java.util.List;
/*      */ import java.util.Map;
/*      */ import javax.xml.namespace.QName;
/*      */ import javax.xml.parsers.ParserConfigurationException;
/*      */ import org.jboss.logging.Logger;
/*      */ import org.jboss.util.Classes;
/*      */ import org.jboss.xb.binding.AbstractMarshaller;
/*      */ import org.jboss.xb.binding.AbstractMarshaller.ClassMapping;
/*      */ import org.jboss.xb.binding.AbstractMarshaller.ContentHandlerAdaptor;
/*      */ import org.jboss.xb.binding.AbstractMarshaller.FieldToWildcardMapping;
/*      */ import org.jboss.xb.binding.AbstractMarshaller.Stack;
/*      */ import org.jboss.xb.binding.AbstractMarshaller.StackImpl;
/*      */ import org.jboss.xb.binding.AttributesImpl;
/*      */ import org.jboss.xb.binding.Constants;
/*      */ import org.jboss.xb.binding.Content;
/*      */ import org.jboss.xb.binding.ContentWriter;
/*      */ import org.jboss.xb.binding.JBossXBRuntimeException;
/*      */ import org.jboss.xb.binding.NamespaceRegistry;
/*      */ import org.jboss.xb.binding.ObjectLocalMarshaller;
/*      */ import org.jboss.xb.binding.ObjectModelProvider;
/*      */ import org.jboss.xb.binding.SimpleTypeBindings;
/*      */ import org.jboss.xb.binding.Util;
/*      */ import org.jboss.xb.binding.introspection.FieldInfo;
/*      */ import org.jboss.xb.binding.metadata.CharactersMetaData;
/*      */ import org.jboss.xb.binding.metadata.PropertyMetaData;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.AllBinding;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.AttributeBinding;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.ChoiceBinding;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.ModelGroupBinding;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.TermBinding;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.WildcardBinding;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.XsdBinder;
/*      */ import org.jboss.xb.binding.sunday.xop.XOPMarshaller;
/*      */ import org.jboss.xb.binding.sunday.xop.XOPObject;
/*      */ import org.xml.sax.ContentHandler;
/*      */ import org.xml.sax.SAXException;
/*      */ 
/*      */ public class MarshallerImpl extends AbstractMarshaller
/*      */ {
/*      */   private AbstractMarshaller.Stack stack;
/*      */   private Object root;
/*      */   private boolean supportNil;
/*      */   private boolean ignoreUnresolvedWildcard;
/*      */   private QName rootTypeQName;
/*      */   private SchemaBindingResolver schemaResolver;
/*      */   private SchemaBinding schema;
/*      */   private MarshallingContextImpl ctx;
/*      */ 
/*      */   public MarshallerImpl()
/*      */   {
/*   63 */     this.stack = new AbstractMarshaller.StackImpl();
/*      */ 
/*   70 */     this.supportNil = true;
/*      */ 
/*   80 */     this.ctx = new MarshallingContextImpl(null);
/*      */   }
/*      */ 
/*      */   public boolean isIgnoreUnresolvedWildcard() {
/*   84 */     return this.ignoreUnresolvedWildcard;
/*      */   }
/*      */ 
/*      */   public void setIgnoreUnresolvedWildcard(boolean ignoreUnresolvedWildcard)
/*      */   {
/*   89 */     this.ignoreUnresolvedWildcard = ignoreUnresolvedWildcard;
/*      */   }
/*      */ 
/*      */   public SchemaBindingResolver getSchemaResolver()
/*      */   {
/*   94 */     return this.schemaResolver;
/*      */   }
/*      */ 
/*      */   public void setSchemaResolver(SchemaBindingResolver schemaResolver)
/*      */   {
/*   99 */     this.schemaResolver = schemaResolver;
/*      */   }
/*      */ 
/*      */   public QName getRootTypeQName()
/*      */   {
/*  104 */     return this.rootTypeQName;
/*      */   }
/*      */ 
/*      */   public void setRootTypeQName(QName rootTypeQName)
/*      */   {
/*  109 */     this.rootTypeQName = rootTypeQName;
/*      */   }
/*      */ 
/*      */   public boolean isSupportNil()
/*      */   {
/*  114 */     return this.supportNil;
/*      */   }
/*      */ 
/*      */   public void setSupportNil(boolean supportNil)
/*      */   {
/*  119 */     this.supportNil = supportNil;
/*      */   }
/*      */ 
/*      */   public void addAttribute(String prefix, String localName, String type, String value)
/*      */   {
/*      */   }
/*      */ 
/*      */   public void marshal(Reader xsdReader, ObjectModelProvider provider, Object root, Writer writer)
/*      */     throws IOException, SAXException, ParserConfigurationException
/*      */   {
/*  142 */     SchemaBinding model = XsdBinder.bind(xsdReader, null, this.schemaResolver);
/*  143 */     marshallInternal(root, model, writer);
/*      */   }
/*      */ 
/*      */   public void marshal(String xsdURL, ObjectModelProvider provider, Object root, Writer writer)
/*      */     throws IOException, SAXException
/*      */   {
/*  149 */     SchemaBinding model = XsdBinder.bind(xsdURL, this.schemaResolver);
/*  150 */     marshallInternal(root, model, writer);
/*      */   }
/*      */ 
/*      */   public void marshal(SchemaBinding model, ObjectModelProvider provider, Object root, Writer writer)
/*      */     throws IOException, SAXException
/*      */   {
/*  157 */     marshallInternal(root, model, writer);
/*      */   }
/*      */ 
/*      */   private void marshallInternal(Object root, SchemaBinding schema, Writer writer)
/*      */     throws IOException, SAXException
/*      */   {
/*  163 */     if (schema == null)
/*      */     {
/*  165 */       throw new JBossXBRuntimeException("XSModel is not available!");
/*      */     }
/*      */ 
/*  168 */     this.schema = schema;
/*  169 */     this.root = root;
/*      */ 
/*  171 */     this.content.startDocument();
/*      */ 
/*  173 */     if (this.rootTypeQName != null)
/*      */     {
/*  175 */       if (this.rootQNames.isEmpty())
/*      */       {
/*  177 */         throw new JBossXBRuntimeException("If type name (" + this.rootTypeQName + ") for the root element is specified then the name for the root element is required!");
/*      */       }
/*      */ 
/*  182 */       QName rootQName = (QName)this.rootQNames.get(0);
/*      */ 
/*  184 */       TypeBinding type = schema.getType(this.rootTypeQName);
/*  185 */       if (type == null)
/*      */       {
/*  187 */         throw new JBossXBRuntimeException("Global type definition is not found: " + this.rootTypeQName);
/*      */       }
/*      */ 
/*  190 */       if (isArrayWrapper(type))
/*      */       {
/*  192 */         this.stack.push(root);
/*  193 */         marshalComplexType(rootQName, type, true, false);
/*  194 */         this.stack.pop();
/*      */       }
/*      */       else
/*      */       {
/*  198 */         ElementBinding element = new ElementBinding(schema, rootQName, type);
/*  199 */         MarshallingContextImpl.access$102(this.ctx, new ParticleBinding(element));
/*  200 */         marshalElementOccurence(element, root, false, true);
/*      */       }
/*      */     }
/*  203 */     else if (this.rootQNames.isEmpty())
/*      */     {
/*  205 */       Iterator elements = schema.getElementParticles();
/*  206 */       if (!elements.hasNext())
/*      */       {
/*  208 */         throw new JBossXBRuntimeException("The schema doesn't contain global element declarations.");
/*      */       }
/*      */ 
/*  211 */       while (elements.hasNext())
/*      */       {
/*  213 */         ParticleBinding element = (ParticleBinding)elements.next();
/*  214 */         MarshallingContextImpl.access$102(this.ctx, element);
/*  215 */         marshalElementOccurence((ElementBinding)element.getTerm(), root, true, true);
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/*  220 */       for (int i = 0; i < this.rootQNames.size(); i++)
/*      */       {
/*  222 */         QName qName = (QName)this.rootQNames.get(i);
/*  223 */         ParticleBinding element = schema.getElementParticle(qName);
/*  224 */         if (element == null)
/*      */         {
/*  226 */           Iterator components = schema.getElements();
/*  227 */           String roots = "";
/*  228 */           for (int j = 0; components.hasNext(); j++)
/*      */           {
/*  230 */             ElementBinding xsObject = (ElementBinding)components.next();
/*  231 */             if (j > 0)
/*      */             {
/*  233 */               roots = roots + ", ";
/*      */             }
/*  235 */             roots = roots + xsObject.getQName();
/*      */           }
/*  237 */           throw new IllegalStateException("Root element not found: " + qName + " among " + roots);
/*      */         }
/*      */ 
/*  240 */         MarshallingContextImpl.access$102(this.ctx, element);
/*  241 */         marshalElementOccurence((ElementBinding)element.getTerm(), root, true, true);
/*      */       }
/*      */     }
/*      */ 
/*  245 */     this.content.endDocument();
/*      */ 
/*  248 */     writeXmlVersion(writer);
/*      */ 
/*  250 */     ContentWriter contentWriter = new ContentWriter(writer, propertyIsTrueOrNotSet("org.jboss.xml.binding.marshalling.indent"));
/*      */ 
/*  253 */     this.content.handleContent(contentWriter);
/*      */ 
/*  255 */     if (this.log.isTraceEnabled())
/*      */     {
/*  257 */       StringWriter traceWriter = new StringWriter();
/*  258 */       contentWriter = new ContentWriter(traceWriter, propertyIsTrueOrNotSet("org.jboss.xml.binding.marshalling.indent"));
/*      */ 
/*  261 */       this.content.handleContent(contentWriter);
/*  262 */       this.log.trace("marshalled:\n" + traceWriter.getBuffer().toString());
/*      */     }
/*      */   }
/*      */ 
/*      */   private boolean marshalElementOccurence(ElementBinding element, Object value, boolean optional, boolean declareNs)
/*      */   {
/*  271 */     QName xsiTypeQName = null;
/*  272 */     TypeBinding xsiType = null;
/*  273 */     if (value != null)
/*      */     {
/*  275 */       QName typeQName = element.getType().getQName();
/*  276 */       xsiTypeQName = (QName)this.cls2TypeMap.get(value.getClass());
/*      */ 
/*  278 */       if ((xsiTypeQName != null) && ((!typeQName.getLocalPart().equals(xsiTypeQName.getLocalPart())) || (!typeQName.getNamespaceURI().equals(xsiTypeQName.getNamespaceURI()))))
/*      */       {
/*  283 */         if (this.log.isTraceEnabled())
/*      */         {
/*  285 */           this.log.trace(value.getClass() + " is mapped to xsi:type " + xsiTypeQName);
/*      */         }
/*      */ 
/*  288 */         xsiType = this.schema.getType(xsiTypeQName);
/*  289 */         if (xsiType == null)
/*      */         {
/*  291 */           this.log.warn("Class " + value.getClass() + " is mapped to type " + xsiTypeQName + " but the type is not found in schema.");
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  302 */     TermBeforeMarshallingCallback marshallingHandler = element.getBeforeMarshallingCallback();
/*  303 */     if (marshallingHandler != null)
/*      */     {
/*  305 */       value = marshallingHandler.beforeMarshalling(value, this.ctx);
/*      */     }
/*      */ 
/*  308 */     this.stack.push(value);
/*  309 */     boolean marshalled = marshalElement(element, xsiType, optional, declareNs);
/*  310 */     this.stack.pop();
/*      */ 
/*  312 */     return marshalled;
/*      */   }
/*      */ 
/*      */   private boolean marshalElement(ElementBinding element, TypeBinding xsiType, boolean optional, boolean declareNs)
/*      */   {
/*  317 */     Object value = this.stack.peek();
/*  318 */     boolean nillable = element.isNillable();
/*  319 */     boolean result = (value != null) || ((value == null) && ((optional) || (nillable)));
/*  320 */     boolean trace = (this.log.isTraceEnabled()) && (result);
/*  321 */     if (trace)
/*      */     {
/*  323 */       this.log.trace("started element " + element.getQName());
/*      */     }
/*      */ 
/*  326 */     if (value != null)
/*      */     {
/*  328 */       boolean declareXsiType = xsiType != null;
/*  329 */       marshalElementType(element.getQName(), declareXsiType ? xsiType : element.getType(), declareNs, declareXsiType);
/*      */     }
/*  335 */     else if (nillable)
/*      */     {
/*  337 */       writeNillable(element.getQName(), nillable);
/*      */     }
/*      */ 
/*  340 */     if (trace)
/*      */     {
/*  342 */       this.log.trace("finished element " + element.getQName());
/*      */     }
/*      */ 
/*  345 */     return result;
/*      */   }
/*      */ 
/*      */   private void marshalElementType(QName elementQName, TypeBinding type, boolean declareNs, boolean declareXsiType)
/*      */   {
/*  353 */     String elementNs = elementQName.getNamespaceURI();
/*  354 */     String elementLocal = elementQName.getLocalPart();
/*      */ 
/*  356 */     XOPMarshaller xopMarshaller = this.schema.getXopMarshaller();
/*  357 */     if (xopMarshaller == null)
/*      */     {
/*  359 */       xopMarshaller = type.getXopMarshaller();
/*      */     }
/*      */ 
/*  362 */     if ((xopMarshaller != null) && (isXopOptimizable(type)))
/*      */     {
/*  365 */       if (xopMarshaller.isXOPPackage())
/*      */       {
/*  368 */         Object o = this.stack.peek();
/*  369 */         String cid = xopMarshaller.addMtomAttachment(new XOPObject(o), elementNs, elementLocal);
/*      */ 
/*  372 */         AttributesImpl attrs = null;
/*  373 */         String prefix = getPrefix(elementNs);
/*  374 */         boolean genPrefix = (prefix == null) && (elementNs != null) && (elementNs.length() > 0);
/*  375 */         if (genPrefix)
/*      */         {
/*  377 */           prefix = "ns_" + elementLocal;
/*  378 */           attrs = new AttributesImpl(1);
/*  379 */           declareNs(attrs, prefix, elementNs);
/*      */         }
/*      */ 
/*  382 */         String qName = prefixLocalName(prefix, elementLocal);
/*  383 */         this.content.startElement(elementNs, elementLocal, qName, attrs);
/*      */ 
/*  385 */         AttributesImpl xopAttrs = new AttributesImpl(2);
/*  386 */         xopAttrs.add("http://www.w3.org/2001/XMLSchema", "xop", "xmlns:xop", "CDATA", "http://www.w3.org/2004/08/xop/include");
/*  387 */         xopAttrs.add(null, "href", "href", "CDATA", cid);
/*      */ 
/*  389 */         this.content.startElement("http://www.w3.org/2004/08/xop/include", "Include", "xop:Include", xopAttrs);
/*  390 */         this.content.endElement("http://www.w3.org/2004/08/xop/include", "Include", "xop:Include");
/*      */ 
/*  392 */         this.content.endElement(elementNs, elementLocal, qName);
/*      */ 
/*  395 */         return;
/*      */       }
/*      */ 
/*  402 */       if (!type.isSimple())
/*      */       {
/*  404 */         if (type.hasOnlyXmlMimeAttributes())
/*      */         {
/*  406 */           if (this.log.isTraceEnabled())
/*      */           {
/*  408 */             this.log.trace("XML MIME attributes of type " + type.getQName() + " are ignored, the value is marshalled as " + type.getSimpleType().getQName());
/*      */           }
/*      */ 
/*  414 */           type = type.getSimpleType();
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  424 */     if (type.isSimple())
/*      */     {
/*  426 */       marshalSimpleType(elementQName, type, declareNs, declareXsiType);
/*      */     }
/*      */     else
/*      */     {
/*  430 */       marshalComplexType(elementQName, type, declareNs, declareXsiType);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void marshalSimpleType(QName elementQName, TypeBinding type, boolean declareNs, boolean declareXsiType)
/*      */   {
/*  439 */     MarshallingContextImpl.access$202(this.ctx, null);
/*  440 */     if (((declareNs) || (declareXsiType)) && (this.nsRegistry.size() > 0))
/*      */     {
/*  442 */       if (this.ctx.attrs == null)
/*      */       {
/*  444 */         MarshallingContextImpl.access$202(this.ctx, new AttributesImpl(this.nsRegistry.size() + 1));
/*      */       }
/*  446 */       declareNs(this.ctx.attrs);
/*      */     }
/*      */ 
/*  449 */     String elementNs = elementQName.getNamespaceURI();
/*  450 */     String elementLocal = elementQName.getLocalPart();
/*      */ 
/*  452 */     String prefix = getPrefix(elementNs);
/*  453 */     boolean genPrefix = (prefix == null) && (elementNs != null) && (elementNs.length() > 0);
/*  454 */     if (genPrefix)
/*      */     {
/*  456 */       prefix = "ns_" + elementLocal;
/*  457 */       if (this.ctx.attrs == null)
/*      */       {
/*  459 */         MarshallingContextImpl.access$202(this.ctx, new AttributesImpl(1));
/*      */       }
/*  461 */       declareNs(this.ctx.attrs, prefix, elementNs);
/*      */     }
/*      */ 
/*  464 */     if (declareXsiType)
/*      */     {
/*  466 */       declareXsiType(type.getQName(), this.ctx.attrs);
/*      */     }
/*      */ 
/*  469 */     String typeName = type.getQName() == null ? null : type.getQName().getLocalPart();
/*  470 */     if (((this.ctx.attrs == null) && ("QName".equals(typeName))) || ("NOTATION".equals(typeName)) || ((type.getItemType() != null) && (("QName".equals(type.getItemType().getQName().getLocalPart())) || ("NOTATION".equals(type.getItemType().getQName().getLocalPart())))))
/*      */     {
/*  478 */       MarshallingContextImpl.access$202(this.ctx, new AttributesImpl(5));
/*      */     }
/*      */ 
/*  481 */     Object value = this.stack.peek();
/*  482 */     String marshalled = marshalCharacters(elementNs, prefix, type, value);
/*      */ 
/*  484 */     String qName = prefixLocalName(prefix, elementLocal);
/*  485 */     this.content.startElement(elementNs, elementLocal, qName, this.ctx.attrs);
/*  486 */     this.content.characters(marshalled.toCharArray(), 0, marshalled.length());
/*  487 */     this.content.endElement(elementNs, elementLocal, qName);
/*      */   }
/*      */ 
/*      */   private void marshalComplexType(QName elementQName, TypeBinding type, boolean declareNs, boolean declareXsiType)
/*      */   {
/*  495 */     Collection attrBindings = type.getAttributes();
/*  496 */     int attrsTotal = (declareNs) || (declareXsiType) ? this.nsRegistry.size() + attrBindings.size() + 1 : attrBindings.size();
/*  497 */     MarshallingContextImpl.access$202(this.ctx, attrsTotal > 0 ? new AttributesImpl(attrsTotal) : null);
/*      */ 
/*  499 */     if ((declareNs) && (this.nsRegistry.size() > 0))
/*      */     {
/*  501 */       declareNs(this.ctx.attrs);
/*      */     }
/*      */ 
/*  504 */     String generatedPrefix = null;
/*  505 */     if (declareXsiType)
/*      */     {
/*  507 */       generatedPrefix = declareXsiType(type.getQName(), this.ctx.attrs);
/*  508 */       if (generatedPrefix != null)
/*      */       {
/*  510 */         String typeNsWithGeneratedPrefix = type.getQName().getNamespaceURI();
/*  511 */         declareNs(this.ctx.attrs, generatedPrefix, typeNsWithGeneratedPrefix);
/*  512 */         declareNamespace(generatedPrefix, typeNsWithGeneratedPrefix);
/*      */       }
/*      */     }
/*      */ 
/*  516 */     String elementNs = elementQName.getNamespaceURI();
/*  517 */     String elementLocal = elementQName.getLocalPart();
/*      */ 
/*  519 */     String prefix = getPrefix(elementNs);
/*  520 */     boolean genPrefix = (prefix == null) && (elementNs != null) && (elementNs.length() > 0);
/*  521 */     if (genPrefix)
/*      */     {
/*  524 */       prefix = "ns_" + elementLocal;
/*  525 */       declareNamespace(prefix, elementNs);
/*  526 */       if (this.ctx.attrs == null)
/*      */       {
/*  528 */         MarshallingContextImpl.access$202(this.ctx, new AttributesImpl(1));
/*      */       }
/*  530 */       declareNs(this.ctx.attrs, prefix, elementNs);
/*      */     }
/*      */ 
/*  533 */     if (!attrBindings.isEmpty())
/*      */     {
/*  535 */       for (Iterator i = attrBindings.iterator(); i.hasNext(); )
/*      */       {
/*  537 */         AttributeBinding attrBinding = (AttributeBinding)i.next();
/*  538 */         QName attrQName = attrBinding.getQName();
/*      */ 
/*  540 */         if (Constants.QNAME_XMIME_CONTENTTYPE.equals(attrQName))
/*      */         {
/*      */           continue;
/*      */         }
/*      */ 
/*  545 */         MarshallingContextImpl.access$302(this.ctx, attrBinding);
/*  546 */         AttributeMarshaller marshaller = attrBinding.getMarshaller();
/*  547 */         String marshalledAttr = marshaller.marshal(this.ctx);
/*      */ 
/*  549 */         if (marshalledAttr != null)
/*      */         {
/*  551 */           if (this.ctx.attrs == null)
/*      */           {
/*  553 */             MarshallingContextImpl.access$202(this.ctx, new AttributesImpl(5));
/*      */           }
/*      */ 
/*  556 */           String attrNs = attrQName.getNamespaceURI();
/*  557 */           String attrLocal = attrQName.getLocalPart();
/*  558 */           String attrPrefix = null;
/*  559 */           if (attrNs != null)
/*      */           {
/*  561 */             attrPrefix = getPrefix(attrNs);
/*  562 */             if ((attrPrefix == null) && (attrNs != null) && (attrNs.length() > 0))
/*      */             {
/*  564 */               attrPrefix = "ns_" + attrLocal;
/*  565 */               declareNs(this.ctx.attrs, attrPrefix, attrNs);
/*      */             }
/*      */           }
/*      */ 
/*  569 */           String prefixedName = prefixLocalName(attrPrefix, attrLocal);
/*  570 */           this.ctx.attrs.add(attrNs, attrLocal, prefixedName, "CDATA", marshalledAttr);
/*      */         }
/*      */       }
/*  573 */       MarshallingContextImpl.access$302(this.ctx, null);
/*      */     }
/*      */ 
/*  576 */     String characters = null;
/*  577 */     TypeBinding simpleType = type.getSimpleType();
/*  578 */     if ((simpleType != null) && (!Constants.QNAME_ANYTYPE.equals(type.getQName())))
/*      */     {
/*  580 */       String fieldName = this.ctx.getSimpleContentProperty();
/*  581 */       CharactersMetaData charactersMetaData = type.getCharactersMetaData();
/*  582 */       PropertyMetaData propertyMetaData = charactersMetaData == null ? null : charactersMetaData.getProperty();
/*  583 */       if (propertyMetaData != null)
/*      */       {
/*  585 */         fieldName = propertyMetaData.getName();
/*      */       }
/*      */ 
/*  588 */       if (fieldName != null)
/*      */       {
/*  590 */         boolean ignoreUnresolvedFieldOrClass = type.getSchemaBinding().isIgnoreUnresolvedFieldOrClass();
/*  591 */         Object o = this.stack.peek();
/*  592 */         Object value = getElementValue(o, fieldName, ignoreUnresolvedFieldOrClass);
/*  593 */         if (value != null)
/*      */         {
/*  595 */           String typeName = simpleType.getQName().getLocalPart();
/*  596 */           if ((this.ctx.attrs == null) && (("QName".equals(typeName)) || ("NOTATION".equals(typeName)) || ((simpleType.getItemType() != null) && (("QName".equals(simpleType.getItemType().getQName().getLocalPart())) || ("NOTATION".equals(simpleType.getItemType().getQName().getLocalPart()))))))
/*      */           {
/*  605 */             MarshallingContextImpl.access$202(this.ctx, new AttributesImpl(5));
/*      */           }
/*      */ 
/*  608 */           characters = marshalCharacters(elementNs, prefix, simpleType, value);
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  613 */     String qName = prefixLocalName(prefix, elementLocal);
/*  614 */     this.content.startElement(elementNs, elementLocal, qName, this.ctx.attrs);
/*      */ 
/*  616 */     ParticleBinding particle = type.getParticle();
/*  617 */     if (particle != null)
/*      */     {
/*  619 */       marshalParticle(particle, false);
/*      */     }
/*      */ 
/*  622 */     if (characters != null)
/*      */     {
/*  624 */       this.content.characters(characters.toCharArray(), 0, characters.length());
/*      */     }
/*  626 */     this.content.endElement(elementNs, elementLocal, qName);
/*      */ 
/*  628 */     MarshallingContextImpl.access$202(this.ctx, null);
/*      */ 
/*  630 */     if (genPrefix)
/*      */     {
/*  632 */       removePrefixMapping(prefix);
/*      */     }
/*      */ 
/*  635 */     if (generatedPrefix != null)
/*      */     {
/*  637 */       removePrefixMapping(generatedPrefix);
/*      */     }
/*      */   }
/*      */ 
/*      */   private boolean marshalParticle(ParticleBinding particle, boolean declareNs)
/*      */   {
/*  644 */     TermBinding term = particle.getTerm();
/*      */ 
/*  648 */     ParticleBinding ctxParticle = this.ctx.particle;
/*  649 */     MarshallingContextImpl.access$102(this.ctx, particle);
/*      */     boolean marshalled;
/*  651 */     if (term.isModelGroup())
/*      */     {
/*  653 */       ModelGroupBinding modelGroup = (ModelGroupBinding)term;
/*      */       boolean marshalled;
/*  654 */       if ((modelGroup.isSkip()) || (this.stack.isEmpty()))
/*      */       {
/*  656 */         marshalled = marshalModelGroup(modelGroup, declareNs);
/*      */       }
/*      */       else
/*      */       {
/*  660 */         PropertyMetaData propertyMetaData = modelGroup.getPropertyMetaData();
/*  661 */         if (propertyMetaData == null)
/*      */         {
/*  663 */           throw new JBossXBRuntimeException("Currently, property binding metadata must be available for a model group to be marshalled!");
/*      */         }
/*      */ 
/*  668 */         Object o = getChildren(this.stack.peek(), propertyMetaData.getName(), modelGroup.getSchema().isIgnoreUnresolvedFieldOrClass());
/*      */ 
/*  672 */         TermBeforeMarshallingCallback marshallingHandler = modelGroup.getBeforeMarshallingCallback();
/*      */ 
/*  674 */         Iterator i = (o != null) && (isRepeatable(particle)) ? getIterator(o) : null;
/*  675 */         if (i != null)
/*      */         {
/*  677 */           boolean marshalled = true;
/*  678 */           while ((i.hasNext()) && (marshalled))
/*      */           {
/*  680 */             Object value = i.next();
/*      */ 
/*  682 */             if (marshallingHandler != null)
/*      */             {
/*  684 */               value = marshallingHandler.beforeMarshalling(value, this.ctx);
/*      */             }
/*      */ 
/*  687 */             this.stack.push(value);
/*  688 */             marshalled = marshalModelGroup(modelGroup, declareNs);
/*  689 */             this.stack.pop();
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*  694 */         if (marshallingHandler != null)
/*      */         {
/*  696 */           o = marshallingHandler.beforeMarshalling(o, this.ctx);
/*      */         }
/*      */ 
/*  699 */         this.stack.push(o);
/*  700 */         boolean marshalled = marshalModelGroup(modelGroup, declareNs);
/*  701 */         this.stack.pop();
/*      */       }
/*      */ 
/*      */     }
/*  705 */     else if (term.isWildcard())
/*      */     {
/*  707 */       Object o = this.stack.peek();
/*      */ 
/*  709 */       boolean popWildcardValue = false;
/*  710 */       ObjectLocalMarshaller marshaller = null;
/*  711 */       AbstractMarshaller.FieldToWildcardMapping mapping = (AbstractMarshaller.FieldToWildcardMapping)this.field2WildcardMap.get(o.getClass());
/*  712 */       if (mapping != null)
/*      */       {
/*  714 */         marshaller = mapping.marshaller;
/*  715 */         o = mapping.fieldInfo.getValue(o);
/*  716 */         this.stack.push(o);
/*  717 */         popWildcardValue = true;
/*      */       }
/*      */ 
/*  720 */       TermBeforeMarshallingCallback marshallingHandler = term.getBeforeMarshallingCallback();
/*      */ 
/*  722 */       Iterator i = (o != null) && (isRepeatable(particle)) ? getIterator(o) : null;
/*  723 */       if (i != null)
/*      */       {
/*  725 */         boolean marshalled = true;
/*  726 */         while ((i.hasNext()) && (marshalled))
/*      */         {
/*  728 */           Object value = i.next();
/*      */ 
/*  730 */           if (marshallingHandler != null)
/*      */           {
/*  732 */             value = marshallingHandler.beforeMarshalling(value, this.ctx);
/*      */           }
/*      */ 
/*  735 */           marshalled = marshalWildcardOccurence(particle, marshaller, value, declareNs);
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  740 */       if (marshallingHandler != null)
/*      */       {
/*  742 */         o = marshallingHandler.beforeMarshalling(o, this.ctx);
/*      */       }
/*      */ 
/*  745 */       boolean marshalled = marshalWildcardOccurence(particle, marshaller, o, declareNs);
/*      */ 
/*  748 */       if (popWildcardValue)
/*      */       {
/*  750 */         this.stack.pop();
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/*  755 */       ElementBinding element = (ElementBinding)term;
/*  756 */       SchemaBinding schema = element.getSchema();
/*  757 */       Object o = getElementValue(element, schema.isIgnoreLowLine(), schema.isIgnoreUnresolvedFieldOrClass());
/*      */ 
/*  759 */       Iterator i = (o != null) && (isRepeatable(particle)) ? getIterator(o) : null;
/*  760 */       if (i != null)
/*      */       {
/*  762 */         boolean marshalled = true;
/*  763 */         while ((i.hasNext()) && (marshalled))
/*      */         {
/*  765 */           Object value = i.next();
/*  766 */           marshalled = marshalElementOccurence(element, value, particle.getMinOccurs() == 0, declareNs);
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  771 */       marshalled = marshalElementOccurence(element, o, particle.getMinOccurs() == 0, declareNs);
/*      */     }
/*      */ 
/*  775 */     MarshallingContextImpl.access$102(this.ctx, ctxParticle);
/*  776 */     return marshalled;
/*      */   }
/*      */ 
/*      */   private boolean marshalWildcardOccurence(ParticleBinding particle, ObjectLocalMarshaller marshaller, Object value, boolean declareNs)
/*      */   {
/*  784 */     boolean marshalled = true;
/*  785 */     if (marshaller != null)
/*      */     {
/*  787 */       marshaller.marshal(this.ctx, value);
/*      */     }
/*  789 */     else if (value != null)
/*      */     {
/*  791 */       this.stack.push(value);
/*  792 */       marshalled = marshalWildcard(particle, declareNs);
/*  793 */       this.stack.pop();
/*      */     }
/*  795 */     return marshalled;
/*      */   }
/*      */ 
/*      */   private boolean marshalWildcard(ParticleBinding particle, boolean declareNs)
/*      */   {
/*  800 */     WildcardBinding wildcard = (WildcardBinding)particle.getTerm();
/*  801 */     Object o = this.stack.peek();
/*  802 */     AbstractMarshaller.ClassMapping mapping = getClassMapping(o.getClass());
/*  803 */     if (mapping == null)
/*      */     {
/*  806 */       QName autoType = SimpleTypeBindings.typeQName(o.getClass());
/*  807 */       if (autoType != null)
/*      */       {
/*  809 */         String marshalled = SimpleTypeBindings.marshal(autoType.getLocalPart(), o, null);
/*  810 */         this.content.characters(marshalled.toCharArray(), 0, marshalled.length());
/*  811 */         return true;
/*      */       }
/*      */ 
/*  815 */       ObjectLocalMarshaller marshaller = wildcard.getUnresolvedMarshaller();
/*  816 */       if (marshaller != null)
/*      */       {
/*  818 */         marshaller.marshal(this.ctx, o);
/*  819 */         return true;
/*      */       }
/*      */ 
/*  822 */       String msg = "Failed to marshal wildcard: neither class mapping was found for " + o.getClass() + "@" + o.hashCode() + " (toString: " + o + ") nor marshaller for unresolved classes was setup.";
/*      */ 
/*  826 */       if (this.ignoreUnresolvedWildcard)
/*      */       {
/*  828 */         this.log.warn(msg);
/*  829 */         return true;
/*      */       }
/*      */ 
/*  833 */       throw new JBossXBRuntimeException(msg);
/*      */     }
/*      */ 
/*  838 */     Object parentRoot = this.root;
/*  839 */     AbstractMarshaller.Stack parentStack = this.stack;
/*  840 */     SchemaBinding parentSchema = this.schema;
/*      */ 
/*  842 */     this.root = o;
/*  843 */     this.stack = new AbstractMarshaller.StackImpl();
/*  844 */     this.schema = (mapping.schemaUrl == null ? this.schema : XsdBinder.bind(mapping.schemaUrl, this.schemaResolver));
/*      */ 
/*  847 */     if (mapping.elementName != null)
/*      */     {
/*  849 */       ParticleBinding element = this.schema.getElementParticle(mapping.elementName);
/*  850 */       if (element == null)
/*      */       {
/*  852 */         throw new JBossXBRuntimeException("Element " + mapping.elementName + " is not declared in the schema.");
/*      */       }
/*      */ 
/*  855 */       ParticleBinding ctxParticle = this.ctx.particle;
/*  856 */       MarshallingContextImpl.access$102(this.ctx, element);
/*  857 */       boolean marshalled = marshalElementOccurence((ElementBinding)element.getTerm(), this.root, particle.getMinOccurs() == 0, declareNs);
/*  858 */       MarshallingContextImpl.access$102(this.ctx, ctxParticle);
/*      */     }
/*  860 */     else if (mapping.typeName != null)
/*      */     {
/*  862 */       TypeBinding typeDef = this.schema.getType(mapping.typeName);
/*  863 */       if (typeDef == null)
/*      */       {
/*  865 */         throw new JBossXBRuntimeException("Type " + mapping.typeName + " is not defined in the schema.");
/*      */       }
/*      */ 
/*  871 */       if (wildcard.getQName() == null)
/*      */       {
/*  873 */         throw new JBossXBRuntimeException("Expected the wildcard to have a non-null QName.");
/*      */       }
/*      */ 
/*  876 */       ElementBinding element = new ElementBinding(this.schema, wildcard.getQName(), typeDef);
/*  877 */       ParticleBinding ctxParticle = this.ctx.particle;
/*  878 */       MarshallingContextImpl.access$102(this.ctx, new ParticleBinding(element));
/*  879 */       boolean marshalled = marshalElementOccurence(element, this.root, particle.getMinOccurs() == 0, declareNs);
/*  880 */       MarshallingContextImpl.access$102(this.ctx, ctxParticle);
/*      */     }
/*      */     else
/*      */     {
/*  884 */       throw new JBossXBRuntimeException("Class mapping for " + mapping.cls + " is associated with neither global element name nor global type name.");
/*      */     }
/*      */     boolean marshalled;
/*  890 */     this.root = parentRoot;
/*  891 */     this.stack = parentStack;
/*  892 */     this.schema = parentSchema;
/*      */ 
/*  894 */     return marshalled;
/*      */   }
/*      */ 
/*      */   private boolean marshalModelGroup(ModelGroupBinding modelGroup, boolean declareNs)
/*      */   {
/*      */     boolean marshalled;
/*      */     boolean marshalled;
/*  900 */     if ((modelGroup instanceof AllBinding))
/*      */     {
/*  902 */       marshalled = marshalModelGroupAll(modelGroup.getParticles(), declareNs);
/*      */     }
/*      */     else
/*      */     {
/*      */       boolean marshalled;
/*  904 */       if ((modelGroup instanceof ChoiceBinding))
/*      */       {
/*  906 */         marshalled = marshalModelGroupChoice(modelGroup.getParticles(), declareNs);
/*      */       }
/*      */       else
/*      */       {
/*  910 */         marshalled = marshalModelGroupSequence(modelGroup, declareNs);
/*      */       }
/*      */     }
/*  912 */     return marshalled;
/*      */   }
/*      */ 
/*      */   private boolean marshalModelGroupAll(Collection particles, boolean declareNs)
/*      */   {
/*  917 */     boolean marshalled = false;
/*  918 */     for (Iterator i = particles.iterator(); i.hasNext(); )
/*      */     {
/*  920 */       ParticleBinding particle = (ParticleBinding)i.next();
/*  921 */       marshalled |= marshalParticle(particle, declareNs);
/*      */     }
/*  923 */     return marshalled;
/*      */   }
/*      */ 
/*      */   private boolean marshalModelGroupChoice(Collection particles, boolean declareNs)
/*      */   {
/*  928 */     boolean marshalled = false;
/*  929 */     Content mainContent = this.content;
/*  930 */     for (Iterator i = particles.iterator(); (i.hasNext()) && (!marshalled); )
/*      */     {
/*  932 */       ParticleBinding particle = (ParticleBinding)i.next();
/*  933 */       this.content = new Content();
/*  934 */       marshalled = marshalParticle(particle, declareNs);
/*      */     }
/*      */ 
/*  937 */     if (marshalled)
/*      */     {
/*  939 */       mainContent.append(this.content);
/*      */     }
/*  941 */     this.content = mainContent;
/*      */ 
/*  943 */     return marshalled;
/*      */   }
/*      */ 
/*      */   private boolean marshalModelGroupSequence(ModelGroupBinding sequence, boolean declareNs)
/*      */   {
/*  950 */     Iterator valueIterator = null;
/*  951 */     if ((!sequence.isSkip()) && (!this.stack.isEmpty()))
/*      */     {
/*  953 */       Object o = this.stack.peek();
/*  954 */       if ((o != null) && ((Collection.class.isAssignableFrom(o.getClass())) || (o.getClass().isArray())))
/*      */       {
/*  956 */         valueIterator = getIterator(o);
/*      */       }
/*      */     }
/*      */ 
/*  960 */     boolean marshalled = true;
/*  961 */     for (Iterator i = sequence.getParticles().iterator(); i.hasNext(); )
/*      */     {
/*  963 */       if (valueIterator != null)
/*      */       {
/*  965 */         Object o = valueIterator.hasNext() ? valueIterator.next() : null;
/*  966 */         this.stack.push(o);
/*      */       }
/*      */ 
/*  969 */       ParticleBinding particle = (ParticleBinding)i.next();
/*  970 */       marshalled &= marshalParticle(particle, declareNs);
/*      */ 
/*  972 */       if (valueIterator != null)
/*      */       {
/*  974 */         this.stack.pop();
/*      */       }
/*      */     }
/*  977 */     return marshalled;
/*      */   }
/*      */ 
/*      */   private String marshalCharacters(String elementUri, String elementPrefix, TypeBinding simpleType, Object value)
/*      */   {
/*  986 */     QName simpleTypeQName = simpleType.getQName();
/*      */     String marshalled;
/*      */     String marshalled;
/*  987 */     if (simpleType.getItemType() != null)
/*      */     {
/*  989 */       TypeBinding itemType = simpleType.getItemType();
/*      */       String marshalled;
/*  990 */       if ("http://www.w3.org/2001/XMLSchema".equals(itemType.getQName().getNamespaceURI()))
/*      */       {
/*      */         List list;
/*  993 */         if ((value instanceof List))
/*      */         {
/*  995 */           list = (List)value;
/*      */         }
/*      */         else
/*      */         {
/*      */           List list;
/*  997 */           if (value.getClass().isArray())
/*      */           {
/*  999 */             list = asList(value);
/*      */           }
/*      */           else
/*      */           {
/* 1004 */             throw new JBossXBRuntimeException("Expected value for list type is an array or " + List.class.getName() + " but got: " + value);
/*      */           }
/*      */         }
/*      */         List list;
/* 1009 */         marshalled = SimpleTypeBindings.marshalList(itemType.getQName().getLocalPart(), list, null);
/*      */       }
/*      */       else
/*      */       {
/* 1013 */         throw new JBossXBRuntimeException("Marshalling of list types with item types not from http://www.w3.org/2001/XMLSchema is not supported.");
/*      */       }
/*      */ 
/*      */     }
/* 1018 */     else if ((simpleTypeQName != null) && ("http://www.w3.org/2001/XMLSchema".equals(simpleTypeQName.getNamespaceURI())))
/*      */     {
/* 1020 */       String typeName = simpleTypeQName.getLocalPart();
/*      */ 
/* 1022 */       String prefix = null;
/* 1023 */       boolean removePrefix = false;
/* 1024 */       if (("QName".equals(typeName)) || ("NOTATION".equals(typeName)))
/*      */       {
/* 1027 */         QName qNameValue = (QName)value;
/* 1028 */         if ((qNameValue.getNamespaceURI() != null) && (qNameValue.getNamespaceURI().length() > 0))
/*      */         {
/* 1030 */           prefix = this.nsRegistry.getPrefix(qNameValue.getNamespaceURI());
/* 1031 */           if (prefix == null)
/*      */           {
/* 1033 */             prefix = qNameValue.getPrefix();
/* 1034 */             if ((prefix == null) || (prefix.length() == 0))
/*      */             {
/* 1036 */               prefix = qNameValue.getLocalPart() + "_ns";
/*      */             }
/* 1038 */             this.nsRegistry.addPrefixMapping(prefix, qNameValue.getNamespaceURI());
/* 1039 */             this.ctx.declareNamespace(prefix, qNameValue.getNamespaceURI());
/*      */ 
/* 1041 */             removePrefix = true;
/*      */           }
/*      */         }
/*      */       }
/*      */ 
/* 1046 */       String marshalled = SimpleTypeBindings.marshal(typeName, value, this.nsRegistry);
/*      */ 
/* 1048 */       if (removePrefix)
/*      */       {
/* 1050 */         this.nsRegistry.removePrefixMapping(prefix);
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/*      */       String marshalled;
/* 1054 */       if ((simpleType.getLexicalPattern() != null) && (simpleType.getBaseType() != null) && (Constants.QNAME_BOOLEAN.equals(simpleType.getBaseType().getQName())))
/*      */       {
/* 1058 */         String item = (String)simpleType.getLexicalPattern().get(0);
/*      */         String marshalled;
/* 1059 */         if ((item.indexOf('0') != -1) && (item.indexOf('1') != -1))
/*      */         {
/* 1061 */           marshalled = ((Boolean)value).booleanValue() ? "1" : "0";
/*      */         }
/*      */         else
/*      */         {
/* 1065 */           marshalled = ((Boolean)value).booleanValue() ? "true" : "false";
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/* 1070 */         if (simpleType.getLexicalEnumeration() != null)
/*      */         {
/*      */           Method getValue;
/*      */           try {
/* 1075 */             getValue = value.getClass().getMethod("value", null);
/*      */           }
/*      */           catch (NoSuchMethodException e)
/*      */           {
/*      */             try
/*      */             {
/* 1081 */               getValue = value.getClass().getMethod("getValue", null);
/*      */             }
/*      */             catch (NoSuchMethodException e1)
/*      */             {
/* 1085 */               throw new JBossXBRuntimeException("Failed to find neither value() nor getValue() in " + value.getClass() + " which is bound to enumeration type " + simpleTypeQName);
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/*      */           try
/*      */           {
/* 1094 */             value = getValue.invoke(value, null);
/*      */           }
/*      */           catch (Exception e)
/*      */           {
/* 1098 */             throw new JBossXBRuntimeException("Failed to invoke getValue() on " + value + " to get the enumeration value", e);
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/* 1104 */         marshalled = marshalCharacters(elementUri, elementPrefix, simpleType.getBaseType(), value);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1110 */     return marshalled;
/*      */   }
/*      */ 
/*      */   private void writeNillable(QName elementQName, boolean nillable)
/*      */   {
/* 1115 */     if (!this.supportNil)
/*      */     {
/* 1117 */       return;
/*      */     }
/*      */ 
/* 1120 */     if (!nillable)
/*      */     {
/* 1122 */       throw new JBossXBRuntimeException("Failed to marshal " + elementQName + ": Java value is null but the element is not nillable.");
/*      */     }
/*      */ 
/* 1128 */     String elementNs = elementQName.getNamespaceURI();
/* 1129 */     String elementLocal = elementQName.getLocalPart();
/*      */ 
/* 1132 */     String prefix = getPrefix(elementNs);
/*      */     AttributesImpl attrs;
/* 1133 */     if ((prefix == null) && (elementNs != null) && (elementNs.length() > 0))
/*      */     {
/* 1135 */       prefix = "ns_" + elementLocal;
/* 1136 */       AttributesImpl attrs = new AttributesImpl(2);
/* 1137 */       declareNs(attrs, prefix, elementNs);
/*      */     }
/*      */     else
/*      */     {
/* 1141 */       attrs = new AttributesImpl(1);
/*      */     }
/*      */ 
/* 1144 */     String xsiPrefix = getPrefix("http://www.w3.org/2001/XMLSchema-instance");
/* 1145 */     if (xsiPrefix == null)
/*      */     {
/* 1147 */       xsiPrefix = "xsi";
/* 1148 */       declareNs(attrs, "xsi", "http://www.w3.org/2001/XMLSchema-instance");
/*      */     }
/*      */ 
/* 1151 */     String nilQName = xsiPrefix + ":nil";
/* 1152 */     attrs.add("http://www.w3.org/2001/XMLSchema-instance", "nil", nilQName, null, "1");
/*      */ 
/* 1154 */     String qName = prefixLocalName(prefix, elementLocal);
/* 1155 */     this.content.startElement(elementNs, elementLocal, qName, attrs);
/* 1156 */     this.content.endElement(elementNs, elementLocal, qName);
/*      */   }
/*      */ 
/*      */   private Object getElementValue(ElementBinding element, boolean ignoreLowLine, boolean ignoreNotFoundField)
/*      */   {
/* 1164 */     Object peeked = this.stack.peek();
/*      */     Object value;
/*      */     Object value;
/* 1165 */     if (peeked == null)
/*      */     {
/* 1167 */       value = null;
/*      */     }
/*      */     else
/*      */     {
/*      */       Object value;
/* 1169 */       if (((peeked instanceof Collection)) || (peeked.getClass().isArray()))
/*      */       {
/* 1171 */         value = peeked;
/*      */       }
/*      */       else
/*      */       {
/* 1175 */         String fieldName = null;
/* 1176 */         PropertyMetaData propertyMetaData = element.getPropertyMetaData();
/* 1177 */         if (propertyMetaData != null)
/*      */         {
/* 1179 */           fieldName = propertyMetaData.getName();
/*      */         }
/*      */ 
/* 1182 */         if (fieldName == null)
/*      */         {
/* 1184 */           fieldName = Util.xmlNameToFieldName(element.getQName().getLocalPart(), ignoreLowLine);
/*      */         }
/*      */ 
/* 1187 */         value = getChildren(peeked, fieldName, ignoreNotFoundField);
/* 1188 */         if (value == null)
/*      */         {
/* 1190 */           value = getElementValue(peeked, fieldName, ignoreNotFoundField);
/*      */         }
/*      */       }
/*      */     }
/* 1193 */     return value;
/*      */   }
/*      */ 
/*      */   private static boolean isArrayWrapper(TypeBinding type)
/*      */   {
/* 1198 */     boolean is = false;
/* 1199 */     if (!type.isSimple())
/*      */     {
/* 1201 */       ParticleBinding particle = type.getParticle();
/* 1202 */       if (particle != null)
/*      */       {
/* 1204 */         is = (particle.getMaxOccursUnbounded()) || (particle.getMaxOccurs() > 1);
/*      */       }
/*      */     }
/* 1207 */     return is;
/*      */   }
/*      */ 
/*      */   private Iterator getIterator(Object value)
/*      */   {
/* 1212 */     Iterator i = null;
/* 1213 */     if ((value instanceof Collection))
/*      */     {
/* 1215 */       i = ((Collection)value).iterator();
/*      */     }
/* 1217 */     else if (value.getClass().isArray())
/*      */     {
/* 1219 */       Object arr = value;
/* 1220 */       i = new Iterator(arr)
/*      */       {
/* 1222 */         private int curInd = 0;
/* 1223 */         private int length = Array.getLength(this.val$arr);
/*      */ 
/*      */         public boolean hasNext()
/*      */         {
/* 1227 */           return this.curInd < this.length;
/*      */         }
/*      */ 
/*      */         public Object next()
/*      */         {
/* 1232 */           return Array.get(this.val$arr, this.curInd++);
/*      */         }
/*      */ 
/*      */         public void remove()
/*      */         {
/* 1237 */           throw new UnsupportedOperationException("remove is not implemented.");
/*      */         } } ;
/*      */     }
/* 1241 */     else if ((value instanceof Iterator))
/*      */     {
/* 1243 */       i = (Iterator)value;
/*      */     }
/*      */ 
/* 1249 */     return i;
/*      */   }
/*      */ 
/*      */   private static Object getChildren(Object o, String fieldName, boolean ignoreNotFoundField)
/*      */   {
/* 1254 */     Object children = null;
/* 1255 */     if (!writeAsValue(o.getClass()))
/*      */     {
/* 1257 */       children = getJavaValue(fieldName, o, true, ignoreNotFoundField);
/*      */     }
/* 1259 */     return children;
/*      */   }
/*      */ 
/*      */   private static Object getJavaValue(String fieldName, Object o, boolean forComplexType, boolean ignoreNotFoundField)
/*      */   {
/* 1267 */     FieldInfo fieldInfo = FieldInfo.getFieldInfo(o.getClass(), fieldName, !ignoreNotFoundField);
/* 1268 */     Object value = null;
/* 1269 */     if ((fieldInfo != null) && ((!forComplexType) || ((forComplexType) && (!writeAsValue(fieldInfo.getType())))))
/*      */     {
/* 1271 */       value = fieldInfo.getValue(o);
/*      */     }
/* 1273 */     return value;
/*      */   }
/*      */ 
/*      */   private static Object getElementValue(Object o, String fieldName, boolean ignoreNotFoundField)
/*      */   {
/*      */     Object value;
/*      */     Object value;
/* 1279 */     if (writeAsValue(o.getClass()))
/*      */     {
/* 1281 */       value = o;
/*      */     }
/*      */     else
/*      */     {
/* 1285 */       value = getJavaValue(fieldName, o, false, ignoreNotFoundField);
/*      */     }
/*      */ 
/* 1288 */     return value;
/*      */   }
/*      */ 
/*      */   private static boolean writeAsValue(Class type)
/*      */   {
/* 1293 */     return (Classes.isPrimitive(type)) || (type == String.class) || (type == Date.class) || (type == BigDecimal.class) || (type == BigInteger.class);
/*      */   }
/*      */ 
/*      */   private static boolean isRepeatable(ParticleBinding particle)
/*      */   {
/* 1302 */     return (particle.getMaxOccursUnbounded()) || (particle.getMaxOccurs() > 1) || (particle.getMinOccurs() > 1);
/*      */   }
/*      */ 
/*      */   private static final List asList(Object arr)
/*      */   {
/* 1307 */     return new AbstractList(arr)
/*      */     {
/* 1309 */       private final Object array = this.val$arr;
/*      */ 
/*      */       public Object get(int index)
/*      */       {
/* 1313 */         return Array.get(this.array, index);
/*      */       }
/*      */ 
/*      */       public int size()
/*      */       {
/* 1318 */         return Array.getLength(this.array);
/*      */       }
/*      */     };
/*      */   }
/*      */ 
/*      */   private static boolean isXopOptimizable(TypeBinding type) {
/* 1325 */     while (type != null)
/*      */     {
/* 1327 */       if (Constants.QNAME_BASE64BINARY.equals(type.getQName()))
/*      */       {
/* 1329 */         return true;
/*      */       }
/* 1331 */       type = type.getBaseType();
/*      */     }
/* 1333 */     return false;
/*      */   }
/*      */   private class MarshallingContextImpl implements MarshallingContext {
/*      */     private ContentHandler ch;
/*      */     private AttributeBinding attr;
/*      */     private ParticleBinding particle;
/*      */     private AttributesImpl attrs;
/*      */ 
/*      */     private MarshallingContextImpl() {  }
/*      */ 
/* 1346 */     public boolean isAttributeRequired() { throw new UnsupportedOperationException();
/*      */     }
/*      */ 
/*      */     public boolean isTypeComplex()
/*      */     {
/* 1351 */       throw new UnsupportedOperationException();
/*      */     }
/*      */ 
/*      */     public String getSimpleContentProperty()
/*      */     {
/* 1356 */       return MarshallerImpl.this.schema.getSimpleContentProperty();
/*      */     }
/*      */ 
/*      */     public ContentHandler getContentHandler()
/*      */     {
/* 1361 */       if (this.ch == null)
/*      */       {
/* 1363 */         this.ch = new AbstractMarshaller.ContentHandlerAdaptor(MarshallerImpl.this);
/*      */       }
/* 1365 */       return this.ch;
/*      */     }
/*      */ 
/*      */     public SchemaBinding getSchemaBinding()
/*      */     {
/* 1370 */       return MarshallerImpl.this.schema;
/*      */     }
/*      */ 
/*      */     public AttributeBinding getAttributeBinding()
/*      */     {
/* 1375 */       return this.attr;
/*      */     }
/*      */ 
/*      */     public String getPrefix(String ns)
/*      */     {
/* 1380 */       return MarshallerImpl.this.getPrefix(ns);
/*      */     }
/*      */ 
/*      */     public void declareNamespace(String prefix, String ns)
/*      */     {
/* 1385 */       MarshallerImpl.access$500(this.attrs, prefix, ns);
/* 1386 */       MarshallerImpl.this.nsRegistry.addPrefixMapping(prefix, ns);
/*      */     }
/*      */ 
/*      */     public NamespaceRegistry getNamespaceContext()
/*      */     {
/* 1391 */       return MarshallerImpl.this.nsRegistry;
/*      */     }
/*      */ 
/*      */     public Object peek()
/*      */     {
/* 1396 */       return MarshallerImpl.this.stack.isEmpty() ? null : MarshallerImpl.this.stack.peek();
/*      */     }
/*      */ 
/*      */     public ParticleBinding getParticleBinding()
/*      */     {
/* 1401 */       return this.particle;
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.sunday.marshalling.MarshallerImpl
 * JD-Core Version:    0.6.0
 */