/*     */ package org.jboss.xb.binding.sunday.marshalling;
/*     */ 
/*     */ import java.util.Arrays;
/*     */ import java.util.List;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.xb.binding.Constants;
/*     */ import org.jboss.xb.binding.JBossXBRuntimeException;
/*     */ import org.jboss.xb.binding.NamespaceRegistry;
/*     */ import org.jboss.xb.binding.SimpleTypeBindings;
/*     */ import org.jboss.xb.binding.Util;
/*     */ import org.jboss.xb.binding.introspection.FieldInfo;
/*     */ import org.jboss.xb.binding.metadata.PropertyMetaData;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.AttributeBinding;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;
/*     */ 
/*     */ public class DefaultAttributeMarshaller extends AbstractAttributeMarshaller
/*     */ {
/*  45 */   public static final DefaultAttributeMarshaller INSTANCE = new DefaultAttributeMarshaller();
/*     */ 
/*     */   public Object getValue(MarshallingContext ctx)
/*     */   {
/*  49 */     Object owner = ctx.peek();
/*  50 */     SchemaBinding schema = ctx.getSchemaBinding();
/*  51 */     AttributeBinding binding = ctx.getAttributeBinding();
/*  52 */     QName qName = binding.getQName();
/*     */ 
/*  54 */     String fieldName = null;
/*  55 */     PropertyMetaData propertyMetaData = binding.getPropertyMetaData();
/*  56 */     if (propertyMetaData != null)
/*     */     {
/*  58 */       fieldName = propertyMetaData.getName();
/*     */     }
/*     */ 
/*  61 */     if (fieldName == null)
/*     */     {
/*  63 */       fieldName = Util.xmlNameToFieldName(qName.getLocalPart(), schema.isIgnoreLowLine());
/*     */     }
/*     */ 
/*  67 */     FieldInfo fieldInfo = FieldInfo.getFieldInfo(owner.getClass(), fieldName, (binding.getRequired()) && (!schema.isIgnoreUnresolvedFieldOrClass()));
/*     */ 
/*  70 */     Object value = null;
/*  71 */     if (fieldInfo != null)
/*     */     {
/*  73 */       value = fieldInfo.getValue(owner);
/*     */     }
/*     */ 
/*  76 */     return value;
/*     */   }
/*     */ 
/*     */   public String marshalValue(MarshallingContext ctx, Object value)
/*     */   {
/*  81 */     if (value == null)
/*     */     {
/*  83 */       return null;
/*     */     }
/*     */ 
/*  88 */     AttributeBinding binding = ctx.getAttributeBinding();
/*  89 */     TypeBinding attrType = binding.getType();
/*     */     String marshalled;
/*     */     String marshalled;
/*  91 */     if (attrType.getItemType() != null)
/*     */     {
/*  93 */       TypeBinding itemType = attrType.getItemType();
/*     */       String marshalled;
/*  94 */       if ("http://www.w3.org/2001/XMLSchema".equals(itemType.getQName().getNamespaceURI()))
/*     */       {
/*     */         List list;
/*  97 */         if ((value instanceof List))
/*     */         {
/*  99 */           list = (List)value;
/*     */         }
/*     */         else
/*     */         {
/*     */           List list;
/* 101 */           if (value.getClass().isArray())
/*     */           {
/* 103 */             list = Arrays.asList((Object[])(Object[])value);
/*     */           }
/*     */           else
/*     */           {
/* 107 */             throw new JBossXBRuntimeException("Expected value for list type is an array or " + List.class.getName() + " but got: " + value);
/*     */           }
/*     */         }
/*     */         List list;
/* 114 */         if (Constants.QNAME_QNAME.getLocalPart().equals(itemType.getQName().getLocalPart()))
/*     */         {
/* 116 */           String attrLocal = binding.getQName().getLocalPart();
/* 117 */           for (int listInd = 0; listInd < list.size(); listInd++)
/*     */           {
/* 119 */             QName item = (QName)list.get(listInd);
/* 120 */             String itemNs = item.getNamespaceURI();
/* 121 */             if ((itemNs == null) || (itemNs.length() <= 0))
/*     */               continue;
/* 123 */             String itemPrefix = ctx.getPrefix(itemNs);
/* 124 */             if (itemPrefix == null)
/*     */             {
/* 126 */               itemPrefix = item.getPrefix();
/* 127 */               if ((itemPrefix == null) || (itemPrefix.length() == 0))
/*     */               {
/* 129 */                 itemPrefix = attrLocal + listInd;
/*     */               }
/* 131 */               ctx.declareNamespace(itemPrefix, itemNs);
/*     */             }
/*     */ 
/* 134 */             if (itemPrefix.equals(item.getPrefix()))
/*     */               continue;
/* 136 */             item = new QName(item.getNamespaceURI(), item.getLocalPart(), itemPrefix);
/* 137 */             list.set(listInd, item);
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/* 143 */         marshalled = SimpleTypeBindings.marshalList(itemType.getQName().getLocalPart(), list, null);
/*     */       }
/*     */       else
/*     */       {
/* 147 */         throw new JBossXBRuntimeException("Marshalling of list types with item types not from http://www.w3.org/2001/XMLSchema is not supported.");
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/*     */       String marshalled;
/* 152 */       if ((attrType.getLexicalPattern() != null) && (attrType.getBaseType() != null) && (Constants.QNAME_BOOLEAN.equals(attrType.getBaseType().getQName())))
/*     */       {
/* 156 */         String item = (String)attrType.getLexicalPattern().get(0);
/*     */         String marshalled;
/* 157 */         if ((item.indexOf('0') != -1) && (item.indexOf('1') != -1))
/*     */         {
/* 159 */           marshalled = ((Boolean)value).booleanValue() ? "1" : "0";
/*     */         }
/*     */         else
/*     */         {
/* 163 */           marshalled = ((Boolean)value).booleanValue() ? "true" : "false";
/*     */         }
/*     */       }
/* 166 */       else if (Constants.QNAME_QNAME.equals(attrType.getQName()))
/*     */       {
/* 168 */         boolean removePrefix = false;
/* 169 */         String prefix = null;
/* 170 */         String ns = ((QName)value).getNamespaceURI();
/* 171 */         if ((ns != null) && (ns.length() > 0))
/*     */         {
/* 173 */           prefix = ctx.getPrefix(ns);
/* 174 */           if (prefix == null)
/*     */           {
/* 176 */             prefix = ((QName)value).getPrefix();
/* 177 */             if ((prefix == null) || (prefix.length() == 0))
/*     */             {
/* 179 */               prefix = "ns_" + ((QName)value).getLocalPart();
/*     */             }
/* 181 */             ctx.declareNamespace(prefix, ns);
/*     */           }
/* 183 */           ctx.getNamespaceContext().addPrefixMapping(prefix, ns);
/* 184 */           removePrefix = true;
/*     */         }
/*     */ 
/* 187 */         String marshalled = SimpleTypeBindings.marshalQName((QName)value, ctx.getNamespaceContext());
/*     */ 
/* 189 */         if (removePrefix)
/*     */         {
/* 191 */           ctx.getNamespaceContext().removePrefixMapping(prefix);
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 196 */         marshalled = value.toString();
/*     */       }
/*     */     }
/* 199 */     return marshalled;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.sunday.marshalling.DefaultAttributeMarshaller
 * JD-Core Version:    0.6.0
 */