/*     */ package org.jboss.xb.binding.parser.sax;
/*     */ 
/*     */ import java.io.InputStream;
/*     */ import java.io.Reader;
/*     */ import java.lang.reflect.Method;
/*     */ import javax.xml.parsers.SAXParser;
/*     */ import javax.xml.parsers.SAXParserFactory;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ import org.jboss.util.xml.JBossEntityResolver;
/*     */ import org.jboss.xb.binding.JBossXBException;
/*     */ import org.jboss.xb.binding.JBossXBRuntimeException;
/*     */ import org.jboss.xb.binding.parser.JBossXBParser;
/*     */ import org.jboss.xb.binding.parser.JBossXBParser.ContentHandler;
/*     */ import org.jboss.xb.binding.parser.JBossXBParser.DtdAwareContentHandler;
/*     */ import org.xml.sax.Attributes;
/*     */ import org.xml.sax.ContentHandler;
/*     */ import org.xml.sax.EntityResolver;
/*     */ import org.xml.sax.ErrorHandler;
/*     */ import org.xml.sax.InputSource;
/*     */ import org.xml.sax.Locator;
/*     */ import org.xml.sax.SAXException;
/*     */ import org.xml.sax.SAXParseException;
/*     */ import org.xml.sax.XMLReader;
/*     */ import org.xml.sax.ext.LexicalHandler;
/*     */ 
/*     */ public class SaxJBossXBParser
/*     */   implements JBossXBParser
/*     */ {
/*  52 */   private static final Logger log = Logger.getLogger(SaxJBossXBParser.class);
/*     */ 
/*  54 */   private static final SAXParserFactory saxFactory = SAXParserFactory.newInstance();
/*     */   private final SAXParser parser;
/*     */   private final XMLReader reader;
/*     */   private JBossXBParser.ContentHandler contentHandler;
/*     */   private DelegatingContentHandler delegateHandler;
/*     */   private boolean trace;
/*     */ 
/*     */   private static void enableXInclude()
/*     */   {
/*     */     try
/*     */     {
/*  77 */       Class clazz = saxFactory.getClass();
/*  78 */       Method method = clazz.getMethod("setXIncludeAware", new Class[] { Boolean.TYPE });
/*  79 */       method.invoke(saxFactory, new Object[] { Boolean.TRUE });
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  83 */       log.trace("Not setting XIncludeAware", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public SaxJBossXBParser()
/*     */     throws JBossXBException
/*     */   {
/*     */     try
/*     */     {
/*  92 */       this.parser = saxFactory.newSAXParser();
/*  93 */       logParserInfo();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  97 */       throw new JBossXBException("Failed to create a new SAX parser", e);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 102 */       this.reader = this.parser.getXMLReader();
/*     */     }
/*     */     catch (SAXException e1)
/*     */     {
/* 106 */       throw new JBossXBRuntimeException("Failed to get parser's XMLReader", e1);
/*     */     }
/*     */ 
/* 109 */     this.delegateHandler = new DelegatingContentHandler(null);
/* 110 */     this.reader.setContentHandler(this.delegateHandler);
/* 111 */     this.reader.setErrorHandler(MetaDataErrorHandler.INSTANCE);
/* 112 */     this.reader.setEntityResolver(new JBossEntityResolver());
/*     */     try
/*     */     {
/* 116 */       this.reader.setProperty("http://xml.org/sax/properties/lexical-handler", this.delegateHandler);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 120 */       log.debug("LexicalHandler", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setEntityResolver(EntityResolver entityResolver)
/*     */     throws JBossXBException
/*     */   {
/* 137 */     this.reader.setEntityResolver(entityResolver);
/*     */   }
/*     */ 
/*     */   public void setProperty(String name, Object value)
/*     */   {
/*     */     try
/*     */     {
/* 144 */       this.reader.setProperty(name, value);
/*     */     }
/*     */     catch (SAXException e)
/*     */     {
/* 148 */       throw new JBossXBRuntimeException("Failed to set property on the XML reader", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setFeature(String name, boolean value)
/*     */   {
/*     */     try
/*     */     {
/* 156 */       this.reader.setFeature(name, value);
/* 157 */       log.debug(name + " set to: " + this.reader.getFeature(name));
/*     */     }
/*     */     catch (SAXException e)
/*     */     {
/* 161 */       throw new JBossXBRuntimeException("Failed to set feature on the XMLReader", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void parse(String systemId, JBossXBParser.ContentHandler handler) throws JBossXBException
/*     */   {
/* 167 */     this.contentHandler = handler;
/* 168 */     this.trace = log.isTraceEnabled();
/*     */ 
/* 170 */     logParserInfo();
/*     */     try
/*     */     {
/* 173 */       this.reader.parse(systemId);
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 177 */       throw new JBossXBException("Failed to parse source: " + getLocationAsString(systemId), e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void parse(InputStream is, JBossXBParser.ContentHandler handler) throws JBossXBException
/*     */   {
/* 183 */     this.contentHandler = handler;
/* 184 */     this.trace = log.isTraceEnabled();
/*     */ 
/* 186 */     logParserInfo();
/*     */     try
/*     */     {
/* 189 */       this.reader.parse(new InputSource(is));
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 193 */       throw new JBossXBException("Failed to parse source: " + e.getMessage(), e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void parse(Reader reader, JBossXBParser.ContentHandler handler) throws JBossXBException
/*     */   {
/* 199 */     this.contentHandler = handler;
/* 200 */     this.trace = log.isTraceEnabled();
/*     */ 
/* 202 */     logParserInfo();
/*     */     try
/*     */     {
/* 205 */       this.reader.parse(new InputSource(reader));
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 209 */       throw new JBossXBException("Failed to parse source: " + e.getMessage(), e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getLocationAsString(String fileName)
/*     */   {
/* 215 */     Locator locator = this.delegateHandler.getDocumentLocator();
/* 216 */     if (locator == null) {
/* 217 */       return fileName;
/*     */     }
/*     */ 
/* 220 */     JBossStringBuilder buffer = new JBossStringBuilder();
/* 221 */     String id = locator.getSystemId();
/* 222 */     if (id == null)
/* 223 */       id = locator.getPublicId();
/* 224 */     buffer.append(id).append('@');
/* 225 */     buffer.append(locator.getLineNumber());
/* 226 */     buffer.append(',');
/* 227 */     buffer.append(locator.getColumnNumber());
/* 228 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   private void logParserInfo()
/*     */   {
/* 234 */     StringBuffer sb = new StringBuffer();
/* 235 */     sb.append("Created parser: ").append(this.parser).append(", isNamespaceAware: ").append(this.parser.isNamespaceAware()).append(", isValidating: ").append(this.parser.isValidating()).append(", isXIncludeAware: ");
/*     */     try
/*     */     {
/* 241 */       sb.append(this.parser.isXIncludeAware());
/*     */     }
/*     */     catch (UnsupportedOperationException e)
/*     */     {
/* 245 */       sb.append("unsupported operation '").append(e.getMessage()).append('\'');
/*     */     }
/* 247 */     log.debug(sb.toString());
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  57 */     saxFactory.setValidating(true);
/*  58 */     saxFactory.setNamespaceAware(true);
/*  59 */     enableXInclude();
/*     */   }
/*     */ 
/*     */   private static final class MetaDataErrorHandler
/*     */     implements ErrorHandler
/*     */   {
/* 422 */     public static final ErrorHandler INSTANCE = new MetaDataErrorHandler();
/*     */ 
/*     */     public void warning(SAXParseException exception)
/*     */     {
/* 426 */       SaxJBossXBParser.log.warn(formatMessage(exception));
/*     */     }
/*     */ 
/*     */     public void error(SAXParseException exception)
/*     */       throws SAXException
/*     */     {
/* 432 */       throw new SAXException(formatMessage(exception));
/*     */     }
/*     */ 
/*     */     public void fatalError(SAXParseException exception)
/*     */       throws SAXException
/*     */     {
/* 438 */       throw new SAXException(formatMessage(exception));
/*     */     }
/*     */ 
/*     */     public String formatMessage(SAXParseException exception)
/*     */     {
/* 443 */       StringBuffer buffer = new StringBuffer(50);
/* 444 */       buffer.append(exception.getMessage()).append(" @ ");
/* 445 */       String location = exception.getPublicId();
/* 446 */       if (location != null)
/*     */       {
/* 448 */         buffer.append(location);
/*     */       }
/*     */       else
/*     */       {
/* 452 */         location = exception.getSystemId();
/* 453 */         if (location != null)
/*     */         {
/* 455 */           buffer.append(location);
/*     */         }
/*     */         else
/*     */         {
/* 459 */           buffer.append("*unknown*");
/*     */         }
/*     */       }
/* 462 */       buffer.append('[');
/* 463 */       buffer.append(exception.getLineNumber()).append(',');
/* 464 */       buffer.append(exception.getColumnNumber()).append(']');
/* 465 */       return buffer.toString();
/*     */     }
/*     */   }
/*     */ 
/*     */   private final class DelegatingContentHandler
/*     */     implements ContentHandler, LexicalHandler
/*     */   {
/*     */     Locator locator;
/*     */ 
/*     */     private DelegatingContentHandler()
/*     */     {
/*     */     }
/*     */ 
/*     */     public void comment(char[] ch, int start, int length)
/*     */       throws SAXException
/*     */     {
/*     */     }
/*     */ 
/*     */     public void startDTD(String name, String publicId, String systemId)
/*     */       throws SAXException
/*     */     {
/* 267 */       if ((SaxJBossXBParser.this.contentHandler instanceof JBossXBParser.DtdAwareContentHandler))
/*     */       {
/* 269 */         JBossXBParser.DtdAwareContentHandler dach = (JBossXBParser.DtdAwareContentHandler)SaxJBossXBParser.this.contentHandler;
/* 270 */         dach.startDTD(name, publicId, systemId);
/*     */       }
/*     */     }
/*     */ 
/*     */     public void endDTD() throws SAXException {
/* 275 */       if ((SaxJBossXBParser.this.contentHandler instanceof JBossXBParser.DtdAwareContentHandler))
/*     */       {
/* 277 */         JBossXBParser.DtdAwareContentHandler dach = (JBossXBParser.DtdAwareContentHandler)SaxJBossXBParser.this.contentHandler;
/* 278 */         dach.endDTD();
/*     */       }
/*     */     }
/*     */ 
/*     */     public void startEntity(String name)
/*     */       throws SAXException
/*     */     {
/*     */     }
/*     */ 
/*     */     public void endEntity(String name)
/*     */       throws SAXException
/*     */     {
/*     */     }
/*     */ 
/*     */     public void startCDATA()
/*     */       throws SAXException
/*     */     {
/*     */     }
/*     */ 
/*     */     public void endCDATA()
/*     */       throws SAXException
/*     */     {
/*     */     }
/*     */ 
/*     */     public void endDocument()
/*     */     {
/*     */     }
/*     */ 
/*     */     public void startDocument()
/*     */     {
/*     */     }
/*     */ 
/*     */     public void characters(char[] ch, int start, int length)
/*     */     {
/* 323 */       SaxJBossXBParser.this.contentHandler.characters(ch, start, length);
/*     */     }
/*     */ 
/*     */     public void ignorableWhitespace(char[] ch, int start, int length)
/*     */     {
/*     */     }
/*     */ 
/*     */     public void endPrefixMapping(String prefix)
/*     */     {
/* 335 */       SaxJBossXBParser.this.contentHandler.endPrefixMapping(prefix);
/*     */     }
/*     */ 
/*     */     public void skippedEntity(String name)
/*     */     {
/*     */     }
/*     */ 
/*     */     public Locator getDocumentLocator()
/*     */     {
/* 344 */       return this.locator;
/*     */     }
/*     */ 
/*     */     public void setDocumentLocator(Locator locator)
/*     */     {
/* 349 */       this.locator = locator;
/*     */     }
/*     */ 
/*     */     public void processingInstruction(String target, String data)
/*     */     {
/* 354 */       SaxJBossXBParser.this.contentHandler.processingInstruction(target, data);
/*     */     }
/*     */ 
/*     */     public void startPrefixMapping(String prefix, String uri)
/*     */     {
/* 359 */       SaxJBossXBParser.this.contentHandler.startPrefixMapping(prefix, uri);
/*     */     }
/*     */ 
/*     */     public void endElement(String namespaceURI, String localName, String qName)
/*     */     {
/* 364 */       String name = null;
/* 365 */       if (SaxJBossXBParser.this.trace)
/*     */       {
/* 367 */         if (localName.length() == 0)
/*     */         {
/* 369 */           name = qName;
/*     */         }
/*     */         else
/*     */         {
/* 373 */           name = namespaceURI + ':' + localName;
/*     */         }
/* 375 */         SaxJBossXBParser.log.trace("Enter endElement " + name);
/*     */       }
/*     */       try
/*     */       {
/* 379 */         SaxJBossXBParser.this.contentHandler.endElement(namespaceURI, localName, qName);
/*     */       }
/*     */       finally
/*     */       {
/* 383 */         if (SaxJBossXBParser.this.trace)
/*     */         {
/* 385 */           SaxJBossXBParser.log.trace("Exit endElement  " + name);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/*     */     public void startElement(String namespaceURI, String localName, String qName, Attributes atts)
/*     */     {
/* 392 */       String name = null;
/* 393 */       if (SaxJBossXBParser.this.trace)
/*     */       {
/* 395 */         if (localName.length() == 0)
/*     */         {
/* 397 */           name = qName;
/*     */         }
/*     */         else
/*     */         {
/* 401 */           name = namespaceURI + ':' + localName;
/*     */         }
/* 403 */         SaxJBossXBParser.log.trace("Enter startElement " + name);
/*     */       }
/*     */       try
/*     */       {
/* 407 */         SaxJBossXBParser.this.contentHandler.startElement(namespaceURI, localName, qName, atts, null);
/*     */       }
/*     */       finally
/*     */       {
/* 411 */         if (SaxJBossXBParser.this.trace)
/*     */         {
/* 413 */           SaxJBossXBParser.log.trace("Exit startElement  " + name);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.parser.sax.SaxJBossXBParser
 * JD-Core Version:    0.6.0
 */