/*     */ package org.jboss.xb.binding.metadata;
/*     */ 
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import javax.xml.namespace.QName;
/*     */ 
/*     */ public class XsdElement
/*     */ {
/*  35 */   public static final QName QNAME_NAME = new QName("name");
/*     */   private final QName qName;
/*  38 */   private Map attributes = Collections.EMPTY_MAP;
/*  39 */   private Map children = Collections.EMPTY_MAP;
/*     */   private String data;
/*     */ 
/*     */   public XsdElement(QName qName)
/*     */   {
/*  44 */     this.qName = qName;
/*     */   }
/*     */ 
/*     */   public String getAttribute(QName qName)
/*     */   {
/*  49 */     return (String)this.attributes.get(qName);
/*     */   }
/*     */ 
/*     */   public void addAttribute(QName qName, String value)
/*     */   {
/*  54 */     switch (this.attributes.size())
/*     */     {
/*     */     case 0:
/*  57 */       this.attributes = Collections.singletonMap(qName, value);
/*  58 */       break;
/*     */     case 1:
/*  60 */       this.attributes = new HashMap(this.attributes);
/*     */     default:
/*  62 */       this.attributes.put(qName, value);
/*     */     }
/*     */   }
/*     */ 
/*     */   public XsdElement getChild(QName qName)
/*     */   {
/*  68 */     return (XsdElement)this.children.get(qName);
/*     */   }
/*     */ 
/*     */   public void addChild(XsdElement child)
/*     */   {
/*  73 */     switch (this.children.size())
/*     */     {
/*     */     case 0:
/*  76 */       this.children = Collections.singletonMap(child.qName, child);
/*  77 */       break;
/*     */     case 1:
/*  79 */       this.children = new HashMap(this.children);
/*     */     default:
/*  81 */       this.children.put(child.qName, child);
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getData()
/*     */   {
/*  87 */     return this.data;
/*     */   }
/*     */ 
/*     */   public void setData(String data)
/*     */   {
/*  92 */     this.data = data;
/*     */   }
/*     */ 
/*     */   public QName getQName()
/*     */   {
/*  97 */     return this.qName;
/*     */   }
/*     */ 
/*     */   public String getNameAttribute()
/*     */   {
/* 102 */     return getAttribute(QNAME_NAME);
/*     */   }
/*     */ 
/*     */   public void setNameAttribute(String name)
/*     */   {
/* 107 */     addAttribute(QNAME_NAME, name);
/*     */   }
/*     */ 
/*     */   public boolean equals(Object o)
/*     */   {
/* 112 */     if (this == o)
/*     */     {
/* 114 */       return true;
/*     */     }
/* 116 */     if (!(o instanceof XsdElement))
/*     */     {
/* 118 */       return false;
/*     */     }
/*     */ 
/* 121 */     XsdElement xsdElement = (XsdElement)o;
/*     */ 
/* 125 */     return this.qName.equals(xsdElement.qName);
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 133 */     return this.qName.hashCode();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.metadata.XsdElement
 * JD-Core Version:    0.6.0
 */