/*     */ package org.jboss.xb.binding.introspection;
/*     */ 
/*     */ import java.lang.ref.WeakReference;
/*     */ import java.util.Map;
/*     */ import java.util.WeakHashMap;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import org.jboss.xb.binding.JBossXBRuntimeException;
/*     */ import org.jboss.xb.util.NoopMap;
/*     */ 
/*     */ public class ClassInfos
/*     */ {
/*  38 */   private static Map classloaderCache = new WeakHashMap();
/*     */ 
/*     */   public static void disableCache()
/*     */   {
/*  46 */     synchronized (classloaderCache)
/*     */     {
/*  48 */       classloaderCache = NoopMap.INSTANCE;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void enableCache()
/*     */   {
/*  57 */     synchronized (classloaderCache)
/*     */     {
/*  59 */       if (!isCacheEnabled())
/*     */       {
/*  61 */         classloaderCache = new WeakHashMap();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public static boolean isCacheEnabled()
/*     */   {
/*  71 */     synchronized (classloaderCache)
/*     */     {
/*  73 */       return classloaderCache != NoopMap.INSTANCE;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void flushCache()
/*     */   {
/*  82 */     synchronized (classloaderCache)
/*     */     {
/*  84 */       classloaderCache.clear();
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void flushCache(String cls)
/*     */   {
/*  94 */     ClassLoader cl = Thread.currentThread().getContextClassLoader();
/*  95 */     Map classLoaderCache = getClassLoaderCache(cl);
/*  96 */     classLoaderCache.remove(cls);
/*     */   }
/*     */ 
/*     */   public static void flushCache(Class cls)
/*     */   {
/* 105 */     Map classLoaderCache = getClassLoaderCache(cls.getClassLoader());
/* 106 */     classLoaderCache.remove(cls.getName());
/*     */   }
/*     */ 
/*     */   public static ClassInfo getClassInfo(Class cls)
/*     */   {
/* 111 */     Map classLoaderCache = getClassLoaderCache(cls.getClassLoader());
/*     */ 
/* 113 */     WeakReference weak = (WeakReference)classLoaderCache.get(cls.getName());
/* 114 */     if (weak != null)
/*     */     {
/* 116 */       Object result = weak.get();
/* 117 */       if (result != null)
/*     */       {
/* 119 */         return (ClassInfo)result;
/*     */       }
/*     */     }
/*     */ 
/* 123 */     ClassInfo clsInfo = new ClassInfo(cls);
/* 124 */     weak = new WeakReference(clsInfo);
/* 125 */     classLoaderCache.put(cls.getName(), weak);
/* 126 */     return clsInfo;
/*     */   }
/*     */ 
/*     */   public static ClassInfo getClassInfo(String name, boolean required)
/*     */   {
/* 131 */     ClassLoader cl = Thread.currentThread().getContextClassLoader();
/* 132 */     Map classLoaderCache = getClassLoaderCache(cl);
/*     */ 
/* 134 */     WeakReference weak = (WeakReference)classLoaderCache.get(name);
/* 135 */     if (weak != null)
/*     */     {
/* 137 */       Object result = weak.get();
/* 138 */       if (result != null)
/*     */       {
/* 140 */         return (ClassInfo)result;
/*     */       }
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 146 */       ClassInfo clsInfo = new ClassInfo(cl.loadClass(name));
/* 147 */       weak = new WeakReference(clsInfo);
/* 148 */       classLoaderCache.put(name, weak);
/* 149 */       return clsInfo;
/*     */     }
/*     */     catch (ClassNotFoundException e)
/*     */     {
/* 153 */       if (required)
/*     */       {
/* 155 */         throw new JBossXBRuntimeException("Failed to load class " + name);
/*     */       }
/*     */     }
/*     */ 
/* 159 */     return null;
/*     */   }
/*     */ 
/*     */   private static Map getClassLoaderCache(ClassLoader cl)
/*     */   {
/* 164 */     synchronized (classloaderCache)
/*     */     {
/* 166 */       Map result = (Map)classloaderCache.get(cl);
/* 167 */       if (result == null)
/*     */       {
/* 169 */         result = new ConcurrentHashMap();
/* 170 */         classloaderCache.put(cl, result);
/*     */       }
/* 172 */       return result;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.introspection.ClassInfos
 * JD-Core Version:    0.6.0
 */