/*     */ package org.jboss.xb.binding.introspection;
/*     */ 
/*     */ import java.beans.BeanInfo;
/*     */ import java.beans.IntrospectionException;
/*     */ import java.beans.Introspector;
/*     */ import java.beans.PropertyDescriptor;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.Map;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import org.jboss.xb.binding.JBossXBRuntimeException;
/*     */ 
/*     */ public class ClassInfo
/*     */ {
/*  39 */   private static final Object FIELD_INFO_NA = new Object();
/*     */   private final Class type;
/*  41 */   private Map fields = new ConcurrentHashMap();
/*     */   private boolean introspected;
/*     */ 
/*     */   public ClassInfo(Class cls)
/*     */   {
/*  46 */     this.type = cls;
/*     */   }
/*     */ 
/*     */   public Class getType()
/*     */   {
/*  51 */     return this.type;
/*     */   }
/*     */ 
/*     */   public FieldInfo getFieldInfo(String name, boolean required)
/*     */   {
/*  62 */     Object o = this.fields.get(name);
/*  63 */     if (o == null)
/*     */     {
/*  65 */       FieldInfo fieldInfo = FieldInfo.getFieldInfo(this, name);
/*  66 */       if (fieldInfo == null)
/*     */       {
/*  68 */         this.fields.put(name, FIELD_INFO_NA);
/*     */       }
/*     */       else
/*     */       {
/*  72 */         return fieldInfo;
/*     */       }
/*     */     }
/*  75 */     else if (o != FIELD_INFO_NA)
/*     */     {
/*  77 */       return (FieldInfo)o;
/*     */     }
/*     */ 
/*  80 */     if (required)
/*     */     {
/*  82 */       throw new JBossXBRuntimeException("Failed to find read method or field for property '" + name + "' in " + this.type);
/*     */     }
/*     */ 
/*  87 */     return null;
/*     */   }
/*     */ 
/*     */   void addFieldInfo(FieldInfo fieldInfo)
/*     */   {
/*  92 */     this.fields.put(fieldInfo.getName(), fieldInfo);
/*     */   }
/*     */ 
/*     */   FieldInfo introspect(String name)
/*     */   {
/*  97 */     if (this.introspected)
/*     */     {
/*  99 */       return null;
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 104 */       BeanInfo info = Introspector.getBeanInfo(this.type);
/* 105 */       PropertyDescriptor[] props = info.getPropertyDescriptors();
/* 106 */       if (props != null)
/*     */       {
/* 108 */         for (int i = 0; i < props.length; i++)
/*     */         {
/* 110 */           PropertyDescriptor prop = props[i];
/* 111 */           Method readMethod = prop.getReadMethod();
/*     */ 
/* 113 */           if (readMethod == null)
/*     */             continue;
/* 115 */           Method writeMethod = prop.getWriteMethod();
/* 116 */           FieldInfo fieldInfo = new FieldInfo(this.type, prop.getName(), readMethod, writeMethod);
/* 117 */           addFieldInfo(fieldInfo);
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (IntrospectionException e)
/*     */     {
/*     */     }
/*     */ 
/* 126 */     this.introspected = true;
/* 127 */     return getFieldInfo(name, false);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.introspection.ClassInfo
 * JD-Core Version:    0.6.0
 */