/*     */ package org.jboss.xb.binding.group;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collections;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.xb.binding.JBossXBRuntimeException;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.AttributeBinding;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.CharactersHandler;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
/*     */ 
/*     */ public class ValueListInitializer
/*     */ {
/*     */   private int initializedState;
/*  42 */   private Map attrIndex = Collections.EMPTY_MAP;
/*  43 */   private Map elemIndex = Collections.EMPTY_MAP;
/*  44 */   private List requiredBindings = Collections.EMPTY_LIST;
/*     */ 
/*     */   public void addRequiredAttribute(QName qName, AttributeBinding binding)
/*     */   {
/*  63 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public void addRequiredElement(QName qName, ElementBinding binding)
/*     */   {
/*  83 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public ValueList newValueList(ValueListHandler handler, Class targetClass)
/*     */   {
/*  88 */     return new ValueList(this, handler, targetClass);
/*     */   }
/*     */ 
/*     */   public void addAttributeValue(QName qName, AttributeBinding binding, ValueList valueList, Object value)
/*     */   {
/*  93 */     Integer index = (Integer)this.attrIndex.get(qName);
/*  94 */     if (index == null)
/*     */     {
/*  96 */       valueList.setAttributeValue(qName, binding, value);
/*     */     }
/*     */     else
/*     */     {
/* 100 */       if (isInitialized(valueList))
/*     */       {
/* 102 */         throw new JBossXBRuntimeException("The value list has already been initialized!");
/*     */       }
/* 104 */       valueList.setRequiredValue(index.intValue(), qName.hashCode(), value);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void addTextValue(QName qName, ParticleBinding particle, CharactersHandler handler, ValueList valueList, Object value)
/*     */   {
/* 114 */     valueList.addTextValue(qName, particle, handler, value);
/*     */   }
/*     */ 
/*     */   public void addTermValue(QName qName, ParticleBinding binding, Object handler, ValueList valueList, Object value, ParticleBinding parentParticle)
/*     */   {
/* 119 */     Integer index = (Integer)this.elemIndex.get(qName);
/* 120 */     if (index == null)
/*     */     {
/* 122 */       if (binding.isRepeatable())
/*     */       {
/* 124 */         valueList.addRepeatableTermValue(qName, binding, handler, value, parentParticle);
/*     */       }
/*     */       else
/*     */       {
/* 128 */         valueList.addTermValue(qName, binding, handler, value, parentParticle);
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 133 */       if (isInitialized(valueList))
/*     */       {
/* 135 */         throw new JBossXBRuntimeException("The value list has already been initialized!");
/*     */       }
/* 137 */       valueList.setRequiredValue(index.intValue(), qName.hashCode(), value);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean isInitialized(ValueList valueList)
/*     */   {
/* 144 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public Object getAttributeValue(QName qName, ValueList valueList)
/*     */   {
/* 162 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public Object getElementValue(QName qName, ValueList valueList)
/*     */   {
/* 180 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public List getRequiredBindings()
/*     */   {
/* 186 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   private void addBinding(Object binding)
/*     */   {
/* 193 */     if (this.requiredBindings == Collections.EMPTY_LIST)
/*     */     {
/* 195 */       this.requiredBindings = new ArrayList();
/*     */     }
/* 197 */     this.requiredBindings.add(binding);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.group.ValueListInitializer
 * JD-Core Version:    0.6.0
 */