/*     */ package org.jboss.xb.binding.group;
/*     */ 
/*     */ import java.lang.reflect.Array;
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.util.Arrays;
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import org.jboss.util.Classes;
/*     */ import org.jboss.xb.binding.GenericValueContainer;
/*     */ import org.jboss.xb.binding.JBossXBRuntimeException;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.AttributeBinding;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.AttributeHandler;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.CharactersHandler;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.ParticleHandler;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.TermBinding;
/*     */ 
/*     */ public abstract interface ValueListHandler
/*     */ {
/*  48 */   public static final ValueListHandler IMMUTABLE = new ValueListHandler()
/*     */   {
/*     */     public Object newInstance(ParticleBinding particle, ValueList valueList)
/*     */     {
/*  52 */       Class cls = valueList.getTargetClass();
/*  53 */       Map map = valueList.getNonRequiredValues();
/*     */ 
/*  55 */       Collection values = map.values();
/*  56 */       if (values.isEmpty())
/*     */       {
/*  58 */         throw new JBossXBRuntimeException("Value list does not contain non-required values.");
/*     */       }
/*     */ 
/*  61 */       Constructor ctor = null;
/*  62 */       Constructor[] ctors = cls.getConstructors();
/*     */ 
/*  64 */       if ((ctors == null) || (ctors.length == 0))
/*     */       {
/*  66 */         throw new JBossXBRuntimeException("The class has no declared constructors: " + cls);
/*     */       }
/*     */ 
/*  69 */       for (int i = 0; i < ctors.length; i++)
/*     */       {
/*  71 */         Class[] types = ctors[i].getParameterTypes();
/*     */ 
/*  73 */         if ((types == null) || (types.length == 0))
/*     */         {
/*  75 */           throw new IllegalStateException("Found no-arg constructor for immutable " + cls);
/*     */         }
/*     */ 
/*  78 */         if (types.length != map.size())
/*     */           continue;
/*  80 */         ctor = ctors[i];
/*     */ 
/*  82 */         int typeInd = 0;
/*  83 */         Iterator iter = values.iterator();
/*  84 */         while (iter.hasNext())
/*     */         {
/*  86 */           Class type = types[(typeInd++)];
/*  87 */           if (type.isPrimitive())
/*     */           {
/*  89 */             type = Classes.getPrimitiveWrapper(type);
/*     */           }
/*     */ 
/*  92 */           if (!type.isAssignableFrom(iter.next().getClass()))
/*     */           {
/*  94 */             ctor = null;
/*  95 */             break;
/*     */           }
/*     */         }
/*     */ 
/*  99 */         if (ctor != null)
/*     */         {
/*     */           break;
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 106 */       if (ctor == null)
/*     */       {
/* 108 */         StringBuffer buf = new StringBuffer();
/* 109 */         buf.append("There is no ctor in ").append(cls).append(" that would take the following arguments:\n");
/*     */ 
/* 112 */         int cnt = 0;
/* 113 */         for (Iterator i = values.iterator(); i.hasNext(); )
/*     */         {
/* 115 */           Object o = i.next();
/* 116 */           cnt++; buf.append(' ').append(cnt).append(") ").append(o.getClass()).append(": ").append(o).append('\n');
/*     */         }
/* 118 */         throw new IllegalStateException(buf.toString());
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 123 */         return ctor.newInstance(values.toArray());
/*     */       }
/*     */       catch (Exception e) {
/*     */       }
/* 127 */       throw new IllegalStateException("Failed to create immutable instance of " + cls + " using arguments: " + values + ": " + e.getMessage());
/*     */     }
/*  48 */   };
/*     */ 
/* 136 */   public static final ValueListHandler NON_DEFAULT_CTOR = new ValueListHandler()
/*     */   {
/*     */     public Object newInstance(ParticleBinding particle, ValueList valueList)
/*     */     {
/* 140 */       Class cls = valueList.getTargetClass();
/* 141 */       int size = valueList.size();
/*     */ 
/* 143 */       if (size == 0)
/*     */       {
/*     */         try
/*     */         {
/* 147 */           return newInstance(cls.getConstructor(null), null);
/*     */         }
/*     */         catch (NoSuchMethodException e)
/*     */         {
/* 151 */           throw new JBossXBRuntimeException("Value list does not contain non-required values and there is no no-arg ctor in " + cls);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 157 */       Constructor ctor = matchBestCtor(cls, valueList);
/*     */ 
/* 159 */       if (ctor == null)
/*     */       {
/* 161 */         StringBuffer buf = new StringBuffer();
/* 162 */         buf.append("Failed to find no-arg ctor or best-match ctor in ").append(cls).append(", property values:\n");
/*     */ 
/* 165 */         int cnt = 0;
/* 166 */         for (int i = 0; i < size; i++)
/*     */         {
/* 168 */           Object o = valueList.getValue(i).value;
/* 169 */           cnt++; buf.append(' ').append(cnt).append(") ").append(o).append('\n');
/*     */         }
/* 171 */         throw new JBossXBRuntimeException(buf.toString());
/*     */       }
/*     */ 
/* 175 */       int argsTotal = ctor.getParameterTypes().length;
/*     */       Object o;
/*     */       Object o;
/* 176 */       if (argsTotal == size)
/*     */       {
/* 178 */         Object[] args = getArgs(ctor, valueList);
/* 179 */         o = newInstance(ctor, args);
/*     */       }
/*     */       else
/*     */       {
/* 183 */         Object[] args = getArgs(ctor, valueList);
/* 184 */         o = newInstance(ctor, args);
/*     */ 
/* 186 */         int i = argsTotal;
/* 187 */         while (i < size)
/*     */         {
/* 189 */           ValueList.NonRequiredValue valueEntry = valueList.getValue(i++);
/* 190 */           Object binding = valueEntry.binding;
/* 191 */           if ((binding instanceof ParticleBinding))
/*     */           {
/* 193 */             Object handler = valueEntry.handler;
/* 194 */             ParticleBinding childParticle = (ParticleBinding)binding;
/* 195 */             if ((handler instanceof ParticleHandler))
/*     */             {
/* 197 */               ParticleHandler pHandler = (ParticleHandler)handler;
/*     */               Iterator iter;
/* 198 */               if (childParticle.isRepeatable())
/*     */               {
/* 200 */                 TermBinding term = childParticle.getTerm();
/* 201 */                 if ((!(o instanceof GenericValueContainer)) && (term.getAddMethodMetaData() == null) && (term.getMapEntryMetaData() == null) && (term.getPutMethodMetaData() == null))
/*     */                 {
/* 206 */                   pHandler.setParent(o, valueEntry.value, valueEntry.qName, childParticle, particle);
/*     */                 }
/*     */                 else
/*     */                 {
/* 210 */                   Collection col = (Collection)valueEntry.value;
/* 211 */                   for (iter = col.iterator(); iter.hasNext(); )
/*     */                   {
/* 213 */                     pHandler.setParent(o, iter.next(), valueEntry.qName, childParticle, particle);
/*     */                   }
/*     */                 }
/*     */               }
/*     */               else
/*     */               {
/* 219 */                 pHandler.setParent(o, valueEntry.value, valueEntry.qName, childParticle, particle);
/*     */               }
/*     */             }
/*     */             else
/*     */             {
/* 224 */               ((CharactersHandler)handler).setValue(valueEntry.qName, (ElementBinding)childParticle.getTerm(), o, valueEntry.value);
/*     */             }
/*     */ 
/*     */           }
/* 231 */           else if ((binding instanceof AttributeBinding))
/*     */           {
/* 233 */             AttributeBinding attr = (AttributeBinding)binding;
/* 234 */             AttributeHandler handler = attr.getHandler();
/* 235 */             if (handler != null)
/*     */             {
/* 237 */               handler.attribute(valueEntry.qName, attr.getQName(), attr, o, valueEntry.value);
/*     */             }
/*     */             else
/*     */             {
/* 241 */               throw new JBossXBRuntimeException("Attribute binding present but has no handler: element=" + valueEntry.qName + ", attrinute=" + attr.getQName());
/*     */             }
/*     */ 
/*     */           }
/*     */           else
/*     */           {
/* 250 */             throw new JBossXBRuntimeException("Unexpected binding type: " + binding);
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/* 255 */       return o;
/*     */     }
/*     */ 
/*     */     private Constructor matchBestCtor(Class cls, ValueList valueList)
/*     */     {
/* 260 */       Constructor bestMatch = null;
/* 261 */       int bestMatchArgsTotal = 0;
/* 262 */       Constructor[] ctors = cls.getConstructors();
/* 263 */       int size = valueList.size();
/*     */ 
/* 265 */       for (int i = 0; i < ctors.length; i++)
/*     */       {
/* 267 */         Constructor ctor = ctors[i];
/* 268 */         Class[] types = ctor.getParameterTypes();
/*     */ 
/* 270 */         if (((types == null) || (types.length == 0)) && (bestMatch == null))
/*     */         {
/* 272 */           bestMatch = ctor;
/*     */         }
/*     */         else
/*     */         {
/* 276 */           if (bestMatchArgsTotal > types.length)
/*     */             continue;
/* 278 */           int typeInd = 0;
/* 279 */           for (int valueInd = 0; (typeInd < types.length) && (valueInd < size); valueInd++)
/*     */           {
/* 281 */             Class type = types[typeInd];
/* 282 */             if (type.isPrimitive())
/*     */             {
/* 284 */               type = Classes.getPrimitiveWrapper(type);
/*     */             }
/*     */ 
/* 287 */             ValueList.NonRequiredValue valueEntry = valueList.getValue(valueInd);
/* 288 */             Object value = valueEntry.value;
/* 289 */             if ((value != null) && (!type.isAssignableFrom(value.getClass())) && ((!(valueEntry.binding instanceof ParticleBinding)) || (!((ParticleBinding)valueEntry.binding).isRepeatable()) || (!type.isArray())))
/*     */             {
/*     */               break;
/*     */             }
/*     */ 
/* 302 */             if ((bestMatchArgsTotal == types.length) && (!bestMatch.getParameterTypes()[typeInd].isAssignableFrom(type)))
/*     */               break;
/* 279 */             typeInd++;
/*     */           }
/*     */ 
/* 309 */           if (typeInd != types.length)
/*     */             continue;
/* 311 */           bestMatch = ctor;
/* 312 */           bestMatchArgsTotal = types.length;
/*     */         }
/*     */       }
/*     */ 
/* 316 */       return bestMatch;
/*     */     }
/*     */ 
/*     */     private Object newInstance(Constructor bestMatch, Object[] args)
/*     */     {
/*     */       try
/*     */       {
/* 323 */         return bestMatch.newInstance(args);
/*     */       }
/*     */       catch (Exception e) {
/*     */       }
/* 327 */       throw new JBossXBRuntimeException("Failed to create an instance of " + bestMatch.getDeclaringClass() + " using the following ctor arguments " + Arrays.asList(args), e);
/*     */     }
/*     */ 
/*     */     private Object[] getArgs(Constructor ctor, ValueList valueList)
/*     */     {
/* 337 */       Class[] types = ctor.getParameterTypes();
/* 338 */       Object[] args = new Object[types.length];
/* 339 */       for (int i = 0; i < types.length; i++)
/*     */       {
/* 341 */         ValueList.NonRequiredValue valueEntry = valueList.getValue(i);
/* 342 */         Object arg = valueEntry.value;
/*     */         int arrInd;
/*     */         Iterator iter;
/* 343 */         if ((valueEntry.value != null) && (!types[i].isAssignableFrom(arg.getClass())))
/*     */         {
/* 347 */           if ((types[i].isArray()) && (Collection.class.isAssignableFrom(arg.getClass())))
/*     */           {
/* 349 */             Collection col = (Collection)arg;
/* 350 */             arg = Array.newInstance(types[i].getComponentType(), col.size());
/* 351 */             arrInd = 0;
/* 352 */             for (iter = col.iterator(); iter.hasNext(); )
/*     */             {
/* 354 */               Array.set(arg, arrInd++, iter.next());
/*     */             }
/*     */           }
/*     */         }
/* 358 */         args[i] = arg;
/*     */       }
/* 360 */       return args;
/*     */     }
/* 136 */   };
/*     */ 
/*     */   public abstract Object newInstance(ParticleBinding paramParticleBinding, ValueList paramValueList);
/*     */ 
/*     */   public static class FACTORY
/*     */   {
/*     */     public static ValueListHandler lazy(Object parent)
/*     */     {
/* 374 */       return new ValueListHandler(parent)
/*     */       {
/* 376 */         private final ValueList parentValueList = (this.val$parent instanceof ValueList) ? (ValueList)this.val$parent : null;
/*     */ 
/*     */         public Object newInstance(ParticleBinding particle, ValueList valueList)
/*     */         {
/* 380 */           for (int i = 0; i < valueList.size(); i++)
/*     */           {
/* 382 */             ValueList.NonRequiredValue valueEntry = valueList.getValue(i);
/* 383 */             Object binding = valueEntry.binding;
/* 384 */             if ((binding instanceof ParticleBinding))
/*     */             {
/* 386 */               Object handler = valueEntry.handler;
/* 387 */               ParticleBinding childParticle = (ParticleBinding)binding;
/* 388 */               if ((handler instanceof ParticleHandler))
/*     */               {
/* 390 */                 ParticleHandler pHandler = (ParticleHandler)handler;
/* 391 */                 if (childParticle.isRepeatable())
/*     */                 {
/* 393 */                   if (this.parentValueList != null)
/*     */                   {
/* 395 */                     this.parentValueList.addTermValue(valueEntry.qName, childParticle, pHandler, valueEntry.value, null);
/*     */                   }
/*     */                   else
/*     */                   {
/* 399 */                     Collection col = (Collection)valueEntry.value;
/*     */ 
/* 401 */                     pHandler.setParent(this.val$parent, col, valueEntry.qName, childParticle, valueEntry.parentParticle);
/*     */                   }
/*     */ 
/*     */                 }
/* 413 */                 else if (this.parentValueList != null)
/*     */                 {
/* 415 */                   this.parentValueList.addTermValue(valueEntry.qName, childParticle, pHandler, valueEntry.value, valueEntry.parentParticle);
/*     */                 }
/*     */                 else
/*     */                 {
/* 419 */                   pHandler.setParent(this.val$parent, valueEntry.value, valueEntry.qName, childParticle, valueEntry.parentParticle);
/*     */                 }
/*     */ 
/*     */               }
/*     */               else
/*     */               {
/* 425 */                 CharactersHandler cHandler = (CharactersHandler)handler;
/* 426 */                 if (this.parentValueList != null)
/*     */                 {
/* 428 */                   this.parentValueList.addTextValue(valueEntry.qName, childParticle, cHandler, valueEntry.value);
/*     */                 }
/*     */                 else
/*     */                 {
/* 432 */                   cHandler.setValue(valueEntry.qName, (ElementBinding)childParticle.getTerm(), this.val$parent, valueEntry.value);
/*     */                 }
/*     */               }
/*     */             }
/* 436 */             else if ((binding instanceof AttributeBinding))
/*     */             {
/* 438 */               AttributeBinding attr = (AttributeBinding)binding;
/* 439 */               AttributeHandler handler = attr.getHandler();
/* 440 */               if (handler != null)
/*     */               {
/* 442 */                 if (this.parentValueList != null)
/*     */                 {
/* 444 */                   this.parentValueList.setAttributeValue(attr.getQName(), attr, valueEntry.value);
/*     */                 }
/*     */                 else
/*     */                 {
/* 448 */                   handler.attribute(valueEntry.qName, attr.getQName(), attr, this.val$parent, valueEntry.value);
/*     */                 }
/*     */               }
/*     */               else
/*     */               {
/* 453 */                 throw new JBossXBRuntimeException("Attribute binding present but has no handler: element=" + valueEntry.qName + ", attrinute=" + attr.getQName());
/*     */               }
/*     */ 
/*     */             }
/*     */             else
/*     */             {
/* 462 */               throw new JBossXBRuntimeException("Unexpected binding type: " + binding);
/*     */             }
/*     */           }
/*     */ 
/* 466 */           return this.val$parent;
/*     */         }
/*     */       };
/*     */     }
/*     */ 
/*     */     public static ValueListHandler child() {
/* 473 */       return new ValueListHandler()
/*     */       {
/*     */         public Object newInstance(ParticleBinding particle, ValueList valueList)
/*     */         {
/* 477 */           if (valueList.size() > 1)
/*     */           {
/* 479 */             String msg = "Expected only one child for " + particle.getTerm() + " but got:";
/* 480 */             for (int i = 0; i < valueList.size(); i++)
/*     */             {
/* 482 */               ValueList.NonRequiredValue valueEntry = valueList.getValue(0);
/* 483 */               msg = msg + " " + valueEntry.value + ";";
/*     */             }
/* 485 */             throw new JBossXBRuntimeException(msg);
/*     */           }
/*     */ 
/* 488 */           ValueList.NonRequiredValue valueEntry = valueList.getValue(0);
/* 489 */           return valueEntry.value;
/*     */         }
/*     */       };
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.group.ValueListHandler
 * JD-Core Version:    0.6.0
 */