/*      */ package org.jboss.xb.binding;
/*      */ 
/*      */ import java.io.IOException;
/*      */ import java.io.Reader;
/*      */ import java.io.StringWriter;
/*      */ import java.io.Writer;
/*      */ import java.lang.reflect.Array;
/*      */ import java.lang.reflect.Method;
/*      */ import java.util.AbstractList;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Arrays;
/*      */ import java.util.Collection;
/*      */ import java.util.Iterator;
/*      */ import java.util.List;
/*      */ import java.util.Map;
/*      */ import javax.xml.namespace.QName;
/*      */ import javax.xml.parsers.ParserConfigurationException;
/*      */ import org.apache.xerces.xs.StringList;
/*      */ import org.apache.xerces.xs.XSAttributeDeclaration;
/*      */ import org.apache.xerces.xs.XSAttributeUse;
/*      */ import org.apache.xerces.xs.XSComplexTypeDefinition;
/*      */ import org.apache.xerces.xs.XSElementDeclaration;
/*      */ import org.apache.xerces.xs.XSModel;
/*      */ import org.apache.xerces.xs.XSModelGroup;
/*      */ import org.apache.xerces.xs.XSNamedMap;
/*      */ import org.apache.xerces.xs.XSObject;
/*      */ import org.apache.xerces.xs.XSObjectList;
/*      */ import org.apache.xerces.xs.XSParticle;
/*      */ import org.apache.xerces.xs.XSSimpleTypeDefinition;
/*      */ import org.apache.xerces.xs.XSTerm;
/*      */ import org.apache.xerces.xs.XSTypeDefinition;
/*      */ import org.apache.xerces.xs.XSWildcard;
/*      */ import org.jboss.logging.Logger;
/*      */ import org.jboss.xb.binding.introspection.FieldInfo;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
/*      */ import org.xml.sax.ContentHandler;
/*      */ import org.xml.sax.SAXException;
/*      */ 
/*      */ public class XercesXsMarshaller extends AbstractMarshaller
/*      */ {
/*   64 */   private AbstractMarshaller.Stack stack = new AbstractMarshaller.StackImpl();
/*      */   private GenericObjectModelProvider provider;
/*      */   private Object root;
/*   76 */   private boolean supportNil = true;
/*      */   private QName rootTypeQName;
/*      */   private SchemaBindingResolver schemaResolver;
/*      */   private XSModel model;
/*      */   private boolean ignoreUnresolvedWildcard;
/*      */   private XSAttributeUse currentAttribute;
/*      */   private XSTypeDefinition currentElementType;
/*   89 */   private String simpleContentProperty = "value";
/*      */ 
/*   91 */   private MarshallingContext ctx = new MarshallingContext()
/*      */   {
/*      */     private ContentHandler ch;
/*      */ 
/*      */     public boolean isAttributeRequired() {
/*   97 */       if (XercesXsMarshaller.this.currentAttribute == null)
/*      */       {
/*   99 */         throw new JBossXBRuntimeException("There is no current attribute!");
/*      */       }
/*  101 */       return XercesXsMarshaller.this.currentAttribute.getRequired();
/*      */     }
/*      */ 
/*      */     public boolean isTypeComplex()
/*      */     {
/*  106 */       if (XercesXsMarshaller.this.currentElementType == null)
/*      */       {
/*  108 */         throw new JBossXBRuntimeException("There is no current element!");
/*      */       }
/*  110 */       return XercesXsMarshaller.this.currentElementType.getTypeCategory() == 15;
/*      */     }
/*      */ 
/*      */     public String getSimpleContentProperty()
/*      */     {
/*  115 */       return XercesXsMarshaller.this.simpleContentProperty;
/*      */     }
/*      */ 
/*      */     public ContentHandler getContentHandler()
/*      */     {
/*  120 */       if (this.ch == null)
/*      */       {
/*  122 */         this.ch = new AbstractMarshaller.ContentHandlerAdaptor(XercesXsMarshaller.this);
/*      */       }
/*  124 */       return this.ch;
/*      */     }
/*      */ 
/*      */     public NamespaceRegistry getNamespaceContext()
/*      */     {
/*  129 */       return XercesXsMarshaller.this.nsRegistry;
/*      */     }
/*   91 */   };
/*      */ 
/*      */   public String getSimpleContentProperty()
/*      */   {
/*  135 */     return this.simpleContentProperty;
/*      */   }
/*      */ 
/*      */   public void setSimpleContentProperty(String simpleContentProperty)
/*      */   {
/*  140 */     this.simpleContentProperty = simpleContentProperty;
/*      */   }
/*      */ 
/*      */   public boolean isIgnoreUnresolvedWildcard()
/*      */   {
/*  145 */     return this.ignoreUnresolvedWildcard;
/*      */   }
/*      */ 
/*      */   public void setIgnoreUnresolvedWildcard(boolean ignoreUnresolvedWildcard)
/*      */   {
/*  150 */     this.ignoreUnresolvedWildcard = ignoreUnresolvedWildcard;
/*      */   }
/*      */ 
/*      */   public SchemaBindingResolver getSchemaResolver()
/*      */   {
/*  155 */     return this.schemaResolver;
/*      */   }
/*      */ 
/*      */   public void setSchemaResolver(SchemaBindingResolver schemaResolver)
/*      */   {
/*  160 */     this.schemaResolver = schemaResolver;
/*      */   }
/*      */ 
/*      */   public QName getRootTypeQName()
/*      */   {
/*  165 */     return this.rootTypeQName;
/*      */   }
/*      */ 
/*      */   public void setRootTypeQName(QName rootTypeQName)
/*      */   {
/*  170 */     this.rootTypeQName = rootTypeQName;
/*      */   }
/*      */ 
/*      */   public boolean isSupportNil()
/*      */   {
/*  175 */     return this.supportNil;
/*      */   }
/*      */ 
/*      */   public void setSupportNil(boolean supportNil)
/*      */   {
/*  180 */     this.supportNil = supportNil;
/*      */   }
/*      */ 
/*      */   public void addAttribute(String prefix, String localName, String type, String value)
/*      */   {
/*      */   }
/*      */ 
/*      */   public void marshal(Reader xsdReader, ObjectModelProvider provider, Object root, Writer writer)
/*      */     throws IOException, SAXException, ParserConfigurationException
/*      */   {
/*  203 */     XSModel model = Util.loadSchema(xsdReader, null, this.schemaResolver);
/*  204 */     marshallInternal(provider, root, model, writer);
/*      */   }
/*      */ 
/*      */   public void marshal(String xsdURL, ObjectModelProvider provider, Object root, Writer writer)
/*      */     throws IOException, SAXException
/*      */   {
/*  210 */     XSModel model = Util.loadSchema(xsdURL, this.schemaResolver);
/*  211 */     marshallInternal(provider, root, model, writer);
/*      */   }
/*      */ 
/*      */   public void marshal(XSModel model, ObjectModelProvider provider, Object root, Writer writer)
/*      */     throws IOException, SAXException
/*      */   {
/*  217 */     marshallInternal(provider, root, model, writer);
/*      */   }
/*      */ 
/*      */   private void marshallInternal(ObjectModelProvider provider, Object root, XSModel model, Writer writer)
/*      */     throws IOException, SAXException
/*      */   {
/*  223 */     if (model == null)
/*      */     {
/*  225 */       throw new JBossXBRuntimeException("XSModel is not available!");
/*      */     }
/*      */ 
/*  228 */     this.model = model;
/*  229 */     this.provider = ((provider instanceof GenericObjectModelProvider) ? (GenericObjectModelProvider)provider : new DelegatingObjectModelProvider(provider));
/*      */ 
/*  232 */     this.root = root;
/*      */ 
/*  234 */     this.content.startDocument();
/*      */ 
/*  236 */     if (this.rootTypeQName != null)
/*      */     {
/*  238 */       if (this.rootQNames.isEmpty())
/*      */       {
/*  240 */         throw new JBossXBRuntimeException("If type name (" + this.rootTypeQName + ") for the root element is specified then the name for the root element is required!");
/*      */       }
/*      */ 
/*  245 */       QName rootQName = (QName)this.rootQNames.get(0);
/*      */ 
/*  247 */       XSTypeDefinition type = model.getTypeDefinition(this.rootTypeQName.getLocalPart(), this.rootTypeQName.getNamespaceURI());
/*      */ 
/*  250 */       if (type == null)
/*      */       {
/*  252 */         throw new JBossXBRuntimeException("Global type definition is not found: " + this.rootTypeQName);
/*      */       }
/*      */ 
/*  255 */       if (isArrayWrapper(type))
/*      */       {
/*  257 */         Object o = provider.getRoot(root, null, rootQName.getNamespaceURI(), rootQName.getLocalPart());
/*  258 */         this.stack.push(o);
/*  259 */         marshalComplexType(rootQName.getNamespaceURI(), rootQName.getLocalPart(), (XSComplexTypeDefinition)type, true, false);
/*      */ 
/*  265 */         this.stack.pop();
/*      */       }
/*      */       else
/*      */       {
/*  269 */         Object o = provider.getRoot(root, null, rootQName.getNamespaceURI(), rootQName.getLocalPart());
/*  270 */         marshalElementOccurence(rootQName.getNamespaceURI(), rootQName.getLocalPart(), type, o, false, false, true);
/*      */       }
/*      */ 
/*      */     }
/*  280 */     else if (this.rootQNames.isEmpty())
/*      */     {
/*  282 */       XSNamedMap components = model.getComponents(2);
/*  283 */       if (components.getLength() == 0)
/*      */       {
/*  285 */         throw new JBossXBRuntimeException("The schema doesn't contain global element declarations.");
/*      */       }
/*      */ 
/*  288 */       for (int i = 0; i < components.getLength(); i++)
/*      */       {
/*  290 */         XSElementDeclaration element = (XSElementDeclaration)components.item(i);
/*  291 */         Object o = provider.getRoot(root, null, element.getNamespace(), element.getName());
/*  292 */         marshalElementOccurence(element.getNamespace(), element.getName(), element.getTypeDefinition(), o, element.getNillable(), false, true);
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/*  304 */       for (int i = 0; i < this.rootQNames.size(); i++)
/*      */       {
/*  306 */         QName qName = (QName)this.rootQNames.get(i);
/*  307 */         XSElementDeclaration element = model.getElementDeclaration(qName.getLocalPart(), qName.getNamespaceURI());
/*  308 */         if (element == null)
/*      */         {
/*  310 */           XSNamedMap components = model.getComponents(2);
/*  311 */           String roots = "";
/*  312 */           for (int j = 0; j < components.getLength(); j++)
/*      */           {
/*  314 */             XSObject xsObject = components.item(j);
/*  315 */             if (j > 0)
/*      */             {
/*  317 */               roots = roots + ", ";
/*      */             }
/*  319 */             roots = roots + "{" + xsObject.getNamespace() + "}" + xsObject.getName();
/*      */           }
/*  321 */           throw new IllegalStateException("Root element not found: " + qName + " among " + roots);
/*      */         }
/*      */ 
/*  324 */         Object o = provider.getRoot(root, null, element.getNamespace(), element.getName());
/*  325 */         marshalElementOccurence(element.getNamespace(), element.getName(), element.getTypeDefinition(), o, element.getNillable(), false, true);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  336 */     this.content.endDocument();
/*      */ 
/*  339 */     writeXmlVersion(writer);
/*      */ 
/*  341 */     ContentWriter contentWriter = new ContentWriter(writer, propertyIsTrueOrNotSet("org.jboss.xml.binding.marshalling.indent"));
/*      */ 
/*  344 */     this.content.handleContent(contentWriter);
/*      */ 
/*  346 */     if (this.log.isTraceEnabled())
/*      */     {
/*  348 */       StringWriter traceWriter = new StringWriter();
/*  349 */       contentWriter = new ContentWriter(traceWriter, propertyIsTrueOrNotSet("org.jboss.xml.binding.marshalling.indent"));
/*      */ 
/*  352 */       this.content.handleContent(contentWriter);
/*  353 */       this.log.trace("marshalled:\n" + traceWriter.getBuffer().toString());
/*      */     }
/*      */   }
/*      */ 
/*      */   private boolean marshalElement(String elementNs, String elementLocal, XSTypeDefinition type, boolean optional, boolean nillable, boolean declareNs, boolean declareXsiType)
/*      */   {
/*  364 */     Object value = this.stack.peek();
/*  365 */     boolean result = (value != null) || ((value == null) && ((optional) || (nillable)));
/*  366 */     boolean trace = (this.log.isTraceEnabled()) && (result);
/*  367 */     if (trace)
/*      */     {
/*  369 */       String prefix = getPrefix(elementNs);
/*  370 */       this.log.trace("started element ns=" + elementNs + ", local=" + elementLocal + ", prefix=" + prefix);
/*      */     }
/*      */ 
/*  373 */     if (value != null)
/*      */     {
/*  375 */       marshalElementType(elementNs, elementLocal, type, declareNs, nillable, declareXsiType);
/*      */     }
/*  377 */     else if (nillable)
/*      */     {
/*  379 */       writeNillable(elementNs, elementLocal, nillable);
/*      */     }
/*      */ 
/*  382 */     if (trace)
/*      */     {
/*  384 */       this.log.trace("finished element ns=" + elementNs + ", local=" + elementLocal);
/*      */     }
/*      */ 
/*  387 */     return result;
/*      */   }
/*      */ 
/*      */   private void marshalElementType(String elementNs, String elementLocal, XSTypeDefinition type, boolean declareNs, boolean nillable, boolean declareXsiType)
/*      */   {
/*  397 */     switch (type.getTypeCategory())
/*      */     {
/*      */     case 16:
/*  400 */       marshalSimpleType(elementNs, elementLocal, (XSSimpleTypeDefinition)type, declareNs, nillable, declareXsiType);
/*      */ 
/*  407 */       break;
/*      */     case 15:
/*  409 */       marshalComplexType(elementNs, elementLocal, (XSComplexTypeDefinition)type, declareNs, declareXsiType);
/*  410 */       break;
/*      */     default:
/*  412 */       throw new IllegalStateException("Unexpected type category: " + type.getTypeCategory());
/*      */     }
/*      */   }
/*      */ 
/*      */   private void marshalSimpleType(String elementUri, String elementLocal, XSSimpleTypeDefinition type, boolean declareNs, boolean nillable, boolean declareXsiType)
/*      */   {
/*  423 */     Object value = this.stack.peek();
/*  424 */     if (value != null)
/*      */     {
/*  426 */       String prefix = getPrefix(elementUri);
/*  427 */       boolean genPrefix = (prefix == null) && (elementUri != null) && (elementUri.length() > 0);
/*  428 */       if (genPrefix)
/*      */       {
/*  430 */         prefix = "ns_" + elementLocal;
/*      */       }
/*      */ 
/*  433 */       AttributesImpl attrs = null;
/*  434 */       String typeName = type.getName();
/*  435 */       if (("QName".equals(typeName)) || ("NOTATION".equals(typeName)) || ((type.getItemType() != null) && (("QName".equals(type.getItemType().getName())) || ("NOTATION".equals(type.getItemType().getName())))))
/*      */       {
/*  443 */         attrs = new AttributesImpl(5);
/*      */       }
/*      */ 
/*  446 */       String marshalled = marshalCharacters(elementUri, prefix, type, value, attrs);
/*      */ 
/*  448 */       if (((declareNs) || (declareXsiType)) && (this.nsRegistry.size() > 0))
/*      */       {
/*  450 */         if (attrs == null)
/*      */         {
/*  452 */           attrs = new AttributesImpl(this.nsRegistry.size() + 1);
/*      */         }
/*  454 */         declareNs(attrs);
/*      */       }
/*      */ 
/*  457 */       if (declareXsiType)
/*      */       {
/*  459 */         declareXsiType(type, attrs);
/*      */       }
/*      */ 
/*  462 */       if (genPrefix)
/*      */       {
/*  464 */         if (attrs == null)
/*      */         {
/*  466 */           attrs = new AttributesImpl(1);
/*      */         }
/*  468 */         attrs.add(null, prefix, "xmlns:" + prefix, null, elementUri);
/*      */       }
/*      */ 
/*  471 */       String qName = prefixLocalName(prefix, elementLocal);
/*      */ 
/*  473 */       this.content.startElement(elementUri, elementLocal, qName, attrs);
/*  474 */       this.content.characters(marshalled.toCharArray(), 0, marshalled.length());
/*  475 */       this.content.endElement(elementUri, elementLocal, qName);
/*      */     }
/*      */     else
/*      */     {
/*  479 */       writeNillable(elementUri, elementLocal, nillable);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void marshalComplexType(String elementNsUri, String elementLocalName, XSComplexTypeDefinition type, boolean declareNs, boolean declareXsiType)
/*      */   {
/*  489 */     Object o = this.stack.peek();
/*  490 */     XSParticle particle = type.getParticle();
/*      */ 
/*  492 */     XSObjectList attributeUses = type.getAttributeUses();
/*  493 */     int attrsTotal = (declareNs) || (declareXsiType) ? this.nsRegistry.size() + attributeUses.getLength() + 1 : attributeUses.getLength();
/*      */ 
/*  496 */     AttributesImpl attrs = attrsTotal > 0 ? new AttributesImpl(attrsTotal) : null;
/*      */ 
/*  498 */     if ((declareNs) && (this.nsRegistry.size() > 0))
/*      */     {
/*  500 */       declareNs(attrs);
/*      */     }
/*      */ 
/*  503 */     String generatedPrefix = null;
/*  504 */     if (declareXsiType)
/*      */     {
/*  506 */       generatedPrefix = declareXsiType(type, attrs);
/*  507 */       if (generatedPrefix != null)
/*      */       {
/*  509 */         String typeNsWithGeneratedPrefix = type.getNamespace();
/*  510 */         declareNs(attrs, generatedPrefix, typeNsWithGeneratedPrefix);
/*  511 */         declareNamespace(generatedPrefix, typeNsWithGeneratedPrefix);
/*      */       }
/*      */     }
/*      */ 
/*  515 */     String prefix = getPrefix(elementNsUri);
/*  516 */     boolean genPrefix = (prefix == null) && (elementNsUri != null) && (elementNsUri.length() > 0);
/*  517 */     if (genPrefix)
/*      */     {
/*  520 */       prefix = "ns_" + elementLocalName;
/*  521 */       declareNamespace(prefix, elementNsUri);
/*  522 */       if (attrs == null)
/*      */       {
/*  524 */         attrs = new AttributesImpl(1);
/*      */       }
/*  526 */       attrs.add(null, prefix, "xmlns:" + prefix, null, elementNsUri);
/*      */     }
/*      */ 
/*  529 */     for (int i = 0; i < attributeUses.getLength(); i++)
/*      */     {
/*  531 */       this.currentAttribute = ((XSAttributeUse)attributeUses.item(i));
/*  532 */       XSAttributeDeclaration attrDec = this.currentAttribute.getAttrDeclaration();
/*  533 */       String attrNs = attrDec.getNamespace();
/*  534 */       String attrLocal = attrDec.getName();
/*  535 */       Object attrValue = this.provider.getAttributeValue(o, this.ctx, attrNs, attrLocal);
/*      */ 
/*  537 */       if (attrValue == null)
/*      */         continue;
/*  539 */       if (attrs == null)
/*      */       {
/*  541 */         attrs = new AttributesImpl(5);
/*      */       }
/*      */ 
/*  544 */       String attrPrefix = null;
/*  545 */       if (attrNs != null)
/*      */       {
/*  547 */         attrPrefix = getPrefix(attrNs);
/*  548 */         if ((attrPrefix == null) && (attrNs != null) && (attrNs.length() > 0))
/*      */         {
/*  550 */           attrPrefix = "ns_" + attrLocal;
/*  551 */           attrs.add(null, attrPrefix, "xmlns:" + attrPrefix, null, attrNs);
/*      */         }
/*      */       }
/*      */ 
/*  555 */       String qName = attrPrefix + ":" + attrLocal;
/*      */ 
/*  558 */       XSSimpleTypeDefinition attrType = attrDec.getTypeDefinition();
/*  559 */       if (attrType.getItemType() != null)
/*      */       {
/*  561 */         XSSimpleTypeDefinition itemType = attrType.getItemType();
/*  562 */         if ("http://www.w3.org/2001/XMLSchema".equals(itemType.getNamespace()))
/*      */         {
/*      */           List list;
/*  565 */           if ((attrValue instanceof List))
/*      */           {
/*  567 */             list = (List)attrValue;
/*      */           }
/*      */           else
/*      */           {
/*      */             List list;
/*  569 */             if (attrValue.getClass().isArray())
/*      */             {
/*  571 */               list = Arrays.asList((Object[])(Object[])attrValue);
/*      */             }
/*      */             else
/*      */             {
/*  575 */               throw new JBossXBRuntimeException("Expected value for list type is an array or " + List.class.getName() + " but got: " + attrValue);
/*      */             }
/*      */           }
/*      */           List list;
/*  582 */           if (Constants.QNAME_QNAME.getLocalPart().equals(itemType.getName()))
/*      */           {
/*  584 */             for (int listInd = 0; listInd < list.size(); listInd++)
/*      */             {
/*  586 */               QName item = (QName)list.get(listInd);
/*  587 */               String itemNs = item.getNamespaceURI();
/*  588 */               if ((itemNs == null) || (itemNs.length() <= 0))
/*      */                 continue;
/*      */               String itemPrefix;
/*      */               String itemPrefix;
/*  591 */               if (itemNs.equals(elementNsUri))
/*      */               {
/*  593 */                 itemPrefix = prefix;
/*      */               }
/*      */               else
/*      */               {
/*  597 */                 itemPrefix = getPrefix(itemNs);
/*  598 */                 if (itemPrefix == null)
/*      */                 {
/*  600 */                   itemPrefix = attrLocal + listInd;
/*  601 */                   declareNs(attrs, itemPrefix, itemNs);
/*      */                 }
/*      */               }
/*  604 */               item = new QName(item.getNamespaceURI(), item.getLocalPart(), itemPrefix);
/*  605 */               list.set(listInd, item);
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/*  610 */           attrValue = SimpleTypeBindings.marshalList(itemType.getName(), list, null);
/*      */         }
/*      */         else
/*      */         {
/*  614 */           throw new JBossXBRuntimeException("Marshalling of list types with item types not from http://www.w3.org/2001/XMLSchema is not supported.");
/*      */         }
/*      */ 
/*      */       }
/*  619 */       else if ((attrType.getLexicalPattern().item(0) != null) && (attrType.derivedFrom("http://www.w3.org/2001/XMLSchema", Constants.QNAME_BOOLEAN.getLocalPart(), 2)))
/*      */       {
/*  626 */         String item = attrType.getLexicalPattern().item(0);
/*  627 */         if ((item.indexOf('0') != -1) && (item.indexOf('1') != -1))
/*      */         {
/*  629 */           attrValue = ((Boolean)attrValue).booleanValue() ? "1" : "0";
/*      */         }
/*      */         else
/*      */         {
/*  633 */           attrValue = ((Boolean)attrValue).booleanValue() ? "true" : "false";
/*      */         }
/*      */       }
/*  636 */       else if ((Constants.QNAME_QNAME.getNamespaceURI().equals(attrType.getNamespace())) && (Constants.QNAME_QNAME.getLocalPart().equals(attrType.getName())))
/*      */       {
/*  639 */         QName qNameValue = (QName)attrValue;
/*      */ 
/*  641 */         String qNamePrefix = null;
/*  642 */         boolean declarePrefix = false;
/*  643 */         String ns = qNameValue.getNamespaceURI();
/*  644 */         if ((ns != null) && (ns.length() > 0))
/*      */         {
/*  646 */           qNamePrefix = getPrefix(ns);
/*  647 */           if (qNamePrefix == null)
/*      */           {
/*  649 */             qNamePrefix = qNameValue.getPrefix();
/*  650 */             if ((qNamePrefix == null) || (qNamePrefix.length() == 0))
/*      */             {
/*  652 */               qNamePrefix = "ns_" + qNameValue.getLocalPart();
/*      */             }
/*  654 */             declareNs(attrs, qNamePrefix, ns);
/*  655 */             this.nsRegistry.addPrefixMapping(qNamePrefix, ns);
/*  656 */             declarePrefix = true;
/*      */           }
/*      */         }
/*      */ 
/*  660 */         attrValue = SimpleTypeBindings.marshalQName(qNameValue, this.nsRegistry);
/*      */ 
/*  662 */         if (declarePrefix)
/*      */         {
/*  664 */           this.nsRegistry.removePrefixMapping(qNamePrefix);
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/*  669 */         attrValue = attrValue.toString();
/*      */       }
/*      */ 
/*  672 */       attrs.add(attrNs, attrLocal, qName, attrDec.getTypeDefinition().getName(), attrValue.toString());
/*      */     }
/*      */ 
/*  680 */     this.currentAttribute = null;
/*      */ 
/*  682 */     String characters = null;
/*  683 */     if (type.getSimpleType() != null)
/*      */     {
/*  685 */       Object value = getSimpleContentValue(elementNsUri, elementLocalName, type);
/*  686 */       if (value != null)
/*      */       {
/*  688 */         XSSimpleTypeDefinition simpleType = type.getSimpleType();
/*  689 */         String typeName = simpleType.getName();
/*  690 */         if ((attrs == null) && (("QName".equals(typeName)) || ("NOTATION".equals(typeName)) || ((simpleType.getItemType() != null) && (("QName".equals(simpleType.getItemType().getName())) || ("NOTATION".equals(simpleType.getItemType().getName()))))))
/*      */         {
/*  699 */           attrs = new AttributesImpl(5);
/*      */         }
/*      */ 
/*  702 */         characters = marshalCharacters(elementNsUri, prefix, simpleType, value, attrs);
/*      */       }
/*      */     }
/*      */ 
/*  706 */     String qName = prefixLocalName(prefix, elementLocalName);
/*  707 */     this.content.startElement(elementNsUri, elementLocalName, qName, attrs);
/*      */ 
/*  709 */     if (particle != null)
/*      */     {
/*  711 */       marshalParticle(particle, false);
/*      */     }
/*      */ 
/*  714 */     if (characters != null)
/*      */     {
/*  716 */       this.content.characters(characters.toCharArray(), 0, characters.length());
/*      */     }
/*  718 */     this.content.endElement(elementNsUri, elementLocalName, qName);
/*      */ 
/*  720 */     if (genPrefix)
/*      */     {
/*  722 */       removePrefixMapping(prefix);
/*      */     }
/*      */ 
/*  725 */     if (generatedPrefix != null)
/*      */     {
/*  727 */       removePrefixMapping(generatedPrefix);
/*      */     }
/*      */   }
/*      */ 
/*      */   private boolean marshalParticle(XSParticle particle, boolean declareNs)
/*      */   {
/*  734 */     XSTerm term = particle.getTerm();
/*      */     Object o;
/*      */     Iterator i;
/*      */     boolean marshalled;
/*      */     boolean marshalled;
/*      */     boolean marshalled;
/*  737 */     switch (term.getType())
/*      */     {
/*      */     case 7:
/*  740 */       o = this.stack.peek();
/*  741 */       i = (o != null) && (isRepeatable(particle)) ? getIterator(o) : null;
/*  742 */       if (i != null)
/*      */       {
/*  744 */         boolean marshalled = true;
/*  745 */         while ((i.hasNext()) && (marshalled))
/*      */         {
/*  747 */           Object value = i.next();
/*  748 */           this.stack.push(value);
/*  749 */           marshalled = marshalModelGroup(particle, declareNs);
/*  750 */           this.stack.pop();
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  755 */       marshalled = marshalModelGroup(particle, declareNs);
/*      */ 
/*  757 */       break;
/*      */     case 9:
/*  759 */       o = this.stack.peek();
/*      */ 
/*  761 */       boolean popWildcardValue = false;
/*  762 */       ObjectLocalMarshaller marshaller = null;
/*  763 */       AbstractMarshaller.FieldToWildcardMapping mapping = (AbstractMarshaller.FieldToWildcardMapping)this.field2WildcardMap.get(o.getClass());
/*  764 */       if (mapping != null)
/*      */       {
/*  766 */         marshaller = mapping.marshaller;
/*  767 */         o = mapping.fieldInfo.getValue(o);
/*  768 */         this.stack.push(o);
/*  769 */         popWildcardValue = true;
/*      */       }
/*      */ 
/*  772 */       i = (o != null) && (isRepeatable(particle)) ? getIterator(o) : null;
/*  773 */       if (i != null)
/*      */       {
/*  775 */         marshalled = true;
/*  776 */         while ((i.hasNext()) && (marshalled))
/*      */         {
/*  778 */           Object value = i.next();
/*  779 */           marshalled = marshalWildcardOccurence(particle, marshaller, value, declareNs);
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  784 */       marshalled = marshalWildcardOccurence(particle, marshaller, o, declareNs);
/*      */ 
/*  787 */       if (!popWildcardValue)
/*      */         break;
/*  789 */       this.stack.pop(); break;
/*      */     case 2:
/*  794 */       XSElementDeclaration element = (XSElementDeclaration)term;
/*  795 */       XSTypeDefinition type = element.getTypeDefinition();
/*  796 */       o = getElementValue(element.getNamespace(), element.getName(), type);
/*      */ 
/*  798 */       i = (o != null) && (isRepeatable(particle)) ? getIterator(o) : null;
/*  799 */       if (i != null)
/*      */       {
/*  801 */         marshalled = true;
/*  802 */         while ((i.hasNext()) && (marshalled))
/*      */         {
/*  804 */           Object value = i.next();
/*  805 */           marshalled = marshalElementOccurence(element.getNamespace(), element.getName(), type, value, element.getNillable(), particle.getMinOccurs() == 0, declareNs);
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  818 */       marshalled = marshalElementOccurence(element.getNamespace(), element.getName(), type, o, element.getNillable(), particle.getMinOccurs() == 0, declareNs);
/*      */ 
/*  828 */       break;
/*      */     default:
/*  830 */       throw new IllegalStateException("Unexpected term type: " + term.getType());
/*      */     }
/*  832 */     return marshalled;
/*      */   }
/*      */ 
/*      */   private boolean marshalElementOccurence(String elementNs, String elementLocal, XSTypeDefinition type, Object value, boolean nillable, boolean optional, boolean declareNs)
/*      */   {
/*  843 */     boolean declareXsiType = false;
/*  844 */     QName xsiTypeQName = null;
/*  845 */     if (value != null)
/*      */     {
/*  847 */       xsiTypeQName = (QName)this.cls2TypeMap.get(value.getClass());
/*  848 */       if ((xsiTypeQName != null) && ((!type.getName().equals(xsiTypeQName.getLocalPart())) || (!type.getNamespace().equals(xsiTypeQName.getNamespaceURI()))))
/*      */       {
/*  853 */         declareXsiType = true;
/*  854 */         if (this.log.isTraceEnabled())
/*      */         {
/*  856 */           this.log.trace(value.getClass() + " is mapped to xsi:type " + xsiTypeQName);
/*      */         }
/*      */ 
/*  859 */         XSTypeDefinition xsiType = this.model.getTypeDefinition(xsiTypeQName.getLocalPart(), xsiTypeQName.getNamespaceURI());
/*      */ 
/*  863 */         if (xsiType == null)
/*      */         {
/*  865 */           this.log.warn("Class " + value.getClass() + " is mapped to type " + xsiTypeQName + " but the type is not found in schema.");
/*      */         }
/*      */         else
/*      */         {
/*  875 */           type = xsiType;
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  880 */     this.stack.push(value);
/*  881 */     boolean marshalled = marshalElement(elementNs, elementLocal, type, optional, nillable, declareNs, declareXsiType);
/*      */ 
/*  889 */     this.stack.pop();
/*      */ 
/*  891 */     return marshalled;
/*      */   }
/*      */ 
/*      */   private boolean marshalWildcardOccurence(XSParticle particle, ObjectLocalMarshaller marshaller, Object value, boolean declareNs)
/*      */   {
/*  899 */     boolean marshalled = true;
/*  900 */     if (marshaller != null)
/*      */     {
/*  902 */       marshaller.marshal(this.ctx, value);
/*      */     }
/*      */     else
/*      */     {
/*  906 */       this.stack.push(value);
/*  907 */       marshalled = marshalWildcard(particle, declareNs);
/*  908 */       this.stack.pop();
/*      */     }
/*  910 */     return marshalled;
/*      */   }
/*      */ 
/*      */   private boolean marshalWildcard(XSParticle particle, boolean declareNs)
/*      */   {
/*  915 */     XSWildcard wildcard = (XSWildcard)particle.getTerm();
/*  916 */     Object o = this.stack.peek();
/*  917 */     AbstractMarshaller.ClassMapping mapping = getClassMapping(o.getClass());
/*  918 */     if (mapping == null)
/*      */     {
/*  921 */       QName autoType = SimpleTypeBindings.typeQName(o.getClass());
/*  922 */       if (autoType != null)
/*      */       {
/*  924 */         String marshalled = SimpleTypeBindings.marshal(autoType.getLocalPart(), o, null);
/*  925 */         this.content.characters(marshalled.toCharArray(), 0, marshalled.length());
/*  926 */         return true;
/*      */       }
/*      */ 
/*  930 */       if (this.ignoreUnresolvedWildcard)
/*      */       {
/*  932 */         this.log.warn("Failed to marshal wildcard. Class mapping not found for " + o.getClass() + "@" + o.hashCode() + ": " + o);
/*      */ 
/*  938 */         return true;
/*      */       }
/*      */ 
/*  942 */       throw new IllegalStateException("Failed to marshal wildcard. Class mapping not found for " + o.getClass() + "@" + o.hashCode() + ": " + o);
/*      */     }
/*      */ 
/*  952 */     GenericObjectModelProvider parentProvider = this.provider;
/*  953 */     Object parentRoot = this.root;
/*  954 */     AbstractMarshaller.Stack parentStack = this.stack;
/*  955 */     XSModel parentModel = this.model;
/*      */ 
/*  957 */     this.root = o;
/*  958 */     this.stack = new AbstractMarshaller.StackImpl();
/*  959 */     this.model = (mapping.schemaUrl == null ? this.model : Util.loadSchema(mapping.schemaUrl, this.schemaResolver));
/*  960 */     if (mapping.provider != null)
/*      */     {
/*  962 */       this.provider = mapping.provider;
/*      */     }
/*      */     boolean marshalled;
/*  966 */     if (mapping.elementName != null)
/*      */     {
/*  968 */       XSElementDeclaration elDec = this.model.getElementDeclaration(mapping.elementName.getLocalPart(), mapping.elementName.getNamespaceURI());
/*      */ 
/*  972 */       if (elDec == null)
/*      */       {
/*  974 */         throw new JBossXBRuntimeException("Element " + mapping.elementName + " is not declared in the schema.");
/*      */       }
/*      */ 
/*  977 */       Object elementValue = this.provider.getRoot(this.root, null, elDec.getNamespace(), elDec.getName());
/*  978 */       marshalled = marshalElementOccurence(elDec.getNamespace(), elDec.getName(), elDec.getTypeDefinition(), elementValue, elDec.getNillable(), particle.getMinOccurs() == 0, declareNs);
/*      */     }
/*      */     else
/*      */     {
/*      */       boolean marshalled;
/*  987 */       if (mapping.typeName != null)
/*      */       {
/*  989 */         XSTypeDefinition typeDef = this.model.getTypeDefinition(mapping.typeName.getLocalPart(), mapping.typeName.getNamespaceURI());
/*      */ 
/*  993 */         if (typeDef == null)
/*      */         {
/*  995 */           List typeNames = new ArrayList();
/*  996 */           XSNamedMap types = this.model.getComponents(3);
/*  997 */           for (int i = 0; i < types.getLength(); i++)
/*      */           {
/*  999 */             XSObject type = types.item(i);
/* 1000 */             if ("http://www.w3.org/2001/XMLSchema".equals(type.getNamespace()))
/*      */               continue;
/* 1002 */             typeNames.add(new QName(type.getNamespace(), type.getName()));
/*      */           }
/*      */ 
/* 1005 */           throw new JBossXBRuntimeException("Type " + mapping.typeName + " is not defined in the schema." + " Defined types are: " + typeNames);
/*      */         }
/*      */ 
/* 1012 */         Object elementValue = this.provider.getRoot(this.root, null, wildcard.getNamespace(), wildcard.getName());
/* 1013 */         marshalled = marshalElementOccurence(wildcard.getNamespace(), wildcard.getName(), typeDef, elementValue, true, particle.getMinOccurs() == 0, declareNs);
/*      */       }
/*      */       else
/*      */       {
/* 1025 */         throw new JBossXBRuntimeException("Class mapping for " + mapping.cls + " is associated with neither global element name nor global type name.");
/*      */       }
/*      */     }
/*      */     boolean marshalled;
/* 1031 */     this.root = parentRoot;
/* 1032 */     this.provider = parentProvider;
/* 1033 */     this.stack = parentStack;
/* 1034 */     this.model = parentModel;
/*      */ 
/* 1036 */     return marshalled;
/*      */   }
/*      */ 
/*      */   private boolean marshalModelGroup(XSParticle particle, boolean declareNs)
/*      */   {
/* 1041 */     XSModelGroup modelGroup = (XSModelGroup)particle.getTerm();
/*      */     boolean marshalled;
/* 1043 */     switch (modelGroup.getCompositor())
/*      */     {
/*      */     case 3:
/* 1046 */       marshalled = marshalModelGroupAll(modelGroup.getParticles(), declareNs);
/* 1047 */       break;
/*      */     case 2:
/* 1049 */       marshalled = marshalModelGroupChoice(modelGroup.getParticles(), declareNs);
/* 1050 */       break;
/*      */     case 1:
/* 1052 */       marshalled = marshalModelGroupSequence(modelGroup.getParticles(), declareNs);
/* 1053 */       break;
/*      */     default:
/* 1055 */       throw new IllegalStateException("Unexpected compsitor: " + modelGroup.getCompositor());
/*      */     }
/* 1057 */     return marshalled;
/*      */   }
/*      */ 
/*      */   private boolean marshalModelGroupAll(XSObjectList particles, boolean declareNs)
/*      */   {
/* 1062 */     boolean marshalled = false;
/* 1063 */     for (int i = 0; i < particles.getLength(); i++)
/*      */     {
/* 1065 */       XSParticle particle = (XSParticle)particles.item(i);
/* 1066 */       marshalled |= marshalParticle(particle, declareNs);
/*      */     }
/* 1068 */     return marshalled;
/*      */   }
/*      */ 
/*      */   private boolean marshalModelGroupChoice(XSObjectList particles, boolean declareNs)
/*      */   {
/* 1073 */     boolean marshalled = false;
/* 1074 */     Content mainContent = this.content;
/* 1075 */     for (int i = 0; (i < particles.getLength()) && (!marshalled); i++)
/*      */     {
/* 1077 */       XSParticle particle = (XSParticle)particles.item(i);
/* 1078 */       this.content = new Content();
/* 1079 */       marshalled = marshalParticle(particle, declareNs);
/*      */     }
/*      */ 
/* 1082 */     if (marshalled)
/*      */     {
/* 1084 */       mainContent.append(this.content);
/*      */     }
/* 1086 */     this.content = mainContent;
/*      */ 
/* 1088 */     return marshalled;
/*      */   }
/*      */ 
/*      */   private boolean marshalModelGroupSequence(XSObjectList particles, boolean declareNs)
/*      */   {
/* 1093 */     boolean marshalled = true;
/* 1094 */     for (int i = 0; i < particles.getLength(); i++)
/*      */     {
/* 1096 */       XSParticle particle = (XSParticle)particles.item(i);
/* 1097 */       marshalled &= marshalParticle(particle, declareNs);
/*      */     }
/* 1099 */     return marshalled;
/*      */   }
/*      */ 
/*      */   private String marshalCharacters(String elementUri, String elementPrefix, XSSimpleTypeDefinition type, Object value, AttributesImpl attrs)
/*      */   {
/*      */     String marshalled;
/*      */     String marshalled;
/* 1109 */     if (type.getItemType() != null)
/*      */     {
/* 1111 */       XSSimpleTypeDefinition itemType = type.getItemType();
/*      */       String marshalled;
/* 1112 */       if ("http://www.w3.org/2001/XMLSchema".equals(itemType.getNamespace()))
/*      */       {
/*      */         List list;
/* 1115 */         if ((value instanceof List))
/*      */         {
/* 1117 */           list = (List)value;
/*      */         }
/*      */         else
/*      */         {
/*      */           List list;
/* 1119 */           if (value.getClass().isArray())
/*      */           {
/* 1121 */             list = asList(value);
/*      */           }
/*      */           else
/*      */           {
/* 1126 */             throw new JBossXBRuntimeException("Expected value for list type is an array or " + List.class.getName() + " but got: " + value);
/*      */           }
/*      */         }
/*      */         List list;
/* 1131 */         marshalled = SimpleTypeBindings.marshalList(itemType.getName(), list, null);
/*      */       }
/*      */       else
/*      */       {
/* 1135 */         throw new JBossXBRuntimeException("Marshalling of list types with item types not from http://www.w3.org/2001/XMLSchema is not supported.");
/*      */       }
/*      */ 
/*      */     }
/* 1140 */     else if ("http://www.w3.org/2001/XMLSchema".equals(type.getNamespace()))
/*      */     {
/* 1142 */       String typeName = type.getName();
/*      */ 
/* 1144 */       String prefix = null;
/* 1145 */       boolean removePrefix = false;
/* 1146 */       if (("QName".equals(typeName)) || ("NOTATION".equals(typeName)))
/*      */       {
/* 1149 */         QName qName = (QName)value;
/* 1150 */         if ((qName.getNamespaceURI() != null) && (qName.getNamespaceURI().length() > 0))
/*      */         {
/* 1152 */           prefix = this.nsRegistry.getPrefix(qName.getNamespaceURI());
/* 1153 */           if (prefix == null)
/*      */           {
/* 1155 */             prefix = qName.getPrefix();
/* 1156 */             if ((prefix == null) || (prefix.length() == 0))
/*      */             {
/* 1158 */               prefix = qName.getLocalPart() + "_ns";
/*      */             }
/* 1160 */             this.nsRegistry.addPrefixMapping(prefix, qName.getNamespaceURI());
/* 1161 */             declareNs(attrs, prefix, qName.getNamespaceURI());
/*      */ 
/* 1163 */             removePrefix = true;
/*      */           }
/*      */         }
/*      */       }
/* 1167 */       String marshalled = SimpleTypeBindings.marshal(typeName, value, this.nsRegistry);
/*      */ 
/* 1169 */       if (removePrefix)
/*      */       {
/* 1171 */         this.nsRegistry.removePrefixMapping(prefix);
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/*      */       String marshalled;
/* 1175 */       if ((type.getLexicalPattern().item(0) != null) && (type.derivedFrom("http://www.w3.org/2001/XMLSchema", Constants.QNAME_BOOLEAN.getLocalPart(), 2)))
/*      */       {
/* 1182 */         String item = type.getLexicalPattern().item(0);
/*      */         String marshalled;
/* 1183 */         if ((item.indexOf('0') != -1) && (item.indexOf('1') != -1))
/*      */         {
/* 1185 */           marshalled = ((Boolean)value).booleanValue() ? "1" : "0";
/*      */         }
/*      */         else
/*      */         {
/* 1189 */           marshalled = ((Boolean)value).booleanValue() ? "true" : "false";
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/* 1194 */         StringList lexicalEnumeration = type.getLexicalEnumeration();
/* 1195 */         if ((lexicalEnumeration != null) && (lexicalEnumeration.getLength() > 0))
/*      */         {
/*      */           Method getValue;
/*      */           try {
/* 1200 */             getValue = value.getClass().getMethod("value", null);
/*      */           }
/*      */           catch (NoSuchMethodException e)
/*      */           {
/*      */             try
/*      */             {
/* 1206 */               getValue = value.getClass().getMethod("getValue", null);
/*      */             }
/*      */             catch (NoSuchMethodException e1)
/*      */             {
/* 1210 */               List values = new ArrayList(lexicalEnumeration.getLength());
/* 1211 */               for (int i = 0; i < lexicalEnumeration.getLength(); i++)
/*      */               {
/* 1213 */                 values.add(lexicalEnumeration.item(i));
/*      */               }
/*      */ 
/* 1216 */               throw new JBossXBRuntimeException("Failed to find neither value() nor getValue() in " + value.getClass() + " which is bound to enumeration type (" + type.getNamespace() + ", " + type.getName() + "): " + values);
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/*      */           try
/*      */           {
/* 1228 */             value = getValue.invoke(value, null);
/*      */           }
/*      */           catch (Exception e)
/*      */           {
/* 1232 */             throw new JBossXBRuntimeException("Failed to invoke getValue() on " + value + " to get the enumeration value", e);
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/* 1238 */         marshalled = marshalCharacters(elementUri, elementPrefix, (XSSimpleTypeDefinition)type.getBaseType(), value, attrs);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1244 */     return marshalled;
/*      */   }
/*      */ 
/*      */   private String declareXsiType(XSTypeDefinition type, AttributesImpl attrs)
/*      */   {
/* 1255 */     String result = null;
/* 1256 */     String xsiPrefix = this.nsRegistry.getPrefix("http://www.w3.org/2001/XMLSchema-instance");
/* 1257 */     if (xsiPrefix == null)
/*      */     {
/* 1259 */       attrs.add("http://www.w3.org/2001/XMLSchema", "xmlns", "xmlns:xsi", null, "http://www.w3.org/2001/XMLSchema-instance");
/* 1260 */       xsiPrefix = "xsi";
/*      */     }
/*      */ 
/* 1263 */     String pref = getPrefix(type.getNamespace());
/* 1264 */     if (pref == null)
/*      */     {
/* 1267 */       result = pref = type.getName() + "_ns";
/*      */     }
/*      */ 
/* 1270 */     String typeQName = pref + ':' + type.getName();
/* 1271 */     attrs.add("http://www.w3.org/2001/XMLSchema-instance", "type", xsiPrefix + ":type", null, typeQName);
/* 1272 */     return result;
/*      */   }
/*      */ 
/*      */   private Object getElementValue(String elementNs, String elementLocal, XSTypeDefinition type)
/*      */   {
/* 1278 */     Object peeked = this.stack.isEmpty() ? this.root : this.stack.peek();
/*      */     Object value;
/*      */     Object value;
/* 1279 */     if (peeked == null)
/*      */     {
/* 1281 */       value = null;
/*      */     }
/*      */     else
/*      */     {
/*      */       Object value;
/* 1283 */       if (((peeked instanceof Collection)) || (peeked.getClass().isArray()))
/*      */       {
/* 1286 */         value = peeked;
/*      */       }
/*      */       else
/*      */       {
/* 1290 */         XSTypeDefinition parentType = this.currentElementType;
/* 1291 */         this.currentElementType = type;
/*      */ 
/* 1293 */         value = this.provider.getChildren(peeked, this.ctx, elementNs, elementLocal);
/* 1294 */         if (value == null)
/*      */         {
/* 1296 */           value = this.provider.getElementValue(peeked, this.ctx, elementNs, elementLocal);
/*      */         }
/*      */ 
/* 1299 */         this.currentElementType = parentType;
/*      */       }
/*      */     }
/* 1301 */     return value;
/*      */   }
/*      */ 
/*      */   private Object getSimpleContentValue(String elementNs, String elementLocal, XSTypeDefinition type)
/*      */   {
/* 1307 */     Object peeked = this.stack.isEmpty() ? this.root : this.stack.peek();
/*      */     Object value;
/*      */     Object value;
/* 1308 */     if (peeked == null)
/*      */     {
/* 1310 */       value = null;
/*      */     }
/*      */     else
/*      */     {
/* 1314 */       XSTypeDefinition parentType = this.currentElementType;
/* 1315 */       this.currentElementType = type;
/* 1316 */       value = this.provider.getElementValue(peeked, this.ctx, elementNs, elementLocal);
/* 1317 */       this.currentElementType = parentType;
/*      */     }
/* 1319 */     return value;
/*      */   }
/*      */ 
/*      */   private void writeNillable(String elementNs, String elementLocal, boolean nillable)
/*      */   {
/* 1324 */     if (!this.supportNil)
/*      */     {
/* 1326 */       return;
/*      */     }
/*      */ 
/* 1329 */     if (!nillable)
/*      */     {
/* 1331 */       throw new JBossXBRuntimeException("Failed to marshal " + new QName(elementNs, elementLocal) + ": Java value is null but the element is not nillable.");
/*      */     }
/*      */ 
/* 1338 */     String prefix = getPrefix(elementNs);
/*      */     AttributesImpl attrs;
/* 1339 */     if ((prefix == null) && (elementNs != null) && (elementNs.length() > 0))
/*      */     {
/* 1341 */       prefix = "ns_" + elementLocal;
/* 1342 */       AttributesImpl attrs = new AttributesImpl(2);
/* 1343 */       attrs.add(null, prefix, "xmlns:" + prefix, null, elementNs);
/*      */     }
/*      */     else
/*      */     {
/* 1347 */       attrs = new AttributesImpl(1);
/*      */     }
/*      */ 
/* 1350 */     String xsiPrefix = getPrefix("http://www.w3.org/2001/XMLSchema-instance");
/* 1351 */     if (xsiPrefix == null)
/*      */     {
/* 1353 */       xsiPrefix = "xsi";
/* 1354 */       attrs.add(null, xsiPrefix, "xmlns:xsi", null, "http://www.w3.org/2001/XMLSchema-instance");
/*      */     }
/*      */ 
/* 1362 */     String nilQName = xsiPrefix + ":nil";
/* 1363 */     attrs.add("http://www.w3.org/2001/XMLSchema-instance", "nil", nilQName, null, "1");
/*      */ 
/* 1365 */     String qName = prefixLocalName(prefix, elementLocal);
/* 1366 */     this.content.startElement(elementNs, elementLocal, qName, attrs);
/* 1367 */     this.content.endElement(elementNs, elementLocal, qName);
/*      */   }
/*      */ 
/*      */   private static boolean isArrayWrapper(XSTypeDefinition type)
/*      */   {
/* 1372 */     boolean is = false;
/* 1373 */     if (15 == type.getTypeCategory())
/*      */     {
/* 1375 */       XSComplexTypeDefinition cType = (XSComplexTypeDefinition)type;
/* 1376 */       XSParticle particle = cType.getParticle();
/* 1377 */       if (particle != null)
/*      */       {
/* 1379 */         is = (particle.getMaxOccursUnbounded()) || (particle.getMaxOccurs() > 1);
/*      */       }
/*      */     }
/* 1382 */     return is;
/*      */   }
/*      */ 
/*      */   private Iterator getIterator(Object value)
/*      */   {
/* 1387 */     Iterator i = null;
/* 1388 */     if ((value instanceof Collection))
/*      */     {
/* 1390 */       i = ((Collection)value).iterator();
/*      */     }
/* 1392 */     else if (value.getClass().isArray())
/*      */     {
/* 1394 */       Object arr = value;
/* 1395 */       i = new Iterator(arr)
/*      */       {
/* 1397 */         private int curInd = 0;
/* 1398 */         private int length = Array.getLength(this.val$arr);
/*      */ 
/*      */         public boolean hasNext()
/*      */         {
/* 1402 */           return this.curInd < this.length;
/*      */         }
/*      */ 
/*      */         public Object next()
/*      */         {
/* 1407 */           return Array.get(this.val$arr, this.curInd++);
/*      */         }
/*      */ 
/*      */         public void remove()
/*      */         {
/* 1412 */           throw new UnsupportedOperationException("remove is not implemented.");
/*      */         } } ;
/*      */     }
/* 1416 */     else if ((value instanceof Iterator))
/*      */     {
/* 1418 */       i = (Iterator)value;
/*      */     }
/*      */ 
/* 1424 */     return i;
/*      */   }
/*      */ 
/*      */   private static boolean isRepeatable(XSParticle particle)
/*      */   {
/* 1429 */     return (particle.getMaxOccursUnbounded()) || (particle.getMaxOccurs() > 1) || (particle.getMinOccurs() > 1);
/*      */   }
/*      */ 
/*      */   private static final List asList(Object arr)
/*      */   {
/* 1434 */     return new AbstractList(arr)
/*      */     {
/* 1436 */       private final Object array = this.val$arr;
/*      */ 
/*      */       public Object get(int index)
/*      */       {
/* 1440 */         return Array.get(this.array, index);
/*      */       }
/*      */ 
/*      */       public int size()
/*      */       {
/* 1445 */         return Array.getLength(this.array);
/*      */       }
/*      */     };
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.XercesXsMarshaller
 * JD-Core Version:    0.6.0
 */