/*     */ package org.jboss.xb.binding;
/*     */ 
/*     */ import java.io.InputStream;
/*     */ import java.io.Reader;
/*     */ import org.jboss.xb.binding.metadata.unmarshalling.DocumentBinding;
/*     */ import org.jboss.xb.binding.parser.JBossXBParser;
/*     */ import org.jboss.xb.binding.parser.JBossXBParser.ContentHandler;
/*     */ import org.jboss.xb.binding.parser.sax.SaxJBossXBParser;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.SundayContentHandler;
/*     */ import org.xml.sax.EntityResolver;
/*     */ import org.xml.sax.ErrorHandler;
/*     */ 
/*     */ public class UnmarshallerImpl
/*     */   implements Unmarshaller
/*     */ {
/*  45 */   private ObjectModelBuilder builder = new ObjectModelBuilder();
/*     */   private final JBossXBParser parser;
/*     */ 
/*     */   public UnmarshallerImpl()
/*     */     throws JBossXBException
/*     */   {
/*  55 */     this.parser = new SaxJBossXBParser();
/*     */   }
/*     */ 
/*     */   public void setValidation(boolean validation) throws JBossXBException
/*     */   {
/*  60 */     this.parser.setFeature("http://xml.org/sax/features/validation", validation);
/*     */ 
/*  65 */     if (!validation)
/*  66 */       this.parser.setFeature("http://apache.org/xml/features/validation/dynamic", false);
/*     */   }
/*     */ 
/*     */   public void setSchemaValidation(boolean validation) throws JBossXBException
/*     */   {
/*  71 */     this.parser.setFeature("http://apache.org/xml/features/validation/schema", validation);
/*     */   }
/*     */ 
/*     */   public void setFeature(String feature, boolean value) throws JBossXBException
/*     */   {
/*  76 */     this.parser.setFeature(feature, value);
/*     */   }
/*     */ 
/*     */   public void setNamespaceAware(boolean namespaces) throws JBossXBException
/*     */   {
/*  81 */     this.parser.setFeature("http://xml.org/sax/features/namespaces", namespaces);
/*     */   }
/*     */ 
/*     */   public void setEntityResolver(EntityResolver entityResolver) throws JBossXBException
/*     */   {
/*  86 */     this.parser.setEntityResolver(entityResolver);
/*     */   }
/*     */ 
/*     */   public void setErrorHandler(ErrorHandler errorHandler)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void mapFactoryToNamespace(ObjectModelFactory factory, String namespaceUri)
/*     */   {
/*  96 */     if (this.builder == null)
/*     */     {
/*  98 */       this.builder = new ObjectModelBuilder();
/*     */     }
/* 100 */     this.builder.mapFactoryToNamespace(factory, namespaceUri);
/*     */   }
/*     */ 
/*     */   public Object unmarshal(String xmlFile)
/*     */     throws JBossXBException
/*     */   {
/* 106 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public Object unmarshal(String xmlFile, JBossXBParser.ContentHandler handler) throws JBossXBException
/*     */   {
/* 111 */     this.parser.parse(xmlFile, handler);
/* 112 */     return handler.getRoot();
/*     */   }
/*     */ 
/*     */   public Object unmarshal(String xml, SchemaBinding schemaBinding) throws JBossXBException
/*     */   {
/* 117 */     JBossXBParser.ContentHandler cHandler = new SundayContentHandler(schemaBinding);
/* 118 */     this.parser.parse(xml, cHandler);
/* 119 */     return cHandler.getRoot();
/*     */   }
/*     */ 
/*     */   public Object unmarshal(Reader xmlReader, SchemaBinding schemaBinding) throws JBossXBException
/*     */   {
/* 124 */     JBossXBParser.ContentHandler cHandler = new SundayContentHandler(schemaBinding);
/* 125 */     this.parser.parse(xmlReader, cHandler);
/* 126 */     return cHandler.getRoot();
/*     */   }
/*     */ 
/*     */   public Object unmarshal(InputStream xmlStream, SchemaBinding schemaBinding) throws JBossXBException
/*     */   {
/* 131 */     JBossXBParser.ContentHandler cHandler = new SundayContentHandler(schemaBinding);
/* 132 */     this.parser.parse(xmlStream, cHandler);
/* 133 */     return cHandler.getRoot();
/*     */   }
/*     */ 
/*     */   public Object unmarshal(String xml, SchemaBindingResolver schemaResolver) throws JBossXBException
/*     */   {
/* 138 */     JBossXBParser.ContentHandler cHandler = new SundayContentHandler(schemaResolver);
/* 139 */     this.parser.parse(xml, cHandler);
/* 140 */     return cHandler.getRoot();
/*     */   }
/*     */ 
/*     */   public Object unmarshal(Reader xmlReader, SchemaBindingResolver schemaResolver) throws JBossXBException
/*     */   {
/* 145 */     JBossXBParser.ContentHandler cHandler = new SundayContentHandler(schemaResolver);
/* 146 */     this.parser.parse(xmlReader, cHandler);
/* 147 */     return cHandler.getRoot();
/*     */   }
/*     */ 
/*     */   public Object unmarshal(InputStream xmlStream, SchemaBindingResolver schemaResolver) throws JBossXBException
/*     */   {
/* 152 */     JBossXBParser.ContentHandler cHandler = new SundayContentHandler(schemaResolver);
/* 153 */     this.parser.parse(xmlStream, cHandler);
/* 154 */     return cHandler.getRoot();
/*     */   }
/*     */ 
/*     */   public Object unmarshal(Reader reader, ObjectModelFactory factory, Object root) throws JBossXBException
/*     */   {
/* 159 */     if (this.builder == null)
/*     */     {
/* 161 */       this.builder = new ObjectModelBuilder();
/*     */     }
/* 163 */     this.builder.init(factory, root);
/* 164 */     this.parser.parse(reader, this.builder);
/* 165 */     return this.builder.getRoot();
/*     */   }
/*     */ 
/*     */   public Object unmarshal(InputStream is, ObjectModelFactory factory, Object root) throws JBossXBException
/*     */   {
/* 170 */     if (this.builder == null)
/*     */     {
/* 172 */       this.builder = new ObjectModelBuilder();
/*     */     }
/* 174 */     this.builder.init(factory, root);
/* 175 */     this.parser.parse(is, this.builder);
/* 176 */     return this.builder.getRoot();
/*     */   }
/*     */ 
/*     */   public Object unmarshal(String systemId, ObjectModelFactory factory, Object root) throws JBossXBException
/*     */   {
/* 181 */     if (this.builder == null)
/*     */     {
/* 183 */       this.builder = new ObjectModelBuilder();
/*     */     }
/* 185 */     this.builder.init(factory, root);
/* 186 */     this.parser.parse(systemId, this.builder);
/* 187 */     return this.builder.getRoot();
/*     */   }
/*     */ 
/*     */   public Object unmarshal(String systemId, ObjectModelFactory factory, DocumentBinding binding)
/*     */     throws JBossXBException
/*     */   {
/* 193 */     if (binding != null)
/*     */     {
/* 195 */       throw new IllegalStateException("DocumentBinding API is not supported anymore!");
/*     */     }
/* 197 */     return unmarshal(systemId, factory, (Object)null);
/*     */   }
/*     */ 
/*     */   public Object unmarshal(Reader reader, ObjectModelFactory factory, DocumentBinding binding) throws JBossXBException
/*     */   {
/* 202 */     if (binding != null)
/*     */     {
/* 204 */       throw new IllegalStateException("DocumentBinding API is not supported anymore!");
/*     */     }
/* 206 */     return unmarshal(reader, factory, (Object)null);
/*     */   }
/*     */ 
/*     */   JBossXBParser getParser()
/*     */   {
/* 211 */     return this.parser;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.UnmarshallerImpl
 * JD-Core Version:    0.6.0
 */