/*     */ package org.jboss.xb.binding;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import org.jboss.xb.binding.parser.JBossXBParser;
/*     */ 
/*     */ public abstract class UnmarshallerFactory
/*     */ {
/*     */   protected Map features;
/*     */   protected Boolean validation;
/*     */   protected Boolean namespaces;
/*     */ 
/*     */   public UnmarshallerFactory()
/*     */   {
/*  36 */     this.validation = Boolean.TRUE;
/*  37 */     this.namespaces = Boolean.TRUE;
/*     */   }
/*     */ 
/*     */   public static UnmarshallerFactory newInstance() {
/*  41 */     return new UnmarshallerFactoryImpl();
/*     */   }
/*     */ 
/*     */   public abstract Unmarshaller newUnmarshaller();
/*     */ 
/*     */   public void setFeature(String name, Object value)
/*     */   {
/*     */     Boolean bValue;
/*  49 */     if (value == null)
/*     */     {
/*  51 */       bValue = null;
/*     */     }
/*     */     else
/*     */     {
/*     */       Boolean bValue;
/*  53 */       if ((value instanceof String))
/*     */       {
/*  55 */         bValue = Boolean.valueOf((String)value);
/*     */       }
/*     */       else
/*     */       {
/*     */         Boolean bValue;
/*  57 */         if ((value instanceof Boolean))
/*     */         {
/*  59 */           bValue = (Boolean)value;
/*     */         }
/*     */         else
/*     */         {
/*  63 */           throw new JBossXBRuntimeException("Allowed feature values are null, 'true, 'false', Boolean.TRUE, Boolean.FALSE. Passed in value: " + value);
/*     */         }
/*     */       }
/*     */     }
/*     */     Boolean bValue;
/*  68 */     if ("http://xml.org/sax/features/validation".equals(name))
/*     */     {
/*  70 */       this.validation = bValue;
/*     */     }
/*  72 */     else if ("http://xml.org/sax/features/namespaces".equals(name))
/*     */     {
/*  74 */       this.namespaces = bValue;
/*     */     }
/*     */     else
/*     */     {
/*  78 */       if (this.features == null)
/*     */       {
/*  80 */         this.features = new HashMap();
/*     */       }
/*  82 */       this.features.put(name, value);
/*     */     }
/*     */   }
/*     */ 
/*     */   static class UnmarshallerFactoryImpl extends UnmarshallerFactory
/*     */   {
/*     */     public Unmarshaller newUnmarshaller()
/*     */     {
/*     */       UnmarshallerImpl unmarshaller;
/*     */       try
/*     */       {
/*  96 */         unmarshaller = new UnmarshallerImpl();
/*     */       }
/*     */       catch (JBossXBException e)
/*     */       {
/* 100 */         throw new JBossXBRuntimeException(e.getMessage(), e);
/*     */       }
/*     */ 
/* 103 */       JBossXBParser parser = unmarshaller.getParser();
/* 104 */       if (this.validation != null)
/*     */       {
/* 106 */         parser.setFeature("http://xml.org/sax/features/validation", this.validation.booleanValue());
/*     */       }
/*     */ 
/* 109 */       if (this.namespaces != null)
/*     */       {
/* 111 */         parser.setFeature("http://xml.org/sax/features/namespaces", this.namespaces.booleanValue());
/*     */       }
/*     */       Iterator i;
/* 114 */       if (this.features != null)
/*     */       {
/* 116 */         for (i = this.features.entrySet().iterator(); i.hasNext(); )
/*     */         {
/* 118 */           Map.Entry entry = (Map.Entry)i.next();
/* 119 */           if (entry.getValue() != null)
/*     */           {
/* 121 */             Boolean value = (Boolean)entry.getValue();
/* 122 */             parser.setFeature((String)entry.getKey(), value.booleanValue());
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 132 */         parser.setFeature("http://apache.org/xml/features/validation/dynamic", true);
/*     */       }
/*     */       catch (JBossXBRuntimeException e)
/*     */       {
/*     */       }
/*     */ 
/* 139 */       return unmarshaller;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.UnmarshallerFactory
 * JD-Core Version:    0.6.0
 */