package org.jboss.xb.binding;

import java.io.InputStream;
import java.io.Reader;
import org.jboss.xb.binding.metadata.unmarshalling.DocumentBinding;
import org.jboss.xb.binding.parser.JBossXBParser.ContentHandler;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;

public abstract interface Unmarshaller
{
  public static final String VALIDATION = "http://xml.org/sax/features/validation";
  public static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
  public static final String NAMESPACE_PREFIXES = "http://xml.org/sax/features/namespace-prefixes";
  public static final String DYNAMIC_VALIDATION = "http://apache.org/xml/features/validation/dynamic";
  public static final String SCHEMA_VALIDATION = "http://apache.org/xml/features/validation/schema";
  public static final String SCHEMA_FULL_CHECKING = "http://apache.org/xml/features/validation/schema-full-checking";

  public abstract void setValidation(boolean paramBoolean)
    throws JBossXBException;

  public abstract void setNamespaceAware(boolean paramBoolean)
    throws JBossXBException;

  public abstract void setSchemaValidation(boolean paramBoolean)
    throws JBossXBException;

  public abstract void setFeature(String paramString, boolean paramBoolean)
    throws JBossXBException;

  public abstract void setEntityResolver(EntityResolver paramEntityResolver)
    throws JBossXBException;

  public abstract void setErrorHandler(ErrorHandler paramErrorHandler);

  public abstract void mapFactoryToNamespace(ObjectModelFactory paramObjectModelFactory, String paramString);

  public abstract Object unmarshal(String paramString, JBossXBParser.ContentHandler paramContentHandler)
    throws JBossXBException;

  public abstract Object unmarshal(String paramString)
    throws JBossXBException;

  public abstract Object unmarshal(String paramString, SchemaBinding paramSchemaBinding)
    throws JBossXBException;

  public abstract Object unmarshal(Reader paramReader, SchemaBinding paramSchemaBinding)
    throws JBossXBException;

  public abstract Object unmarshal(InputStream paramInputStream, SchemaBinding paramSchemaBinding)
    throws JBossXBException;

  public abstract Object unmarshal(String paramString, SchemaBindingResolver paramSchemaBindingResolver)
    throws JBossXBException;

  public abstract Object unmarshal(Reader paramReader, SchemaBindingResolver paramSchemaBindingResolver)
    throws JBossXBException;

  public abstract Object unmarshal(InputStream paramInputStream, SchemaBindingResolver paramSchemaBindingResolver)
    throws JBossXBException;

  public abstract Object unmarshal(Reader paramReader, ObjectModelFactory paramObjectModelFactory, Object paramObject)
    throws JBossXBException;

  public abstract Object unmarshal(InputStream paramInputStream, ObjectModelFactory paramObjectModelFactory, Object paramObject)
    throws JBossXBException;

  public abstract Object unmarshal(String paramString, ObjectModelFactory paramObjectModelFactory, Object paramObject)
    throws JBossXBException;

  public abstract Object unmarshal(String paramString, ObjectModelFactory paramObjectModelFactory, DocumentBinding paramDocumentBinding)
    throws JBossXBException;

  public abstract Object unmarshal(Reader paramReader, ObjectModelFactory paramObjectModelFactory, DocumentBinding paramDocumentBinding)
    throws JBossXBException;
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.Unmarshaller
 * JD-Core Version:    0.6.0
 */