/*     */ package org.jboss.xb.binding;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.text.SimpleDateFormat;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Date;
/*     */ import java.util.HashSet;
/*     */ import java.util.List;
/*     */ import java.util.Locale;
/*     */ import java.util.Set;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.Classes;
/*     */ import org.xml.sax.Attributes;
/*     */ 
/*     */ public class SchemalessObjectModelFactory
/*     */   implements GenericObjectModelFactory
/*     */ {
/*  47 */   private static final Logger log = Logger.getLogger(SchemalessObjectModelFactory.class);
/*     */ 
/*     */   public Object newChild(Object parent, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/*  55 */     Object child = null;
/*     */     try
/*     */     {
/*  58 */       if ((parent instanceof Collection))
/*     */       {
/*  60 */         if (!localName.equals(String.class.getName()))
/*     */         {
/*  62 */           Class itemClass = Thread.currentThread().getContextClassLoader().loadClass(localName);
/*  63 */           child = itemClass.newInstance();
/*  64 */           ((Collection)parent).add(child);
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/*  69 */         Method getter = parent.getClass().getMethod("get" + localName, null);
/*  70 */         if (!SchemalessMarshaller.isAttributeType(getter.getReturnType()))
/*     */         {
/*  72 */           if (List.class.isAssignableFrom(getter.getReturnType()))
/*     */           {
/*  74 */             child = new ArrayList();
/*     */           }
/*  76 */           else if (Set.class.isAssignableFrom(getter.getReturnType()))
/*     */           {
/*  78 */             child = new HashSet();
/*     */           }
/*  80 */           else if (Collection.class.isAssignableFrom(getter.getReturnType()))
/*     */           {
/*  82 */             child = new ArrayList();
/*     */           }
/*     */           else
/*     */           {
/*  86 */             child = getter.getReturnType().newInstance();
/*     */           }
/*     */         }
/*     */ 
/*  90 */         if (child != null)
/*     */         {
/*  92 */           Method setter = Classes.getAttributeSetter(parent.getClass(), localName, getter.getReturnType());
/*  93 */           setter.invoke(parent, new Object[] { child });
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (NoSuchMethodException e)
/*     */     {
/*  99 */       log.error("Failed to get getter/setter method for " + localName + " from " + parent.getClass(), e);
/* 100 */       throw new IllegalStateException("Failed to get getter/setter method for " + localName + " from " + parent.getClass() + ": " + e.getMessage());
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 110 */       log.error("Failed to instantiate child", e);
/* 111 */       throw new IllegalStateException("Failed to instantiate child: " + e.getMessage());
/*     */     }
/* 113 */     return child;
/*     */   }
/*     */ 
/*     */   public void addChild(Object parent, Object child, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void setValue(Object o, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/*     */     try
/*     */     {
/* 128 */       if ((o instanceof Collection))
/*     */       {
/* 130 */         if (localName.equals(String.class.getName()))
/*     */         {
/* 132 */           ((Collection)o).add(value);
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 137 */         Method getter = Classes.getAttributeGetter(o.getClass(), localName);
/* 138 */         Method setter = Classes.getAttributeSetter(o.getClass(), localName, getter.getReturnType());
/*     */         Object fieldValue;
/*     */         Object fieldValue;
/* 141 */         if (Date.class.isAssignableFrom(getter.getReturnType()))
/*     */         {
/* 143 */           SimpleDateFormat formatter = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
/* 144 */           fieldValue = formatter.parse(value);
/*     */         }
/*     */         else
/*     */         {
/* 148 */           fieldValue = value;
/*     */         }
/*     */ 
/* 151 */         setter.invoke(o, new Object[] { fieldValue });
/*     */       }
/*     */     }
/*     */     catch (NoSuchMethodException e)
/*     */     {
/* 156 */       throw new IllegalStateException("Failed to discover getter/setter for " + localName + " in " + o);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 160 */       throw new IllegalStateException("Failed to set value for " + localName + " in " + o);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object newRoot(Object root, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/*     */     Class rootClass;
/*     */     try
/*     */     {
/* 173 */       rootClass = Thread.currentThread().getContextClassLoader().loadClass(localName);
/*     */     }
/*     */     catch (ClassNotFoundException e)
/*     */     {
/* 177 */       log.error("Faile to load root class " + localName, e);
/* 178 */       throw new IllegalStateException("Failed to load root class: " + localName + ": " + e.getMessage());
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 183 */       root = rootClass.newInstance();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 187 */       log.error("Failed to create an instance of root " + localName, e);
/* 188 */       throw new IllegalStateException("Failed to create an instance of root " + localName + ": " + e.getMessage());
/*     */     }
/*     */ 
/* 191 */     return root;
/*     */   }
/*     */ 
/*     */   public Object completeRoot(Object root, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 196 */     return root;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.SchemalessObjectModelFactory
 * JD-Core Version:    0.6.0
 */