/*     */ package org.jboss.xb.binding;
/*     */ 
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.StringTokenizer;
/*     */ import javax.xml.namespace.NamespaceContext;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.apache.xerces.xs.XSTypeDefinition;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.xb.binding.parser.JBossXBParser.DtdAwareContentHandler;
/*     */ import org.xml.sax.Attributes;
/*     */ 
/*     */ public class ObjectModelBuilder
/*     */   implements UnmarshallingContext, JBossXBParser.DtdAwareContentHandler
/*     */ {
/*  55 */   private static final Logger log = Logger.getLogger(ObjectModelBuilder.class);
/*     */ 
/*  61 */   private static final Object IGNORED = new Object();
/*     */   private Object root;
/*     */   private Stack all;
/*     */   private Stack accepted;
/*     */   private GenericObjectModelFactory curFactory;
/*     */   private String curNameSwitchingFactory;
/*     */   private String curNsSwitchingFactory;
/*     */   private Stack nameSwitchingFactory;
/*     */   private Stack nsSwitchingFactory;
/*     */   private GenericObjectModelFactory defaultFactory;
/*     */   private Map factoriesToNs;
/*     */   private final NamespaceRegistry nsRegistry;
/*     */   private boolean trimTextContent;
/*     */   private boolean trace;
/*     */ 
/*     */   public ObjectModelBuilder()
/*     */   {
/*  71 */     this.all = new StackImpl(null);
/*     */ 
/*  76 */     this.accepted = new StackImpl(null);
/*     */ 
/*  92 */     this.factoriesToNs = Collections.EMPTY_MAP;
/*     */ 
/*  97 */     this.nsRegistry = new NamespaceRegistry();
/*     */ 
/* 100 */     this.trimTextContent = true;
/*     */ 
/* 102 */     this.trace = log.isTraceEnabled();
/*     */   }
/*     */ 
/*     */   public void mapFactoryToNamespace(ObjectModelFactory factory, String namespaceUri)
/*     */   {
/* 108 */     if (this.factoriesToNs == Collections.EMPTY_MAP)
/*     */     {
/* 110 */       this.factoriesToNs = new HashMap();
/*     */     }
/* 112 */     this.factoriesToNs.put(namespaceUri, getGenericObjectModelFactory(factory));
/*     */   }
/*     */ 
/*     */   public void init(ObjectModelFactory defaultFactory, Object root)
/*     */   {
/* 117 */     this.defaultFactory = getGenericObjectModelFactory(defaultFactory);
/* 118 */     this.all.clear();
/* 119 */     this.accepted.clear();
/* 120 */     this.root = root;
/*     */   }
/*     */ 
/*     */   public void pushFactory(String namespaceURI, String localName, GenericObjectModelFactory factory)
/*     */   {
/* 125 */     if (this.curNsSwitchingFactory != null)
/*     */     {
/* 127 */       if (this.nsSwitchingFactory == null)
/*     */       {
/* 129 */         this.nsSwitchingFactory = new StackImpl(null);
/* 130 */         this.nameSwitchingFactory = new StackImpl(null);
/*     */       }
/* 132 */       this.nsSwitchingFactory.push(this.curNsSwitchingFactory);
/* 133 */       this.nameSwitchingFactory.push(this.curNameSwitchingFactory);
/*     */     }
/* 135 */     this.curNsSwitchingFactory = namespaceURI;
/* 136 */     this.curNameSwitchingFactory = localName;
/* 137 */     this.curFactory = factory;
/*     */   }
/*     */ 
/*     */   public void popFactory()
/*     */   {
/* 142 */     if ((this.nsSwitchingFactory == null) || (this.nsSwitchingFactory.isEmpty()))
/*     */     {
/* 144 */       this.curNameSwitchingFactory = null;
/* 145 */       this.curNsSwitchingFactory = null;
/*     */     }
/*     */     else
/*     */     {
/* 149 */       this.curNameSwitchingFactory = ((String)this.nameSwitchingFactory.pop());
/* 150 */       this.curNsSwitchingFactory = ((String)this.nsSwitchingFactory.pop());
/*     */     }
/*     */ 
/* 153 */     this.curFactory = getFactory(this.curNsSwitchingFactory);
/*     */   }
/*     */ 
/*     */   public Iterator getNamespaceURIs()
/*     */   {
/* 160 */     return this.nsRegistry.getRegisteredURIs();
/*     */   }
/*     */ 
/*     */   public NamespaceContext getNamespaceContext()
/*     */   {
/* 165 */     return this.nsRegistry;
/*     */   }
/*     */ 
/*     */   public boolean isTrimTextContent()
/*     */   {
/* 170 */     return this.trimTextContent;
/*     */   }
/*     */ 
/*     */   public void setTrimTextContent(boolean trimTextContent)
/*     */   {
/* 175 */     this.trimTextContent = trimTextContent;
/*     */   }
/*     */ 
/*     */   public QName resolveQName(String value)
/*     */   {
/* 185 */     StringTokenizer st = new StringTokenizer(value, ":");
/* 186 */     if (st.countTokens() == 1) {
/* 187 */       return new QName(value);
/*     */     }
/* 189 */     if (st.countTokens() != 2) {
/* 190 */       throw new IllegalArgumentException("Illegal QName: " + value);
/*     */     }
/* 192 */     String prefix = st.nextToken();
/* 193 */     String local = st.nextToken();
/* 194 */     String nsURI = this.nsRegistry.getNamespaceURI(prefix);
/* 195 */     if (nsURI == null) {
/* 196 */       throw new IllegalStateException("Cannot obtain namespace URI for prefix: " + prefix);
/*     */     }
/* 198 */     return new QName(nsURI, local, prefix);
/*     */   }
/*     */ 
/*     */   public String getChildContent(String namespaceURI, String qName)
/*     */   {
/* 204 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public XSTypeDefinition getType()
/*     */   {
/* 210 */     return null;
/*     */   }
/*     */ 
/*     */   public void startPrefixMapping(String prefix, String uri)
/*     */   {
/* 217 */     this.nsRegistry.addPrefixMapping(prefix, uri);
/*     */   }
/*     */ 
/*     */   public void endPrefixMapping(String prefix)
/*     */   {
/* 222 */     this.nsRegistry.removePrefixMapping(prefix);
/*     */   }
/*     */ 
/*     */   public void processingInstruction(String target, String data)
/*     */   {
/* 227 */     if (!"jbossxb".equals(target))
/*     */     {
/* 229 */       return;
/*     */     }
/*     */ 
/* 232 */     int i = data.indexOf("factory=\"");
/* 233 */     if (i != -1)
/*     */     {
/* 235 */       int end = data.indexOf('"', i + 9);
/* 236 */       if (end == -1)
/*     */       {
/* 238 */         throw new JBossXBRuntimeException("Property 'factory' is not terminated with '\"' in processing instruction: " + data);
/*     */       }
/*     */ 
/* 243 */       String factoryProp = data.substring(i + 9, end);
/*     */       Class factoryCls;
/*     */       try
/*     */       {
/* 247 */         factoryCls = Thread.currentThread().getContextClassLoader().loadClass(factoryProp);
/*     */       }
/*     */       catch (ClassNotFoundException e)
/*     */       {
/* 251 */         throw new JBossXBRuntimeException("Failed to load factory class : " + e.getMessage(), e);
/*     */       }
/*     */       ObjectModelFactory factory;
/*     */       try
/*     */       {
/* 257 */         factory = (ObjectModelFactory)factoryCls.newInstance();
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 261 */         throw new JBossXBRuntimeException("Failed to instantiate factory " + factoryProp + ": " + e.getMessage(), e);
/*     */       }
/*     */ 
/* 266 */       i = data.indexOf("ns=\"");
/* 267 */       if (i == -1)
/*     */       {
/* 269 */         throw new JBossXBRuntimeException("Property 'ns' not found in factory mapping processing instruction: " + data);
/*     */       }
/*     */ 
/* 274 */       end = data.indexOf("\"", i + 4);
/* 275 */       if (end == -1)
/*     */       {
/* 277 */         throw new JBossXBRuntimeException("Property 'ns' is not terminated with '\"' in processing instruction: " + data);
/*     */       }
/*     */ 
/* 282 */       String nsProp = data.substring(i + 4, end);
/* 283 */       mapFactoryToNamespace(factory, nsProp);
/*     */     }
/*     */     else
/*     */     {
/* 287 */       throw new JBossXBRuntimeException("Unexpected data in processing instruction: target=" + target + ", data=" + data);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object getRoot()
/*     */   {
/* 295 */     if (!this.all.isEmpty())
/*     */     {
/* 297 */       popAll();
/* 298 */       popAccepted();
/*     */     }
/* 300 */     return this.root;
/*     */   }
/*     */ 
/*     */   public void startDTD(String name, String publicId, String systemId)
/*     */   {
/* 305 */     GenericObjectModelFactory factory = getFactory(systemId);
/*     */     try
/*     */     {
/* 309 */       Class[] sig = { String.class, String.class, String.class };
/* 310 */       Method startDTD = factory.getClass().getMethod("startDTD", sig);
/* 311 */       Object[] args = { name, publicId, systemId };
/* 312 */       startDTD.invoke(factory, args);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 316 */       log.debug("No startDTD found on factory: " + factory);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void endDTD()
/*     */   {
/*     */     try
/*     */     {
/* 325 */       Class[] sig = new Class[0];
/* 326 */       Method endDTD = this.defaultFactory.getClass().getMethod("endDTD", sig);
/* 327 */       Object[] args = new Object[0];
/* 328 */       endDTD.invoke(this.defaultFactory, args);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 332 */       log.debug("No endDTD found on factory: " + this.defaultFactory);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void startElement(String namespaceURI, String localName, String qName, Attributes atts, XSTypeDefinition type)
/*     */   {
/* 342 */     Object parent = this.accepted.isEmpty() ? this.root : peekAccepted();
/*     */     Object element;
/* 345 */     if (!namespaceURI.equals(this.curNsSwitchingFactory))
/*     */     {
/* 347 */       GenericObjectModelFactory newFactory = getFactory(namespaceURI);
/*     */       Object element;
/*     */       Object element;
/* 348 */       if (newFactory != this.curFactory)
/*     */       {
/* 350 */         element = newFactory.newRoot(parent, this, namespaceURI, localName, atts);
/*     */       }
/*     */       else
/*     */       {
/* 354 */         element = newFactory.newChild(parent, this, namespaceURI, localName, atts);
/*     */       }
/*     */ 
/* 359 */       pushFactory(namespaceURI, localName, newFactory);
/*     */     }
/*     */     else
/*     */     {
/* 363 */       element = this.curFactory.newChild(parent, this, namespaceURI, localName, atts);
/*     */     }
/*     */ 
/* 366 */     if (element == null)
/*     */     {
/* 368 */       pushAll(IGNORED);
/*     */ 
/* 370 */       if (this.trace)
/*     */       {
/* 372 */         log.trace("ignored " + namespaceURI + ':' + qName);
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 377 */       pushAll(element);
/* 378 */       pushAccepted(element);
/*     */ 
/* 380 */       if (this.trace)
/*     */       {
/* 382 */         log.trace("accepted " + namespaceURI + ':' + qName);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void endElement(String namespaceURI, String localName, String qName)
/*     */   {
/* 389 */     AllElement element = popAll();
/*     */ 
/* 391 */     if (!this.accepted.isEmpty())
/*     */     {
/* 393 */       Object acceptedElement = peekAccepted();
/* 394 */       if ((element.characters != null) && (element.characters.length() > 0))
/*     */       {
/* 396 */         if (this.trimTextContent)
/*     */         {
/* 398 */           String characters = element.characters.toString().trim();
/* 399 */           if (characters.length() > 0)
/*     */           {
/* 401 */             this.curFactory.setValue(acceptedElement, this, namespaceURI, localName, characters);
/*     */           }
/*     */         }
/*     */         else
/*     */         {
/* 406 */           this.curFactory.setValue(acceptedElement, this, namespaceURI, localName, element.characters.toString());
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 411 */     if ((localName.equals(this.curNameSwitchingFactory)) && (namespaceURI.equals(this.curNsSwitchingFactory)))
/*     */     {
/* 413 */       popFactory();
/*     */     }
/*     */ 
/* 416 */     if (element.element != IGNORED)
/*     */     {
/* 418 */       popAccepted();
/* 419 */       Object parent = this.accepted.isEmpty() ? null : peekAccepted();
/*     */ 
/* 421 */       if (parent != null)
/*     */       {
/* 423 */         this.curFactory.addChild(parent, element.element, this, namespaceURI, localName);
/*     */       }
/*     */       else
/*     */       {
/* 427 */         this.root = this.curFactory.completeRoot(element.element, this, namespaceURI, localName);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void characters(char[] ch, int start, int length)
/*     */   {
/* 434 */     if (!this.accepted.isEmpty())
/*     */     {
/* 436 */       String str = String.valueOf(ch, start, length);
/* 437 */       AllElement allElement = peekAll();
/* 438 */       if (allElement.characters == null)
/*     */       {
/* 440 */         allElement.characters = new StringBuffer(str);
/*     */       }
/*     */       else
/*     */       {
/* 444 */         allElement.characters.append(str);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private GenericObjectModelFactory getFactory(String namespaceUri)
/*     */   {
/* 453 */     GenericObjectModelFactory factory = (GenericObjectModelFactory)this.factoriesToNs.get(namespaceUri);
/* 454 */     if (factory == null)
/*     */     {
/* 456 */       factory = this.defaultFactory;
/*     */     }
/* 458 */     return factory;
/*     */   }
/*     */ 
/*     */   static Object invokeFactory(Object factory, Method method, Object[] args) {
/*     */     IllegalStateException ise;
/*     */     try {
/* 465 */       return method.invoke(factory, args);
/*     */     }
/*     */     catch (InvocationTargetException e)
/*     */     {
/* 469 */       Throwable te = e.getCause();
/* 470 */       if ((te instanceof RuntimeException))
/*     */       {
/* 472 */         throw ((RuntimeException)te);
/*     */       }
/*     */ 
/* 475 */       String msg = "Failed to invoke method " + method + ", factory=" + factory;
/* 476 */       log.error(msg, e.getTargetException());
/*     */ 
/* 478 */       IllegalStateException ise = new IllegalStateException(msg);
/* 479 */       ise.initCause(te);
/* 480 */       throw ise;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 484 */       String msg = "Failed to invoke method " + method.getName() + ", factory=" + factory;
/* 485 */       log.error(msg, e);
/* 486 */       ise = new IllegalStateException(msg);
/* 487 */       ise.initCause(e);
/* 488 */     }throw ise;
/*     */   }
/*     */ 
/*     */   static Method getMethodForElement(Object factory, String name, Class[] params)
/*     */   {
/* 494 */     Method method = null;
/*     */     try
/*     */     {
/* 497 */       method = factory.getClass().getMethod(name, params);
/*     */     }
/*     */     catch (NoSuchMethodException e)
/*     */     {
/*     */     }
/*     */     catch (SecurityException e)
/*     */     {
/* 504 */       throw e;
/*     */     }
/*     */ 
/* 507 */     return method;
/*     */   }
/*     */ 
/*     */   static final GenericObjectModelFactory getGenericObjectModelFactory(ObjectModelFactory factory)
/*     */   {
/* 512 */     if (!(factory instanceof GenericObjectModelFactory))
/*     */     {
/* 514 */       factory = new DelegatingObjectModelFactory(factory);
/*     */     }
/* 516 */     return (factory instanceof GenericObjectModelFactory) ? (GenericObjectModelFactory)factory : new DelegatingObjectModelFactory(factory);
/*     */   }
/*     */ 
/*     */   private void pushAccepted(Object o)
/*     */   {
/* 523 */     this.accepted.push(o);
/*     */   }
/*     */ 
/*     */   private Object popAccepted()
/*     */   {
/* 528 */     return this.accepted.pop();
/*     */   }
/*     */ 
/*     */   private Object peekAccepted()
/*     */   {
/* 533 */     return this.accepted.peek();
/*     */   }
/*     */ 
/*     */   private void pushAll(Object o)
/*     */   {
/* 538 */     this.all.push(new AllElement(o));
/*     */   }
/*     */ 
/*     */   private AllElement popAll()
/*     */   {
/* 543 */     return (AllElement)this.all.pop();
/*     */   }
/*     */ 
/*     */   private AllElement peekAll()
/*     */   {
/* 548 */     return (AllElement)this.all.peek();
/*     */   }
/*     */ 
/*     */   private static class StackImpl
/*     */     implements ObjectModelBuilder.Stack
/*     */   {
/* 578 */     private List list = new ArrayList();
/*     */ 
/*     */     public void clear()
/*     */     {
/* 582 */       this.list.clear();
/*     */     }
/*     */ 
/*     */     public void push(Object o)
/*     */     {
/* 587 */       this.list.add(o);
/*     */     }
/*     */ 
/*     */     public Object pop()
/*     */     {
/* 592 */       return this.list.remove(this.list.size() - 1);
/*     */     }
/*     */ 
/*     */     public Object peek()
/*     */     {
/* 597 */       return this.list.get(this.list.size() - 1);
/*     */     }
/*     */ 
/*     */     public boolean isEmpty()
/*     */     {
/* 602 */       return this.list.isEmpty();
/*     */     }
/*     */   }
/*     */ 
/*     */   private static abstract interface Stack
/*     */   {
/*     */     public abstract void clear();
/*     */ 
/*     */     public abstract void push(Object paramObject);
/*     */ 
/*     */     public abstract Object pop();
/*     */ 
/*     */     public abstract Object peek();
/*     */ 
/*     */     public abstract boolean isEmpty();
/*     */   }
/*     */ 
/*     */   private static final class AllElement
/*     */   {
/*     */     public final Object element;
/*     */     public StringBuffer characters;
/*     */ 
/*     */     public AllElement(Object element)
/*     */     {
/* 558 */       this.element = element;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.ObjectModelBuilder
 * JD-Core Version:    0.6.0
 */