/*     */ package org.jboss.xb.binding;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.xml.namespace.NamespaceContext;
/*     */ import javax.xml.namespace.QName;
/*     */ 
/*     */ public class NamespaceRegistry
/*     */   implements NamespaceContext, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 8435680858785550261L;
/*     */   private int namespaceIndex;
/*  55 */   private final Map prefixByUri = new HashMap();
/*  56 */   private final Map uriByPrefix = new HashMap();
/*     */ 
/*     */   public QName registerQName(QName qname)
/*     */   {
/*  66 */     if (qname == null) {
/*  67 */       return null;
/*     */     }
/*  69 */     String nsURI = qname.getNamespaceURI();
/*  70 */     String prefix = getPrefix(nsURI);
/*  71 */     if (prefix == null)
/*     */     {
/*  73 */       prefix = qname.getPrefix();
/*  74 */       if (prefix.length() == 0)
/*  75 */         prefix = registerURI(nsURI, null);
/*     */       else {
/*  77 */         prefix = registerURI(nsURI, prefix);
/*     */       }
/*     */     }
/*  80 */     qname = new QName(nsURI, qname.getLocalPart(), prefix);
/*  81 */     return qname;
/*     */   }
/*     */ 
/*     */   public String registerURI(String nsURI, String prefix)
/*     */   {
/*  93 */     if (prefix == null)
/*     */     {
/*  95 */       prefix = "ns" + ++this.namespaceIndex;
/*     */     }
/*     */ 
/*  98 */     addPrefixMapping(prefix, nsURI);
/*  99 */     return prefix;
/*     */   }
/*     */ 
/*     */   public void addPrefixMapping(String prefix, String nsURI)
/*     */   {
/* 110 */     if (nsURI == null) {
/* 111 */       throw new IllegalArgumentException("Cannot add mapping for null namespace URI");
/*     */     }
/* 113 */     Object obj = this.uriByPrefix.get(prefix);
/* 114 */     if (!nsURI.equals(obj))
/*     */     {
/* 116 */       if (obj == null)
/*     */       {
/* 118 */         this.uriByPrefix.put(prefix, nsURI);
/*     */       }
/* 120 */       else if ((obj instanceof String))
/*     */       {
/* 122 */         List list = new ArrayList();
/* 123 */         list.add(obj);
/* 124 */         list.add(nsURI);
/* 125 */         this.uriByPrefix.put(prefix, list);
/*     */       }
/* 127 */       else if ((obj instanceof List))
/*     */       {
/* 129 */         ((List)obj).add(nsURI);
/*     */       }
/*     */       else
/*     */       {
/* 133 */         throwUnexpectedEntryException(obj);
/*     */       }
/*     */ 
/* 136 */       obj = this.prefixByUri.get(nsURI);
/* 137 */       if (obj == null)
/*     */       {
/* 139 */         this.prefixByUri.put(nsURI, prefix);
/*     */       }
/* 141 */       else if ((obj instanceof String))
/*     */       {
/* 143 */         List list = new ArrayList();
/* 144 */         list.add(obj);
/* 145 */         list.add(prefix);
/* 146 */         this.prefixByUri.put(nsURI, list);
/*     */       }
/* 148 */       else if ((obj instanceof List))
/*     */       {
/* 150 */         ((List)obj).add(prefix);
/*     */       }
/*     */       else
/*     */       {
/* 154 */         throwUnexpectedEntryException(obj);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void removePrefixMapping(String prefix)
/*     */   {
/* 166 */     Object obj = this.uriByPrefix.get(prefix);
/* 167 */     if (obj != null)
/*     */     {
/* 169 */       String uri = null;
/* 170 */       if ((obj instanceof String))
/*     */       {
/* 172 */         uri = (String)obj;
/* 173 */         this.uriByPrefix.remove(prefix);
/*     */       }
/* 175 */       else if ((obj instanceof List))
/*     */       {
/* 177 */         List list = (List)obj;
/* 178 */         uri = (String)list.remove(list.size() - 1);
/* 179 */         if (list.isEmpty())
/*     */         {
/* 181 */           this.uriByPrefix.remove(prefix);
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 186 */         throwUnexpectedEntryException(obj);
/*     */       }
/*     */ 
/* 189 */       if (uri != null)
/*     */       {
/* 191 */         obj = this.prefixByUri.get(uri);
/* 192 */         if ((obj instanceof String))
/*     */         {
/* 194 */           if (!prefix.equals(obj))
/*     */           {
/* 196 */             throw new IllegalStateException("Inconsistent mapping: prefix=" + prefix + ", found=" + obj);
/*     */           }
/* 198 */           this.prefixByUri.remove(uri);
/*     */         }
/* 200 */         else if ((obj instanceof List))
/*     */         {
/* 202 */           List list = (ArrayList)obj;
/* 203 */           list.remove(prefix);
/* 204 */           if (list.isEmpty())
/*     */           {
/* 206 */             this.prefixByUri.remove(uri);
/*     */           }
/*     */         }
/*     */         else
/*     */         {
/* 211 */           throwUnexpectedEntryException(obj);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void unregisterURI(String nsURI)
/*     */   {
/* 225 */     Object obj = this.prefixByUri.get(nsURI);
/* 226 */     if (obj != null)
/*     */     {
/* 228 */       String prefix = null;
/* 229 */       if ((obj instanceof String))
/*     */       {
/* 231 */         prefix = (String)obj;
/* 232 */         this.prefixByUri.remove(nsURI);
/* 233 */         removePrefixMappingOnly(prefix, nsURI);
/*     */       }
/* 235 */       else if ((obj instanceof List))
/*     */       {
/* 237 */         List list = (List)obj;
/* 238 */         for (int i = 0; i < list.size(); i++)
/*     */         {
/* 240 */           removePrefixMappingOnly((String)list.get(i), nsURI);
/*     */         }
/* 242 */         this.prefixByUri.remove(nsURI);
/*     */       }
/*     */       else
/*     */       {
/* 246 */         throwUnexpectedEntryException(obj);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean isRegistered(String nsURI)
/*     */   {
/* 255 */     return this.prefixByUri.containsKey(nsURI);
/*     */   }
/*     */ 
/*     */   public Iterator getRegisteredURIs()
/*     */   {
/* 262 */     return this.prefixByUri.keySet().iterator();
/*     */   }
/*     */ 
/*     */   public Iterator getRegisteredPrefixes()
/*     */   {
/* 269 */     return this.uriByPrefix.keySet().iterator();
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/* 277 */     return this.prefixByUri.size();
/*     */   }
/*     */ 
/*     */   public String getPrefix(String nsURI)
/*     */   {
/* 287 */     Object obj = this.prefixByUri.get(nsURI);
/*     */ 
/* 289 */     String prefix = null;
/* 290 */     if (obj != null)
/*     */     {
/* 292 */       if ((obj instanceof String))
/*     */       {
/* 294 */         prefix = (String)obj;
/*     */       }
/* 296 */       else if ((obj instanceof List))
/*     */       {
/* 298 */         List list = (List)obj;
/* 299 */         prefix = (String)list.get(list.size() - 1);
/*     */       }
/*     */       else
/*     */       {
/* 303 */         throwUnexpectedEntryException(obj);
/*     */       }
/*     */     }
/*     */ 
/* 307 */     return prefix;
/*     */   }
/*     */ 
/*     */   public Iterator getPrefixes(String namespaceURI)
/*     */   {
/* 318 */     Object obj = this.prefixByUri.get(namespaceURI);
/*     */ 
/* 320 */     Iterator result = null;
/* 321 */     if (obj == null)
/*     */     {
/* 323 */       result = Collections.EMPTY_LIST.iterator();
/*     */     }
/* 325 */     else if ((obj instanceof String))
/*     */     {
/* 327 */       result = Collections.singletonList(obj).iterator();
/*     */     }
/* 329 */     else if ((obj instanceof List))
/*     */     {
/* 331 */       result = ((List)obj).iterator();
/*     */     }
/*     */     else
/*     */     {
/* 335 */       throwUnexpectedEntryException(obj);
/*     */     }
/*     */ 
/* 338 */     return result;
/*     */   }
/*     */ 
/*     */   public String getNamespaceURI(String prefix)
/*     */   {
/* 345 */     Object obj = this.uriByPrefix.get(prefix);
/*     */ 
/* 347 */     String uri = null;
/* 348 */     if (obj != null)
/*     */     {
/* 350 */       if ((obj instanceof String))
/*     */       {
/* 352 */         uri = (String)obj;
/*     */       }
/* 354 */       else if ((obj instanceof List))
/*     */       {
/* 356 */         List list = (List)obj;
/* 357 */         uri = (String)list.get(list.size() - 1);
/*     */       }
/*     */       else
/*     */       {
/* 361 */         throwUnexpectedEntryException(obj);
/*     */       }
/*     */     }
/*     */ 
/* 365 */     return uri;
/*     */   }
/*     */ 
/*     */   private void removePrefixMappingOnly(String prefix, String nsURI)
/*     */   {
/* 372 */     Object obj = this.uriByPrefix.get(prefix);
/* 373 */     if ((obj instanceof String))
/*     */     {
/* 375 */       if (!obj.equals(nsURI))
/*     */       {
/* 377 */         throw new IllegalStateException("Inconsistent mapping: uri=" + nsURI + ", found=" + obj);
/*     */       }
/* 379 */       this.uriByPrefix.remove(prefix);
/*     */     }
/* 381 */     else if ((obj instanceof List))
/*     */     {
/* 383 */       List list = (List)obj;
/* 384 */       list.remove(prefix);
/* 385 */       if (list.isEmpty())
/*     */       {
/* 387 */         this.uriByPrefix.remove(prefix);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void throwUnexpectedEntryException(Object entry)
/*     */   {
/* 394 */     throw new IllegalStateException("Unexpected entry type: expected java.lang.String or java.util.List but got " + entry.getClass());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.NamespaceRegistry
 * JD-Core Version:    0.6.0
 */