/*     */ package org.jboss.xb.binding;
/*     */ 
/*     */ import java.lang.reflect.Array;
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.impl.runtime.RtUtil;
/*     */ 
/*     */ public abstract interface GenericValueContainer
/*     */ {
/*     */   public abstract void addChild(QName paramQName, Object paramObject);
/*     */ 
/*     */   public abstract Object instantiate();
/*     */ 
/*     */   public abstract Class getTargetClass();
/*     */ 
/*     */   public static class FACTORY
/*     */   {
/*     */     public static GenericValueContainer array(Class itemClass)
/*     */     {
/*  41 */       return array(null, null, itemClass);
/*     */     }
/*     */ 
/*     */     public static GenericValueContainer array(Class wrapperClass, String itemProperty, Class itemClass)
/*     */     {
/*  48 */       return new GenericValueContainer(wrapperClass, itemProperty, itemClass)
/*     */       {
/*  50 */         private final Class wrapperType = this.val$wrapperClass;
/*  51 */         private final String itemProp = this.val$itemProperty;
/*  52 */         private final Class itemType = this.val$itemClass;
/*  53 */         private final List items = new ArrayList();
/*     */ 
/*     */         public void addChild(QName name, Object value)
/*     */         {
/*  57 */           this.items.add(value);
/*     */         }
/*     */ 
/*     */         public Object instantiate()
/*     */         {
/*  97 */           Object arr = Array.newInstance(this.itemType, this.items.size());
/*  98 */           for (int i = 0; i < this.items.size(); i++)
/*     */           {
/*     */             try
/*     */             {
/* 102 */               Array.set(arr, i, this.items.get(i));
/*     */             }
/*     */             catch (IllegalArgumentException e)
/*     */             {
/* 106 */               throw new JBossXBRuntimeException("Failed to set " + this.items.get(i) + " as an item of array " + arr);
/*     */             }
/*     */ 
/*     */           }
/*     */ 
/* 113 */           Object result = arr;
/*     */ 
/* 115 */           if (this.wrapperType != null)
/*     */           {
/* 117 */             Constructor ctor = null;
/*     */             try
/*     */             {
/*     */               try
/*     */               {
/* 122 */                 Class[] sig = null;
/* 123 */                 ctor = this.wrapperType.getConstructor(sig);
/* 124 */                 Object[] args = null;
/* 125 */                 result = ctor.newInstance(args);
/* 126 */                 RtUtil.set(result, arr, this.itemProp, null, false, null);
/*     */               }
/*     */               catch (NoSuchMethodException e)
/*     */               {
/* 130 */                 Constructor[] ctors = this.wrapperType.getConstructors();
/* 131 */                 for (int i = 0; i < ctors.length; i++)
/*     */                 {
/* 133 */                   Class[] types = ctors[i].getParameterTypes();
/* 134 */                   if ((types.length != 1) || (!types[0].isAssignableFrom(arr.getClass())))
/*     */                     continue;
/* 136 */                   ctor = ctors[i];
/* 137 */                   break;
/*     */                 }
/*     */ 
/* 141 */                 if (ctor == null)
/*     */                 {
/* 143 */                   throw new JBossXBRuntimeException("Failed to find an appropriate ctor in " + this.wrapperType + " to wrap " + arr);
/*     */                 }
/*     */ 
/* 149 */                 result = ctor.newInstance(new Object[] { arr });
/*     */               }
/*     */             }
/*     */             catch (JBossXBRuntimeException e)
/*     */             {
/* 154 */               throw e;
/*     */             }
/*     */             catch (Exception e)
/*     */             {
/* 158 */               throw new JBossXBRuntimeException("Failed to initialize array wrapper " + this.wrapperType + " for " + arr, e);
/*     */             }
/*     */ 
/*     */           }
/*     */ 
/* 163 */           return result;
/*     */         }
/*     */ 
/*     */         public Class getTargetClass()
/*     */         {
/* 170 */           return Array.newInstance(this.itemType, 0).getClass();
/*     */         }
/*     */ 
/*     */         public String toString()
/*     */         {
/* 175 */           return super.toString() + "array";
/*     */         }
/*     */       };
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.GenericValueContainer
 * JD-Core Version:    0.6.0
 */