/*     */ package org.jboss.xb.binding;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class DelegatingObjectModelProvider
/*     */   implements GenericObjectModelProvider
/*     */ {
/*  36 */   private static final Logger log = Logger.getLogger(DelegatingObjectModelProvider.class);
/*     */   private final ObjectModelProvider provider;
/*  39 */   private final boolean trace = log.isTraceEnabled();
/*     */ 
/*     */   public DelegatingObjectModelProvider(ObjectModelProvider provider)
/*     */   {
/*  43 */     this.provider = provider;
/*     */   }
/*     */ 
/*     */   public Object getChildren(Object o, MarshallingContext ctx, String namespaceURI, String localName)
/*     */   {
/*  48 */     return provideChildren(this.provider, o, namespaceURI, localName);
/*     */   }
/*     */ 
/*     */   public Object getElementValue(Object o, MarshallingContext ctx, String namespaceURI, String localName)
/*     */   {
/*  53 */     return provideValue(this.provider, o, namespaceURI, localName);
/*     */   }
/*     */ 
/*     */   public Object getAttributeValue(Object o, MarshallingContext ctx, String namespaceURI, String localName)
/*     */   {
/*  58 */     return provideAttributeValue(this.provider, o, namespaceURI, localName);
/*     */   }
/*     */ 
/*     */   public Object getRoot(Object o, MarshallingContext ctx, String namespaceURI, String localName)
/*     */   {
/*  63 */     return this.provider.getRoot(o, null, namespaceURI, localName);
/*     */   }
/*     */ 
/*     */   Object provideChildren(ObjectModelProvider provider, Object parent, String namespaceUri, String name)
/*     */   {
/*  73 */     Class providerClass = provider.getClass();
/*  74 */     Class parentClass = parent.getClass();
/*  75 */     String methodName = "getChildren";
/*     */ 
/*  77 */     Object container = null;
/*  78 */     Method method = getProviderMethod(providerClass, methodName, new Class[] { parentClass, String.class, String.class });
/*     */ 
/*  82 */     if (method != null)
/*     */     {
/*     */       try
/*     */       {
/*  86 */         container = method.invoke(provider, new Object[] { parent, namespaceUri, name });
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/*  90 */         log.error("Failed to invoke method " + methodName, e);
/*  91 */         throw new IllegalStateException("Failed to invoke method " + methodName);
/*     */       }
/*     */     }
/*  94 */     else if (this.trace)
/*     */     {
/*  96 */       log.trace("No " + methodName + " for " + name);
/*     */     }
/*  98 */     return container;
/*     */   }
/*     */ 
/*     */   Object provideValue(ObjectModelProvider provider, Object parent, String namespaceUri, String name)
/*     */   {
/* 106 */     Class providerClass = provider.getClass();
/* 107 */     Class parentClass = parent.getClass();
/* 108 */     String methodName = "getElementValue";
/*     */ 
/* 110 */     Object value = null;
/* 111 */     Method method = getProviderMethod(providerClass, methodName, new Class[] { parentClass, String.class, String.class });
/*     */ 
/* 115 */     if (method != null)
/*     */     {
/*     */       try
/*     */       {
/* 119 */         value = method.invoke(provider, new Object[] { parent, namespaceUri, name });
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 123 */         throw new IllegalStateException("Failed to invoke method " + methodName);
/*     */       }
/*     */     }
/* 126 */     else if (this.trace)
/*     */     {
/* 128 */       log.trace("No " + methodName + " for " + name);
/*     */     }
/* 130 */     return value;
/*     */   }
/*     */ 
/*     */   Object provideAttributeValue(ObjectModelProvider provider, Object object, String namespaceUri, String name)
/*     */   {
/* 138 */     Class providerClass = provider.getClass();
/* 139 */     Class objectClass = object.getClass();
/* 140 */     String methodName = "getAttributeValue";
/*     */ 
/* 142 */     Object value = null;
/* 143 */     Method method = getProviderMethod(providerClass, methodName, new Class[] { objectClass, String.class, String.class });
/*     */ 
/* 147 */     if (method != null)
/*     */     {
/*     */       try
/*     */       {
/* 151 */         value = method.invoke(provider, new Object[] { object, namespaceUri, name });
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 155 */         throw new IllegalStateException("Failed to invoke method " + methodName);
/*     */       }
/*     */     }
/* 158 */     else if (this.trace)
/*     */     {
/* 160 */       log.trace("No " + methodName + " for " + name);
/*     */     }
/* 162 */     return value;
/*     */   }
/*     */ 
/*     */   private static Method getProviderMethod(Class providerClass, String methodName, Class[] args)
/*     */   {
/* 167 */     Method method = null;
/*     */     try
/*     */     {
/* 170 */       method = providerClass.getMethod(methodName, args);
/*     */     }
/*     */     catch (NoSuchMethodException e)
/*     */     {
/*     */     }
/*     */ 
/* 176 */     return method;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.DelegatingObjectModelProvider
 * JD-Core Version:    0.6.0
 */