/*     */ package org.jboss.xb.binding;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import org.jboss.util.StringPropertyReplacer;
/*     */ import org.xml.sax.Attributes;
/*     */ 
/*     */ public class DelegatingObjectModelFactory
/*     */   implements GenericObjectModelFactory
/*     */ {
/*     */   private final ObjectModelFactory typedFactory;
/*  43 */   private final Map addMethodsByParent = new HashMap();
/*     */   private boolean replaceProps;
/*     */ 
/*     */   public DelegatingObjectModelFactory(ObjectModelFactory typedFactory)
/*     */   {
/*  48 */     this.typedFactory = typedFactory;
/*  49 */     this.replaceProps = isReplacePropertyRefs(typedFactory);
/*     */ 
/*  51 */     Method[] methods = typedFactory.getClass().getMethods();
/*  52 */     for (int i = 0; i < methods.length; i++)
/*     */     {
/*  54 */       Method method = methods[i];
/*  55 */       if (!"addChild".equals(method.getName()))
/*     */         continue;
/*  57 */       Class parent = method.getParameterTypes()[0];
/*  58 */       AddMethods addMethods = (AddMethods)this.addMethodsByParent.get(parent);
/*  59 */       if (addMethods == null)
/*     */       {
/*  61 */         addMethods = new AddMethods(parent);
/*  62 */         this.addMethodsByParent.put(parent, addMethods);
/*     */       }
/*  64 */       addMethods.addMethod(method);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void startDTD(String name, String publicId, String systemId)
/*     */   {
/*     */     try
/*     */     {
/*  73 */       Class[] sig = { String.class, String.class, String.class };
/*  74 */       Method startDTD = this.typedFactory.getClass().getMethod("startDTD", sig);
/*  75 */       Object[] args = { name, publicId, systemId };
/*  76 */       startDTD.invoke(this.typedFactory, args);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object newRoot(Object root, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/*  90 */     return this.typedFactory.newRoot(root, navigator, namespaceURI, localName, attrs);
/*     */   }
/*     */ 
/*     */   public Object newChild(Object parent, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/*  96 */     Class objClass = parent.getClass();
/*  97 */     Class[] classes = { objClass, UnmarshallingContext.class, String.class, String.class, Attributes.class };
/*  98 */     Method method = ObjectModelBuilder.getMethodForElement(this.typedFactory, "newChild", classes);
/*     */ 
/* 101 */     while ((method == null) && (objClass.getSuperclass() != Object.class))
/*     */     {
/* 103 */       objClass = objClass.getSuperclass();
/* 104 */       classes = new Class[] { objClass, UnmarshallingContext.class, String.class, String.class, Attributes.class };
/* 105 */       method = ObjectModelBuilder.getMethodForElement(this.typedFactory, "newChild", classes);
/*     */     }
/*     */ 
/* 109 */     Object child = null;
/* 110 */     if (method != null)
/*     */     {
/* 112 */       Object[] objects = { parent, navigator, namespaceURI, localName, attrs };
/* 113 */       child = ObjectModelBuilder.invokeFactory(this.typedFactory, method, objects);
/*     */     }
/* 115 */     return child;
/*     */   }
/*     */ 
/*     */   public void addChild(Object parent, Object child, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 135 */     AddMethods addMethods = (AddMethods)this.addMethodsByParent.get(parent.getClass());
/* 136 */     if (addMethods != null)
/*     */     {
/* 138 */       Method method = addMethods.getMethodForChild(child.getClass());
/* 139 */       if (method != null)
/*     */       {
/* 141 */         ObjectModelBuilder.invokeFactory(this.typedFactory, method, new Object[] { parent, child, navigator, namespaceURI, localName });
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setValue(Object o, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 158 */     Class objClass = o.getClass();
/* 159 */     Class[] classes = { objClass, UnmarshallingContext.class, String.class, String.class, String.class };
/* 160 */     Method method = ObjectModelBuilder.getMethodForElement(this.typedFactory, "setValue", classes);
/*     */ 
/* 163 */     while ((method == null) && (objClass.getSuperclass() != Object.class))
/*     */     {
/* 165 */       objClass = objClass.getSuperclass();
/* 166 */       classes = new Class[] { objClass, UnmarshallingContext.class, String.class, String.class, String.class };
/* 167 */       method = ObjectModelBuilder.getMethodForElement(this.typedFactory, "setValue", classes);
/*     */     }
/*     */ 
/* 171 */     if (method != null)
/*     */     {
/* 174 */       if (this.replaceProps)
/* 175 */         value = StringPropertyReplacer.replaceProperties(value);
/* 176 */       Object[] objects = { o, navigator, namespaceURI, localName, value };
/* 177 */       ObjectModelBuilder.invokeFactory(this.typedFactory, method, objects);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object completeRoot(Object root, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 183 */     return root;
/*     */   }
/*     */ 
/*     */   static boolean isReplacePropertyRefs(ObjectModelFactory factory)
/*     */   {
/* 194 */     boolean replace = true;
/*     */     try
/*     */     {
/* 197 */       Class[] sig = new Class[0];
/* 198 */       Method isReplace = factory.getClass().getMethod("isReplacePropertyRefs", sig);
/* 199 */       if (Boolean.class.isAssignableFrom(isReplace.getReturnType()))
/*     */       {
/* 201 */         Object[] args = new Object[0];
/* 202 */         Boolean flag = (Boolean)isReplace.invoke(factory, args);
/* 203 */         replace = flag.booleanValue();
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */     }
/*     */ 
/* 210 */     return replace;
/*     */   }
/*     */ 
/*     */   private static class AddMethods
/*     */   {
/*     */     private static final int DEFAULT_METHODS_SIZE = 10;
/*     */     public final Class parent;
/* 220 */     private Method[] methods = new Method[10];
/*     */     private int totalMethods;
/*     */ 
/*     */     public AddMethods(Class parent) {
/* 225 */       this.parent = parent;
/*     */     }
/*     */ 
/*     */     public void addMethod(Method m)
/*     */     {
/* 230 */       if (this.totalMethods == this.methods.length)
/*     */       {
/* 232 */         Method[] tmp = this.methods;
/* 233 */         this.methods = new Method[this.methods.length + 10];
/* 234 */         System.arraycopy(tmp, 0, this.methods, 0, tmp.length);
/*     */       }
/* 236 */       this.methods[(this.totalMethods++)] = m;
/*     */     }
/*     */ 
/*     */     public Method getMethodForChild(Class child)
/*     */     {
/* 241 */       Class closestParam = null;
/* 242 */       Method closestMethod = null;
/* 243 */       for (int i = 0; i < this.totalMethods; i++)
/*     */       {
/* 245 */         Method method = this.methods[i];
/* 246 */         Class param = method.getParameterTypes()[1];
/* 247 */         if (param == child)
/*     */         {
/* 249 */           return method;
/*     */         }
/* 251 */         if ((!param.isAssignableFrom(child)) || ((closestParam != null) && (!closestParam.isAssignableFrom(param)))) {
/*     */           continue;
/*     */         }
/* 254 */         closestParam = param;
/* 255 */         closestMethod = method;
/*     */       }
/*     */ 
/* 258 */       return closestMethod;
/*     */     }
/*     */ 
/*     */     public boolean equals(Object o)
/*     */     {
/* 263 */       if (this == o)
/*     */       {
/* 265 */         return true;
/*     */       }
/* 267 */       if (!(o instanceof AddMethods))
/*     */       {
/* 269 */         return false;
/*     */       }
/*     */ 
/* 272 */       AddMethods addMethods = (AddMethods)o;
/*     */ 
/* 276 */       return this.parent.equals(addMethods.parent);
/*     */     }
/*     */ 
/*     */     public int hashCode()
/*     */     {
/* 284 */       return this.parent.hashCode();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.DelegatingObjectModelFactory
 * JD-Core Version:    0.6.0
 */