/*     */ package org.jboss.xb.binding;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.Writer;
/*     */ import org.xml.sax.Attributes;
/*     */ import org.xml.sax.ContentHandler;
/*     */ import org.xml.sax.Locator;
/*     */ import org.xml.sax.SAXException;
/*     */ 
/*     */ public class ContentWriter
/*     */   implements ContentHandler
/*     */ {
/*     */   final boolean useIndent;
/*  42 */   private String indent = "   ";
/*  43 */   private int depth = 0;
/*  44 */   private boolean started = false;
/*     */   private final Writer writer;
/*     */ 
/*     */   public ContentWriter(Writer writer, boolean indent)
/*     */   {
/*  50 */     this.writer = writer;
/*  51 */     this.useIndent = indent;
/*     */   }
/*     */ 
/*     */   public void setDocumentLocator(Locator locator)
/*     */   {
/*  56 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public void startDocument()
/*     */     throws SAXException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void endDocument()
/*     */     throws SAXException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void startPrefixMapping(String prefix, String uri)
/*     */     throws SAXException
/*     */   {
/*  72 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public void endPrefixMapping(String prefix)
/*     */     throws SAXException
/*     */   {
/*  78 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public void startElement(String namespaceURI, String localName, String qName, Attributes atts)
/*     */     throws SAXException
/*     */   {
/*  84 */     if (this.useIndent)
/*     */     {
/*  86 */       write(this.writer, 10);
/*  87 */       for (int j = 0; j < this.depth; j++)
/*     */       {
/*  89 */         write(this.writer, this.indent);
/*     */       }
/*     */     }
/*     */ 
/*  93 */     if (!this.started)
/*     */     {
/*  95 */       this.started = true;
/*     */     }
/*     */ 
/*  98 */     this.depth += 1;
/*     */ 
/* 100 */     write(this.writer, 60);
/* 101 */     write(this.writer, qName);
/*     */ 
/* 103 */     if ((atts != null) && (atts.getLength() > 0))
/*     */     {
/* 105 */       for (int i = 0; i < atts.getLength(); i++)
/*     */       {
/* 107 */         write(this.writer, 32);
/* 108 */         write(this.writer, atts.getQName(i));
/* 109 */         write(this.writer, "=\"");
/* 110 */         writeNormalized(this.writer, atts.getValue(i));
/* 111 */         write(this.writer, 34);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 151 */     write(this.writer, 62);
/*     */   }
/*     */ 
/*     */   public void endElement(String namespaceURI, String localName, String qName)
/*     */     throws SAXException
/*     */   {
/* 158 */     this.depth -= 1;
/* 159 */     if (!this.started)
/*     */     {
/* 161 */       if (this.useIndent)
/*     */       {
/* 163 */         write(this.writer, 10);
/* 164 */         for (int j = 0; j < this.depth; j++)
/*     */         {
/* 166 */           write(this.writer, this.indent);
/*     */         }
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 172 */       this.started = false;
/*     */     }
/*     */ 
/* 175 */     write(this.writer, "</");
/* 176 */     write(this.writer, qName);
/* 177 */     write(this.writer, 62);
/*     */   }
/*     */ 
/*     */   public void characters(char[] ch, int start, int length)
/*     */     throws SAXException
/*     */   {
/* 183 */     writeNormalized(this.writer, ch, start, length);
/*     */   }
/*     */ 
/*     */   public void ignorableWhitespace(char[] ch, int start, int length)
/*     */     throws SAXException
/*     */   {
/* 189 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public void processingInstruction(String target, String data)
/*     */     throws SAXException
/*     */   {
/* 195 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public void skippedEntity(String name)
/*     */     throws SAXException
/*     */   {
/* 201 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   private static void write(Writer writer, String str)
/*     */     throws SAXException
/*     */   {
/*     */     try
/*     */     {
/* 210 */       writer.write(str);
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 214 */       throw new SAXException("Writting failed: " + e.getMessage(), e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static void writeNormalized(Writer writer, String str) throws SAXException
/*     */   {
/* 220 */     writeNormalized(writer, str.toCharArray(), 0, str.length());
/*     */   }
/*     */ 
/*     */   private static void write(Writer writer, int ch) throws SAXException
/*     */   {
/*     */     try
/*     */     {
/* 227 */       writer.write(ch);
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 231 */       throw new SAXException("Writting failed: " + e.getMessage(), e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static void writeNormalized(Writer writer, char[] ch, int start, int length) throws SAXException
/*     */   {
/*     */     try
/*     */     {
/* 239 */       int left = start;
/* 240 */       int i = start;
/* 241 */       while (i < start + length)
/*     */       {
/* 243 */         char c = ch[(i++)];
/* 244 */         if (c == '<')
/*     */         {
/* 246 */           writer.write(ch, left, i - left - 1);
/* 247 */           writer.write("&lt;");
/* 248 */           left = i;
/*     */         }
/* 250 */         else if (c == '>')
/*     */         {
/* 252 */           writer.write(ch, left, i - left - 1);
/* 253 */           writer.write("&gt;");
/* 254 */           left = i;
/*     */         }
/* 256 */         else if (c == '&')
/*     */         {
/* 258 */           writer.write(ch, left, i - left - 1);
/* 259 */           writer.write("&amp;");
/* 260 */           left = i;
/*     */         }
/* 262 */         else if (c == '\'')
/*     */         {
/* 264 */           writer.write(ch, left, i - left - 1);
/* 265 */           writer.write("&apos;");
/* 266 */           left = i;
/*     */         }
/* 268 */         else if (c == '"')
/*     */         {
/* 270 */           writer.write(ch, left, i - left - 1);
/* 271 */           writer.write("&quot;");
/* 272 */           left = i;
/*     */         }
/*     */       }
/*     */ 
/* 276 */       if (left < i)
/*     */       {
/* 278 */         writer.write(ch, left, i - left);
/*     */       }
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 283 */       throw new SAXException("Writting failed: " + e.getMessage(), e);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.ContentWriter
 * JD-Core Version:    0.6.0
 */