/*     */ package org.jboss.wsf.stack.jbws;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.FileOutputStream;
/*     */ import java.io.FileWriter;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.Writer;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import java.util.LinkedList;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import javax.wsdl.Definition;
/*     */ import javax.wsdl.Import;
/*     */ import javax.wsdl.factory.WSDLFactory;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.NotImplementedException;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.utils.ResourceURL;
/*     */ import org.jboss.ws.metadata.umdm.ServiceMetaData;
/*     */ import org.jboss.ws.metadata.umdm.UnifiedMetaData;
/*     */ import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
/*     */ import org.jboss.wsf.common.DOMUtils;
/*     */ import org.jboss.wsf.common.IOUtils;
/*     */ import org.jboss.wsf.spi.SPIProvider;
/*     */ import org.jboss.wsf.spi.SPIProviderResolver;
/*     */ import org.jboss.wsf.spi.deployment.ArchiveDeployment;
/*     */ import org.jboss.wsf.spi.deployment.Deployment.DeploymentType;
/*     */ import org.jboss.wsf.spi.management.ServerConfig;
/*     */ import org.jboss.wsf.spi.management.ServerConfigFactory;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class WSDLFilePublisher
/*     */ {
/*  69 */   private static final Logger log = Logger.getLogger(WSDLFilePublisher.class);
/*     */   private ArchiveDeployment dep;
/*     */   private String expLocation;
/*     */   private ServerConfig serverConfig;
/*     */ 
/*     */   public WSDLFilePublisher(ArchiveDeployment dep)
/*     */   {
/*  80 */     this.dep = dep;
/*     */ 
/*  82 */     SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
/*  83 */     this.serverConfig = ((ServerConfigFactory)spiProvider.getSPI(ServerConfigFactory.class)).getServerConfig();
/*     */ 
/*  85 */     if (dep.getType().toString().endsWith("JSE"))
/*     */     {
/*  87 */       this.expLocation = "WEB-INF/wsdl/";
/*     */     }
/*     */     else
/*     */     {
/*  91 */       this.expLocation = "META-INF/wsdl/";
/*     */     }
/*     */   }
/*     */ 
/*     */   public void publishWsdlFiles(UnifiedMetaData wsMetaData)
/*     */     throws IOException
/*     */   {
/*  99 */     String deploymentName = this.dep.getCanonicalName();
/*     */ 
/* 102 */     for (ServiceMetaData serviceMetaData : wsMetaData.getServices())
/*     */     {
/* 104 */       File wsdlFile = getPublishLocation(deploymentName, serviceMetaData);
/* 105 */       wsdlFile.getParentFile().mkdirs();
/*     */       try
/*     */       {
/* 110 */         Writer fWriter = IOUtils.getCharsetFileWriter(wsdlFile, "UTF-8");
/* 111 */         WSDLDefinitions wsdlDefinitions = serviceMetaData.getWsdlDefinitions();
/* 112 */         new org.jboss.ws.tools.wsdl.WSDLWriter(wsdlDefinitions).write(fWriter, "UTF-8");
/*     */ 
/* 114 */         URL wsdlPublishURL = wsdlFile.toURL();
/* 115 */         log.info("WSDL published to: " + wsdlPublishURL);
/*     */ 
/* 118 */         serviceMetaData.setWsdlLocation(wsdlFile.toURL());
/*     */ 
/* 121 */         Definition wsdl11Definition = wsdlDefinitions.getWsdlOneOneDefinition();
/* 122 */         if (wsdl11Definition != null)
/*     */         {
/* 124 */           List published = new LinkedList();
/* 125 */           publishWsdlImports(wsdlFile.toURL(), wsdl11Definition, published);
/*     */ 
/* 128 */           Document document = wsdlDefinitions.getWsdlDocument();
/* 129 */           publishSchemaImports(wsdlFile.toURL(), document.getDocumentElement(), published);
/*     */         }
/*     */         else
/*     */         {
/* 133 */           throw new NotImplementedException("WSDL-2.0 imports");
/*     */         }
/*     */       }
/*     */       catch (RuntimeException rte)
/*     */       {
/* 138 */         throw rte;
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 142 */         throw new WSException("Cannot publish wsdl to: " + wsdlFile, e);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void publishWsdlImports(URL parentURL, Definition parentDefinition, List<String> published)
/*     */     throws Exception
/*     */   {
/* 151 */     String baseURI = parentURL.toExternalForm();
/*     */ 
/* 153 */     Iterator it = parentDefinition.getImports().values().iterator();
/* 154 */     while (it.hasNext())
/*     */     {
/* 156 */       for (Import wsdlImport : (List)it.next())
/*     */       {
/* 158 */         String locationURI = wsdlImport.getLocationURI();
/* 159 */         Definition subdef = wsdlImport.getDefinition();
/*     */ 
/* 162 */         if (!locationURI.startsWith("http://"))
/*     */         {
/* 165 */           if (published.contains(locationURI))
/*     */           {
/* 167 */             return;
/*     */           }
/*     */ 
/* 171 */           published.add(locationURI);
/*     */ 
/* 174 */           URL targetURL = new URL(baseURI.substring(0, baseURI.lastIndexOf("/") + 1) + locationURI);
/* 175 */           File targetFile = new File(targetURL.getPath());
/* 176 */           targetFile.getParentFile().mkdirs();
/*     */ 
/* 178 */           WSDLFactory wsdlFactory = WSDLFactory.newInstance();
/* 179 */           javax.wsdl.xml.WSDLWriter wsdlWriter = wsdlFactory.newWSDLWriter();
/* 180 */           FileWriter fw = new FileWriter(targetFile);
/* 181 */           wsdlWriter.writeWSDL(subdef, fw);
/* 182 */           fw.close();
/*     */ 
/* 184 */           if (log.isDebugEnabled()) {
/* 185 */             log.debug("WSDL import published to: " + targetURL);
/*     */           }
/*     */ 
/* 188 */           publishWsdlImports(targetURL, subdef, published);
/*     */ 
/* 191 */           Element subdoc = DOMUtils.parse(targetURL.openStream());
/* 192 */           publishSchemaImports(targetURL, subdoc, published);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void publishSchemaImports(URL parentURL, Element element, List<String> published)
/*     */     throws Exception
/*     */   {
/* 202 */     String baseURI = parentURL.toExternalForm();
/*     */ 
/* 204 */     Iterator it = DOMUtils.getChildElements(element);
/* 205 */     while (it.hasNext())
/*     */     {
/* 207 */       Element childElement = (Element)it.next();
/* 208 */       if (("import".equals(childElement.getLocalName())) || ("include".equals(childElement.getLocalName())))
/*     */       {
/* 210 */         String schemaLocation = childElement.getAttribute("schemaLocation");
/* 211 */         if (schemaLocation.length() > 0)
/*     */         {
/* 213 */           if (!schemaLocation.startsWith("http://"))
/*     */           {
/* 216 */             if (published.contains(schemaLocation))
/*     */             {
/* 218 */               return;
/*     */             }
/*     */ 
/* 222 */             published.add(schemaLocation);
/*     */ 
/* 225 */             URL xsdURL = new URL(baseURI.substring(0, baseURI.lastIndexOf("/") + 1) + schemaLocation);
/* 226 */             File targetFile = new File(xsdURL.getPath());
/* 227 */             targetFile.getParentFile().mkdirs();
/*     */ 
/* 229 */             String deploymentName = this.dep.getCanonicalName();
/*     */ 
/* 232 */             int index = baseURI.indexOf(deploymentName);
/* 233 */             String resourcePath = baseURI.substring(index + deploymentName.length());
/* 234 */             resourcePath = resourcePath.substring(0, resourcePath.lastIndexOf("/"));
/* 235 */             if (resourcePath.length() > 0) {
/* 236 */               resourcePath = resourcePath + "/";
/*     */             }
/* 238 */             resourcePath = this.expLocation + resourcePath + schemaLocation;
/* 239 */             URL resourceURL = this.dep.getMetaDataFileURL(resourcePath);
/* 240 */             InputStream is = new ResourceURL(resourceURL).openStream();
/* 241 */             if (is == null) {
/* 242 */               throw new IllegalArgumentException("Cannot find schema import in deployment: " + resourcePath);
/*     */             }
/* 244 */             FileOutputStream fos = new FileOutputStream(targetFile);
/* 245 */             IOUtils.copyStream(fos, is);
/* 246 */             fos.close();
/* 247 */             is.close();
/*     */ 
/* 249 */             if (log.isDebugEnabled()) {
/* 250 */               log.debug("XMLSchema import published to: " + xsdURL);
/*     */             }
/*     */ 
/* 253 */             Element subdoc = DOMUtils.parse(xsdURL.openStream());
/* 254 */             publishSchemaImports(xsdURL, subdoc, published);
/*     */           }
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 260 */         publishSchemaImports(parentURL, childElement, published);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void unpublishWsdlFiles()
/*     */     throws IOException
/*     */   {
/* 270 */     String deploymentDir = this.dep.getParent() != null ? this.dep.getParent().getSimpleName() : this.dep.getSimpleName();
/*     */ 
/* 272 */     File serviceDir = new File(this.serverConfig.getServerDataDir().getCanonicalPath() + "/wsdl/" + deploymentDir);
/* 273 */     deleteWsdlPublishDirectory(serviceDir);
/*     */   }
/*     */ 
/*     */   private void deleteWsdlPublishDirectory(File dir)
/*     */     throws IOException
/*     */   {
/* 281 */     String[] files = dir.list();
/* 282 */     for (int i = 0; (files != null) && (i < files.length); i++)
/*     */     {
/* 284 */       String fileName = files[i];
/* 285 */       File file = new File(dir + "/" + fileName);
/* 286 */       if (file.isDirectory())
/*     */       {
/* 288 */         deleteWsdlPublishDirectory(file);
/*     */       }
/* 292 */       else if (!file.delete()) {
/* 293 */         log.warn("Cannot delete published wsdl document: " + file.toURL());
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 298 */     dir.delete();
/*     */   }
/*     */ 
/*     */   private File getPublishLocation(String archiveName, ServiceMetaData serviceMetaData)
/*     */     throws IOException
/*     */   {
/* 306 */     String wsdlLocation = null;
/* 307 */     if (serviceMetaData.getWsdlLocation() != null)
/* 308 */       wsdlLocation = serviceMetaData.getWsdlLocation().toExternalForm();
/* 309 */     else if (serviceMetaData.getWsdlFile() != null) {
/* 310 */       wsdlLocation = serviceMetaData.getWsdlFile();
/*     */     }
/* 312 */     if (wsdlLocation == null) {
/* 313 */       throw new IllegalStateException("Cannot obtain wsdl location for: " + serviceMetaData.getServiceName());
/*     */     }
/* 315 */     if (log.isDebugEnabled()) {
/* 316 */       log.debug("Publish WSDL file: " + wsdlLocation);
/*     */     }
/*     */ 
/* 319 */     String publishLocation = serviceMetaData.getWsdlPublishLocation();
/* 320 */     boolean predefinedLocation = (publishLocation != null) && (publishLocation.startsWith("file:"));
/*     */ 
/* 322 */     File locationFile = null;
/* 323 */     if (!predefinedLocation)
/*     */     {
/* 325 */       locationFile = new File(this.serverConfig.getServerDataDir().getCanonicalPath() + "/wsdl/" + archiveName);
/*     */     }
/*     */     else
/*     */     {
/*     */       try
/*     */       {
/* 331 */         locationFile = new File(new URL(publishLocation).getPath());
/*     */       }
/*     */       catch (MalformedURLException e)
/*     */       {
/* 335 */         throw new IllegalArgumentException("Invalid publish location: " + e.getMessage());
/*     */       }
/*     */     }
/*     */     File wsdlFile;
/* 340 */     if (wsdlLocation.indexOf(this.expLocation) >= 0)
/*     */     {
/* 342 */       wsdlLocation = wsdlLocation.substring(wsdlLocation.indexOf(this.expLocation) + this.expLocation.length());
/* 343 */       wsdlFile = new File(locationFile + "/" + wsdlLocation);
/*     */     }
/*     */     else
/*     */     {
/*     */       File wsdlFile;
/* 345 */       if ((wsdlLocation.startsWith("vfsfile:")) || (wsdlLocation.startsWith("file:")) || (wsdlLocation.startsWith("jar:")))
/*     */       {
/* 347 */         wsdlLocation = wsdlLocation.substring(wsdlLocation.lastIndexOf("/") + 1);
/* 348 */         wsdlFile = new File(locationFile + "/" + wsdlLocation);
/*     */       }
/*     */       else
/*     */       {
/* 352 */         throw new WSException("Invalid wsdlFile '" + wsdlLocation + "', expected in: " + this.expLocation);
/*     */       }
/*     */     }
/*     */     File wsdlFile;
/* 355 */     return wsdlFile;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.wsf.stack.jbws.WSDLFilePublisher
 * JD-Core Version:    0.6.0
 */