/*     */ package org.jboss.wsf.stack.jbws;
/*     */ 
/*     */ import org.jboss.ws.metadata.builder.jaxrpc.JAXRPCServerMetaDataBuilder;
/*     */ import org.jboss.ws.metadata.builder.jaxws.JAXWSMetaDataBuilderEJB3;
/*     */ import org.jboss.ws.metadata.builder.jaxws.JAXWSMetaDataBuilderJSE;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ServiceMetaData;
/*     */ import org.jboss.ws.metadata.umdm.UnifiedMetaData;
/*     */ import org.jboss.wsf.spi.deployment.ArchiveDeployment;
/*     */ import org.jboss.wsf.spi.deployment.Deployment;
/*     */ import org.jboss.wsf.spi.deployment.Deployment.DeploymentType;
/*     */ import org.jboss.wsf.spi.deployment.DeploymentAspect;
/*     */ import org.jboss.wsf.spi.deployment.Endpoint;
/*     */ import org.jboss.wsf.spi.deployment.Service;
/*     */ 
/*     */ public class UnifiedMetaDataDeploymentAspect extends DeploymentAspect
/*     */ {
/*     */   public void create(Deployment dep)
/*     */   {
/*  50 */     UnifiedMetaData umd = (UnifiedMetaData)dep.getAttachment(UnifiedMetaData.class);
/*  51 */     if (umd == null)
/*     */     {
/*  53 */       if (dep.getType() == Deployment.DeploymentType.JAXRPC_JSE)
/*     */       {
/*  55 */         JAXRPCServerMetaDataBuilder builder = new JAXRPCServerMetaDataBuilder();
/*  56 */         umd = builder.buildMetaData((ArchiveDeployment)dep);
/*     */       }
/*  58 */       else if (dep.getType() == Deployment.DeploymentType.JAXRPC_EJB21)
/*     */       {
/*  60 */         JAXRPCServerMetaDataBuilder builder = new JAXRPCServerMetaDataBuilder();
/*  61 */         umd = builder.buildMetaData((ArchiveDeployment)dep);
/*     */       }
/*  63 */       else if (dep.getType() == Deployment.DeploymentType.JAXWS_JSE)
/*     */       {
/*  65 */         JAXWSMetaDataBuilderJSE builder = new JAXWSMetaDataBuilderJSE();
/*  66 */         umd = builder.buildMetaData((ArchiveDeployment)dep);
/*     */       }
/*  68 */       else if (dep.getType() == Deployment.DeploymentType.JAXWS_EJB3)
/*     */       {
/*  70 */         JAXWSMetaDataBuilderEJB3 builder = new JAXWSMetaDataBuilderEJB3();
/*  71 */         umd = builder.buildMetaData((ArchiveDeployment)dep);
/*     */       }
/*     */       else
/*     */       {
/*  75 */         throw new IllegalStateException("Invalid type:  " + dep.getType());
/*     */       }
/*     */ 
/*  78 */       dep.addAttachment(UnifiedMetaData.class, umd);
/*     */     }
/*     */ 
/*  81 */     for (Endpoint ep : dep.getService().getEndpoints())
/*     */     {
/*  83 */       ServerEndpointMetaData sepMetaData = (ServerEndpointMetaData)ep.getAttachment(ServerEndpointMetaData.class);
/*  84 */       if (sepMetaData == null)
/*     */       {
/*  86 */         sepMetaData = getEndpointMetaData(umd, ep);
/*  87 */         sepMetaData.setEndpoint(ep);
/*     */ 
/*  89 */         ep.addAttachment(ServerEndpointMetaData.class, sepMetaData);
/*     */ 
/*  91 */         String targetBean = ep.getTargetBeanName();
/*  92 */         if (targetBean != null)
/*  93 */           sepMetaData.setServiceEndpointImplName(targetBean);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private ServerEndpointMetaData getEndpointMetaData(UnifiedMetaData umd, Endpoint ep)
/*     */   {
/* 100 */     String epName = ep.getShortName();
/*     */ 
/* 102 */     ServerEndpointMetaData epMetaData = null;
/* 103 */     for (ServiceMetaData serviceMetaData : umd.getServices())
/*     */     {
/* 105 */       for (EndpointMetaData aux : serviceMetaData.getEndpoints())
/*     */       {
/* 107 */         String linkName = ((ServerEndpointMetaData)aux).getLinkName();
/* 108 */         if (epName.equals(linkName))
/*     */         {
/* 110 */           epMetaData = (ServerEndpointMetaData)aux;
/* 111 */           break;
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 116 */     if (epMetaData == null) {
/* 117 */       throw new IllegalStateException("Cannot find endpoint meta data for: " + epName);
/*     */     }
/* 119 */     return epMetaData;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.wsf.stack.jbws.UnifiedMetaDataDeploymentAspect
 * JD-Core Version:    0.6.0
 */