/*    */ package org.jboss.wsf.stack.jbws;
/*    */ 
/*    */ import com.sun.xml.bind.api.JAXBRIContext;
/*    */ import java.io.IOException;
/*    */ import java.io.InputStream;
/*    */ import java.net.URL;
/*    */ import org.jboss.jaxb.intros.IntroductionsAnnotationReader;
/*    */ import org.jboss.jaxb.intros.IntroductionsConfigParser;
/*    */ import org.jboss.jaxb.intros.configmodel.JaxbIntros;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.ws.core.jaxws.JAXBBindingCustomization;
/*    */ import org.jboss.wsf.spi.binding.BindingCustomization;
/*    */ import org.jboss.wsf.spi.deployment.Deployment;
/*    */ import org.jboss.wsf.spi.deployment.DeploymentAspect;
/*    */ import org.jboss.wsf.spi.deployment.Endpoint;
/*    */ import org.jboss.wsf.spi.deployment.Service;
/*    */ 
/*    */ public class JAXBIntroDeploymentAspect extends DeploymentAspect
/*    */ {
/* 44 */   private static Logger logger = Logger.getLogger(JAXBIntroDeploymentAspect.class);
/*    */ 
/*    */   public void create(Deployment deployment)
/*    */   {
/* 49 */     InputStream introsConfigStream = null;
/*    */     try
/*    */     {
/* 52 */       ClassLoader classLoader = deployment.getRuntimeClassLoader();
/* 53 */       introsConfigStream = classLoader.getResource("META-INF/jaxb-intros.xml").openStream();
/*    */     } catch (Exception e) {
/*    */     }
/* 56 */     if (null == introsConfigStream)
/*    */     {
/*    */       try
/*    */       {
/* 60 */         ClassLoader classLoader = deployment.getRuntimeClassLoader();
/* 61 */         introsConfigStream = classLoader.getResource("WEB-INF/jaxb-intros.xml").openStream();
/*    */       } catch (Exception e) {
/* 63 */         return;
/*    */       }
/*    */     }
/*    */     try
/*    */     {
/* 68 */       if (introsConfigStream != null) {
/* 69 */         JaxbIntros jaxbIntros = IntroductionsConfigParser.parseConfig(introsConfigStream);
/* 70 */         IntroductionsAnnotationReader annotationReader = new IntroductionsAnnotationReader(jaxbIntros);
/* 71 */         String defaultNamespace = jaxbIntros.getDefaultNamespace();
/* 72 */         jaxbCustomizations = new JAXBBindingCustomization();
/*    */ 
/* 74 */         jaxbCustomizations.put(JAXBRIContext.ANNOTATION_READER, annotationReader);
/* 75 */         if (defaultNamespace != null) {
/* 76 */           jaxbCustomizations.put("com.sun.xml.bind.defaultNamespaceRemap", defaultNamespace);
/*    */         }
/*    */ 
/* 80 */         for (Endpoint endpoint : deployment.getService().getEndpoints())
/*    */         {
/* 82 */           endpoint.addAttachment(BindingCustomization.class, jaxbCustomizations);
/*    */         }
/*    */       }
/*    */     }
/*    */     finally
/*    */     {
/*    */       BindingCustomization jaxbCustomizations;
/* 87 */       if (introsConfigStream != null)
/*    */         try {
/* 89 */           introsConfigStream.close();
/*    */         } catch (IOException e) {
/* 91 */           logger.error("[" + deployment.getService().getContextRoot() + "] Error closing JAXB Introductions Configurations stream ", e);
/*    */         }
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.wsf.stack.jbws.JAXBIntroDeploymentAspect
 * JD-Core Version:    0.6.0
 */