/*     */ package org.jboss.wsf.spi.tools.cmd;
/*     */ 
/*     */ import gnu.getopt.Getopt;
/*     */ import gnu.getopt.LongOpt;
/*     */ import java.io.File;
/*     */ import java.io.PrintStream;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import java.net.URLClassLoader;
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import org.jboss.wsf.spi.tools.WSContractProvider;
/*     */ 
/*     */ public class WSProvide
/*     */ {
/*  61 */   private boolean generateSource = false;
/*  62 */   private boolean generateWsdl = false;
/*  63 */   private boolean quiet = false;
/*  64 */   private boolean showTraces = false;
/*  65 */   private boolean loadProvider = false;
/*  66 */   private ClassLoader loader = Thread.currentThread().getContextClassLoader();
/*  67 */   private File outputDir = new File("output");
/*  68 */   private File resourceDir = null;
/*  69 */   private File sourceDir = null;
/*     */ 
/*  71 */   public static String PROGRAM_NAME = System.getProperty("program.name", WSProvide.class.getSimpleName());
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/*  75 */     WSProvide generate = new WSProvide();
/*  76 */     String endpoint = generate.parseArguments(args);
/*  77 */     System.exit(generate.generate(endpoint));
/*     */   }
/*     */ 
/*     */   private String parseArguments(String[] args)
/*     */   {
/*  82 */     String shortOpts = "hwko:r:s:c:qtl";
/*  83 */     LongOpt[] longOpts = { new LongOpt("help", 0, null, 104), new LongOpt("wsdl", 0, null, 119), new LongOpt("keep", 0, null, 107), new LongOpt("output", 1, null, 111), new LongOpt("resource", 1, null, 114), new LongOpt("source", 1, null, 115), new LongOpt("classpath", 1, null, 99), new LongOpt("quiet", 0, null, 113), new LongOpt("show-traces", 0, null, 116), new LongOpt("load-provider", 0, null, 108) };
/*     */ 
/*  97 */     Getopt getopt = new Getopt(PROGRAM_NAME, args, shortOpts, longOpts);
/*     */     int c;
/*  99 */     while ((c = getopt.getopt()) != -1)
/*     */     {
/* 101 */       switch (c)
/*     */       {
/*     */       case 107:
/* 104 */         this.generateSource = true;
/* 105 */         break;
/*     */       case 115:
/* 107 */         this.sourceDir = new File(getopt.getOptarg());
/* 108 */         break;
/*     */       case 114:
/* 110 */         this.resourceDir = new File(getopt.getOptarg());
/* 111 */         break;
/*     */       case 119:
/* 113 */         this.generateWsdl = true;
/* 114 */         break;
/*     */       case 116:
/* 116 */         this.showTraces = true;
/* 117 */         break;
/*     */       case 111:
/* 119 */         this.outputDir = new File(getopt.getOptarg());
/* 120 */         break;
/*     */       case 113:
/* 122 */         this.quiet = true;
/* 123 */         break;
/*     */       case 99:
/* 125 */         processClassPath(getopt.getOptarg());
/* 126 */         break;
/*     */       case 108:
/* 128 */         this.loadProvider = true;
/* 129 */         break;
/*     */       case 104:
/* 131 */         printHelp();
/* 132 */         System.exit(0);
/*     */       case 63:
/* 134 */         System.exit(1);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 139 */     if (this.loadProvider)
/*     */     {
/* 141 */       WSContractProvider gen = WSContractProvider.newInstance(this.loader);
/* 142 */       System.out.println("WSContractProvider instance: " + gen.getClass().getCanonicalName());
/* 143 */       System.exit(0);
/*     */     }
/*     */ 
/* 146 */     int endpointPos = getopt.getOptind();
/* 147 */     if (endpointPos >= args.length)
/*     */     {
/* 149 */       System.err.println("Error: endpoint implementation was not specified!");
/* 150 */       printHelp();
/* 151 */       System.exit(1);
/*     */     }
/*     */ 
/* 154 */     return args[endpointPos];
/*     */   }
/*     */ 
/*     */   private int generate(String endpoint)
/*     */   {
/*     */     try
/*     */     {
/* 162 */       this.loader.loadClass(endpoint);
/*     */     }
/*     */     catch (ClassNotFoundException e)
/*     */     {
/* 166 */       System.err.println("Error: Could not load class [" + endpoint + "]. Did you specify a valid --classpath?");
/* 167 */       return 1;
/*     */     }
/*     */ 
/* 170 */     WSContractProvider gen = WSContractProvider.newInstance(this.loader);
/* 171 */     gen.setGenerateWsdl(this.generateWsdl);
/* 172 */     gen.setGenerateSource(this.generateSource);
/* 173 */     gen.setOutputDirectory(this.outputDir);
/* 174 */     if (this.resourceDir != null)
/* 175 */       gen.setResourceDirectory(this.resourceDir);
/* 176 */     if (this.sourceDir != null) {
/* 177 */       gen.setSourceDirectory(this.sourceDir);
/*     */     }
/* 179 */     if (!this.quiet) {
/* 180 */       gen.setMessageStream(System.out);
/*     */     }
/*     */     try
/*     */     {
/* 184 */       gen.provide(endpoint);
/* 185 */       return 0;
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 189 */       System.err.println("Error: Could not generate. (use --show-traces to see full traces)");
/* 190 */       if (!this.showTraces)
/*     */       {
/* 192 */         String message = t.getMessage();
/* 193 */         if (message == null)
/* 194 */           message = t.getClass().getSimpleName();
/* 195 */         System.err.println("Error: " + message);
/*     */       }
/*     */       else
/*     */       {
/* 199 */         t.printStackTrace(System.err);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 204 */     return 1;
/*     */   }
/*     */ 
/*     */   private void processClassPath(String classPath)
/*     */   {
/* 209 */     String[] entries = classPath.split(File.pathSeparator);
/* 210 */     List urls = new ArrayList(entries.length);
/* 211 */     for (String entry : entries)
/*     */     {
/*     */       try
/*     */       {
/* 215 */         urls.add(new File(entry).toURL());
/*     */       }
/*     */       catch (MalformedURLException e)
/*     */       {
/* 219 */         System.err.println("Error: a classpath entry was malformed: " + entry);
/*     */       }
/*     */     }
/* 222 */     this.loader = new URLClassLoader((URL[])urls.toArray(new URL[0]), this.loader);
/*     */   }
/*     */ 
/*     */   private static void printHelp()
/*     */   {
/* 227 */     PrintStream out = System.out;
/* 228 */     out.println("WSProvideTask generates portable JAX-WS artifacts for an endpoint implementation.\n");
/* 229 */     out.println("usage: " + PROGRAM_NAME + " [options] <endpoint class name>\n");
/* 230 */     out.println("options: ");
/* 231 */     out.println("    -h, --help                  Show this help message");
/* 232 */     out.println("    -k, --keep                  Keep/Generate Java source");
/* 233 */     out.println("    -w, --wsdl                  Enable WSDL file generation");
/* 234 */     out.println("    -c, --classpath=<path>      The classpath that contains the endpoint");
/* 235 */     out.println("    -o, --output=<directory>    The directory to put generated artifacts");
/* 236 */     out.println("    -r, --resource=<directory>  The directory to put resource artifacts");
/* 237 */     out.println("    -s, --source=<directory>    The directory to put Java source");
/* 238 */     out.println("    -q, --quiet                 Be somewhat more quiet");
/* 239 */     out.println("    -t, --show-traces           Show full exception stack traces");
/* 240 */     out.println("    -l, --load-provider         Load the provider and exit (debug utility)");
/* 241 */     out.flush();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.wsf.spi.tools.cmd.WSProvide
 * JD-Core Version:    0.6.0
 */