/*     */ package org.jboss.wsf.spi.tools;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.PrintStream;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import java.util.List;
/*     */ import org.jboss.wsf.spi.util.ServiceLoader;
/*     */ 
/*     */ public abstract class WSContractConsumer
/*     */ {
/*  44 */   private static String DEFAULT_PROVIDER = "org.jboss.ws.tools.jaxws.impl.SunRIConsumerFactoryImpl";
/*     */   public static final String PROVIDER_PROPERTY = "org.jboss.wsf.spi.tools.ConsumerFactoryImpl";
/*     */ 
/*     */   public static WSContractConsumer newInstance()
/*     */   {
/*  56 */     return newInstance(Thread.currentThread().getContextClassLoader());
/*     */   }
/*     */ 
/*     */   public static WSContractConsumer newInstance(ClassLoader loader)
/*     */   {
/*  68 */     ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
/*     */     try
/*     */     {
/*  71 */       Thread.currentThread().setContextClassLoader(loader);
/*  72 */       WSContractConsumerFactory factory = (WSContractConsumerFactory)ServiceLoader.loadService("org.jboss.wsf.spi.tools.ConsumerFactoryImpl", DEFAULT_PROVIDER);
/*  73 */       WSContractConsumer localWSContractConsumer = factory.createConsumer();
/*     */       return localWSContractConsumer; } finally { Thread.currentThread().setContextClassLoader(oldLoader); } throw localObject;
/*     */   }
/*     */ 
/*     */   public abstract void setBindingFiles(List<File> paramList);
/*     */ 
/*     */   public abstract void setCatalog(File paramFile);
/*     */ 
/*     */   public abstract void setOutputDirectory(File paramFile);
/*     */ 
/*     */   public abstract void setSourceDirectory(File paramFile);
/*     */ 
/*     */   public abstract void setGenerateSource(boolean paramBoolean);
/*     */ 
/*     */   public abstract void setTargetPackage(String paramString);
/*     */ 
/*     */   public abstract void setWsdlLocation(String paramString);
/*     */ 
/*     */   public abstract void setMessageStream(PrintStream paramPrintStream);
/*     */ 
/*     */   public abstract void setAdditionalCompilerClassPath(List<String> paramList);
/*     */ 
/*     */   public abstract void setTarget(String paramString);
/*     */ 
/*     */   public abstract void consume(URL paramURL);
/*     */ 
/*     */   public void consume(String wsdl)
/*     */     throws MalformedURLException
/*     */   {
/* 178 */     URL url = null;
/*     */     try
/*     */     {
/* 181 */       url = new URL(wsdl);
/*     */     }
/*     */     catch (MalformedURLException e)
/*     */     {
/* 185 */       File file = new File(wsdl);
/* 186 */       url = file.toURL();
/*     */     }
/*     */ 
/* 189 */     consume(url);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.wsf.spi.tools.WSContractConsumer
 * JD-Core Version:    0.6.0
 */