/*     */ package org.jboss.wsf.spi.metadata.webservices;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.net.URL;
/*     */ import javax.xml.ws.WebServiceException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainsMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedInitParamMetaData;
/*     */ import org.jboss.xb.binding.ObjectModelFactory;
/*     */ import org.jboss.xb.binding.Unmarshaller;
/*     */ import org.jboss.xb.binding.UnmarshallerFactory;
/*     */ import org.jboss.xb.binding.UnmarshallingContext;
/*     */ import org.xml.sax.Attributes;
/*     */ 
/*     */ public class WebservicesFactory
/*     */   implements ObjectModelFactory
/*     */ {
/*  53 */   private static final Logger log = Logger.getLogger(WebservicesFactory.class);
/*     */   private URL descriptorURL;
/*     */ 
/*     */   public WebservicesFactory(URL descriptorURL)
/*     */   {
/*  60 */     this.descriptorURL = descriptorURL;
/*     */   }
/*     */ 
/*     */   public static WebservicesMetaData loadFromVFSRoot(UnifiedVirtualFile root)
/*     */   {
/*  72 */     WebservicesMetaData webservices = null;
/*     */ 
/*  74 */     UnifiedVirtualFile wsdd = null;
/*     */     try
/*     */     {
/*  77 */       wsdd = root.findChild("META-INF/webservices.xml");
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/*     */     }
/*     */ 
/*  85 */     if (null == wsdd)
/*     */     {
/*     */       try
/*     */       {
/*  89 */         wsdd = root.findChild("WEB-INF/webservices.xml");
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/*  98 */     if (wsdd != null)
/*     */     {
/* 101 */       URL wsddUrl = wsdd.toURL();
/*     */       try
/*     */       {
/* 104 */         InputStream is = wsddUrl.openStream();
/* 105 */         Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
/* 106 */         ObjectModelFactory factory = new WebservicesFactory(wsddUrl);
/* 107 */         webservices = (WebservicesMetaData)unmarshaller.unmarshal(is, factory, null);
/* 108 */         is.close();
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 112 */         throw new WebServiceException("Failed to unmarshall webservices.xml:" + e.getMessage());
/*     */       }
/*     */     }
/*     */ 
/* 116 */     return webservices;
/*     */   }
/*     */ 
/*     */   public Object newRoot(Object root, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 126 */     WebservicesMetaData webservicesMetaData = new WebservicesMetaData(this.descriptorURL);
/* 127 */     return webservicesMetaData;
/*     */   }
/*     */ 
/*     */   public Object completeRoot(Object root, UnmarshallingContext ctx, String uri, String name)
/*     */   {
/* 132 */     return root;
/*     */   }
/*     */ 
/*     */   public Object newChild(WebservicesMetaData webservices, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 140 */     if ("webservice-description".equals(localName))
/* 141 */       return new WebserviceDescriptionMetaData(webservices);
/* 142 */     return null;
/*     */   }
/*     */ 
/*     */   public void addChild(WebservicesMetaData webservices, WebserviceDescriptionMetaData webserviceDescription, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 151 */     webservices.addWebserviceDescription(webserviceDescription);
/*     */   }
/*     */ 
/*     */   public Object newChild(WebserviceDescriptionMetaData webserviceDescription, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 159 */     if ("port-component".equals(localName))
/* 160 */       return new PortComponentMetaData(webserviceDescription);
/* 161 */     return null;
/*     */   }
/*     */ 
/*     */   public void addChild(WebserviceDescriptionMetaData webserviceDescription, PortComponentMetaData portComponent, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 170 */     webserviceDescription.addPortComponent(portComponent);
/*     */   }
/*     */ 
/*     */   public Object newChild(PortComponentMetaData portComponent, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 178 */     if ("handler".equals(localName))
/* 179 */       return new UnifiedHandlerMetaData(null);
/* 180 */     if ("handler-chains".equals(localName))
/* 181 */       return new UnifiedHandlerChainsMetaData();
/* 182 */     return null;
/*     */   }
/*     */ 
/*     */   public Object newChild(UnifiedHandlerChainsMetaData handlerChains, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 190 */     if ("handler-chain".equals(localName))
/* 191 */       return new UnifiedHandlerChainMetaData();
/* 192 */     return null;
/*     */   }
/*     */ 
/*     */   public Object newChild(UnifiedHandlerChainMetaData handlerChains, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 200 */     if ("handler".equals(localName))
/* 201 */       return new UnifiedHandlerMetaData();
/* 202 */     return null;
/*     */   }
/*     */ 
/*     */   public void addChild(PortComponentMetaData portComponent, UnifiedHandlerMetaData handler, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 210 */     portComponent.addHandler(handler);
/*     */   }
/*     */ 
/*     */   public void addChild(PortComponentMetaData portComponent, UnifiedHandlerChainsMetaData handlerChains, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 219 */     portComponent.setHandlerChains(handlerChains);
/*     */   }
/*     */ 
/*     */   public void addChild(UnifiedHandlerChainsMetaData chains, UnifiedHandlerChainMetaData handlerChain, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 228 */     chains.addHandlerChain(handlerChain);
/*     */   }
/*     */ 
/*     */   public void addChild(UnifiedHandlerChainMetaData chain, UnifiedHandlerMetaData handler, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 236 */     chain.addHandler(handler);
/*     */   }
/*     */ 
/*     */   public Object newChild(UnifiedHandlerMetaData handler, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*     */   {
/* 244 */     if ("init-param".equals(localName))
/* 245 */       return new UnifiedInitParamMetaData();
/* 246 */     return null;
/*     */   }
/*     */ 
/*     */   public void addChild(UnifiedHandlerMetaData handler, UnifiedInitParamMetaData param, UnmarshallingContext navigator, String namespaceURI, String localName)
/*     */   {
/* 254 */     handler.addInitParam(param);
/*     */   }
/*     */ 
/*     */   public void setValue(WebserviceDescriptionMetaData webserviceDescription, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 262 */     if (log.isTraceEnabled()) {
/* 263 */       log.trace("WebserviceDescriptionMetaData setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value);
/*     */     }
/* 265 */     if (localName.equals("webservice-description-name"))
/* 266 */       webserviceDescription.setWebserviceDescriptionName(value);
/* 267 */     else if (localName.equals("wsdl-file"))
/* 268 */       webserviceDescription.setWsdlFile(value);
/* 269 */     else if (localName.equals("jaxrpc-mapping-file"))
/* 270 */       webserviceDescription.setJaxrpcMappingFile(value);
/*     */   }
/*     */ 
/*     */   public void setValue(PortComponentMetaData portComponent, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 278 */     if (log.isTraceEnabled()) {
/* 279 */       log.trace("PortComponentMetaData setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value);
/*     */     }
/* 281 */     if (localName.equals("port-component-name"))
/* 282 */       portComponent.setPortComponentName(value);
/* 283 */     else if (localName.equals("wsdl-port"))
/* 284 */       portComponent.setWsdlPort(navigator.resolveQName(value));
/* 285 */     else if (localName.equals("service-endpoint-interface"))
/* 286 */       portComponent.setServiceEndpointInterface(value);
/* 287 */     else if (localName.equals("ejb-link"))
/* 288 */       portComponent.setEjbLink(value);
/* 289 */     else if (localName.equals("servlet-link"))
/* 290 */       portComponent.setServletLink(value);
/* 291 */     else if (localName.equals("wsdl-service"))
/* 292 */       portComponent.setWsdlService(navigator.resolveQName(value));
/* 293 */     else if (localName.equals("protocol-binding"))
/* 294 */       portComponent.setProtocolBinding(value);
/* 295 */     else if (localName.equals("enable-mtom"))
/* 296 */       portComponent.setEnableMtom(Boolean.valueOf(value).booleanValue());
/*     */   }
/*     */ 
/*     */   public void setValue(UnifiedHandlerMetaData handler, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 305 */     if (log.isTraceEnabled()) {
/* 306 */       log.trace("UnifiedHandlerMetaData setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value);
/*     */     }
/* 308 */     if (localName.equals("handler-name"))
/* 309 */       handler.setHandlerName(value);
/* 310 */     else if (localName.equals("handler-class"))
/* 311 */       handler.setHandlerClass(value);
/* 312 */     else if (localName.equals("soap-header"))
/* 313 */       handler.addSoapHeader(navigator.resolveQName(value));
/* 314 */     else if (localName.equals("soap-role"))
/* 315 */       handler.addSoapRole(value);
/* 316 */     else if (localName.equals("port-name"))
/* 317 */       handler.addPortName(value);
/*     */   }
/*     */ 
/*     */   public void setValue(UnifiedInitParamMetaData param, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*     */   {
/* 325 */     if (log.isTraceEnabled()) {
/* 326 */       log.trace("UnifiedInitParamMetaData setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value);
/*     */     }
/* 328 */     if (localName.equals("param-name"))
/* 329 */       param.setParamName(value);
/* 330 */     else if (localName.equals("param-value"))
/* 331 */       param.setParamValue(value);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.wsf.spi.metadata.webservices.WebservicesFactory
 * JD-Core Version:    0.6.0
 */