/*     */ package org.jboss.wsf.spi.metadata.webservices;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class WebserviceDescriptionMetaData
/*     */ {
/*  45 */   private static final Logger log = Logger.getLogger(WebserviceDescriptionMetaData.class);
/*     */   private WebservicesMetaData webservices;
/*     */   private String webserviceDescriptionName;
/*     */   private String wsdlFile;
/*     */   private String jaxrpcMappingFile;
/*  57 */   private ArrayList<PortComponentMetaData> portComponents = new ArrayList();
/*     */ 
/*     */   public WebserviceDescriptionMetaData(WebservicesMetaData webservices)
/*     */   {
/*  61 */     this.webservices = webservices;
/*     */   }
/*     */ 
/*     */   public WebservicesMetaData getWebservices()
/*     */   {
/*  66 */     return this.webservices;
/*     */   }
/*     */ 
/*     */   public void addPortComponent(PortComponentMetaData portComponent)
/*     */   {
/*  71 */     this.portComponents.add(portComponent);
/*     */   }
/*     */ 
/*     */   public PortComponentMetaData[] getPortComponents()
/*     */   {
/*  76 */     PortComponentMetaData[] array = new PortComponentMetaData[this.portComponents.size()];
/*  77 */     this.portComponents.toArray(array);
/*  78 */     return array;
/*     */   }
/*     */ 
/*     */   public Collection<QName> getPortComponentQNames()
/*     */   {
/*  92 */     Map map = new HashMap();
/*  93 */     for (PortComponentMetaData pcm : this.portComponents)
/*     */     {
/*  95 */       QName qname = pcm.getWsdlPort();
/*  96 */       map.put(qname.getPrefix(), qname);
/*     */     }
/*  98 */     return map.values();
/*     */   }
/*     */ 
/*     */   public PortComponentMetaData getPortComponentByWsdlPort(String name)
/*     */   {
/* 109 */     ArrayList pcNames = new ArrayList();
/* 110 */     for (PortComponentMetaData pc : this.portComponents)
/*     */     {
/* 112 */       String wsdlPortName = pc.getWsdlPort().getLocalPart();
/* 113 */       if (wsdlPortName.equals(name)) {
/* 114 */         return pc;
/*     */       }
/* 116 */       pcNames.add(wsdlPortName);
/*     */     }
/*     */ 
/* 119 */     log.error("Cannot get port component name '" + name + "', we have: " + pcNames);
/* 120 */     return null;
/*     */   }
/*     */ 
/*     */   public String getWebserviceDescriptionName()
/*     */   {
/* 125 */     return this.webserviceDescriptionName;
/*     */   }
/*     */ 
/*     */   public void setWebserviceDescriptionName(String webserviceDescriptionName)
/*     */   {
/* 130 */     this.webserviceDescriptionName = webserviceDescriptionName;
/*     */   }
/*     */ 
/*     */   public String getWsdlFile()
/*     */   {
/* 135 */     return this.wsdlFile;
/*     */   }
/*     */ 
/*     */   public void setWsdlFile(String wsdlFile)
/*     */   {
/* 140 */     this.wsdlFile = wsdlFile;
/*     */   }
/*     */ 
/*     */   public String getJaxrpcMappingFile()
/*     */   {
/* 145 */     return this.jaxrpcMappingFile;
/*     */   }
/*     */ 
/*     */   public void setJaxrpcMappingFile(String jaxrpcMappingFile)
/*     */   {
/* 150 */     this.jaxrpcMappingFile = jaxrpcMappingFile;
/*     */   }
/*     */ 
/*     */   public String serialize()
/*     */   {
/* 160 */     StringBuilder buffer = new StringBuilder("<webservice-description>");
/* 161 */     buffer.append("<webservice-description-name>").append(this.webserviceDescriptionName).append("</webservice-description-name>");
/* 162 */     buffer.append("<wsdl-file>").append(this.wsdlFile).append("</wsdl-file>");
/* 163 */     buffer.append("<jaxrpc-mapping-file>").append(this.jaxrpcMappingFile).append("</jaxrpc-mapping-file>");
/* 164 */     for (PortComponentMetaData pm : this.portComponents)
/* 165 */       buffer.append(pm.serialize());
/* 166 */     buffer.append("</webservice-description>");
/* 167 */     return buffer.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.wsf.spi.metadata.webservices.WebserviceDescriptionMetaData
 * JD-Core Version:    0.6.0
 */