/*     */ package org.jboss.wsf.spi.metadata.webservices;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainsMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
/*     */ 
/*     */ public class PortComponentMetaData
/*     */ {
/*     */   public static final String PARAMETER_WEBSERVICE_ID = "webserviceID";
/*  55 */   private static final Logger log = Logger.getLogger(PortComponentMetaData.class);
/*     */   private WebserviceDescriptionMetaData webserviceDescription;
/*     */   private String portComponentName;
/*     */   private QName wsdlPort;
/*     */   private String serviceEndpointInterface;
/*     */   private String ejbLink;
/*     */   private String servletLink;
/*  73 */   private List<UnifiedHandlerMetaData> handlers = new ArrayList();
/*     */   private String contextRoot;
/*     */   private Boolean secureWSDLAccess;
/*     */   private boolean enableMtom;
/*     */   private QName wsdlService;
/*     */   private String protocolBinding;
/*     */   private UnifiedHandlerChainsMetaData handlerChains;
/*     */ 
/*     */   public PortComponentMetaData(WebserviceDescriptionMetaData webserviceDescription)
/*     */   {
/*  93 */     this.webserviceDescription = webserviceDescription;
/*     */   }
/*     */ 
/*     */   public WebserviceDescriptionMetaData getWebserviceDescription()
/*     */   {
/*  98 */     return this.webserviceDescription;
/*     */   }
/*     */ 
/*     */   public String getPortComponentName()
/*     */   {
/* 103 */     return this.portComponentName;
/*     */   }
/*     */ 
/*     */   public void setPortComponentName(String portComponentName)
/*     */   {
/* 108 */     this.portComponentName = portComponentName;
/*     */   }
/*     */ 
/*     */   public QName getWsdlPort()
/*     */   {
/* 113 */     return this.wsdlPort;
/*     */   }
/*     */ 
/*     */   public void setWsdlPort(QName wsdlPort)
/*     */   {
/* 118 */     if (wsdlPort.getNamespaceURI().length() == 0) {
/* 119 */       log.warn("<wsdl-port> element in webservices.xml not namespace qualified: " + wsdlPort);
/*     */     }
/* 121 */     this.wsdlPort = wsdlPort;
/*     */   }
/*     */ 
/*     */   public String getEjbLink()
/*     */   {
/* 126 */     return this.ejbLink;
/*     */   }
/*     */ 
/*     */   public void setEjbLink(String ejbLink)
/*     */   {
/* 131 */     this.ejbLink = ejbLink;
/*     */   }
/*     */ 
/*     */   public String getServletLink()
/*     */   {
/* 136 */     return this.servletLink;
/*     */   }
/*     */ 
/*     */   public void setServletLink(String servletLink)
/*     */   {
/* 141 */     this.servletLink = servletLink;
/*     */   }
/*     */ 
/*     */   public String getServiceEndpointInterface()
/*     */   {
/* 146 */     return this.serviceEndpointInterface;
/*     */   }
/*     */ 
/*     */   public void setServiceEndpointInterface(String serviceEndpointInterface)
/*     */   {
/* 151 */     this.serviceEndpointInterface = serviceEndpointInterface;
/*     */   }
/*     */ 
/*     */   public void addHandler(UnifiedHandlerMetaData handler)
/*     */   {
/* 156 */     this.handlers.add(handler);
/*     */   }
/*     */ 
/*     */   public UnifiedHandlerMetaData[] getHandlers()
/*     */   {
/* 161 */     UnifiedHandlerMetaData[] array = new UnifiedHandlerMetaData[this.handlers.size()];
/* 162 */     this.handlers.toArray(array);
/* 163 */     return array;
/*     */   }
/*     */ 
/*     */   public String getContextRoot()
/*     */   {
/* 168 */     return this.contextRoot;
/*     */   }
/*     */ 
/*     */   public void setContextRoot(String contextRoot)
/*     */   {
/* 173 */     this.contextRoot = contextRoot;
/*     */   }
/*     */ 
/*     */   public Boolean getSecureWSDLAccess()
/*     */   {
/* 178 */     return this.secureWSDLAccess;
/*     */   }
/*     */ 
/*     */   public void setSecureWSDLAccess(Boolean secureWSDLAccess)
/*     */   {
/* 183 */     this.secureWSDLAccess = secureWSDLAccess;
/*     */   }
/*     */ 
/*     */   public boolean isEnableMtom()
/*     */   {
/* 188 */     return this.enableMtom;
/*     */   }
/*     */ 
/*     */   public void setEnableMtom(boolean enableMtom)
/*     */   {
/* 193 */     this.enableMtom = enableMtom;
/*     */   }
/*     */ 
/*     */   public QName getWsdlService()
/*     */   {
/* 198 */     return this.wsdlService;
/*     */   }
/*     */ 
/*     */   public void setWsdlService(QName wsdlService)
/*     */   {
/* 203 */     this.wsdlService = wsdlService;
/*     */   }
/*     */ 
/*     */   public String getProtocolBinding()
/*     */   {
/* 208 */     return this.protocolBinding;
/*     */   }
/*     */ 
/*     */   public void setProtocolBinding(String protocolBinding)
/*     */   {
/* 213 */     this.protocolBinding = protocolBinding;
/*     */   }
/*     */ 
/*     */   public UnifiedHandlerChainsMetaData getHandlerChains()
/*     */   {
/* 218 */     return this.handlerChains;
/*     */   }
/*     */ 
/*     */   public void setHandlerChains(UnifiedHandlerChainsMetaData handlerChains)
/*     */   {
/* 223 */     this.handlerChains = handlerChains;
/*     */   }
/*     */ 
/*     */   public String serialize()
/*     */   {
/* 228 */     StringBuilder builder = new StringBuilder("<port-component>");
/* 229 */     builder.append("<port-component-name>").append(this.portComponentName).append("</port-component-name>");
/* 230 */     builder.append("<wsdl-port xmlns:").append(this.wsdlPort.getPrefix()).append("='").append(this.wsdlPort.getNamespaceURI()).append("'>");
/* 231 */     builder.append(this.wsdlPort.getPrefix()).append(':').append(this.wsdlPort.getLocalPart()).append("</wsdl-port>");
/* 232 */     builder.append("<service-endpoint-interface>").append(this.serviceEndpointInterface).append("</service-endpoint-interface>");
/* 233 */     builder.append("<service-impl-bean>");
/* 234 */     if (this.ejbLink != null)
/* 235 */       builder.append("<ejb-link>" + this.ejbLink + "</ejb-link>");
/*     */     else
/* 237 */       builder.append("<servlet-link>" + this.servletLink + "</servlet-link>");
/* 238 */     builder.append("</service-impl-bean>");
/* 239 */     builder.append("</port-component>");
/* 240 */     return builder.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.wsf.spi.metadata.webservices.PortComponentMetaData
 * JD-Core Version:    0.6.0
 */